import pyexiv2
import Image

def copy_metadata(source, target, software=None):
    source    = pyexiv2.Image(source)
    target    = pyexiv2.Image(target)
    source.readMetadata()
    target.readMetadata()
    if software:
        source['Exif.Image.Software'] = software
    #the following is more or less the same target[key] = source[key]
    #but prevents conversions
    for key in source.exifKeys():
        target._Image__setExifTag(key, source._Image__getExifTag(key)[1])
    for key in source.iptcKeys():
        target[key] = source[key]
        #target._Image__setIptcTag(key, source._Image__getIptcTag(key)[1])
        
    target.writeMetadata()
    
def test():
    IMAGE   = 'IMGA3230.JPG'
    IMAGE_PIL   = 'IMGA3230_PIL.JPG'
    im  = Image.open(IMAGE)
    im.save(IMAGE_PIL)
    copy_metadata(IMAGE, IMAGE_PIL)
    
if __name__ == '__main__':
    test()

