# -*- coding: UTF-8 -*-

# Phatch - Photo Batch Processor
# Copyright (C) 2007-2008 www.stani.be
#
# This program is free software: you can redistribute it and/or modify
# it under the terms of the GNU General Public License as published by
# the Free Software Foundation, either version 3 of the License, or
# (at your option) any later version.
#
# This program is distributed in the hope that it will be useful,
# but WITHOUT ANY WARRANTY; without even the implied warranty of
# MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
# GNU General Public License for more details.
# 
# You should have received a copy of the GNU General Public License
# along with this program.  If not, see http://www.gnu.org/licenses/
#
# Phatch recommends SPE (http://pythonide.stani.be) for editing python files.


"""Important: Run this file everytime info is changed."""
import codecs, sys, time

#constants
NAME                = 'Phatch'
AUTHOR              = 'Stani'
AUTHOR_EMAIL        = 'spe.stani.be@gmail.com'
GPL_VERSION         = '3'
STANI               = {'name':AUTHOR, 'email':AUTHOR_EMAIL}
SUPPORTED_LANGUAGES = ['Dutch','English']

from version import VERSION, DATE

#credits
CREDITS         = {
    'code'          : [STANI],
    'documentation' : [STANI,
                        {'name':u'Frédéric Mantegazza',
                        'email':'frederic.mantegazza@gbiloba.org',
                        'url':'http://www.gbiloba.org'},
##                        {'name':'Leeshen C Henslee III',
##                        'email':'thisguyisi@gmail.com'},
    ],
    'translation'   : [STANI,
                        {'name':u'John Lejeune','url':'http://www.zindep.com'},
                        {'name':u'aeglos'},
                        {'name':u'Aktiwers'},
                        {'name':u'Alexander Taubenkorb'},
                        {'name':u'Alexandre Prokoudine'},
                        {'name':u'alex'},
                        {'name':u'Andras Bibok'},
                        {'name':u'Andrea (pikkio)'},
                        {'name':u'André Gondim'},
                        {'name':u'Andrey Skuryatin'},
                        {'name':u'Archie'},
                        {'name':u'Arielle B Cruz'},
                        {'name':u'Aristotelis Grammatikakis'},
                        {'name':u'Arnau Llovet Vidal'},
                        {'name':u'Aktiwers'},
                        {'name':u'Cedric Graebin'},
                        {'name':u'Clovis Gauzy'},
                        {'name':u'Daniel Nylander'},
                        {'name':u'Daniel Voicu'},
                        {'name':u'Diska'},
                        {'name':u'DPini'},
                        {'name':u'drag0nl0rd'},
                        {'name':u'Dread Knight'},
                        {'name':u'emil.s'},
                        {'name':u'Halgeir'},
                        {'name':u'Felipe'},
                        {'name':u'frinux'},
                        {'name':u'Galvin'},
                        {'name':u'Gérard Duteil'},
                        {'name':u'Jad'},
                        {'name':u'Johannes Majobe'},
                        {'name':u'kasade'},
                        {'name':u'Kulcsár, Kázmér'},
                        {'name':u'Luca Livraghi'},
                        {'name':u'madcore'},
                        {'name':u'Marcos'},
                        {'name':u'Mario Ferraro'},
                        {'name':u'Martin Lettner'},
                        {'name':u'matrixik'},
                        {'name':u'Maudy Pedrao'},
                        {'name':u'medeshago'},
                        {'name':u'Michael Christoph Jan Godawski'},
                        {'name':u'Michael Katz'},
                        {'name':u'Mijia'},
                        {'name':u'Miroslav Koucký'},
                        {'name':u'Mortimer'},
                        {'name':u'Motin'},
                        {'name':u'Mustafa Görmezer',
                        'email':'mustafa@goermezer.de',
                        'url':'http://www.goermezer.de'},
                        {'name':u'Nicola Piovesan'},
                        {'name':u'Nicolae Istratii'},
                        {'name':u'pasirt'},
                        {'name':u'Pavel Korotvička'},
                        {'name':u'Petr Pulc'},
                        {'name':u'Pierre Slamich'},
                        {'name':u'Piotr Ożarowski'},
                        {'name':u'pveith'},
                        {'name':u'qiuty'},
                        {'name':u'quina'},
                        {'name':u'rainofchaos'},
                        {'name':u'Rodrigo Garcia Gonzalez'},
                        {'name':u'Roman Shiryaev'},
                        {'name':u'Salandro'},
                        {'name':u'SebX86'},
                        {'name':u'Sergiy Babakin'},
                        {'name':u'skarevoluti'},
                        {'name':u'Stephan Klein'},
                        {'name':u'Swarms'},
                        {'name':u'therapiekind'},
                        {'name':u'Todor Eemreorov'},
                        {'name':u'Tosszyx'},
                        {'name':u'wcoqui'},
                        {'name':u'Wiesiek'},
                        {'name':u'Will Scott'},
                        {'name':u'zelezni'},
                        {'name':u'Zirro'},
                        ],
    'graphics'      : [
                        {'name':u'Igor Kekeljevic', 
                        'email':'admiror@nscable.net',
                        'url':'http://www.admiror-ns.co.yu',},
                        {'name':'NuoveXt 1.6',
                        'url':'http://nuovext.pwsp.net',
                        'author':'Alexandre Moore'},
                        {'name':'Open Clip Art Library',
                        'url':'http://www.openclipart.org'},
                        STANI,
                    ],
    'libraries'     : [{'name':'Python %s'%sys.version.split(' ')[0], 
                        'url':'http://www.python.org',
                        'author':'Guido Van Rossum',
                        'license':'Python license'},
                        {'name':'wxGlade',
                        'url':'http://wxglade.sourceforge.net/',
                        'author':'Alberto Griggio'},
                        {'name':'pubsub.py', 
                        'author':'Oliver Schoenborn',
                        'license':'wxWidgets license'},
                        {'name':'TextCtrlAutoComplete.py', 
                        'author':'Edward Flick (CDF Inc, http://www.cdf-imaging.com)',
                        'license':'wxWidgets license',
                        'url':'http://wiki.wxpython.org/TextCtrlAutoComplete',
                        },
                        {'name':'PyExiv2', 
                        'url':'http://tilloy.net/dev/pyexiv2/',
                        'author':'Olivier Somon',
                        'license':'GPL license'},
                        {'name':'python-nautilus',
                        'url':'http://www.gnome.org/projects/nautilus/',
                        'license':'GPL license'
                        }
                        ],
    'sponsors'      : [{'name':'Webhost (python, zope, plone)',
                        'url':'http://www.zindep.com',
                        'email':'gbourge@zindep.com',
                    }]
}

#year: automatically fetch copyright years
YEAR                = time.localtime()[0]
if YEAR > 2007:
    CO_YEAR         = '2007-%s'%YEAR
else:
    CO_YEAR         = '2007'
    
#setup.py information
SETUP          = {
    'name'              : NAME,
    'version'           : VERSION,
    'author'            : AUTHOR,
    'author_email'      : AUTHOR_EMAIL,
    'maintainer'        : AUTHOR,
    'maintainer_email'  : AUTHOR_EMAIL,
    'url'               : 'http://photobatch.stani.be',
    'description'       : 'PHoto bATCH Processor & Renamer',
    'long_description'  : 'Phatch enables you to resize, rotate, mirror, '
                          'apply watermarks, shadows, rounded courners, '
                          'perspective, ... to any photo collection easily '
                          'with a single mouse click. You can arrange your own'
                          ' action lists and write plugins with PIL. \n\n'
                          'Phatch can rename or copy images based on any EXIF '
                          'or IPTC tag. In combination with pyexiv2 Phatch can'
                          ' also save EXIF and IPTC metadata. \n\n'
                          'Phatch has a wxPython GUI, but can also run as a '
                          'console application on servers.'
                        ,
    'classifiers'       : [          
            'Development Status :: 4 - Beta',
            'Environment :: Console',
            'Environment :: MacOS X',
            'Environment :: Win32 (MS Windows)',
            'Environment :: X11 Applications',
            'Environment :: X11 Applications :: Gnome',
            'Environment :: X11 Applications :: GTK',
            'Intended Audience :: Developers',
            'Intended Audience :: End Users/Desktop',
            'License :: OSI Approved :: GNU General Public License (GPL)',
            'Operating System :: MacOS :: MacOS X',
            'Operating System :: Microsoft :: Windows',
            'Operating System :: OS Independent',
            'Operating System :: POSIX',
            'Operating System :: POSIX :: Linux',
            'Programming Language :: Python',
            'Topic :: Artistic Software',
            'Topic :: Multimedia :: Graphics',
            'Topic :: Multimedia :: Graphics :: Graphics Conversion',
    ] + ['Natural Language :: '+language for language in SUPPORTED_LANGUAGES],
}
                        
INFO                = {
    'copyright'         : '(c) %s www.stani.be'%CO_YEAR,
    'date'              : DATE,
    'description'       : 'Photo Batch Processor',
    'extension'         : '.'+NAME.lower(),
    'download_url'      : 'http://photobatch.stani.be',
    'gpl_version'       : GPL_VERSION,
    'license'           : 'GPL v.'+GPL_VERSION,
    'maintainer'        : 'Stani M',
    'fsf_adress'        : '51 Franklin Street, Fifth Floor, '
                            'Boston, MA 02110-1301, USA',
}

INFO.update(SETUP)

README    = \
"""%(name)s = PHoto bATCH Processor
    
%(url)s

Batch your photo's with one mouse click. Typical examples are resizing,
rotating, applying shadows, watermarks, rounded corners, EXIF renaming, ...

%(name)s was developed with the SPE editor (http://pythonide.stani.be) on 
Ubuntu (GNU/Linux), but should run fine as well on Windows and Mac Os X.

Please read first carefully the installation instructions for your platform
on the documentation website, which you can find at:
%(url)s > documentation > install

If you are a python developer, you can write easily your own plugins with PIL
 (Python Image Library). Please send your plugins to %(author_email)s 
You probably first want to read the developers documentation:
%(url)s > documentation > developers

All credits are in the AUTHORS file or in the Help> About dialog box.

%(name)s is licensed under the %(license)s, of which you can find the details
in the COPYING file. %(name)s has no limitations, no time-outs, no nags, no 
adware, no banner ads and no spyware. It is 100%% free and open source.

%(copyright)s
"""%INFO

PIL_CREDITS         = {'name':'Python Image Library',
                        'url':'http://www.pythonware.com/products/pil/',
                        'author':'Fredrik Lundh',
                        'license':'PIL license'
                        }
                        
WXPYTHON_CREDITS    = {'name':'wxPython', 
                        'url':'http://www.wxpython.org',
                        'author':'Robin Dunn',
                        'license':'wxWidgets license'}

def all_credits():
    #PIL - Python Image Library
    import Image
    pil_credits                 = PIL_CREDITS
    pil_credits['name']         += ' %s'%Image.VERSION
    if not (pil_credits in CREDITS['libraries']):
        CREDITS['libraries'].append(pil_credits)
    #wxPython
    import wx
    wxPython_credits            = WXPYTHON_CREDITS
    wxPython_credits['name']    += ' %s'%wx.VERSION_STRING
    if not (wxPython_credits in CREDITS['libraries']):
        CREDITS['libraries'].append(wxPython_credits)
    return CREDITS

def write_readme():
    readme = open('../../README','w')
    readme.write(README)
    readme.close()
    
def write_credits():
    all_credits()
    authors = codecs.open('../../AUTHORS','wb','utf-8')
    authors.write("Phatch is the result of work by (in no particular order):")
    tasks   = CREDITS.keys()
    tasks.sort()
    for task in tasks:
        authors.write('\n\n\n%s:\n\n'%task.title())
        authors.write(u'\n'.join([' - '.join(person.values()) 
            for person in CREDITS[task]]))
    authors.close()
    
def write_readme_credits(): 
    write_readme()
    write_credits()
    
if __name__ == '__main__':
    write_readme_credits()
    
#icons
#http://arenyart.googlepages.com/icons
#icons: http://www.paolinoland.it/index.php?option=com_content&task=view&id=14&Itemid=29
