#ifndef PPEFFECT_H
#define PPEFFECT_H

#include <gtk/gtkwindow.h>
#include <gdk/gdkpixbuf.h>

#include "../imagesource/imagesource.h"

enum PPEFFECT_STAGE {PPEFFECT_PRESCALE,PPEFFECT_POSTSCALE};

class PPEffect;

class PPEffectHeader
{
	public:
	PPEffectHeader();
	~PPEffectHeader();
	ImageSource *ApplyEffects(ImageSource *source,enum PPEFFECT_STAGE stage);
	int EffectCount(enum PPEFFECT_STAGE stage);
	PPEffect *GetFirstEffect(enum PPEFFECT_STAGE stage);
	private:
	PPEffect *firsteffect;
	friend class PPEffect;
};


class PPEffect
{
	public:
	PPEffect(PPEffectHeader &header,enum PPEFFECT_STAGE stage);
	virtual ~PPEffect();
	virtual ImageSource *Apply(ImageSource *source)=0;
	virtual	bool Dialog(GtkWindow *parent,GdkPixbuf *preview)=0;
	virtual	PPEffect *Next(enum PPEFFECT_STAGE stage);
	virtual	GdkPixbuf *GetIcon()=0;
	protected:
	enum PPEFFECT_STAGE stage;
	PPEffectHeader &header;
	PPEffect *prev,*next;
};

#endif
