#ifndef LAYOUT_H
#define LAYOUT_H

#include <stdio.h>
#include <glib.h>
#include <gtk/gtkwidget.h>
#include <gdk/gdkpixbuf.h>

#include "profilemanager/profilemanager.h"
#include "imagesource/imagesource.h"
#include "stpui_widgets/units.h"
#include "support/pageextent.h"
#include "support/layoutrectangle.h"
#include "effects/ppeffect.h"

#include "layoutdb.h"

class Layout_ImageInfo;
class PhotoPrint_State;
class Progress;

// Layout capabilities - needed by the UI:
#define PPLAYOUT_CROP 1
#define PPLAYOUT_ROTATE 2
#define PPLAYOUT_MASK 4
#define PPLAYOUT_PROFILE 8
#define PPLAYOUT_BACKGROUND 16
#define PPLAYOUT_EFFECTS 32

class Layout : public virtual PageExtent
{
	public:
	Layout(PhotoPrint_State &state,Layout *oldlayout=NULL);
	virtual ~Layout();
	virtual const char *GetType()=0;
	virtual int GetCapabilities();
	virtual int AddImage(const char *filename,bool allowcropping=false,PP_ROTATION rotation=PP_ROTATION_AUTO);
	virtual void CopyImage(Layout_ImageInfo *ii);
	virtual void TransferImages(Layout *oldlayout,Progress *p=NULL);
	virtual void Clear();
	virtual int GetPages();
	virtual ImageSource *GetImageSource(int page,CMColourDevice target=CM_COLOURDEVICE_PRINTER,CMTransformFactory *factory=NULL,int res=0);
	virtual IS_TYPE GetColourSpace(CMColourDevice target);
	virtual void UpdatePageSize()=0;
	virtual void LayoutToDB(LayoutDB &db);
	virtual void DBToLayout(LayoutDB &db);
	virtual void Reflow();
	virtual GtkWidget *CreateWidget();
	virtual void RefreshWidget(GtkWidget *widget);
	virtual Layout_ImageInfo *FirstImage();
	virtual Layout_ImageInfo *NextImage();
	virtual void SelectAll();
	virtual void SelectNone();
	virtual Layout_ImageInfo *FirstSelected();
	virtual Layout_ImageInfo *NextSelected();
	virtual Layout_ImageInfo *ImageAtCoord(int x,int y);
	virtual int GetCurrentPage();
	virtual void SetCurrentPage(int page);
	virtual void Print(Progress *p);
	virtual void (*SetUnitFunc())(GtkWidget *wid,enum Units unit);
	virtual void DrawPreviewBG(GtkWidget *widget,int xpos,int ypos,int width,int height);
	virtual void DrawPreview(GtkWidget *widget,int xpos,int ypos,int width,int height);
	virtual void SetBackground(const char *filename);
	virtual void FlushThumbnails();
	protected:
	int xoffset,yoffset;
	int pages;
	int currentpage;
	// Background image
	char *backgroundfilename;
	GdkPixbuf *background;
	GdkPixbuf *backgroundtransformed;
	// Housekeeping
	PhotoPrint_State &state;
	GList *imagelist;
	GList *iterator;
	// For thumbnails and preview...
	CMTransformFactory *factory;
	GdkGC *gc;
	GdkColor bgcol;
	friend class Layout_ImageInfo;
};


class Layout_ImageInfo : public PPEffectHeader
{
	public:
	Layout_ImageInfo(Layout &layout,const char *filename,int page,bool allowcropping=false,PP_ROTATION rotation=PP_ROTATION_AUTO);
	Layout_ImageInfo(Layout &layout,Layout_ImageInfo *oldii,int page,bool allowcropping=false,PP_ROTATION rotation=PP_ROTATION_AUTO);
	virtual ~Layout_ImageInfo();
	virtual GdkPixbuf *GetThumbnail();
	virtual GdkPixbuf *GetThumbnailNoEffects();
	virtual ImageSource *GetImageSource(CMColourDevice target=CM_COLOURDEVICE_PRINTER,CMTransformFactory *factory=NULL);
	virtual LayoutRectangle *GetBounds();
	virtual ImageSource *ApplyMask(ImageSource *is);
	virtual void DrawThumbnail(GtkWidget *widget,int xpos,int ypos,int width,int height);
	virtual void SetMask(const char *filename);
	virtual const char *GetFilename();
	virtual bool GetSelected();
	virtual void SetSelected(bool sel);
	virtual void ToggleSelected();
	virtual void FlushThumbnail();
	virtual void AssignProfile(const char *filename);
	virtual const char *GetAssignedProfile();
	virtual void SetRenderingIntent(LCMSWrapper_Intent intent);
	virtual LCMSWrapper_Intent GetRenderingIntent();
	int page;
	bool allowcropping;
	LayoutRectangle_Alignment crop_hpan;
	LayoutRectangle_Alignment crop_vpan;
	enum PP_ROTATION rotation;
	protected:
	Layout &layout;
	char *filename;
	char *maskfilename;
	GdkPixbuf *thumbnail;
	GdkPixbuf *mask;
	GdkPixbuf *transformed;
	bool selected;
	char *customprofile;
	LCMSWrapper_Intent customintent;
	friend class Layout;
};


#endif
