<?php

/**
* Provides variables and methods for a clipping rectangle
*
* The variables and methods in this class provide a clipping rectangle that
* can be used by any drawing function to restrict drawing/filling to a
* rectangular region.
*
* @version 0.3
* @author  Matt McClanahan <cardinal@dodds.net>
* @package Imlib
* @access public
*/
class ImlibCliprect extends ImlibColor
{
   /**
   * The array defining the cliprect (x,y,w,h)
   *
   * @var array $cliprect
   * @access private
   */
   var $cliprect;

   /**
   * A boolean that determines if a cliprect is in use or not
   *
   * @var bool $cliprect_inuse
   */
   var $cliprect_inuse;

   /**
   * ImlibCliprect constructor
   *
   * @access public
   */
   function ImlibCliprect() { $this->cliprect_inuse = 0; }

   /**
   * Get the four values of the cliprect
   *
   * @param int Upper left X coordinate to clip from
   * @param int Upper left Y coordinate to clip from
   * @param int Width of the cliprect
   * @param int Height of the cliprect
   * @access public
   * @see set_cliprect()
   */
   function get_cliprect(&$x,&$y,&$w,&$h)
   {
      list($x,$y,$w,$h) = $this->cliprect;
   }

   /**
   * Get the array that defines the cliprect (x,y,w,h)
   *
   * @return array Array defining the clipping rectangle
   * @access public
   * @see set_cliprect_array()
   */
   function get_cliprect_array()
   {
      return $this->cliprect;
   }

   /**
   * Get the boolean that determines if a cliprect is in use or not
   *
   * @return bool True if the cliprect is in use
   * @access public
   * @see set_cliprect_inuse()
   */
   function get_cliprect_inuse()
   {
      return $this->cliprect_inuse;
   }

   /**
   * Set the four values of the cliprect.  0 for X disables the cliprect.
   *
   * @param int Upper left X coordinate to clip from
   * @param int Upper left Y coordinate to clip from
   * @param int Width of the cliprect
   * @param int Height of the cliprect
   * @access public
   * @see get_cliprect()
   */
   function set_cliprect($x,$y,$w,$h)
   {
      if ($x == 0)
      {
         $this->cliprect = 0;
         $this->cliprect_inuse = 0;
         return;
      }
      $this->cliprect_inuse = 1;
      $this->cliprect = Array($x,$y,$w,$h);
   }

   /**
   * Set the array that defines the cliprect (x,y,w,h)
   *
   * @param array Array that defines the cliprect
   * @access public
   * @see get_cliprect_array()
   */
   function set_cliprect_array($arr)
   {
      if ($arr[0] == 0)
      {
         $this->cliprect = 0;
         $this->cliprect_inuse = 0;
         return;
      }
      $this->cliprect_inuse = 1;
      $this->cliprect = $arr;
   }

   /**
   * Set the boolean that determines if the cliprect is in use
   *
   * @param bool True to enable, false to disable
   * @access public
   * @see get_cliprect_inuse()
   */
   function set_cliprect_inuse($set)
   {
      $this->cliprect_inuse = $set;
   }
};

?>
