<?php
/*
 * Danish Language file for PhpGedView.
 *
 * phpGedView: Genealogy Viewer
 * Copyright (C) 2002 to 2007  PGV Development Team
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 *
 * @package PhpGedView
 * @translator Jørgen Hansen
 * @version $Id: configure_help.da.php 1777 2007-09-30 20:43:59Z fisharebest $
 */

if (stristr($_SERVER["SCRIPT_NAME"], basename(__FILE__))!==false) {
	print "Du kan ikke tilgå en sprogfil direkte.";
	exit;
}

$pgv_lang["COMMIT_COMMAND_help"] 			= "~#pgv_lang[COMMIT_COMMAND]#~<br /><br />Hvis du ønsker at anvende et versionstyringssystem, som fx CVS til at arkivere ændringer af din GEDCOM-fil, din konfiguration eller privatlivsindstillinger, så skriv kommandoen her.  Lad feltet stå tomt, hvis du ikke ønsker at anvende et versionsstyringssystem.  Gyldige valgmuligheder er <b>cvs</b> og <b>svn</b>.<br />";
$pgv_lang["COMMIT_COMMAND"] 			= "Kommando til versionsstyring";
$pgv_lang["SHOW_MULTISITE_SEARCH_help"]	= "~#pgv_lang[SHOW_MULTISITE_SEARCH]#~<br /><br />Multisite søgning giver brugere mulighed for at søge på tværs af flere PhpGedView hjemmesider, som du har konfigureret i administrationsdelen af PhpGedView.  Her bestemmer man, om multisite søgning kan anvendes af alle eller kun af godkendte brugere.<br />";
$pgv_lang["SHOW_MULTISITE_SEARCH"]		= "Vis multisite søgning";
$pgv_lang["DBPERSIST"]					= "Anvend permanent forbindelse til database";
$pgv_lang["DBPERSIST_help"]				=  "~#pgv_lang[DBPERSIST]#~<br /><br />Her bestemmes om PhpGedView skal anvende en permanent databaseforbindelse, når den benytter databasen.<br /><br />Vælges <b>Ja</b>, kan PhpGedView genanvende databaseforbindelsen og derved øge hastigheden mht. at etablere adgang til databasen. Imidlertid kan det forårsage en fejl, hvis din databasevært har sat det maksimale antal forbindelser for lavt.  Hvis du er usikker på om din vært understøtter permanente forbindelser, bør du vælge <b>Nej</b>.<br />";
$pgv_lang["INDI_FACTS_ADD"] 			= "Tilføj personfakta";
$pgv_lang["INDI_FACTS_ADD_help"]		= "~#pgv_lang[INDI_FACTS_ADD]#~<br /><br />Dette er en liste over de fakta, som brugerne kan føje til personer. Listen viser de felter eller fakta i form af GEDCOM-koder (ADDR,AFN,BIRT,CGR osv), som brugerne kan opdatere. Du kan modificere listen ved at fjerne eller tilføje GEDCOM-koder, standard koder såvel som tilpassede. For eksempel, hvis GEDCOM-koden BIRT findes på listen, betyder det, at brugerne har lov til at opdatere en persons fødselsdato, idet BIRT koden i GEDCOM-standarden er de felter, der indholder fødselsdatoen for en person. <br>For yderligere oplysninger om disse koder, henvises til fx. http://www.brotherskeeper.dk/gedcom_koder/gedcom-standard.htm. GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[INDI_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["INDI_FACTS_UNIQUE"] 			= "Entydige personfakta";
$pgv_lang["INDI_FACTS_UNIQUE_help"]		= "~#pgv_lang[INDI_FACTS_UNIQUE]#~<br /><br />Dette er en liste over de fakta, som brugerne kun kan føje til personer een gang. Listen viser felterne eller fakta i form af GEDCOM-koder (ADDR,AFN,BIRT,CGR osv).  For eksempel, hvis BIRT findes på denne liste, så vil brugere ikke kunne tilføje mere end een fødselsdato til en person.  GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[INDI_FACTS_ADD]#</i>.<br />";
$pgv_lang["INDI_FACTS_QUICK"] 			= "Hurtig person fakta";
$pgv_lang["INDI_FACTS_QUICK_help"]	= "~#pgv_lang[INDI_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM individ fakta, der vises ved siden af den komplette liste og som kan tilføjes med et enkelt klik.<br />";
$pgv_lang["FAM_FACTS_ADD"] 			= "Tilføj familiefakta";
$pgv_lang["FAM_FACTS_ADD_help"]		= "~#pgv_lang[FAM_FACTS_ADD]#~<br /><br />Dette er en liste over de fakta, som brugerne kan føje til familier. Listen viser de felter eller fakta i form af GEDCOM-koder (ADDR,AFN,BIRT,CGR osv).  Du kan modificere denne liste ved at fjerne eller tilføje GEDCOM-koder, standard koder såvel som tilpassede.  GEDCOM-koder, der findes på denne liste må ikke også findes på listen <i>#pgv_lang[FAM_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["FAM_FACTS_UNIQUE"] 			= "Entydige familiefakta";
$pgv_lang["FAM_FACTS_QUICK"] 			= "Hurtig Familie fakta";
$pgv_lang["FAM_FACTS_QUICK_help"]	= "~#pgv_lang[FAM_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM familie fakta, der vises ved siden af den komplette liste og som kan tilføjes med et enkelt klik.<br />";
$pgv_lang["FAM_FACTS_UNIQUE_help"]		= "~#pgv_lang[FAM_FACTS_UNIQUE]#~<br /><br />Dette er en liste over de fakta, som brugerne kun kan føje til familier <u>een gang</u>. Listen viser felterne eller fakta i form af GEDCOM-koder (ADDR,AFN,BIRT,CGR osv). For eksempel, hvis MARR findes på denne liste, så vil brugere ikke kunne tilføje mere end een vielsesoplysning for en familie.  GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[FAM_FACTS_ADD]#</i>.<br />";
$pgv_lang["SOUR_FACTS_ADD"] 			= "Tilføj kildefakta";
$pgv_lang["SOUR_FACTS_ADD_help"]		= "~#pgv_lang[SOUR_FACTS_ADD]#~<br /><br />Dette er en liste over de fakta, som brugerne kan føje til kildeoplysningerne.  Du kan modificere denne liste ved at fjerne eller tilføje GEDCOM-koder, standard koder såvel som tilpassede.  GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[SOUR_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["SOUR_FACTS_QUICK"] 			= "Hurtig kilde fakta";
$pgv_lang["SOUR_FACTS_QUICK_help"]	= "~#pgv_lang[SOUR_FACTS_QUICK]#~<br /><br />Dette er den korte liste over GEDCOM kilde fakta, der vises ved siden af den komplette liste og som kan tilføjes med et enkelt klik.<br />";
$pgv_lang["SOUR_FACTS_UNIQUE"] 			= "Entydige kildefakta";
$pgv_lang["SOUR_FACTS_UNIQUE_help"]		= "~#pgv_lang[SOUR_FACTS_UNIQUE]#~<br /><br />Dette er en liste over de fakta, som brugerne kun kan føje til kildeoplysningerne <u>een gang</u>. For eksempel, hvis TITL findes på denne liste, så vil brugere ikke kunne tilføje mere end een titel på en kilde.  GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[SOUR_FACTS_ADD]#</i>.<br />";
$pgv_lang["REPO_FACTS_ADD"] 			= "Tilføj fakta for opbevaringssteder";
$pgv_lang["REPO_FACTS_ADD_help"]		= "~#pgv_lang[REPO_FACTS_ADD]#~<br /><br />Dette er en liste over fakta, som brugerne kan føje til oplysningerne om opbevaringssteder, dvs. hvor kilderne fysisk befinder sig.  Du kan ændre denne liste ved at fjerne eller tilføje GEDCOM-koder efter behov.  For eksempel, hvis listen indeholder koderne PHON,EMAIL,FAX vil brugerne kunne tilføje oplsyninger om telefon, e-mail adresse, og fax for opbevaringsstedet, der kan være et landsarkiv eller lignende. GEDCOM-koder, der findes på denne liste må ikke også findes på listen: <i>#pgv_lang[REPO_FACTS_UNIQUE]#</i>.<br />";
$pgv_lang["REPO_FACTS_UNIQUE"] 			= "Entydige fakta for opbevaringsteder";
$pgv_lang["REPO_FACTS_UNIQUE_help"]		= "~#pgv_lang[REPO_FACTS_UNIQUE]#~<br /><br />Dette er en liste over fakta, som brugerne kun kan føje til opbevaringsstederne <u>en gang</u>.  For eksempel, hvis NAME findes på listen, så vil brugere ikke kunne tilføje mere end et navn på opbevaringsstedet.  GEDCOM-koder, der findes på denne liste må ikke findes på listen: <i>#pgv_lang[REPO_FACTS_ADD]#</i>.<br />";
$pgv_lang["LANG_SELECTION"] 			= "Understøttede sprog";
$pgv_lang["LANG_SELECTION_help"]		= "~#pgv_lang[LANG_SELECTION]#~<br /><br />Du kan ændre listen over sprog, der understøttes af din PhpGedView site ved at tilføje eller fjerne de tilhørende checkmærker.  Dette vil ændre de sprog, som brugerne kan vælge imellem.<br /><br />Du kan opnå det samme ved at klikke på linket: <b>#pgv_lang[enable_disable_lang]#</b> i #pgv_lang[admin]# menuen, hvor du også kan ændre fx. ikonet for sprogets flag, datoformatet, eller om efternavnet altid skal printes først.<br />";
$pgv_lang["MEDIA_ID_PREFIX"]		= "Medie-ID præfiks";
$pgv_lang["MEDIA_ID_PREFIX_help"]	= "~#pgv_lang[MEDIA_ID_PREFIX]#~<br /><br />Når en ny mediefil tilføjes online i PhpGedView, vil et nyt ID for mediefilen blive genereret automatisk. Mediefilens ID vil få dette præfiks.<br />";
$pgv_lang["FAM_ID_PREFIX"]		= "Familie ID præfiks";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Når en ny familie tilføjes online i PhpGedView, så vil et nyt ID for familien blive genereret automatisk. Familiens ID vil få dette præfiks.<br />";
$pgv_lang["QUICK_REQUIRED_FAMFACTS"]			= "Fakta for familier, der altid skal vises på formularen til hurtig opdatering";
$pgv_lang["QUICK_REQUIRED_FAMFACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FAMFACTS]#~<br /><br />Dette er en komma-separeret liste med GEDCOM-koder, der altid vil blive vist på fanebladet: <b>Familie</b> i formularen til hurtig opdatering, uafhængig af om de allerede findes i faktaoplysningerne for personer.  For eksempel, hvis MARR findes på listen, så vil felterne for vielsesdato og vielsessted altid blive vist på formularen.<br />";
$pgv_lang["QUICK_ADD_FAMFACTS"]			= "Fakta for familier, der skal vises på formularen til hurtig opdatering";
$pgv_lang["QUICK_ADD_FAMFACTS_help"]		= "~#pgv_lang[QUICK_ADD_FAMFACTS]#~<br /><br />Dette er en komma-separeret liste med GEDCOM-koder, der vil blive vist på fanebladet: <b>Familie</b> i formularen for hurtig opdatering.  Kun de fakta i denne liste vil blive vist på formularen eller gjort tilgængelig, så de kan vælges i det område, hvor du tilføjer nye fakta på formularen.<br />";
$pgv_lang["QUICK_REQUIRED_FACTS"]			= "Fakta, der altid skal vises på formularen til hurtig opdatering";
$pgv_lang["QUICK_REQUIRED_FACTS_help"]		= "~#pgv_lang[QUICK_REQUIRED_FACTS]#~<br /><br />Dette er en komma-separeret liste med GEDCOM-koder, der altid vil blive vist på formularen til hurtig opdatering uafhængig af om de allerede findes i faktaoplysningerne for personer.  For eksempel, hvis BIRT findes i listen, så vil felter til fødselsdato og fødested altid blive vist på formularen.<br />";
$pgv_lang["QUICK_ADD_FACTS"]			= "Fakta der skal vises på formularen til hurtig opdatering";
$pgv_lang["QUICK_ADD_FACTS_help"]		= "~#pgv_lang[QUICK_ADD_FACTS]#~<br /><br />Dette er en komma-separeret liste med GEDCOM-koder, der vil blive vist på formularen til hurtig opdatering.  Kun de fakta på denne liste vil blive vist på formularen eller gjort tilgængelige, så de kan vælges i det område, hvor du tilføjer nye fakta i formularen.<br />";
$pgv_lang["AUTO_GENERATE_THUMBS"]			= "Automatisk genererede miniaturebilleder";
$pgv_lang["AUTO_GENERATE_THUMBS_help"]		= "~#pgv_lang[AUTO_GENERATE_THUMBS]#~<br /><br />Skal systemet automatisk generere miniaturebilleder for billeder, hvor der ikke findes nogle.  Din PHP installation understøtter muligvis ikke denne funktion.<br />";
$pgv_lang["phpinfo_help"]				= "~#pgv_lang[phpinfo]#~<br /><br />Denne side giver uddybende information om den server hvor PhpGedView er installeret.  Mange konfigurationsmæssige detaljer om serverens software, der vedrører PHP og PhpGedView, kan ses.<br />";
$pgv_lang["config_help_help"]			= "~#pgv_lang[config_help]#~<br /><br />Denne side samler alle hovedemnerne vedr. hjælp til konfigurationen på et sted.  Du kan se informationen på din skærm, eller du kan printe den til senere brug.<br />";
$pgv_lang["more_config_hjaelp"]			= "<br /><b>Mere hjælp</b><br />Mere hjælp kan findes ved at klikke på <b>?</b> ved siden af elementerne på siden.<br />";
$pgv_lang["THUMBNAIL_WIDTH"]			= "Bredden af de genererede miniaturebilleder";
$pgv_lang["THUMBNAIL_WIDTH_help"]		= "~#pgv_lang[THUMBNAIL_WIDTH]#~<br /><br />Dette er den bredde (i pixels), som programmet vil bruge nåsr den genererer miniaturebilleder automatisk.  Standard indstillingen er 100.<br />";
$pgv_lang["SHOW_SOURCES"]				= "Vis kilder";
$pgv_lang["SHOW_SOURCES_help"]			= "~#pgv_lang[SHOW_SOURCES]#~<br /><br />Angiv adgangsniveau for alle kilder af hensyn til beskyttelse af privatlivet. Hvis brugeren ikke har adgang til at se kilder, vil menuvalget for kilder være fjernet i forbindelse med lLister og faneblade, og kilder vil ikke blive vist på faktasiden for personer eller familier.";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION"]	= "Kræver at en administrator godkender registreringer af nye brugere";
$pgv_lang["REQUIRE_ADMIN_AUTH_REGISTRATION_help"]	= "~#pgv_lang[REQUIRE_ADMIN_AUTH_REGISTRATION]#~<br /><br />Hvis <b>#pgv_lang[USE_REGISTRATION_MODULE]#</b> er aktiveret, kan man kontrollere om administratoren skal godkende registreringen.<br /><br />Vælges <b>Ja</b>, vil alle nye brugere først skulle bekræfte registreringen og derefter godkendes af en administrator førend de kan logge sig ind.  Vælges <b>Nej</b>, vil checkboksen <b>#pgv_lang[verified_by_admin]#</b> blive afkrydset automatisk, når brugerne bekræfter deres konto. Brugerne kan derefter logge sig ind direkte uden at administratoren behøver at godkende kontoen.<br /><br />Dette gemmes i \$REQUIRE_ADMIN_AUTH_REGISTRATION i filen <i>config.php</i>.";
$pgv_lang["SPLIT_PLACES"]				= "Split steder i Redigeringsvisning";
$pgv_lang["SPLIT_PLACES_help"]			= "~#pgv_lang[SPLIT_PLACES]#~<br /><br />Vælges <b>Ja</b> vil feltet for stednavne splittes således, at hvert sted (separeret med komma) bliver vist i sit eget felt for at gøre redigeringen mere enkel.<br />  Eksempel :<br /><ol><li>Standard opsætning<br /><u>Sted</u>: Nørvang, Børkop, Vejle, Danmark<br /><br /><li>Splittet<br /><u>Land</u>: Danmark<br /><u>Amt</u>: Vejle<br/><u>Sogn</u>: Børkop<br/><u>Herred</u>: Nørvang</ol>";
$pgv_lang["ALLOW_REMEMBER_ME"]			= "Vis checkboksen <b>Husk mig</b> på login siden";
$pgv_lang["ALLOW_REMEMBER_ME_help"]		= "~#pgv_lang[ALLOW_REMEMBER_ME]#~<br /><br />Mange hjemmesider giver dig som bruger mulighed for at vælge, om siten skal huske dig næste gang du besøger den.  Hvis du aktiverer dette valg, vil checkboksen <b>Husk mig</b> blive vist på login siden.  Når der er sat et mærke i checkboksen, har brugeren givet PhpGedView tilladelse til at gemme en 'cookie' på brugerens PC. Ved hjælp af cookien kan PhpGedView genkende brugeren næste gang hjemmesiden besøges.<br /><br />Dette gemmes i \$ALLOW_REMEMBER_ME i filen <i>config.php</i>.";
$pgv_lang["UNDERLINE_NAME_QUOTES"]		= "Understreg navn sat i anførselstegn";
$pgv_lang["UNDERLINE_NAME_QUOTES_help"]	= "~#pgv_lang[UNDERLINE_NAME_QUOTES]#~<br /><br />Mange programmer vil sætte det foretrukne fornavn i \"anførselstegn\" i GEDCOM-filen.  Den almindelige måde at vise dette på er at understrege navnet.<br /><br />Eksempel:<br />Navn angivet i GEDCOM-filen som:<br /> 1&nbsp;NAME&nbsp;Rasmus&nbsp;\"Peter\"&nbsp;/Kristensen/<br />- Hvis valget er aktiveret vil navnet blive vist som:<br /><br /><b>Rasmus&nbsp;<u>Peter</u>&nbsp;Kristensen</b><br />eller<br /><b>Kristensen,&nbsp;Rasmus&nbsp;<u>Peter</u></b><br /><br />Dette gemmes i \$UNDERLINE_NAME_QUOTES i filen <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["PRIVACY_BY_RESN"]			= "Brug GEDCOM-kode (RESN) til at sætte restriktioner for at beskytte privatlivet";
$pgv_lang["PRIVACY_BY_RESN_help"]		= "~#pgv_lang[PRIVACY_BY_RESN]#~<br /><br />I GEDCOM 5.5.1 har man mulighed for at vælge at bruge GEDCOM-koden RESN til at angive privatlivsbeskyttelse for personer eller fakta i GEDCOM-filen.  Ved at vælge dette, vil programmet blive bedt om at se efter niveau 1 RESN tags i GEDCOM-posterne.  Niveau 2+ RESN tags vil også automatisk blive tilføjet, men vil ikke have nogen effekt for dette valg.  NB. Aktivering kan betyde, at PhpGedView bruger længere tid om at vise enkelte sider.<br /><br />Dette gemmes i \$PRIVACY_BY_RESN i <i><u>\"filnavn\"</u>.GED_priv.php</i>.";
$pgv_lang["SHOW_LDS_AT_GLANCE"]			= "Vis LDS ordineringskoder i slægtstræernes bokse";
$pgv_lang["SHOW_LDS_AT_GLANCE_help"]	= "~#pgv_lang[SHOW_LDS_AT_GLANCE]#~<br /><br />Vælges <b>Ja</b> vil LDS (Mormoner) ordineringskoder blive vist i slægtstræernes bokse.<ul><li><b>B</b> - Døbt (Baptism)</li><li><b>E</b> - Gave (Endowed)</li><li><b>S</b> - Koblet til ægtefælle (Sealed to spouse)</li><li><b>P</b> - Koblet til forældre (Sealed to parents)</li></ul>En person som har alle ordineringerne vil have <b>BESP</b> skrevet efter sit navn.  Manglende ordineringer bliver vist som <b>_</b> i stedet for bogstavkoden.  For eksempel, <b>BE__</b> indikerer manglende <b>S</b> og <b>P</b> ordineringer.<br /><br />Dette gemmes i \$SHOW_LDS_AT_GLANCE i <i><u>\"filnavn\"</u>.GED_priv.php</i>.";
$pgv_lang["GEDCOM_DEFAULT_TAB"]			= "Standard faneblad, der skal vises på faktasiden for personer";
$pgv_lang["GEDCOM_DEFAULT_TAB_help"]	= "~#pgv_lang[GEDCOM_DEFAULT_TAB]#~<br /><br />Dette valg giver dig mulighed for at bestemme, hvilket faneblad der skal vises først på faktasiden for personer.<br /><br />Dette gemmes i \$GEDCOM_DEFAULT_TAB i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["SHOW_MARRIED_NAMES"]			= "Vis vielsesnavn på personlister";
$pgv_lang["SHOW_MARRIED_NAMES_help"]	= "~#pgv_lang[SHOW_MARRIED_NAMES]#~<br /><br />Dette valg vil vise giftenavnet for hustruer i personlisten.  Denne valgmulighed kræver, at du har kopieret ægtemandens efternavn, da du importerede GEDCOM-filen.<br /><br />Dette gemmes i \$SHOW_MARRIED_NAMES i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["SHOW_QUICK_RESN"]			= "Vis felter for privatliv i #pgv_lang[quick_update_title]# skemaet";
$pgv_lang["SHOW_QUICK_RESN_help"]		= "~#pgv_lang[SHOW_QUICK_RESN]#~<br /><br />Her har du mulighed for at aktivere/deaktivere feltet, hvor man sætter beskyttelse af privatlivet i skemaet: <b>#pgv_lang[quick_update_title]#</b>. Felterne til beskyttelse af privatlivet giver en bruger, der tilføjer information ved hjælp af skemaet, mulighed for at overskrive standardindstillingen mht. privatlivsbeskyttelse for de fakta, som han/hun redigerer.<br /><br />Dette gemmes i \$SHOW_QUICK_RESN i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["USE_QUICK_UPDATE"]			= "Brug skemaet #pgv_lang[quick_update_title]#";
$pgv_lang["USE_QUICK_UPDATE_help"]		= "~#pgv_lang[USE_QUICK_UPDATE]#~<br /><br />Dette valg giver brugere med rettigheder til at ændre, en mulighed for at udføre dette med skemaet #pgv_lang[quick_update_title]#.<br /><br />Dette gemmes i \$USE_QUICK_UPDATE i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["SEARCHLOG_CREATE"]			= "Arkiver søgelogfiler";
$pgv_lang["SEARCHLOG_CREATE_help"]		= "~#pgv_lang[SEARCHLOG_CREATE]#~<br /><br />Her bestemmes, hvor ofte programmet skal arkivere søgelogfiler.<br /><br />Dette gemmes i \$SEARCHLOG_CREATE i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["CHANGELOG_CREATE"]		= "Arkiver ændringslogfiler";
$pgv_lang["CHANGELOG_CREATE_help"]	= "~#pgv_lang[CHANGELOG_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere ændringslogfiler.<br /><br />Dette sætter \$CHANGELOG_CREATE i <i><u>xxx</u>.GED_conf.php</i>.<br />";
$pgv_lang["CHART_BOX_TAGS"]				= "Vis andre fakta i slægtstræer";
$pgv_lang["CHART_BOX_TAGS_help"]		= "~#pgv_lang[CHART_BOX_TAGS]#~<br /><br />Som tillæg til faktaoplysninger om fødsel- og dødsdato vist i Anetræer, kan du her skrive fakta separeret med mellemrum eller komma.  Denne liste kræver at du bruger faktanavnet, som de er beskrevet i GEDCOM 5.5.1 standarden.  For eksempel, hvis du ønsker at vise erhverv i boksene, kan du tilføje \"OCCU\" til feltet.<br /><br />Dette gemmes i \$CHART_BOX_TAGS i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";

//-- CONFIGURE FILE MESSAGES
$pgv_lang["gedcom_conf"]				= "GEDCOM basisvalg";
$pgv_lang["media_conf"]					= "Multimedier";
$pgv_lang["accpriv_conf"]				= "Adgang og privatliv";
$pgv_lang["displ_conf"]					= "Visning og layout";
$pgv_lang["displ_names_conf"]		= "Navn";
$pgv_lang["displ_comsurn_conf"]	= "Oftest forekommende efternavne";
$pgv_lang["displ_layout_conf"]	= "Layout";
$pgv_lang["displ_hide_conf"]		= "Skjul & Vis";
$pgv_lang["editopt_conf"]		= "Brugeres redigering";
$pgv_lang["useropt_conf"]				= "Brugerindstillinger";
$pgv_lang["contact_conf"]				= "Kontaktinformation";
$pgv_lang["meta_conf"]					= "Meta tags";
$pgv_lang["gedconf_head"]				= "Opsætning af GEDCOM";
$pgv_lang["other_theme"]				= "Andet, indtast venligst";
$pgv_lang["performing_update"]			= "Opdaterer.";
$pgv_lang["config_file_read"]		= "Konfigurationsfil indlæst.";
$pgv_lang["does_not_exist"]				= "Eksisterer ikke";
$pgv_lang["media_drive_letter"]			= "Stien til media skal ikke indeholde et drev-bogstav, fordi media så muigvis ikke vil blive vist.";
$pgv_lang["db_setup_bad"]				= "Der er en fejl i indstillingerne til din database.  Check de forskellige indstilloinger mht. opkobling til databasen og foretag de nødvendige ændringer.";
$pgv_lang["bad_host_user_pass"]			= "PhpGedView kunne ikke oprette en forbindelse til din databasevært. Check at du har angivet det korrekte navn på vært, brugernavn og adgangskode.";
$pgv_lang["bad_database_name"]			= "PhpGedView kunne oprette en forbindelse til din databasevært, men fik ikke tilladelse til at bruge databasen med det navn du opgav. Check at databasen findes og at brugernavnet, du opgav, har de nødvendige rettigheder i denne database.";
$pgv_lang["db"]						     	= "Database";
$pgv_lang["dbase"]					   	= "dBase";
$pgv_lang["current_gedcoms"]			= "Aktive slægtsdatabaser (GEDCOM-filer)";
$pgv_lang["ged_gedcom"]					= "GEDCOM-fil";
$pgv_lang["ged_title"]					= "Titel på slægtsdatabasen";
$pgv_lang["ged_config"]					= "Konfigurationsfil";
$pgv_lang["ged_search"]					= "Søgelogfiler";
$pgv_lang["ged_change"]			= "Ændringslogfiler";
$pgv_lang["ged_privacy"]				= "Privatlivsfil";
$pgv_lang["disabled"]					= "Ikke valgt";
$pgv_lang["mouseover"]					= "Ved at føre musen henover";
$pgv_lang["mousedown"]					= "Ved at holde museknappen nede";
$pgv_lang["click"]						= "Ved at klikke med musen";
$pgv_lang["enter_db_pass"]				= "Af sikkerhedsmæssige årsager skal du skrive dit brugernavn og adgangskode til databasen for at ændre konfigurationsværdierne.";
$pgv_lang["server_url_note"]			= "Dette bør være URLen til din PhpGedView mappe. Du bør kun ændre dette, hvis du er sikker på, hvad du gør. PhpGedView har checket at din SERVER_URL bør være #GUESS_URL#";

$pgv_lang["DBTYPE"]					    	= "Vælg database";
$pgv_lang["DBTYPE_help"]				= "~#pgv_lang[DBTYPE]#~<br /><br />Forskellige PEAR understøttede databaser, der kan benyttes.  Der kan vælges mellem MySQL, PostgreSQL, Oracle og SQLite.  Dette gemmes i \$DBTYPE variablen i config.php filen.";
$pgv_lang["DBHOST"] 					= "Databasevært";
$pgv_lang["DBHOST_help"] 				= "~#pgv_lang[DBHOST]#~<br /><br />DNS navnet eller IP-adressen på webserveren, hvor din database er installeret.  Dette gemmes i \$DBHOST variablen i config.php filen.";
$pgv_lang["DBUSER"] 					= "Database brugernavn";
$pgv_lang["DBUSER_help"] 				= "~#pgv_lang[DBUSER]#~<br /><br />Dit brugernavn til databasen. Brugernavnet er nødvendig for at kunne logge ind på din database.  Dette gemmes i \$DBUSER variablen i config.php filen.";
$pgv_lang["DBPASS"] 					= "Database adgangskode";
$pgv_lang["DBPASS_help"] 				= "~#pgv_lang[DBPASS]#~<br /><br />Din adgangskode til databasen. Adgangskoden er nødvendig for at kunne logge ind på din database.  Dette gemmes i \$DBPASS variablen i config.php filen.";
$pgv_lang["DBNAME"] 					= "Database navn";
$pgv_lang["DBNAME_help"] 				= "~#pgv_lang[DBNAME]#~<br /><br />Den database på serveren, som du vil have PhpGedView til at bruge.  Det brugernavn du indtastede i brugerfeltet skal have rettigheder til at gemme, overskrive, opdatere, slette og vælge i databasen.  Dette gemmes i \$DBNAME variablen i config.php filen.";
$pgv_lang["TBLPREFIX"] 					= "Database tabel præfiks";
$pgv_lang["TBLPREFIX_help"] 			= "~#pgv_lang[TBLPREFIX]#~<br /><br />Et præfiks der føjes til de tabeller PhpGedView har oprettet.  Ved at ændre denne værdi kan du sætte flere PhpGedView sider op til at bruge den samme database, men med forskellige tabeller.  Dette gemmes i \$TBLPREFIX variablen i config.php filen.";
$pgv_lang["ALLOW_CHANGE_GEDCOM"] 		= "Tillad at skifte slægtsdatabaser";
$pgv_lang["ALLOW_CHANGE_GEDCOM_help"]	= "~#pgv_lang[ALLOW_CHANGE_GEDCOM]#~<br /><br />Ved at vælge <b>Ja</b>, giver du brugere af hjemmesiden muligheden for at skifte slægtsdatabase, hvis du har lagt flere slægtsdatabaser ind.<br /><br />Hvis du har valgt <b>Nej</b>, vil brugere ikke have mulighed for at skifte slægtsdatabase.<br /><br />Dette gemmes i \$ALLOW_CHANGE_GEDCOM variablen i config.php filen.";
$pgv_lang["upload_path"]			= "Upload sti";
$pgv_lang["upload_path_help"]		= "~#pgv_lang[upload_path]#~<br /><br />Her angives stien til den GEDCOM-fil, du ønsker at uploade. For at vælge stien klikker du på knappen: <b>Browse</b> og navigerer hen til din GEDCOM-fil og klikker derefter på <b>Open</b>.";
$pgv_lang["gedcom_path"] 				= "Sti og navn til GEDCOM-filen";
$pgv_lang["gedcom_path_help"] 			= "~#pgv_lang[gedcom_path]#~<br /><br />Upload først din GEDCOM-fil til et sted, som kan nås af php installationen på din server.  Angiv derefter stien til og navnet på filen, som f.eks.: <b>./index/navn.ged</b>.<br /><br />Læs <a href=\"readme.txt\" target=\"_blank\">Readme.txt</a> filen for mere hjælp.";
$pgv_lang["CHARACTER_SET"] 				= "Tegnsæt";
$pgv_lang["CHARACTER_SET_help"] 		= "~#pgv_lang[CHARACTER_SET]#~<br /><br />Dette er tegnsættet i din GEDCOM-fil.  UTF-8 anbefales, og burde fungere for de fleste sider.  Hvis du eksporterer din GEDCOM-fil i IBM Windows tegnsæt (codepage), skal du skrive WINDOWS her.<br /><br />NB! PHP understøtter IKKE UNICODE (UTF-16), så det nytter ikke at klage over dette til PHP folk :-)";
$pgv_lang["LANGUAGE"] 					= "Sprog";
$pgv_lang["LANGUAGE_help"] 				= "~#pgv_lang[LANGUAGE]#~<br /><br />Vælg det sprog din side bruger som udgangspunkt. Brugerne har mulighed for at ignorere denne indstilling og istedet vælge et sprog selv, enten ved at lade sprogindstillingen i brugerens browser vælge, eller ved at vælge sprog selv på siden, hvis \"Tillad brugere at skifte sprog\" = Ja .";
$pgv_lang["ENABLE_MULTI_LANGUAGE"] 		= "Tillad brugere at skifte sprog";
$pgv_lang["ENABLE_MULTI_LANGUAGE_help"] = "~#pgv_lang[ENABLE_MULTI_LANGUAGE]#~<br /><br />Sættes til <b>Ja</b>, hvis brugerne skal have lov til at vælge et andet sprog fra en 'drop down'-liste på siden, eller blive styret af sprogindstillingen i brugernes browser.";
$pgv_lang["CALENDAR_FORMAT"] 			= "Kalenderformat";
$pgv_lang["CALENDAR_FORMAT_help"] 		= "~#pgv_lang[CALENDAR_FORMAT]#~<br /><br />Giver dig adgang til at specificere, hvilken type kalender du vil bruge sammen med denne slægtsdatabase/GEDCOM-fil. Hebræisk er det samme som den jødiske kalender med hebræiske tegn. <br><br>NB! Værdierne for jødiske / hebræiske datoer er beregnet ud fra de Gregorianske / Julianske datoer. Eftersom den jødiske kalenderdag starter ved solnedgang, vil alle begivenheder, der finder sted mellem solnedgang og midnat blive vist en dag tidligere end den korrekte jødiske dato. Gamle browsere kan have problemer med at vise hebræisk. Visse gamle browsere viser hebræisk baglæns eller slet ikke.";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS"]	= "Vis hebræiske tusindtal";
$pgv_lang["DISPLAY_JEWISH_THOUSANDS_help"] 	= "~#pgv_lang[DISPLAY_JEWISH_THOUSANDS]#~<br /><br />Vis Alafim i Hebræiske kalendere. Vælges <b>Ja</b>, vises året 1969 som <span lang=\"he-IL\" dir='rtl'>&#1492;'&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; men vælges <b>Nej</b>, vises året som <span lang=\"he-IL\" dir='rtl'>&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm;. Dette har ingen indvirkning på den jødiske kalender. Året bliver vist som 5729 uanset denne indstilling.<br />Denne indstilling gemmes i  \$DISPLAY_JEWISH_THOUSANDS variablen i config.php filen.";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM"]	= "Vis hebræisk Geyrshayim";
$pgv_lang["DISPLAY_JEWISH_GERESHAYIM_help"] = "~#pgv_lang[DISPLAY_JEWISH_GERESHAYIM]#~<br /><br />Viser enkelt og dobbelt anførselstegn ved visning af hebræiske datoer. Vælges <b>Ja</b> vises 8 februar 1969 som <span lang='he-IL' dir='rtl'>&#1499;'&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&quot;&#1496;</span>&lrm; i modsætning til, hvis der vælges <b>Nej</b>, hvor datoen bliver vist som <span lang='he-IL' dir='rtl'>&#1499;&#160;&#1513;&#1489;&#1496;&#160;&#1514;&#1513;&#1499;&#1496;</span>&lrm;. Dette påvirker indstillingen mht. det jødiske år, fordi der ikke anvendes anførselstegn i jødiske datoer, der vises med latinsk tegnsæt.<br />Indstillingen gemmes i \$DISPLAY_JEWISH_GERESHAYIM variablen i config.php filen.";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION"] 	= "Jødisk Ashkenazi udtale";
$pgv_lang["JEWISH_ASHKENAZ_PRONUNCIATION_help"] = "~#pgv_lang[JEWISH_ASHKENAZ_PRONUNCIATION]#~<br /><br />Brug jødisk Ashkenazi udtale.<br />Hvis der vælges <b>Ja</b>, vil månederne Cheshvan og Teves blive stavet med Ashkenazi udtale. Hvis der vælges <b>Nej</B> vil månederne blive stavet Hesvan og Tevet. <br />Dette berører kun den jødiske kalender. For den hebræiske kalender anvendes det hebræiske alfabet.<br />Dette gemmes i \$JEWISH_ASHKENAZ_PRONUNCIATION variablen i config.php filen.";
$pgv_lang["USE_RTL_FUNCTIONS"]	= "Brug RTL check";
$pgv_lang["USE_RTL_FUNCTIONS_help"]	= "~#pgv_lang[USE_RTL_FUNCTIONS]#~<br /><br />RTL = tekst der vises fra højre til venstre.<br /><br />Aktiver check for at sikre at GEDCOM-data bliver vist rigtigt for sprog, som bruger RTL.  Hvis der vælges <b>Ja</b> vil alle data blive checket før de bliver vist.<br />NB. Dette valg medfører at siderne tager længere tid om at blive vist.<br /><br />Dette gemmes i \$USE_RTL_FUNCTIONS i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS"] 	= "Antal generationer i slægtstræer";
$pgv_lang["DEFAULT_PEDIGREE_GENERATIONS_help"] = "~#pgv_lang[DEFAULT_PEDIGREE_GENERATIONS]#~<br /><br />Angiv antal generationer, der som standard skal vises i slægtstræer.";
$pgv_lang["MAX_PEDIGREE_GENERATIONS"]	= "Maks antal generationer af aner";
$pgv_lang["MAX_PEDIGREE_GENERATIONS_help"] 	= "~#pgv_lang[MAX_PEDIGREE_GENERATIONS]#~<br /><br />Her anføres det maksimale antal generationer, der skal vises i anetræer.";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS"] 	= "Maks antal generationer af efterkommere";
$pgv_lang["GENERATE_GUID"]		= "Opret automatisk globalt unikke ID\'er";
$pgv_lang["MAX_DESCENDANCY_GENERATIONS_help"]	= "~#pgv_lang[MAX_DESCENDANCY_GENERATIONS]#~<br /><br />Her anføres det maksimale antal generationer, der skal vises i efterkommeroversigter.";
$pgv_lang["USE_RIN"] 					= "Brug RIN# istedet for GEDCOM-ID";
$pgv_lang["USE_RIN_help"] 				= "~#pgv_lang[USE_RIN]#~<br /><br />Vælg <b>Ja</b> for at bruge RIN nummeret istedet for GEDCOM-ID når PhpGedView spørger efter ID for personer i konfigurationsfiler, brugerindstilliger, og slægtstræer. Dette er nyttigt når slægtsprogrammer ikke eksporterer GEDCOM med en ensartet person ID, men altid bruger den samme RIN.";
$pgv_lang["PEDIGREE_ROOT_ID"] 			= "Standard startperson i slægtsdatabasen";
$pgv_lang["PEDIGREE_ROOT_ID_help"] 		= "~#pgv_lang[PEDIGREE_ROOT_ID]#~<br /><br />Gemmer ID for den person, der som standard er valgt som hovedperson ved visning af slægtstræer (anetræer, stamtræer og efterkommeroversigter.";
$pgv_lang["GEDCOM_ID_PREFIX"] 			= "GEDCOM-ID præfiks";
$pgv_lang["GEDCOM_ID_PREFIX_help"] 		= "~#pgv_lang[GEDCOM_ID_PREFIX]#~<br /><br />Medmindre brugerne selv tilføjer et præfiks når de indtaster et ID, vil dette præfiks blive anvendt i forbindelse med slægtstræer, dvs. anetræer, stamtræer, efterkommeroversigter og andre.";
$pgv_lang["FAM_ID_PREFIX"]		= "Familie-ID præfiks";
$pgv_lang["FAM_ID_PREFIX_help"]	= "~#pgv_lang[FAM_ID_PREFIX]#~<br /><br />Når en ny familie tilføjes online i PhpGedView, vil et nyt ID blive genereret automatisk. Familie-ID numre vil få dette præfiks.";
$pgv_lang["SOURCE_ID_PREFIX"]			= "Kilde-ID præfiks";
$pgv_lang["SOURCE_ID_PREFIX_help"]		= "~#pgv_lang[SOURCE_ID_PREFIX]#~<br /><br />Når en ny kilde bliver tilføjet online i PhpGedView, vil der automatisk blive genereret et nyt ID for kilden.  Kilde-ID nummmeret vil få dette præfiks.";
$pgv_lang["REPO_ID_PREFIX"]				= "Opbevaringssted-ID præfiks";
$pgv_lang["REPO_ID_PREFIX_help"]		= "~#pgv_lang[REPO_ID_PREFIX]#~<br /><br />Når et nyt opbevaringssted bliver tilføjet online i PhpGedView, vil der automatisk blive genereret et nyt ID for dette opbevaringssted.  Opbevaringsstedets ID vil få dette præfiks.";
$pgv_lang["PEDIGREE_FULL_DETAILS"] 		= "Vis detaljer om fødsel og død i slægtstræer";
$pgv_lang["PEDIGREE_FULL_DETAILS_help"] = "~#pgv_lang[PEDIGREE_FULL_DETAILS]#~<br /><br />Vælg <b>Ja</b> eller <b>Nej</b> for at bestemme, hvorvidt der skal vises detaljer om en persons fødsel og død som standard i boksene i slægtstræerne.";
$pgv_lang["PEDIGREE_LAYOUT"] 			= "Standard layout for slægtstræer";
$pgv_lang["PEDIGREE_LAYOUT_help"] 		= "~#pgv_lang[PEDIGREE_LAYOUT]#~<br /><br />Her bestemmes om slægtstræet skal printes ud liggende eller stående.";
$pgv_lang["SHOW_EMPTY_BOXES"] 			= "Vis tomme bokse i slægtstræer";
$pgv_lang["SHOW_EMPTY_BOXES_help"] 		= "~#pgv_lang[SHOW_EMPTY_BOXES]#~<br /><br />Her bestemmes om tomme bokse skal vises i slægtstræer eller ej.";
$pgv_lang["ZOOM_BOXES"] 				= "Ændre størrelse på bokse i slægtstræer";
$pgv_lang["ZOOM_BOXES_help"] 			= "~#pgv_lang[ZOOM_BOXES]#~<br /><br />Gør det muligt for en bruger at ændre størrelsen på bokse i slægtstræer og få mere information.<dl><dt>Du kan vælge mellem:</dt><dd><b>~#pgv_lang[disabled]#~</b> for at spærre for denne valgmulighed.</dd><dd><b>~#pgv_lang[mouseover]#~</b> for at boksen skal blive større, skal man flytte musen henover ikonet i boksen.</dd><dd><b>~#pgv_lang[mousedown]#~</b> for at boksen skal blive større, når man holder museknappen nede, når man er over ikonet i boksen.</dd><dd><b>~#pgv_lang[click]#~</b> for at boksen skal blive større må man klikke på ikonet i boksen.</dd></dl>";
$pgv_lang["LINK_ICONS"] 				= "Ikon for \"undermenu\" i slægtstræernes bokse";
$pgv_lang["LINK_ICONS_help"] 			= "~#pgv_lang[LINK_ICONS]#~<br /><br />Gør det muligt for brugere at vælge links til andre slægtstræer og nære slægtninge til personen i boksen.<dl><dt>Du kan vælge mellem:</dt><dd> <b>~#pgv_lang[disabled]#~</b> for at spærre for denne valgmulighed.</dd><dd> <b>~#pgv_lang[mouseover]#~</b>\" for at vise en \"undermenu\" må man flytte musen henover ikonet i boksen.</dd><dd> <b>~#pgv_lang[click]#~</b> for at vise en \"undermenu\" må man klikke på ikonet i boksen.</dd></dl>";
$pgv_lang["ABBREVIATE_CHART_LABELS"]	= "Forkorte ledeord i slægtstræer";
$pgv_lang["ABBREVIATE_CHART_LABELS_help"]	= "~#pgv_lang[ABBREVIATE_CHART_LABELS]#~<br /><br />Her bestemmes om ledeord brugt i et slægtstræ skal forkortes. For eksempel om ledeordet 'Født' kun skal vises med forbogstavet 'F'.";
$pgv_lang["SHOW_PARENTS_AGE"]			= "Vis forældres alder ved siden af barnets fødselsdato";
$pgv_lang["SHOW_PARENTS_AGE_help"]		= "~#pgv_lang[SHOW_PARENTS_AGE]#~<br /><br />Dette valg bestemmer om alderen af barnets far og mor skal vises ved siden af barnets fødselsdato i slægtstræer.";
$pgv_lang["SHOW_RELATIVES_EVENTS"]      = "Vis begivenheder for nære slægtninge på faktasiden for en person";
$pgv_lang["SHOW_RELATIVES_EVENTS_help"] = "~#pgv_lang[SHOW_RELATIVES_EVENTS]#~<br /><br />Fødsler, vielser og dødsfald for slægtninge er vigtige begivenheder i ens liv. Disse valgmuligheder gør det muligt at bestemme, om disse begivenheder skal vises på fanebladet <i>Fakta og detaljer om personen</i> på siderne for den enkelte person.<br /><br />De begivenheder, der kan vælges er:<ul><li>Ægtefælles død</li><li>Børns fødsel og død</li><li>Forældres død</li><li>Søskendes fødsel og død</li><li>Bedsteforældres død</li></ul><br />";
$pgv_lang["EXPAND_RELATIVES_EVENTS"]      = "Udvid automatisk listen over begivenheder";
$pgv_lang["EXPAND_RELATIVES_EVENTS_help"] = "~#pgv_lang[EXPAND_RELATIVES_EVENTS]#~<br /><br />Ved hjælp af denne valgmulighed kan man bestemme om listen over <i>Begivenheder for nære slægtninge</i> skal udvides automatisk eller ej.<br />";
$pgv_lang["EXPAND_SOURCES"]      = "Udvid automatisk listen over kilder";
$pgv_lang["EXPAND_SOURCES_help"] = "~#pgv_lang[EXPAND_SOURCES]#~<br /><br />Ved hjælp af denne valgmulighed kan man bestemme om indholdet under fanebladet <i>Kilder</i> skal vises automatisk på siderne med fakta og detaljer for den enkelte person.<br />";
$pgv_lang["HIDE_LIVE_PEOPLE"] 			= "Aktiver <b>privatlivsbeskyttelse</b>";
$pgv_lang["HIDE_LIVE_PEOPLE_help"] 		= "~#pgv_lang[HIDE_LIVE_PEOPLE]#~<br /><br />Denne funktion giver PhpGedView besked om at skjule personlige oplysninger om nulevende personer.  Nulevende personer defineres som personer, for hvem der ikke er registreret begivenheder længere tilbage end for \".(isset(\$MAX_ALIVE_AGE)?\$MAX_ALIVE_AGE:\"120\").\" år siden, og som ikke har børn, der er født for mere end \".(isset(\$MAX_ALIVE_AGE)?(\$MAX_ALIVE_AGE-20):\"100\").\" år siden.";
$pgv_lang["REQUIRE_AUTHENTICATION"] 	= "Kræv at besøgende <b>SKAL</b> logge ind";
$pgv_lang["REQUIRE_AUTHENTICATION_help"]	= "~#pgv_lang[REQUIRE_AUTHENTICATION]#~<br /><br />Ved at angive dette valg, tvinges alle besøgende til at logge ind førend de kan se data på siden.";
$pgv_lang["WELCOME_TEXT_AUTH_MODE"]		= "Velkomsttekst på log ind side, hvis \"Kræv log ind\" = Ja";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE]#~<br /><br />Her kan du vælge en tekst, som vil vises på siden når du logger dig ind, hvis du kræver at <b>alle</b> besøgende skal have en brugerkonto. Check hvilken af de forhåndsdefinerede tekster, der passer bedst til dig.<br /><br />- Du kan også vælge at skrive din egen velkomsttekst, men husk at den ikke vil blive oversat til besøgende med andre sprog.<br /><br />Du kan vælge mellem disse tekster:<ul><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT1]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_1]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT2]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_2]#</div><br/></li><li><b>#pgv_lang[WELCOME_TEXT_AUTH_MODE_OPT3]#:</b><div class=\"list_value_wrap\">#pgv_lang[welcome_text_auth_mode_3]#</div></li></ul>";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT1"]	= "Forhåndsdefineret tekst, der siger at ALLE besøgende kan søge om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT2"]	= "Forhåndsdefineret tekst, der siger, at Administrator vil vurdere en eventuel ansøgning om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT3"]	= "Forhåndsdefineret tekst, der siger at KUN familiemedlemmer kan søge om en brugerkonto";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_OPT4"]	= "Egen velkomsttekst skrevet i feltet nedenfor";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST"]	= "Egen velkomsttekst, hvis \"Kræv log ind\" = Ja";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST]#~<br /><br />Hvis du har valgt at bruge din egen velkomsttekst ved at vælge <b>Ja</b> i feltet ovenfor, kan du skrive teksten her.<br />Teksten vil <b>ikke</b> blive oversat for besøgende med et andet sprog, men vil blive vist nøjagtig, som du har skrevet den.<br />Hvis du ønsker det, kan du bruge HTML-koder i teksten - Husk afslutningskoder!<br /><br /><b>PS!</b> Du kan bruge en forhåndsdefineret start på din tekst, som vil blive oversat til det sprog, som den besøgende bruger. Vælg <b>Ja</b> i feltet ovenfor for at bruge \"Standard start af ...\".";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD"]	= "Standard start af egen velkomsttekst";
$pgv_lang["WELCOME_TEXT_AUTH_MODE_CUST_HEAD_help"]	= "~#pgv_lang[WELCOME_TEXT_AUTH_MODE_CUST_HEAD]#~<br /><br />Du kan vælge at vise en (flersproglig) standardtekst som start på din egen velkomsttekst.<br /><br />Hvis du vælger \"Ja\", vil teksten starte med følgende sætninger:<br /><br />#pgv_lang[welcome_text_cust_head]#";
$pgv_lang["CHECK_CHILD_DATES"] 			= "Check datoer for børn";
$pgv_lang["CHECK_CHILD_DATES_help"] 	= "~#pgv_lang[CHECK_CHILD_DATES]#~<br /><br />Undersøger datoer for en persons børn for at afgøre om en person bør opfattes som levende eller død.  På ældre PCer og for store GEDCOM-filer kan en søgning forøge responstiden på din side.";
$pgv_lang["MAX_ALIVE_AGE"] 				= "Antaget maksimal levetid for en person";
$pgv_lang["MAX_ALIVE_AGE_help"] 		= "~#pgv_lang[MAX_ALIVE_AGE]#~<br /><br />Dette er den maksimale alder, hvor der kan være en begivenhed for personen. Eller den maksimale alder for børn til en person, som også bruges til at bestemme om en person skal anses for at være død eller ej.";
$pgv_lang["SHOW_GEDCOM_RECORD"] 		= "Tillad brugere at se GEDCOM-poster";
$pgv_lang["SHOW_GEDCOM_RECORD_help"]	= "~#pgv_lang[SHOW_GEDCOM_RECORD]#~<br /><br />Vælges <b>Ja</b>, bliver der oprettet en link til personer, kilder, og familier, som gør det muligt for brugere at åbne et separat vindue med GEDCOM-koden hentet direkte fra GEDCOM-filen.";
$pgv_lang["ALLOW_EDIT_GEDCOM"] 			= "Aktiver online redigering";
$pgv_lang["ALLOW_EDIT_GEDCOM_help"] 	= "~#pgv_lang[ALLOW_EDIT_GEDCOM]#~<br /><br />Aktiverer online redigering af denne slægtsfil så brugere med redigeringsrettigheder kan opdatere slægtsdatabasen online.";
$pgv_lang["EDIT_AUTOCLOSE"]		= "Luk redigeringsvinduet automatisk";
$pgv_lang["EDIT_AUTOCLOSE_help"]	= "~#pgv_lang[EDIT_AUTOCLOSE]#~<br /><br />Denne valgmulighed gør det muligt at bestemme om redigeringsvinduet skal lukkes automatisk efter at redigeringen er færdig.<br />";
$pgv_lang["INDEX_DIRECTORY"] 			= "Mappe til indekseringsfil";
$pgv_lang["INDEX_DIRECTORY_help"] 		= "~#pgv_lang[INDEX_DIRECTORY]#~<br /><br />Stien til en læs- og skrivbar mappe hvor PhpGedView bør gemme indeksfiler (tilføj det efterfølgende \"/\"). PhpGedView kræver ikke at denne mappes navn skal være \"index\". Du kan vælge et hvilken som helst navn.<br /><br />Af sikkerhedsmæssige årsager, bør denne mappe være placeret et sted på serveren der ikke kan tilgås fra internettet. Et eksempel på en sådan struktur følger:<br /><b>PhpGedView:</b> dir1/dir2/dir3/PhpGedView<br /><b>Indeks:</b> dir1/dir4/dir5/dir6/indeks<br /><br />For det viste eksempel, ville du indtaste <b>../../dir4/dir5/dir6/indeks/</b> i dette felt.<br /><br />Dette sætter \$INDEX_DIRECTORY i <i>config.php</i>.<br />";
$pgv_lang["POSTAL_CODE"]  = "Placering af postnummer";
$pgv_lang["POSTAL_CODE_help"] = "~#pgv_lang[POSTAL_CODE]#~<br /><br />I forskellige lande skrives en adresse på en anden måde. Denne valgmulighed gør det muligt at placere postnummeret enten før eller efter bynavnet.<br />";
$pgv_lang["ALPHA_INDEX_LISTS"] 			= "Opdel lange lister efter efternavnenes første bogstav";
$pgv_lang["ALPHA_INDEX_LISTS_help"] 	= "~#pgv_lang[ALPHA_INDEX_LISTS]#~<br /><br />For lange person- og familielister, kan man her vælge 'true' for at dele listen i sider opdelt efter det første bogstav i efternavnet.";
$pgv_lang["NAME_FROM_GEDCOM"] 			= "Hent navn fra GEDCOM-fil";
$pgv_lang["NAME_FROM_GEDCOM_help"] 		= "~#pgv_lang[NAME_FROM_GEDCOM]#~<br /><br />Som standard bruger PhpGedView det navn, der er gemt i indekset til at finde en persons navn. Men i visse GEDCOM-formater og -sprog, indekseres sorterbare navne ikke tilfredsstillende, og den bedste måde at få vist navnet korrekt på, er at hente det fra GEDCOM-filen. Spanske navne er et godt eksempel. Et spansk navn kan bestå af fornavn, fars efternavn, mors efternavn. Når indekset anvendes til sortering og fremvisning, vil navnet blive vist som fornavn, mors efternavn, fars efternavn, men dette er ikke korrekt. Hentes navnet derimod fra GEDCOM-filen, vil det blive vist korrekt. Men når navnet skal hentes fra GEDCOM-filen, gør det samtidig PhpGedView langsommere.";
$pgv_lang["SHOW_ID_NUMBERS_help"] 		= "~#pgv_lang[SHOW_ID_NUMBERS]#~<br /><br />Her vælges om ID nummeret skal vises i parentes efter personnavnet i slægtstræer og på faktasiden for personer.";
$pgv_lang["SHOW_LAST_CHANGE"]		= "Vis GEDCOM postens sidste ændringsdato på lister";
$pgv_lang["SHOW_PEDIGREE_PLACES"] 		= "Stednavneniveauer, der vises i personboksene";
$pgv_lang["SHOW_PEDIGREE_PLACES_help"]	= "~#pgv_lang[SHOW_PEDIGREE_PLACES]#~<br /><br />Her vælges, hvor meget information om et stednavn, der vises i personboksene i slægtstræer. Vælges 9 vil alle niveauer blive vist. Vælges 0, vil ingen stednavne blive vist. Vælges 1, vises første niveau, 2 viser 2 niveauer osv.";
$pgv_lang["MULTI_MEDIA"] 				= "Aktiver multimedier";
$pgv_lang["MULTI_MEDIA_help"] 			= "~#pgv_lang[MULTI_MEDIA]#~<br /><br />GEDCOM 5.5.1 giver dig mulighed for at knytte billeder, videoer, og andre multimedie objekter til din GEDCOM-fil.  Hvis du ikke har inkluderet multimedie objekter i din GEDCOM-fil, kan du fravælge multimedie objekter ved at vælge 'Nej'. <br />Se multimedie afsnittet i <a href=\"readme.txt\">readme.txt</a> filen for flere oplysninger om at inkludere multimedier på din side.";
$pgv_lang["MEDIA_EXTERNAL"]				= "Behold URL-links";
$pgv_lang["MEDIA_EXTERNAL_help"]		= "~#pgv_lang[MEDIA_EXTERNAL]#~<br /><br />Vælges <b>Ja</b>, vil et link til multimedier, der starter med f.eks. http://, ftp://, mms:// ikke blive ændret.<br />Eksempel: http://www.minfamilie.dk/billeder/far.jpg vil forblive uændret og linket http://www.minfamilie.dk/billeder/far.jpg vil blive anvendt.<br />Når det er sat til <b>Nej</b>, vil linket blive behandlet som en standard reference, og <b>mediemappen</b> vil blive anvendt.<br />Eksempel: http://www.minfamilie.dk/billeder/far.jpg vil blive ændret til ./media/far.jpg";
$pgv_lang["MEDIA_DIRECTORY"] 			= "Mappe til multimedier";
$pgv_lang["MEDIA_DIRECTORY_help"] 		= "~#pgv_lang[MEDIA_DIRECTORY]#~<br /><br />Stien til en læsbar mappe, hvor PhpGedView skal lede efter lokale multimedie filer (husk at tilføje en afsluttende skråstreg \"/\").";
$pgv_lang["MEDIA_DIRECTORY_LEVELS"] 	= "Antal mappeniveauer for multimedier";
$pgv_lang["MEDIA_DIRECTORY_LEVELS_help"] = "~#pgv_lang[MEDIA_DIRECTORY_LEVELS]#~<br /><br />Værdien 0 ignoreres i alle mapper i medieobjektets fil-sti.  Værdien 1 vil anvende den første mappe, som indeholder dette billede.  Ved at øge værdien, øges antallet af mappeniveauer, der skal inkluderes i stien.  <br />Eksempel: Hvis du linker til et billede i din GEDCOM-fil med en sti som: C:\Documents&nbsp;and&nbsp;Settings\User\Mine&nbsp;Dokumenter\Mine &nbsp;billeder\Slægt\Efternavn\bedstefar.jpg vil værdien 0 svare til stien ./media/bedstefar.jpg.  Værdien 1 vil svare til  ./media/Efternavn/bedstefar.jpg, osv.  De fleste vil kunne nøjes med værdien 0.  Men, forskellige medie objekter, der hedder det samme, vil da overskrive hinanden.  Denne indstilling giver dig mulighed for at organisere dine medier så navnesammenfald ikke giver problemer.";
$pgv_lang["SHOW_HIGHLIGHT_IMAGES_help"] = "~#pgv_lang[SHOW_HIGHLIGHT_IMAGES]#~<br /><br />Hvis du har aktiveret multimedie på din site, kan PhpGedView vise små miniaturebilleder (thumbnails) ved siden af personens navn i tabeller, slægtstræer og bokse.  PhpGedView bruger det første billede, der er listet i en GEDCOM-post ,som det foretrukne billede.  For personer med flere billeder, skal du arrangere dem således, at det billede du ønsker skal anvendes, er placeret før de andre.<br />Se multimedie afsnittet i filen <a href=\"\".(file_exists('readme-dansk.txt')?\"readme-dansk.txt\":\"readme.txt\").\"\" target=\"_blank\">readme\".(file_exists('readme-dansk.txt')?\"-dansk\":\"\").\".txt</a> for mere information om at inkludere medier på din side.";
$pgv_lang["USE_THUMBS_MAIN"]			= "Anvend miniaturebillede som hovedbillede på personsider";
$pgv_lang["USE_THUMBS_MAIN_help"]		= "~#pgv_lang[USE_THUMBS_MAIN]#~<br /><br />Afhængig af, hvordan du gemmer dine billeder, er det sandsynligvis bedst at anvende miniaturebilleder på faktasiden for personer. Hvis dit hovedbillede er meget stort, kan det tage lang tid at downloade. Hvis dine miniaturebilleder har en tilstrækkelig god kvalitet, så kan de bruges i stedet for billeder i fuld størrelse.<br />Vælges <b>Ja</b>, vil miniaturebilleder blive anvendt.<br />Vælges <b>Nej</b>, vil hovedbilledet blive anvendt.";
$pgv_lang["ENABLE_CLIPPINGS_CART"] 		= "Aktivere udklipsholderen";
$pgv_lang["ENABLE_CLIPPINGS_CART_help"] = "~#pgv_lang[ENABLE_CLIPPINGS_CART]#~<br /><br />Udklipsholderen giver de besøgende på din side mulighed for at kopiere dine data og gemme dem i en udklipsfil, som de så senere kan downloade som en GEDCOM-fil og importere i deres eget slægtsprogram.";
$pgv_lang["HIDE_GEDCOM_ERRORS"] 		= "Skjul GEDCOM-fejlmeddelelser";
$pgv_lang["HIDE_GEDCOM_ERRORS_help"] 	= "~#pgv_lang[HIDE_GEDCOM_ERRORS]#~<br /><br />Vælges <b>Ja</b> her, skjules de fejlmeddelelser som PhpGedView gemmer, når den finder et ukendt GEDCOM-kode i din GEDCOM-fil.  PhpGedView bestræber sig på at følge GEDCOM 5.5 standarden, men nogle slægtsprogrammer tilføjer deres egne specielle koder.  Se <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen for mere information.";
$pgv_lang["WORD_WRAPPED_NOTES"] 		= "Indsæt et mellemrum, hvor linier er delt";
$pgv_lang["SHOW_CONTEXT_HELP"]			= "Vis hjælp (?) til tekst som standard";
$pgv_lang["SHOW_CONTEXT_HELP_help"]		= "~#pgv_lang[SHOW_CONTEXT_HELP]#~<br /><br />Vælges dette vil links med hjælpe-spørgsmålstegn blive vist, hvor man kan få en hjælpetekst op vedr. valgmulighederne på siderne.";
$pgv_lang["DAYS_TO_SHOW_LIMIT"]		= "Øvre grænse for hvor mange dage, der kan vises i rammen: Kommende begivenheder";
$pgv_lang["DAYS_TO_SHOW_LIMIT_help"] = "~#pgv_lang[DAYS_TO_SHOW_LIMIT]#~<br /><br />Skriv et antal af dage, der skal vises i rammen: <b>Kommende begivenheder</b>.  Antallet kan ikke være større end 30. Hvis du skriver en større værdi end 30, vil 30 blive anvendt.<br /><br />Den værdi du angiver her bestemmer, hvor langt frem PhpGedView søger for at finde kommende begivenheder.  Resultatet af søgningen, der udføres en gang om dagen, kopieres over i en midlertidig fil.<br /><br />Rammen: <b>Ingen kommende begivenheder</b> på indekssider eller på \"Min GedView Portal\" sider kan kræve et antal dage, der er højere end denne værdi.  Jo større værdi desto længere tid vil det tage at hente dataene fra databasen dagligt, og jo længere tid vil det tage at vise rammen, selv når du beder om at vise et antal dage, der er mindre end denne indstilling.<br />";
$pgv_lang["COMMON_NAMES_THRESHOLD"]		= "Antal gange et efternavn må findes for at vises i<br /><i>Oftest forekommende efternavne</i>";
$pgv_lang["COMMON_NAMES_THRESHOLD_help"]	= "~#pgv_lang[COMMON_NAMES_THRESHOLD]#~<br /><br />Her anføres det antal gange personer med samme efternavn må findes førend efternavnet vil blive vist i listen med \"Oftest forekommende efternavne\" på velkomstsiden.";
$pgv_lang["COMMON_NAMES_ADD"]			= "Tilføj følgende efternavn til listen <i>Oftest forekommende efternavne</i> (komma-separeret)";
$pgv_lang["COMMON_NAMES_ADD_help"]		= "~#pgv_lang[COMMON_NAMES_ADD]#~<br /><br />Hvis et bestemt efternavn ikke findes tilstrækkelig mange gange til at kunne blive vist i listen over \"Oftest forekommende efternavne\", kan den her tilføjes manuelt. Hvis der tilføjes flere navne må de adskilles med et komma. Optællingen skelner imellem om et efternavn er skrevet med forskellige små-/store bogstaver.";
$pgv_lang["COMMON_NAMES_REMOVE"]		= "Fjern følgende efternavn i listen <i>Oftest forekommende efternavne</i> (komma-separeret)";
$pgv_lang["COMMON_NAMES_REMOVE_help"]	= "~#pgv_lang[COMMON_NAMES_REMOVE]#~<br /><br />Hvis du ønsker at fjerne et bestemt efternavn fra listen med \"Oftest forekommende efternavne\", kan du anføre efternavnet her. Hvis der tilføjes flere navne, må de adskilles med et komma. Optællingen skelner imellem om et efternavn er skrevet med små-/store bogstaver.";
$pgv_lang["HOME_SITE_URL"] 				= "URL på din hjemmeside";
$pgv_lang["HOME_SITE_URL_help"] 		= "~#pgv_lang[HOME_SITE_URL]#~<br /><br />Denne URL er inkluderet i topfeltet i temaet, og bruges til at oprette et link til din hjemmeside.";
$pgv_lang["HOME_SITE_TEXT"] 			= "Titlen på din hjemmeside";
$pgv_lang["HOME_SITE_TEXT_help"] 		= "~#pgv_lang[HOME_SITE_TEXT]#~<br /><br />Teksten på linket, som viser til din hjemmeside.";
$pgv_lang["CONTACT_EMAIL"] 				= "Kontaktperson vedr. slægtsspørgsmål";
$pgv_lang["CONTACT_EMAIL_help"] 		= "~#pgv_lang[CONTACT_EMAIL]#~<br /><br />Den bruger som kan kontaktes vedrørende slægtsmateriale på din hjemmeide.";
$pgv_lang["CONTACT_METHOD"] 			= "Kontaktmetode";
$pgv_lang["CONTACT_METHOD_help"] 		= "~#pgv_lang[CONTACT_METHOD]#~<br /><br />Her vælger du den måde, hvorpå besøgende kan få formidlet spørgsmål til <b>#pgv_lang[CONTACT_EMAIL]#</b>.  Kontakt linket vil blive vist nederst på hver side.<dl><dt>Du har følgende valg:</dt><dd><b>#pgv_lang[mailto]#</b>. Besøgende skal have et e-mail program.</dd><dd><b>#pgv_lang[messaging]#</b>. Dette bruger meddelelsessystemet, der er indbygget i PhpGedView, og det sender ingen eksterne e-mails.</dd><dd><b>#pgv_lang[messaging2]#</b>. Dette valg er standard og bruger meddelelsessystemet, der er indbygget i PhpGedView, men sender også en kopi af meddelelserne med e-mail.</dd><dd><b>#pgv_lang[messaging3]#</b>. Dette valg bruger det meddelelsessystem, der er indbygget i PhpGedView, men sender meddelelserne med e-mail uden at tage en kopi til det interne system.</dd><dd><b>#pgv_lang[no_messaging]#</b>. Dette medfører at besøgende ikke kan kontakte dig.</dd></dl>";
$pgv_lang["PHPGEDVIEW_EMAIL"]		= "PhpGedView svar-adresse";
$pgv_lang["WEBMASTER_EMAIL"] 			= "Kontaktperson vedr. teknisk hjælp";
$pgv_lang["WEBMASTER_EMAIL_help"] 		= "~#pgv_lang[WEBMASTER_EMAIL]#~<br /><br />Den bruger, som kan kontaktes vedrørende tekniske spørgsmål eller fejl, de er stødt på under besøget på din side.";
$pgv_lang["SUPPORT_METHOD"] 			= "Kontaktmetode";
$pgv_lang["SUPPORT_METHOD_help"] 		= "~#pgv_lang[SUPPORT_METHOD]#~<br /><br />Her vælger du den måde, hvorpå besøgende kan få formidlet spørgsmål til <b>#pgv_lang[WEBMASTER_EMAIL]#</b> om hjemmesiden.  Kontakt linket vil blive vist nederst på hver side.<dl><dt>Du har følgende valg:</dt><dd><b>#pgv_lang[mailto]#</b>. Besøgende skal have et e-mail program.</dd><dd><b>#pgv_lang[messaging]#</b>. Dette anvender det meddelelsessystem, der er indbygget i PhpGedView, og det sender ingen eksterne e-mails.</dd><dd><b>pgv_lang[messaging2]</b>. Dette valg er standard og anvender det meddelelsessystem, der er indbygget i PhpGedView, men sender også en kopi af meddelelserne med e-mail.</dd><dd><b>#pgv_lang[messaging3]#</b>. Dette valg anvender det meddelelsessystem, der er indbygget i PhpGedView, men sender meddelelserne med e-mail uden at tage en kopi til det interne system.</dd><dd><b>#pgv_lang[no_messaging]#</b>. Dette medfører at besøgende ikke kan kontakte dig.</dd></dl>";
$pgv_lang["SHOW_FACT_ICONS"] 		= "Vis fakta ikoner";
$pgv_lang["SHOW_FACT_ICONS_help"]	= "~#pgv_lang[SHOW_FACT_ICONS]#~<br /><br />Vælg <b>#pgv_lang[yes]#</b> for at vise ikoner ved faktanavne på siden med #pgv_lang[personal_facts]#.  Fakta ikoner vil kun blive vist, hvis de findes i <i>images/facts</i> mappen for det aktuelle tema.<br />";
$pgv_lang["FAVICON"] 					= "Favorit ikon";
$pgv_lang["FAVICON_help"] 				= "~#pgv_lang[FAVICON]#~<br /><br />Angiv en sti til det ikon, du vil vise i dine besøgendes \"Mine favoritter\" menu, når de bookmarker din side i deres \"Mine favoritter\" menu.";
$pgv_lang["THEME_DIR"] 					= "Tema og mappe";
$pgv_lang["THEME_DIR_help"] 			= "~#pgv_lang[THEME_DIR]#~<br /><br />Folderen, hvor PhpGedView gemmer dine temafiler.  Du kan ændre og/eller tilpasse en hvilken som helst af de standard temaer (layouts), der er leveret med PhpGedView, for at give din side et eget design.  Se Theme i ændringsafsnittet i <a href=\"readme.txt\" target=\"_blank\">readme.txt</a> filen for mere information.";
$pgv_lang["TIME_LIMIT"] 				= "PHP tidsbegrænsning";
$pgv_lang["TIME_LIMIT_help"] 			= "~#pgv_lang[TIME_LIMIT]#~<br /><br />Den maksimale tid i sekunder, som PhpGedView får lov til at arbejde. Som standard er den sat til 1 minut.  Afhængig af størrelsen på din GEDCOM-fil, kan du evt. øge denne tidsbegrænsning når du har brug for at indeksere.  Hvis denne værdi sættes til 0, tillader du PHP at køre uendelig.<br />ADVARSEL: Hvis værdien sættes til 0 eller sættes for højt, kan det få din side til at \"hænge\" i visse operativsystemer indtil scriptet afsluttes.  At sætte værdien til 0 betyder at scriptet ikke afsluttes førend en netværksadministrator stopper processen eller genstarter serveren.  Det kan tage lang tid at lave en stor slægtstavle, så ved at sætte denne værdi så lavt som muligt, kan det forhindre at en eller anden får din webserver til at bryde sammen, ved at forsøge, at lave en slægtstavle med 1000 generationer.";
$pgv_lang["PGV_SESSION_SAVE_PATH"] 		= "Sti til logfiler";
$pgv_lang["PGV_SESSION_SAVE_PATH_help"] = "~#pgv_lang[PGV_SESSION_SAVE_PATH]#~<br /><br />Sti til mappen, hvor PhpGedViews logfiler gemmes. Det er ikke alle webhoteller, der har konfigureret deres PHP korrekt, og derfor kan log-data gå tabt ved udskiftning af en side. Denne indstilling gør det muligt for administratorer at kompensere for denne webhotel-fejl, ved at lagre logfiler i en lokal mappe på deres egen side. Til det formål er ./index/ mappen et oplagt valg, hvis det er nødvendigt at ændre på denne sti. Som standard skal boksen være tom, for så vil indstillingerne fra php.ini filen blive anvendt. Boksen skal kun udfyldes, hvis log-data går tabt.<br /><br />Dette gemmes i \$PGV_SESSION_SAVE_PATH variablen i config.php filen.";
$pgv_lang["SERVER_URL"] 				= "PhpGedView URL";
$pgv_lang["SERVER_URL_help"] 			= "~#pgv_lang[SERVER_URL]#~<br /><br />Hvis du bruger https eller en anden port end standard porten, må du indsætte URLen her for at få adgang til din server. <br /><br />Dette gemmes i \$SERVER_URL variablen i config.php filen.";
$pgv_lang["LOGIN_URL"]					= "Log ind URL";
$pgv_lang["LOGIN_URL_help"]				= "~#pgv_lang[LOGIN_URL]#~<br /><br />Du behøver kun at angive en log ind URL hvis du ønsker at flytte til en anden hjemmeside eller placering når brugere logger ind.  Dette kan være nyttigt for eksempel, hvis du ønsker at skifte fra http til https når dine brugere logger ind.  Inkluder hele URL-stien til filen login.php (f.eks. https://www.dinserver.dk/phpgedview/login.php).";
$pgv_lang["PGV_SESSION_TIME"] 			= "Log ind timeout";
$pgv_lang["PGV_SESSION_TIME_help"] 		= "~#pgv_lang[PGV_SESSION_TIME]#~<br /><br />Tid i sekunder før PhpGedView kræver at en bruger, der er logget ind, må logge sig ind igen. Standard er 30 minutter.<br /><br />Dette gemmes i \$PGV_SESSION_TIME variablen i config.php filen";
$pgv_lang["SHOW_STATS"] 				= "Vis udførelsesstatistik";
$pgv_lang["SHOW_STATS_help"] 			= "~#pgv_lang[SHOW_STATS]#~<br /><br />Vis runtime statistik og antal databaseforespørgsler nederst på hver side.";
$pgv_lang["SHOW_COUNTER"]				= "Vis antal hits";
$pgv_lang["SHOW_COUNTER_help"]			= "~#pgv_lang[SHOW_COUNTER]#~<br /><br />Vis tæller med antal hits på velkomstsiden og personsider.";
$pgv_lang["USE_REGISTRATION_MODULE"]	= "Tillad besøgende at anmode om en brugerkonto";
$pgv_lang["USE_REGISTRATION_MODULE_help"] = "~#pgv_lang[USE_REGISTRATION_MODULE]#~<br /><br />Giver besøgende mulighed for at registrere sig for at få en konto på hjemmesiden.<br /><br />Ansøgeren vil modtage en e-mail, der indeholder en kode for at bekræfte ansøgningen.<br />Ansøgningen skal godkendes af en administrator før kontoen bliver aktiveret.<br /><br />Dette gemmes i \$USE_REGISTRATION_MODULE variablen i config.php filen.";
$pgv_lang["ALLOW_USER_THEMES"] 			= "Tillad brugere at vælge deres eget tema";
$pgv_lang["ALLOW_USER_THEMES_help"]		= "~#pgv_lang[ALLOW_USER_THEMES]#~<br /><br />Giver brugere mulighed for selv at vælge deres eget tema.<br /><br />Dette gemmes i \$ALLOW_USER_THEMES variablen i config.php filen.";
$pgv_lang["PGV_SIMPLE_MAIL"]			= "Brug simpel e-mail header i eksterne e-mails";
$pgv_lang["PGV_SIMPLE_MAIL_help"]		= "~#pgv_lang[PGV_SIMPLE_MAIL]#~<br /><br />I den almindelige e-mail header for eksterne e-mails oplyses om e-mail-adresse og navn. Nogle e-mail systemer godtager ikke dette. Ved at vælge \"Ja\", vil kun e-mail-adressen blive brugt.<br /><br />Dette gemmes i \$PGV_SIMPLE_MAIL variablen i config.php filen.";
$pgv_lang["gedcom_title"]				= "#pgv_lang[ged_title]#";
$pgv_lang["gedcom_title_help"]			= "~#pgv_lang[gedcom_title]#~<br /><br />Indtast en titel, som beskriver indholdet i denne slægtsdatabase/GEDCOM-fil. Besøgende af hjemmesiden vil se titlen, når de skal vælge slægtsdatabase. Husk der kan være mere end en slægtsdatabase i programmet.";
$pgv_lang["LOGFILE_CREATE"]				= "Arkiver logfiler";
$pgv_lang["LOGFILE_CREATE_help"] 		= "~#pgv_lang[LOGFILE_CREATE]#~<br /><br />Hvor ofte skal programmet arkivere logfiler.<br /><br />Dette gemmes i \$LOGFILE_CREATE variablen i config.php filen.";
$pgv_lang["PGV_MEMORY_LIMIT"]			= "Maksimum grænse for hukommelse";
$pgv_lang["PGV_MEMORY_LIMIT_help"]		= "~#pgv_lang[PGV_MEMORY_LIMIT]#~<br /><br />Det maksimale forbrug af hukommelse, der kan benyttes af PhpGedView scripts.  Standard er 16M.  Mange værter afviser dette valg i deres PHP konfigurationer, så en ændring af denne værdi behøver ikke nødvendigvis betyde noget for, hvor meget den maksimale hukommelse er.<br /><br />Dette gemmes i \$PGV_MEMORY_LIMIT-variablen i config.php filen.";
$pgv_lang["PGV_STORE_MESSAGES"]			= "Tillad at meddelelser bliver gemt online";
$pgv_lang["PGV_STORE_MESSAGES_help"]	= "~#pgv_lang[PGV_STORE_MESSAGES]#~<br /><br />Her angives om meddelelser, der er sendt via PhpGedView, kan gemmes i databasen. Hvis du vælger <b>Ja</b>, vil brugere kunne få meddelelserne, når de logger sig ind i på hjemmsiden.  Hvis der vælges <b>Nej</b>, vil meddelelserne kun blive sendt med e-mail.<br /><br />Dette gemmes i \$PGV_STORE_MESSAGES variablen i config.php filen.";
$pgv_lang["ALLOW_THEME_DROPDOWN"]		= "Vis felt for at skifte tema";
$pgv_lang["ALLOW_THEME_DROPDOWN_help"]	= "~#pgv_lang[ALLOW_THEME_DROPDOWN]#~<br /><br />Giver brugere mulighed for at vælge deres eget layout (tema) fra en \"drop down\" liste (hvis den er tilgængelig som tema)<br />Det er også nødvendigt at feltet: \"Tillad brugere at vælge deres eget tema\" er sat til <b>Ja</b>.<br />Dette gemmes i \$ALLOW_THEME_DROPDOWN variablen i config.php filen.";
$pgv_lang["MAX_VIEW_RATE"]		= "Maksimal hastighed for sidevisning";
$pgv_lang["MAX_VIEW_RATE_help"]	= "~#pgv_lang[MAX_VIEW_RATE]#~<br /><br />Denne valgmulighed sætter en grænse for, hvor hurtigt man kan skifte mellem siderne.<br /><br />Hvis hastigheden overskrides, vil PhpGedView håndtere sessionen som et forsøg på at hacke siten; sessionen vil blive lukket ned med en passende meddelelse.  Disse to værdier burde sætte en rimelig begrænsning på båndbredden og download af bytes fra serveren.  Denne funktion kan slås fra ved at sætte tidsintervallet til 0.<br /><br />Dette sætter \$MAX_VIEWS og \$MAX_VIEW_TIME i <i>config.php</i>.<br />";
$pgv_lang["META_AUTHOR"]				= "META tag: Forfatter";
$pgv_lang["META_AUTHOR_help"]			= "~#pgv_lang[META_AUTHOR]#~<br /><br />Her kan du angive navnet på den hovedansvarlige for hjemmesiden, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Hvis feltet er tomt, vil det fulde navn på slægtsdatabasens kontaktperson blive anvendt.<br />Dette gemmes i \$META_AUTHOR variablen i config.php filen.";
$pgv_lang["META_AUTHOR_descr"]			= "Lad feltet stå tomt for at anvende det fulde navn på slægtsdatabasens kontaktperson.";
$pgv_lang["META_PUBLISHER"]				= "META tag: Udgiver";
$pgv_lang["META_PUBLISHER_help"]		= "~#pgv_lang[META_PUBLISHER]#~<br /><br />Her kan du angive navnet på udgiveren af hjemmesiden, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Hvis feltet er tomt, vil det fulde navn på slægtsdatabasens kontaktperson blive anvendt.<br />Dette gemmes i \$META_PUBLISHER variablen i config.php filen.";
$pgv_lang["META_PUBLISHER_descr"]		= "Lad feltet stå tomt for at anvende det fulde navn på slægtsdatabasens kontaktperson.";
$pgv_lang["META_COPYRIGHT"]				= "META tag: Ophavsret";
$pgv_lang["META_COPYRIGHT_help"]		= "~#pgv_lang[META_COPYRIGHT]#~<br /><br />Her kan du angive ophavsretten til hjemmesiden, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Hvis feltet er tomt, vil det fulde navn på slægtsdatabasens kontaktperson blive anvendt.<br />Dette gemmes i \$META_COPYRIGHT variablen i config.php filen.";
$pgv_lang["META_COPYRIGHT_descr"]		= "Lad feltet stå tomt for at anvende det fulde navn på slægtsdatabasens kontaktperson.";
$pgv_lang["META_DESCRIPTION"]			= "META tag: Beskrivelse";
$pgv_lang["META_DESCRIPTION_help"]		= "~#pgv_lang[META_DESCRIPTION]#~<br /><br />Her kan du indsætte en beskrivelse af hjemmesiden, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Hvis feltet er tomt, vil titlen på den aktive slægtsdatabase blive anvendt.<br />Dette gemmes i \$META_DESCRIPTION variablen i config.php filen.";
$pgv_lang["META_DESCRIPTION_descr"]		= "Lad feltet stå tomt for at anvende titlen på den aktive slægtsdatabase.";
$pgv_lang["META_PAGE_TOPIC"]			= "META tag: Emne";
$pgv_lang["META_PAGE_TOPIC_help"]		= "~#pgv_lang[META_PAGE_TOPIC]#~<br /><br />Her kan du angive et emneord som din hjemmeside hører ind under, og som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Hvis feltet er tomt, vil titlen på den aktive slægtsdatabase blive anvend. <br />Dette gemmes i \$META_PAGE_TOPIC variablen i config.php filen.";
$pgv_lang["META_PAGE_TOPIC_descr"]		= "Lad feltet stå tomt for at anvende titlen på den aktive slægtsdatabase.";
$pgv_lang["META_AUDIENCE"]				= "META tag: Målgruppe";
$pgv_lang["META_AUDIENCE_help"]			= "~#pgv_lang[META_AUDIENCE]#~<br /><br />Her kan du angive en målgruppe for hjemmesiden og som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.<br />Dette gemmes i \$META_AUDIENCE variablen i config.php filen.";
$pgv_lang["META_PAGE_TYPE"]				= "META tag: Side type";
$pgv_lang["META_PAGE_TYPE_help"]		= "~#pgv_lang[META_PAGE_TYPE]#~<br /><br />Her kan du angive typen af siden, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.<br />Dette gemmes i \$META_PAGE_TYPE variablen i config.php filen.";
$pgv_lang["META_ROBOTS"]				= "META tag: Robotter";
$pgv_lang["META_ROBOTS_help"]			= "~#pgv_lang[META_ROBOTS]#~<br /><br />Her kan du angive søgerobotter, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Mange søgerobotter checker ikke denne værdi.<br />Dette gemmes i \$META_ROBOTS variablen i config.php filen.";
$pgv_lang["META_REVISIT"]				= "META tag: Hvor ofte bør/skal søgerobotter indeksere hjemmesiden";
$pgv_lang["META_REVISIT_help"]			= "~#pgv_lang[META_REVISIT]#~<br /><br />Her kan du angive, hvor ofte du ønsker at hjemmesiden skal opdateres af søgerobotter, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Mange søgerobotter checker ikke denne værdi.<br />Dette gemmes i \$META_REVISIT variablen i config.php filen.";
$pgv_lang["META_KEYWORDS"]				= "META tag: Nøgleord";
$pgv_lang["META_KEYWORDS_help"]			= "~#pgv_lang[META_KEYWORDS]#~<br /><br />Her kan du angive nøgleord, som vil blive indsat i <meta> tagget i begyndelsen af HTML siden.  Mange søgerobotter vil bruge disse nøgleord for at kunne indeksere dine sider.  Som tillæg til det du angiver her, vil de mest anvendte efternavne, der bliver vist i rammen: <b>Statistik</b> på hovedsiden, blive vist.<br />Dette gemmes i \$META_KEYWORDS variablen i config.php filen.";
$pgv_lang["META_SURNAME_KEYWORDS"]		= "Tilføj de mest anvendte efternavne, som nøgleord i meta tagget";
$pgv_lang["META_SURNAME_KEYWORDS_help"]	= "~#pgv_lang[META_SURNAME_KEYWORDS]#~<br /><br />Hvis du vælger <b>Ja</b> vil efternavnene fra listen:<b> #pgv_lang[common_surnames]#</b> blive føjet til som nøgleord i meta tagget.  Det kan hjælpe søgemaskiner så de lettere kan finde din side.<br /><br />Dette gemmes i \$META_SURNAME_KEYWORDS i <i><u>\"filnavn\"</u>.GED_conf.php</i>.";
$pgv_lang["META_TITLE"]					= "META tag: Undertitel";
$pgv_lang["META_TITLE_help"]			= "~#pgv_lang[META_TITLE]#~<br /><br />Her kan du angive en undertitel som supplement til den almindelige titel i <meta> tagget i begyndelsen af HTML siden.  Undertitlen vil blive indsat efter standardtitlen og før PhpGedView navnet.<br />Dette gemmes i \$META_TITLE variablen i config.php filen.";
$pgv_lang["ENABLE_RSS"]				= "Aktiver RSS";
$pgv_lang["RSS_FORMAT"]				= "RSS format";
$pgv_lang["RSS_FORMAT_help"]		= "~#pgv_lang[RSS_FORMAT]#~<br /><br />Det RSS format, der skal anvendes som standard RSS feed format for hjemmesiden. De numeriske suffiks indikerer <u>ikke</u> version, men formatet.  For eksempel, RSS 2.0 er ikke nyere end RSS 1.0, men har et andet format. Feed læsere skulle være i stand til at læse alle formater. Der er ingen forskel på ATOM og ATOM 0.3. Begge bruger ATOM 0.3 draft specifikationen.<br />";
$pgv_lang["SECURITY_CHECK_GEDCOM_DOWNLOADABLE"] = "Kontrollér om GEDCOM filer kan downloades";
$pgv_lang["gedcom_download_secure"]	= "#GEDCOM# kan ikke downloades.";
$pgv_lang["welcome_new2"]			= "<br /><br />Eftersom du kan se denne side, er det lykkedes at installere PhpGedView på din hjemmeside,<br />og du kan nu konfigurere PhpGedView som du ønsker.<br />";
$pgv_lang["welcome_new_help"]			= "~#pgv_lang[welcome_new]#~#pgv_lang[welcome_new2]#Dette vindue kan hjælpe dig gennem konfigurationsprocessen. Ved indtastning/valg af de forskellige felter, vil vinduet indeholde oplysninger om det pågældende felt. Det er OK at lukke vinduet. For at åbne det igen, kan du klikke på et af \"?\" spørgsmålstegnene ud for det pågældende felt.";
$pgv_lang["return_editconfig"]			= "Du kan gå tilbage til denne side for at konfigurere ved at klikke på linket <b>Programindstillinger</b> på siden for <b>Administration</b>,<br />eller ved at angive filen configure.php i adresselinien i din browser.<br />";
$pgv_lang["return_editconfig_gedcom"]	= "Du kan gå tilbage til denne side for at konfigurere ved at klikke på linket <b>Ændre</b> i tabellen <b>Aktive slægtsfiler (GED)</b><br />på siden for administration af <b>Slægtsfil(er) og privatliv</b>, eller ved at angive filen editconfig_gedcom.php i adressefeltet i din browser.<br />";
$pgv_lang["save_config"] 				= "Gem konfiguration";
$pgv_lang["download_gedconf"]			= "Download GEDCOM-konfiguration.";
$pgv_lang["not_writable"]				= "<br /><br />Det har vist sig, at PHP ikke kan skrive til konfigurationsfilen. Du kan derfor bruge \"Download\"-knappen til at gemme dine indstillinger i en fil, som du derefter uploader manuelt.<br /><br />";
$pgv_lang["upload_to_index"]			= "Upload filen til din indeksmappe: ";
$pgv_lang["import_sql"]					= "SQL-filer er fundet i indeksmappen. Da det er sandsynligt at de stammer fra overføringsværktøjet, kan du vælge at importere informationen i din database. Ønsker du at importere disse filer i din database nu?<br />NB! Alle eksisterende brugerrelaterede informationer (brugere, nyheder, favoritter, opsætning af rammer og meddelelser) vil blive overskrevet!<br /><br />Hvis du ønsker at fortsætte, vil PhpGedView prøve at importere dataene. Hvis det skulle vise sig, at det ikke lykkes, så vil du, uanset hvad, få valget om at oprette den første administratorkonto.<br /><br />";

//-- edit privacy messages
$pgv_lang["edit_privacy"]				= "Ret privatlivsfilen";
$pgv_lang["edit_privacy_title"]			= "Ret slægtsdatabasens indstillinger mht. privatliv";
$pgv_lang["save_changed_settings"]		= "Gemme ændringer";
$pgv_lang["add_new_pp_setting"]			= "Tilføj ny privatlivsindstilling for person";
$pgv_lang["add_new_up_setting"]			= "Tilføj ny privatlivsindstilling for bruger";
$pgv_lang["add_new_gf_setting"]			= "Tilføj ny privatlivsindstilling for generelle fakta";
$pgv_lang["add_new_pf_setting"]			= "Tilføj ny privatlivsindstilling for fakta";
$pgv_lang["file_read_error"]			= "F E J L !!! Privatlivsfilen kunne ikke læses!";
$pgv_lang["edit_exist_person_privacy_settings"]	= "Rediger eksisterende privatlivsindstillinger for personer";
$pgv_lang["edit_exist_user_privacy_settings"]	= "Rediger eksisterende privatlivsindstillinger for bruger";
$pgv_lang["edit_exist_global_facts_settings"]	= "Rediger eksisterende indstillinger for generelle fakta";
$pgv_lang["edit_exist_person_facts_settings"]	= "Rediger eksisterende indstillinger for fakta knyttet til personer";
$pgv_lang["general_privacy"]			= "Standard indstillinger for privatliv";
$pgv_lang["general_privacy_help"]		= "~<b>#pgv_lang[general_privacy]#</b>~<br />Disse indstillinger vil være dine standard indstillinger for den valgte slægtsdatabase.<br />Check titlen på siden for at se om du redigerer den rigtige slægtsdatabase (GEDCOM).<br /><br />Dette betyder også, at for hver slægtsdatabase (hvis du har flere end en) du har i programmet, kan du have forskellige indstillinger.<br /><br />Du kan ændre disse standard indstillinger ved at anvende en anden opsætning af privatliv på siden: <b>#pgv_lang[edit_privacy_title]#</b>.";
$pgv_lang["person_privacy"]				= "Privatlivsindstillinger for personer";
$pgv_lang["person_privacy_help"]		= "~<b>#pgv_lang[person_privacy]#~</b><br />Disse indstillinger giver administratorer mulighed for at ændre indstillingen af privatliv for en bestemt person i GEDCOM-filen. Lad os f.eks sige, at du har et barn, der døde som spæd. Normalt vil alle kunne se alle fakta, fordi barnet er dødt. Men, for dig og familien er disse oplysninger helt private. Du vil ikke fjerne dødsangivelsen, men du vil skjule oplysningerne og gøre dem private. Hvis dette barn har ID I100 skal du indstille privatliv som følger: <br /><br />ID: I100<br />Vis til:\"Vis kun til godkendte brugere\"<br /><br />Dette virker også den anden vej. Hvis du vil vise alle oplysninger om en person (ID 101), som du ved er død, men som ikke er registreret som død, kan du tilføje følgende:<br /><br />ID: I101<br />Vis til: \"Vis til alle\"<br /><br />Dette gemmes i \$person_privacy variablen i den valgte privatlivsfil.";
$pgv_lang["user_privacy"]				= "Privatlivsindstillinger for brugere";
$pgv_lang["user_privacy_help"]			= "~<b>#pgv_lang[user_privacy]#~</b><br />Disse indstillinger giver administratorer mulighed for at omgå den normale indstilling af privatliv for en person i slægtsdatabasen baseret på en brugers brugernavn.<br /><br />Så hvis du ikke vil at brugernavnet \"John\" kan se dine private oplysninger, og du har ID I100 i slægtsdatabasen, kan du gøre således:<br /><br />brugernavn: John<br />ID: I100<br />Vis?: \"Skjul\"<br /><br />Derefter vil dine data kun være skjult for brugernavnet \"John\".<br /><br />For at vise I101's data (som normalt vil være skjult fordi I101 er nulevende) til brugernavnet \"John\" skal du vælge:<br /><br />brugernavn: John<br />ID: I101<br />Vis?: \"Vis\"<br /><br />Dette gemmes i \$user_privacy variablen i den valgte privatlivsfil.";
$pgv_lang["global_facts"]				= "Privatlivsindstillinger for generelle fakta";
$pgv_lang["global_facts_help"]			= "~<b>#pgv_lang[global_facts]#~</b><br />Disse indstillinger gælder for de fakta, der generelt skal skjules for alle personer i slægtsdatabasen.<br /><br />[\"Navn på fakta\"] bestemmer, hvilke fakta der skal skjules. [\"Valg\"] bestemmer fakta eller tilhørende oplysninger. [\"Vis til\"] bestemmer på hvilket adgangsniveau fakta vises.<br /><br />Den generelle faktatabel er beregnet til - på basis af GEDCOM-koder - at skjule visse fakta for alle personer, hvadenten disse er nulevende eller døde. SSN tag er som standard skjult for almindelige besøgende. Dette forhindrer folk i at stjæle personnummer og dermed stjæle døde personers identitet, men er egentlig  mest relevant for USA's vedkommende.<br />Hvis du vil skjule alle ægteskabsdata i din slægtsdatabase for almindelige besøgende, kan du vælge:<br /><br />Navn på fakta: (MARR) - Ægteskab (Marriage)<br />Valg: \"Vis fakta\"<br />Vis til?: \"Vis kun til godkendte brugere\".<br /><br />Navn p fakta: (MARR) - Ægteskab<br />Valg: \"Vis faktaoplysninger\"<br />Vis til ?: \"Vis kun til godkendte brugere\"<br /><br />Disse indstillinger vil skjule ægteskab (og tilhørende oplysninger) for alle, der ikke har administratorrettigheder.<br /><br />Til forskel fra alle andre indstillinger, i \"generelle fakta\" kan du skjule fakta til og med for brugere med administrator rettigheder. Dette kan undertrykke uønskede faktaoplysninger fuldstændig.<br /><br />Dette gemmes i \$global_facts variablen i den valgte privatlivsfil.";
$pgv_lang["person_facts"]				= "Privatlivsindstillinger for personlige fakta";
$pgv_lang["person_facts_help"]			= "~<b>#pgv_lang[person_facts]#~</b><br />Disse indstillinger definerer fakta, der skjules for en specifik person i slægtsdatabasen, samt på hvilket niveau disse fakta skal skjules.<br /><br />Det første valg er personens ID, det næste valg er data.<br />[\"Valg\"] vælger data eller tilhørende oplysninger. Valget [\"Vis til\"] bestemmer på hvilket adgangsniveau disse data skal vises.<br /><br />\"Fakta for personer\"-tabellen fungerer på samme måde som \"generelle fakta\"-tabellen med undtagelse af, at du også kan angive ID for den person, hvis data skal skjules. Du kan altså skjule ægteskabsfeltet for en bestemt person.<br /><br />Dette gemmes i \$person_facts variablen i den valgte privatlivsfil.";
$pgv_lang["accessible_by"]				= "Vis til ?";
$pgv_lang["hide"]						= "Skjul";
$pgv_lang["show_question"]				= "Vis ?";
$pgv_lang["user_name"]					= "Brugernavn";
$pgv_lang["name_of_fact"]				= "Navn på fakta";
$pgv_lang["choice"]						= "Valg";
$pgv_lang["fact_show"]					= "Vis fakta";
$pgv_lang["fact_details"]				= "Vis detaljerede fakta";
$pgv_lang["privacy_header"]				= "Rediger privatlivsindstillinger indefra";
$pgv_lang["unable_to_find_privacy_indi"]	= "Kan ikke finde person med ID ";
$pgv_lang["save_and_import"]			= "Efter at du har gemt denne GEDCOM-konfiguration, er det nødvendigt at importere GEDCOM-filen ved at klikke på knappen <b>Importer GEDCOM</b> eller fra <b>Administration->Slægtsfil(er) og privatliv->Importer GEDCOM</b>";
$pgv_lang["help_info"]				= "Du kan få hjælp til hvert emne ved at klikke på det røde &quot;?&quot; ved siden af mærket for hver celle.";
$pgv_lang["SHOW_LIVING_NAMES"]			= "Vis navn på nulevende";
$pgv_lang["SHOW_LIVING_NAMES_help"]		= "~#pgv_lang[SHOW_LIVING_NAMES]#~<br /><br />Skal navnet på nulevende personer vises til alle?<br /><br />Dette gemmes i \$SHOW_LIVING_NAMES variablen i den valgte privatlivsfil.";
$pgv_lang["SHOW_RESEARCH_ASSISTANT"]			= "Vis forskningsassistent";
$pgv_lang["USE_RELATIONSHIP_PRIVACY"]	= "Brug privatliv på slægtskab";
$pgv_lang["USE_RELATIONSHIP_PRIVACY_help"]	= "~#pgv_lang[USE_RELATIONSHIP_PRIVACY]#~<br /><br /><b>Nej</b> betyder at godkendte brugere kan se alle oplysninger om nulevende personer.<br />'<b>Ja</b>' betyder at brugere kun kan se privat information om nulevende personer de er i familie med.<br /><br />Dette gemmes i \$USE_RELATIONSHIP_PRIVACY variablen i den valgte privatlivsfil.";
$pgv_lang["MAX_RELATION_PATH_LENGTH"]	= "Maksimal stilængde for slægtskab";
$pgv_lang["MAX_RELATION_PATH_LENGTH_help"]	= "~#pgv_lang[MAX_RELATION_PATH_LENGTH]#~<br /><br />Dette gemmes i \$MAX_RELATION_PATH_LENGTH variablen i den valgte privatlivsfil.<br /><br />Hvis <b>#pgv_lang[USE_RELATIONSHIP_PRIVACY]#</b> er aktiv, vil brugere, der er logget ind, kun kunne se og ændre personer indenfor disse trin af graden af slægtskab.";
$pgv_lang["CHECK_MARRIAGE_RELATIONS"]	= "Check ægteskabsrelationer";
$pgv_lang["CHECK_MARRIAGE_RELATIONS_help"]	= "~#pgv_lang[CHECK_MARRIAGE_RELATIONS]#~<br /><br />Check slægtninge for ægteskabsrelationer.<br /><br />Dette gemmes i \$CHECK_MARRIAGE_RELATIONS variabler i den valgte privatlivsfil.";
$pgv_lang["SHOW_DEAD_PEOPLE"]			= "Vis døde personer";
$pgv_lang["SHOW_DEAD_PEOPLE_help"]		= "~#pgv_lang[SHOW_DEAD_PEOPLE]#~<br /><br />Sætter niveauet mht. beskyttelse af privatlivet for alle døde personer.";
$pgv_lang["select_privacyfile_button"]	= "Vælg privatlivsfil";
$pgv_lang["PRIVACY_BY_YEAR"]			= "Begræns privatlivsbeskyttelse ud fra begivenhedsdato";
$pgv_lang["PRIVACY_BY_YEAR_help"]		= "~#pgv_lang[PRIVACY_BY_YEAR]#~<br /><br />Indstillingen for <i>Begræns privatlivsbeskyttelse ud fra begivenhedsdato</i> vil skjule faktaoplysninger for personer baseret på, hvor gamle de var, da begivenheden fandt sted, og uafhængig af, om de lever eller er døde.  Brug denne sammen med indstillingen #pgv_lang[MAX_ALIVE_AGE]#.<br /><br />Eksempel: Hvis du sætter alderen til at være 100 og aktiverer denne indstilling ved at angive <b>Ja</b>, så vil alle personer, levende eller døde, der er født for mindre end 100 år siden, blive vist som Privat.<br />Personer, der blev gift for mindre end 85 år siden, og personer, der døde for mindre end 75 år siden, vil også blive vist som Privat.<br /><br /><b>NB!</b>  <i>Vær opmærksom på, at hvis du aktiverer denne indstilling, så vil tiden, det tager for at vise en side, øges noget.</i><br /><br />Dette gemmes i \$PRIVACY_BY_YEAR variablen i den valgte privatlivsfil.";

//-- language edit utility
$pgv_lang["lang_edit_help"]			= "~#pgv_lang[translator_tools]#~<br /><br />Denne side er beregnet for oversættere.  Du kan oversætte, sammenligne og eksportere sprogfiler.  Der er også en mulighed for at hjælpe oversættere med at bestemme kilden til tekst, der vises som output af PhpGedView.<br /><br />Du kan bruge følgende valgmuligheder og værktøjer:<br />";
$pgv_lang["edit_langdiff"]				= "Redigér og konfigurér sprogfiler";
$pgv_lang["bom_check"]					= "Check af sprogfilerne (BOM)";
$pgv_lang["bom_check_help"]				= "~#pgv_lang[bom_check]#~<br /><br />Dette vil checke alle sprogfiler for koden BOM (Byte Order Mark) i filerne.<br />Hvis koden bliver fundet, vil den blive fjernet.";
$pgv_lang["bom_check_desc"]		= "Dette check vil analysere alle sprogfilerne for BOM (Byte Order Mark). Hvis der findes nogle BOM vil de blive fjernet fra filerne. Disse specielle BOM-koder kan bevirke at dele af PhpGedView ikke fungerer korrekt.";
$pgv_lang["lang_debug"]			= "Valg af hjælpetekst debugger";
$pgv_lang["lang_debug_help"]	= "~#pgv_lang[lang_debug]#~<br /><br />#pgv_lang[lang_debug_desc]#<br />";
$pgv_lang["lang_debug_desc"]	= "Når du aktiverer denne mulighed, så vil navnene på sprogvariablerne, der anvendes i hjælpetekster blive printet i hjælpeteksternes popup vinduer.  Dette vil hjælpe oversættere med at finde navnet på variablen, når teksten skal korrigeres.<br /><br />Denne indstilling er kun gældende for den igangværende PhpGedView session.";
$pgv_lang["lang_debug_use"]		= "Anvend hjælpetekst debugger";
$pgv_lang["bom_not_found"]				= "Ingen BOM koder blev fundet.";
$pgv_lang["bom_found"]					= "BOM koden blev fundet i ";
$pgv_lang["edit_lang_utility"]			= "Værktøj til at rette sprogfil";
$pgv_lang["edit_lang_utility_help"]		= "~#pgv_lang[edit_lang_utility]#~<br /><br />Her kan du ændre indholdet af en sprogfil ved at bruge den engelske tekst som reference.<br />Indholdet af den originale engelske sprogfil vil blive listet sammen med teksten i dit valgte sprog. Ved at klikke på en tekst i din sprogfil, vil et nyt vindue åbnes, hvor du kan ændre i teksten.";
$pgv_lang["edit_lang_utility_desc"]	= "Du kan bruge denne funktion til at redigere indholdet af en sprog-fil ved at bruge indholdet af den engelske.<br /><br />Du kan se indholdet af den originale engelske fil og indholdet af den samme type sprogfil (der er 4 sprogfiler) i det sprog, du har valgt at oversætte.  Du klikker på teksten under den engelske version.  Herved åbnes et nyht vindue, hvor du kan redigere teksten.  Du kan gemme ændringerne eller fortryde dem.";
$pgv_lang["edit_lang_utility_warning"]	= "NB!<br />Hvis du vælger at bruge knappen <i>#pgv_lang[close_window_without_refresh]#</i>, skal du være opmærksom på, at du ikke vil se ændringerne med det samme på skærmen i sprog-redigeringen førend du manuelt trykker på knappen \"Indlæs siden pånyt\".<br />Det kan også hænde at din sprogfil kan blive ødelagtm hvis du tilføjer en besked, der ikke har været i sprogfilen førhen eller hvis du ændrer den samme besked igen.<br /><br /><b>Konklusion:</b> Hvis du ikke er sikker på at du gør det rigtigt, brug da venligst ikke knappen <i>#pgv_lang[close_window_without_refresh]#</i>.";
$pgv_lang["language_to_edit"]			= "Sprog der skal rettes";
$pgv_lang["language_to_edit_help"]		= "~#pgv_lang[language_to_edit]#~<br /><br />I denne drop down liste kan du vælge det sprog, som du ønsker at redigere.<br />";
$pgv_lang["file_to_edit"]				= "Sprogfil der skal rettes";
$pgv_lang["file_to_edit_help"]			= "~#pgv_lang[file_to_edit]#~<br /><br />PhpGedView understøtter mange forskellige sprog.  Det er gjort muligt ved at holde al tekst, der er synlig for brugere, i separate sprogfiler adskilt fra hovedprogrammet. For hvert sprog findes der et sæt på ialt 5 sprogfiler, og de forskellige tekster findes i disse filer. Hvilken afhænger af deres funktion.  Når en tekst endnu ikke er blevet oversat, wil PhpGedView bruge den engelske version.<br /><br />Filerne i hvert sprogsæt er:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder begreber, udtryk og Hjælpetekst til brug for opsætningen af PhpGedView.  Hjælpeteksten er ikke beregnet til at skulle ses af almindelige brugere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste over landenavne, taget fra hjemmesiden: Statistics Division, United Nations Department of Economic and Social Affairs.  Dette er <a href=\"http://unstats.un.org/unsd/methods/m49/m49alpha.htm\" target=_blank><b>linket</b></a> til den engelske liste.  Listen findes på engelsk og fransk.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder den tekst, der svarer til GEDCOM-koder ifølge GEDCOM 5.5.1 standarden.  Den indeholder også supplerende faktakoder, der ikke findes i standarden, men anvendt af mange forskellige slægtsforskningsprogrammer.<br /><br />En engelsk kopi af <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 standarden</b></a> kan downloades i PDF (Portable Document Format).</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder hjælpeteksten for almindelige brugere.  Nogle hjælpetekster i filen er beregnet for administratorer, og er skjulte for brugere, der ikke har administratorrettigheder.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Mange begreber og udtryk findes i denne fil.</li></ul>";
$pgv_lang["check"]						= "Check";
$pgv_lang["lang_save"]					= "Gem";
$pgv_lang["contents"]					= "Indhold";
$pgv_lang["listing"]					= "Listning";
$pgv_lang["no_content"]					= "Ikke noget indhold";
$pgv_lang["editlang"]					= "Ændre";
$pgv_lang["editlang_help"]				= "~#pgv_lang[editlang]#~<br /><br />Ret tekst/besked i sprogfil";
$pgv_lang["savelang"]					= "Gem";
$pgv_lang["savelang_help"]				= "~#pgv_lang[savelang]#~<br /><br />Gem rettet tekst i sprogfil";
$pgv_lang["original_message"]			= "Original tekst";
$pgv_lang["message_to_edit"]			= "Tekst der skal ændres";
$pgv_lang["changed_message"]			= "Ændret indhold";
$pgv_lang["message_empty_warning"]		= "-> Advarsel!!! Denne besked er tom i [#LANGUAGE_FILE#] <-";
$pgv_lang["language_to_export"]			= "Eksportere sprog";
$pgv_lang["language_to_export_help"]		= "~#pgv_lang[language_to_export]#~<br /><br />I denne drop down liste kan du vælge det sprog, hvis meddelelser du ønsker at eksportere.<br /><br />Rutinen understøtter i øjeblikket kun eksport af <i>configure_help_text.php</i> filen.  Outputtet er en HTML-fil, som du kan printe ud vha din browser.<br />";
$pgv_lang["export_lang_utility"]		= "Eksportering af sprogfil";
$pgv_lang["export"]						= "Eksporter";
$pgv_lang["export_lang_utility_help"]	= "~#pgv_lang[export_lang_utility]#~<br /><br />Her kan du vælge et sprog og eksportere indholdet i hjælpeteksterne til konfiguration af PhpGedView for at skrive en dokumentation af programmet på det valgte sprog.";
$pgv_lang["export_lang_utility_desc"]	= "Du kan oprette dokumentation for administratorer.<br /><br />Denne funktion vil oprette en HTML-version af konfigurationshjælpefilen i det valgte sprog.  Du kan bruge din browser til at se filen, der er formatteret så den kan printes ud.";
$pgv_lang["export_ok"]					= "Hjælpeteksterne er eksporteret";
$pgv_lang["compare_lang_utility"]		= "Sammenligning af sprogfiler";
$pgv_lang["compare_lang_utility_help"]	= "~#pgv_lang[compare_lang_utility]#~<br /><br />Her kan du sammenligne to sprog og få en liste over forskellen på de forskellige sprogfiler.<br /><br />Se filen [<a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a>] for andre ændringer af sprogfiler.";
$pgv_lang["compare_lang_utility_desc"]	= "Denne funktion vil sammenligne to sæt af sprogfiler og oprette en liste over hvad der er tilføjet og fjernet i forhold til hinanden.<br /><br />Læs også filen <a href=\"languages/LANG_CHANGELOG.txt\" target=\"_blank\">LANG_CHANGELOG.txt</a> for ændringer af den engelske version.  De engelske filer bør anvendes som udgangspunkt for oprettelse af alle andre sprogfiler.";
$pgv_lang["new_language"]				= "Kildesprog";
$pgv_lang["new_language_help"]			= "~#pgv_lang[new_language]#~<br /><br />I denne drop down liste kan du vælge det sprog, hvis meddelelser du ønsker at sammenligne med et andet sprog.<br /><br />Alle ændringer og tilføjelser til sprogfilerne udføres først på de <b>Engelske</b> sprogfiler, så du vil normalt vælge at sammenligne med de engelske.<br />";
$pgv_lang["old_language"]				= "Sekundær sprog";
$pgv_lang["old_language_help"]			= "~#pgv_lang[old_language]#~<br /><br />I denne drop down liste kan du vælge det sprog, du ønsker at sammenligne med det sprog, der er valgt i drop down listen: <b>Kilde</b>.<br /><br />Efter at du har foretaget dit valg klikker du på knappen: <b>Sammenlign</b> for at få en liste over alle tilføjelser i alle fire filer på begge sprog.<br /><br />For lige at genopfriske din hukommelse:<br /><b>Tilføjelse</b> betyder: Det findes <u>i</u> kildefilen, men <u>ikke</u> i den sekundære fil.<br /><br /><b>Fjernet</b> betyder: Det findes <u>ikke</u> i kildefilen, men det <u>findes</u> i den sekundære fil. Dette kan ske når en given meddelelse ikke længere anvendes og derfor blev fjernet fra de engelske filer.  Du kan trygt fjerne den tilsvarende meddelelse fra de sekundære sprogfiler.<br />";
$pgv_lang["compare"]					= "Sammenlign";
$pgv_lang["comparing"]					= "Sprogfiler der er sammenlignet";
$pgv_lang["additions"]					= "Tilføjelser";
$pgv_lang["no_additions"]				= "Ingen tilføjelser";
$pgv_lang["subtractions"]				= "Fjernet (ikke i brug længere)";
$pgv_lang["no_subtractions"]			= "Intet fjernet";
$pgv_lang["config_lang_utility"]		= "Konfiguration af understøttede sprog";
$pgv_lang["config_lang_utility_help"]	= "~#pgv_lang[config_lang_utility]#~<br /><br />Her kan du aktivere/deaktivere sprog, der er understøttet i PhpGedView.<br /><br />";
$pgv_lang["active"]						= "Aktiv";
$pgv_lang["active_help"]				= "~#pgv_lang[active]#~<br /><br />Giver dig mulighed for at vælge om brugere skal kunne ændre indholdet af sprogfilerne.";
$pgv_lang["edit_settings"]				= "Ændre indstillinger";
$pgv_lang["lang_edit"]					= "Ændre";
$pgv_lang["lang_language"]				= "Sprog";
$pgv_lang["export_filename"]			= "Navn på filen som indeholder eksport data:";
$pgv_lang["lang_back"]					= "Gå tilbage til hovedmenuen for at ændre og konfigurere sprogfiler";
$pgv_lang["lang_back_admin"]			= "Tilbage til Admin menu";
$pgv_lang["lang_back_manage_gedcoms"]	= "Gå tilbage til siden med Slægtsfil(er) og privatliv";
$pgv_lang["lang_name_arabic"]			= "Arabisk";
$pgv_lang["lang_name_czech"]			= "Tjekkisk";
$pgv_lang["lang_name_chinese"]			= "Kinesisk";
$pgv_lang["lang_name_danish"]			= "Dansk";
$pgv_lang["lang_name_dutch"]			= "Hollandsk";
$pgv_lang["lang_name_english"]			= "Engelsk";
$pgv_lang["lang_name_finnish"]			= "Finsk";
$pgv_lang["lang_name_french"]			= "Fransk";
$pgv_lang["lang_name_german"]			= "Tysk";
$pgv_lang["lang_name_greek"]			= "Græsk";
$pgv_lang["lang_name_hebrew"]			= "Hebræisk";
$pgv_lang["lang_name_hungarian"]		= "Ungarsk";
$pgv_lang["lang_name_italian"]			= "Italiensk";
$pgv_lang["lang_name_norwegian"]		= "Norsk";
$pgv_lang["lang_name_polish"]			= "Polsk";
$pgv_lang["lang_name_portuguese"]		= "Portugisisk";
$pgv_lang["lang_name_portuguese-br"]	= "Brasiliansk Portugisisk";
$pgv_lang["lang_name_russian"]			= "Russisk";
$pgv_lang["lang_name_spanish"]			= "Spansk";
$pgv_lang["lang_name_spanish-ar"]		= "Latin-amerikansk spansk";
$pgv_lang["lang_name_swedish"]			= "Svensk";
$pgv_lang["lang_name_turkish"]			= "Tyrkisk";
$pgv_lang["lang_name_lithuanian"]	= "Litauisk";
$pgv_lang["lang_name_vietnamese"]	= "Vietnamesisk";
$pgv_lang["lang_name_estonian"]		= "Estonisk";
$pgv_lang["lang_name_slovak"]		= "Slovakisk";
$pgv_lang["lang_new_language"]			= "Nyt sprog";
$pgv_lang["original_lang_name"]			= "Sprogets navn på dets eget sprog";
$pgv_lang["original_lang_name_help"]	= "~#pgv_lang[original_lang_name]#~<br /><br />Navnet på dette sprog i dets eget sprog.<br /><br />Engelsk hedder på engelsk: English<br />Tysk hedder på tysk: Deutsch<br />Hollandsk hedder på hollandsk: Nederlands<br />osv.";
$pgv_lang["lang_shortcut"]				= "Kort navn på sprogfiler";
$pgv_lang["lang_shortcut_help"]			= "~#pgv_lang[lang_shortcut]#~<br /><br />Denne kode definerer forkortelsen, der er anvendt for at navngive sprogfilerne for det valgte sprog indeni PhpGedView.<br />Normalt er det første kode i 'Sprog-genkendelses-koder' som kan defineres i det næste felt i sprog-opsætnings-vinduet.";
$pgv_lang["lang_langcode"]				= "Kode(r) for genkendelse af sprog";
$pgv_lang["lang_langcode_help"]			= "~#pgv_lang[lang_langcode]#~<br /><br />Disse koder betyder at PhpGedView kan finde indstillingen for sprog i browseren for den bruger, der ser på dine PhpGedView-sider. Koderne skal være adskilt med et semikolon ';'";
$pgv_lang["lang_filenames"]				= "Navn på sprogfiler";
$pgv_lang["lang_filenames_help"]		= "~#pgv_lang[lang_filenames]#~<br /><br />PhpGedView har support på mange forskellige sprog.  Dette er muligt fordi al tekst er gemt i separate filer.  Hvert sprog har fire forskellige filer, der anvendes i PhpGedView afhængig af, hvor teksten bruges og hvilken funktion den har.  Hvis der er tilføjet en tekst, der endnu ikke er oversat, vil den engelske tekst blive vist.<br /><br />Filerne i hvert sprogsæt er:<br /><ul><li><b><i>configure_help.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder ledetekster, tekst for forskellige valg og hjælpetekster til brug for konfigureringen af PhpGedView.  Hjælpeteksten er ikke skrevet mhp at skulle vises for almindelige brugere.</li><br /><li><b><i>countries.xx.php</i></b>&nbsp;&nbsp;Dette er en liste over alle lande i verden, hentet fra listen med betegnelsen ISO 3166-1.</li><br /><li><b><i>facts.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder tekst i henhold til faktakoder i GEDCOM 5.5.1 standard.  Den indeholder også som tillæg faktakoder, der ikke findes i standarden, men som bruges i forskellige slægtsprogrammer.<br /><br />En engelsk kopi af <a href=\"http://www.phpgedview.net/ged551-5.pdf\" target=_blank><b>GEDCOM 5.5.1 Standard</b></a> kan hentes i PDF (Portable Document Format).</li><br /><li><b><i>help_text.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder hjælpetekster for almindelige brugere.  Nogle af emnerne i denne fil er specielt tilrettelagt for administratorer og er skjult for brugere, der ikke har administrator-rettigheder.</li><br /><li><b><i>lang.xx.php</i></b>&nbsp;&nbsp;Denne fil indeholder ord og udryk der anvendes i menuer, slægtstræer, lister, udskrifter og andre sider for den almindelige brug af PhpGedView.</li></ul>";
$pgv_lang["flagsfile"]					= "Navn på flag-billedfil";
$pgv_lang["flagsfile_help"]				= "~#pgv_lang[flagsfile]#~<br /><br />Navn og sti til billedfilen med nationalflaget for dette sprog.";
$pgv_lang["text_direction"]				= "Tekstretning";
$pgv_lang["text_direction_help"]		= "~#pgv_lang[text_direction]#~<br /><br />Definerer hvilken retning teksten bliver skrevet i det valgte sprog.<br /><br />Normalt viser alle vestlige sprog en tekst fra venstre til højre.<br />Men sprog som Arabisk eller Hebræisk viser en tekst fra højre til venstre.";
$pgv_lang["date_format"]				= "Datoformat";
$pgv_lang["date_format_help"]			= "~#pgv_lang[date_format]#~<br /><br />Dette felt definerer dato formatet, som normalt er anvendt i slægtsfelterne på det valgte sprog.<br /><br />Variabler du kan bruge er:<br />D for dag<br />M for måned<br />Y for år.<br /><br />Du kan ændre rækkefølgen i feltet og/eller tilføje skilletegn i det.<br /><br />Standard opsætningen for dansk er 'D. M Y', som betyder at datoer indeni en GEDCOM-post som fx 'DATE 20 Nov 1965' vil blive vist i PhpGedView som '20. November 1965'.<br /><br />For eksempel i England har dette felt indholdet: 'D M Y' som vil resultere i, at PhpGedView på det engelske sprog vil vise: '20 November 1965'.<br /><br />Et andet eksempel er det ungarske sprog, som definerer datoen som 'Y. M D.' og her vil denne dato blive vist som '1965. marraskuuta 20.' i PhpGedView.<br />Endnu et eksempel er det finske sprogt som definerer datoen som 'D. M#ta# Y' og her vil denne dato blive vist som '20. marraskuuta 1965'.";
$pgv_lang["time_format"]				= "Tidsformat";
$pgv_lang["time_format_help"]			= "~#pgv_lang[time_format]#~<br /><br />Dette felt definerer formatet på klokkeslæt, der bliver anvendt i det valgte sprog.<br /><br />Variablerne, du kan bruge er:<br />a - Små bogstaver ante meridium og post meridium - 'am' eller 'pm'<br />A - Store bogstaver Ante Meridium og Post Meridiem - 'AM' eller 'PM'<br />B - Swatch Internet tid - 000 til 999<br />c - ISO 8601 dato (inkluderet i PHP 5) - 2004-02-12T15:19:21+00:00<br />d - Dag i måneden, 2 cifre med begyndelsesnul (0() - 01 til 31<br />D - En tekstbaseret præsentation af dagen, kun tre bogstaver - Man til Søn<br />F - En tekstbaseret præsentation af måneden, hele navnet - Januar til December<br />g - 12-timers-format af timer uden et begyndelsesnul (0) - 1 til 12<br />G - 24-timers-format af timer uden begyndelsesnul (0) - 0 til 23<br />h - 12-timers-format af timer med begyndelsesnul (0) - 01 til 12<br />H - 24-timers-format af timer med begyndelsesnul (0) - 00 til 23<br />i - Minutter med begyndelsesnul (0) - 00 til 59<br />I - (stort i) Bestemmer om landet anvender Sommertid - 1 time i sommertiden, 0 i normal-/vintertiden.<br />j - Dag i måneden uden begyndelsesnul (0) - 1 til 31<br />l - (liten 'L') En tekstbaseret præsentation af ugedagen, hele navnet - Søndag til Lørdag<br />M - En tekstbaseret præsentation af måneden, tre bogstaver - Jan til Dec<br />O - Differencen til Greenwich tid (GMT) i timer - Eksempel: +0200<br />r - RFC 2822 formateret dato - Eksempel: Tor, 21 Dec 2000 16:01:07 +0200<br />s - Sekunder, med begyndelsesnul (0) - 00 til 59<br />S - Engelsk ordensbetegnelse for dagen i måneden, 2 bogstaver - st, nd, rd eller th. Fungerer godt med j<br />T - Tidzoneopsætning for denne PC - Eksempler: CEST, EST, MDT ...<br />U - Sekunder siden Unix Epoch (1. Januar 1970 00:00:00 GMT)<br />W - ISO-8601 ugenummer i året, uger starter på mandag (inkluderet i PHP 4.1.0) Eksempel: 42 (uge 42 i dette år)<br />Y - En talbaseret præsentation af et år, 4 cifre - Eksempler: 1999 eller 2003<br />y - En talbaseret præsentation af et år - Eksempler: 99 eller 03<br />z - Dagen i året (starter fra 0) - 0 til 365<br />Z - Tidzoneopsætning i sekunder. Opsættes for tidzoner vest for UTC er altid negativ, og tidzoner øst for UTC er altid positive. - -43200 til 43200<br /><br />Du kan skifte rækkefølgen inde i dette felt og/eller tilføje skilletegn.<br />For eksempel i Norge har dette felt indholdet: 'HI:i:s' som vil give dette resultat: '09:01:25'.<br />Den engelske standard vil blive defineret sådan: 'g:i:sa' som vil give dette resultat: '9:01:25am'.";
$pgv_lang["week_start"]					= "Ugestart";
$pgv_lang["week_start_help"]			= "~#pgv_lang[week_start]#~<br /><br />Ugedagen, der markerer starten på en ny uge i dette sprog.  I mange lande starter ugen om søndagen, mens den i andre lande starter på en mandag eller en anden dag.";
$pgv_lang["name_reverse"]				= "Efternavn først";
$pgv_lang["name_reverse_help"]			= "~#pgv_lang[name_reverse]#~<br /><br />I nogle sprog bør efternavnet vises først i stedet for som normalt sidst. Ved at aktivere dette valg vil efternavnet blive vist først.";
$pgv_lang["ltr"]						= "Venstre til højre";
$pgv_lang["rtl"]						= "Højre til venstre";
$pgv_lang["file_does_not_exist"]		= "FEJL! Kan ikke finde filen...";
$pgv_lang["alphabet_upper"]				= "STORE bogstaver alfabetisk";
$pgv_lang["alphabet_upper_help"]		= "~#pgv_lang[alphabet_upper]#~<br /><br />Sprogets store bogstaver i alfabetisk rækkefølge. Dette bruges for sortering af navnelister i PhpGedView på det valgte sprog.";
$pgv_lang["multi_letter_alphabet"]		= "Fler-bogstavs alfabet";
$pgv_lang["alphabet_lower"]				= "Små bogstaver alfabetisk";
$pgv_lang["alphabet_lower_help"]		= "~#pgv_lang[alphabet_lower]#~<br /><br />Sprogets små bogstaver i alfabetisk rækkefølge. Dette bruges for sortering af navnelister i PhpGedView på det valgte sprog.";
$pgv_lang["translation_forum_help"]	= "~#pgv_lang[translation_forum]#~<br /><br />#pgv_lang[translation_forum_desc]#<br />";
$pgv_lang["dictionary_sort"]		= "Brug ordbogsregler ved sortering";
$pgv_lang["lang_config_write_error"]	= "Fejl ved skriving af sprogets indstillinger til filen [language_settings.php]. Check rettigheder og prøv igen.";
$pgv_lang["translation_forum"]			= "Link til PhpGedView Forum for oversættere på SourceForge (engelsk)";
$pgv_lang["translation_forum_desc"]	= "Dette <a href=\"http://sourceforge.net/forum/forum.php?forum_id=294245\" target=_blank><b>link</b></a> åbner et nyt browservindue.  Du vil blive redirigeret til PhpGedViews forum: <b>Translation forum</b>, hvor du kan diskutere emner vedr. oversættelse.";
$pgv_lang["lang_set_file_read_error"]	= "F E J L !!! Kunne ikke læse filen [language_settings.php]!";
$pgv_lang["add_new_language_help"]		= "Du kan bruge dette værktøj til at tilføje et nyt og endnu ikke understøttet sprog for PhpGedView.<br />Udfyld venligst alle nødvendige felter i det næste vindue.<br />Efter at have oprettet de nye filer, vil du kunne ændre teksten til dette sprog.";
$pgv_lang["add_new_language_desc"]	= "Denne funktion giver dig mulighed for at tilføje et nyt sprog, der ikke tidligere har været oversat og understøttet af PhpGedView.<br /><br />Du kan konfigurere standardindstillingerne for det nye sprog.  Konfigurationen indeholder koder til sproggenkendelse, sprogets skrive og læseretning, hvilken dag en uge starter for det pågældende sprogområde, tidszoner, alfabet, osv.<br /><br />Du vil få mere hjælp vedr. konfiugration og indstillinger af de sprog, der understøttes af PhpGedView, efter at du har valgt sproget og klikket på: <b>#pgv_lang[add_new_lang_button]#</b> knappen.<br /><br />Mere hjælp kan findes på konfigurationssiden for det aktuelle sprog.<br />";
$pgv_lang["add_new_lang_button"]		= "Tlføj et nyt sprog";
$pgv_lang["hide_translated"]			= "Skjul oversættelse";
$pgv_lang["hide_translated_help"]		= "~#pgv_lang[hide_translated]#~<br /><br />Vælges <b>Ja</b> vil man kun se meddelelser på det valgte sprog, der ikke er blevet oversat.  Det betyder, at de nye meddelelser <u>ikke</u> vises i den valgte sprogfil.<br /><br />Nogle sprogfiler indeholder engelsk tekst for forskellige meddelelser, der ikke er oversat.  Denne funktion kan ikke identificere disse uoversatte tekstenheder, da de allerede findes i den valgte sprogfil.  Følgende antages: \"Hvis meddelelsen findes i den sekundære sprogfil, må den findes i en oversat version.\"<br />";
$pgv_lang["lang_file_write_error"]		= "F E J L !!!<br /><br />Kunne ikke gemme ændringer i den valgte sprogfil!<br />Check rettighederne til at skrive til (#lang_filename#)";
$pgv_lang["no_open"]					= "F E J L !!!<br /><br />Kunne ikke åbne filen #lang_filename#";
$pgv_lang["users_langs"]			= "Brugeres sprog";
$pgv_lang["configured_languages"]	= "Anvendte sprog";

//-- User Migration Tool messages
$pgv_lang["um_header"] 					= "Konverteringsværktøj til en anden database";
$pgv_lang["um_proceed"] 				= "Start eksport af datafilerne om brugeren?<br /><br />";
$pgv_lang["um_creating"] 				= "Opretter";
$pgv_lang["um_sql_index"]				= "Dette værktøj vil oprette filen <i>authenticate.php</i> og flere andre <i>.dat</i> filer i din indeksmappe.<br /><br />Efter at filerne er oprettet, kan du skifte til Indeks tilstand med alle registrerede brugere og deres meddelelser, favoritter, nyheder og MyGedview layout intakt.<br /><br />NB! Efter at du har skiftet til Indeks tilstand, skal du importere GEDCOM-fil(erne) påny.<br /><br />";
$pgv_lang["um_file_create_fail1"] 		= "Kunne ikke oprette filen fordi en fil med samme navn allerede findes:";
$pgv_lang["um_file_create_fail2"] 		= "Kunne ikke oprette filen";
$pgv_lang["um_file_create_fail3"] 		= "Kontrollér adgangsrettighederne til denne mappe.";
$pgv_lang["um_file_create_succ1"] 		= "Den nye fil er gemt:";
$pgv_lang["um_file_not_created"] 		= "Filen blev ikke oprettet.";
$pgv_lang["um_nomsg"] 					= "Kunne ikke finde nogen \"Beskeder\" gemt i systemet.";
$pgv_lang["um_nofav"] 					= "Kunne ikke finde nogen \"Favoritter\" gemt i systemet.";
$pgv_lang["um_nonews"] 					= "Kunne ikke finde nogen \"Nyheder\" gemt i systemet.";
$pgv_lang["um_noblocks"] 				= "Kunne ikke finde nogen \"Rammer\" gemt i systemet.";
$pgv_lang["um_index_sql"] = "Dette værktøj vil importere filen <i>authenticate.php</i> og andre <i>.dat</i> filer fra din indeksmappe til din database.<br />";
$pgv_lang["um_noaction"] = "Det er ikke nødvendigt at konvertere bruger-information til SQL-mode nu.<br /><br />Når du har ændret opsætningen til SQL-mode, må du imidlertid udføre konverteringen for at importere alle data i SQL-databasen.  PhpGedView vil da bruge de eksisterende filer fra Index-mode.<br /><br /><b>PS! <u>Ikke</u> fjerne filen <i>authenticate.php</i> og <i>.dat</i> filerne fra din indeksmappe mens du skifter.</b><br />";
$pgv_lang["um_import"] = "Import";
$pgv_lang["um_export"] = "Eksport";
$pgv_lang["um_explain"] = "Dette værktøj vil enten eksportere brugerdata fra SQL til indeks tilstand eller importere brugerdata fra indeksfiler til SQL-tabeller.<br /><br />Brugerdata, favoritter, rammedefinitioner, meddelelser og nyheder vil blive gjort tilgængelig igen efter, at du har skiftet tilstand.<br /><br /><b>ADVARSEL</b><br />Du kan ikke bruge dette værktøj til at overføre brugerdata mellem forskellige versioner af PhpGedView.  Vær sikker på at dataene stammer fra, eller er importeret til, den samme PhpGedView version.<br /><br /><b>IMPORTERE</b><br />Hvis du vælger at importere brugerdata-filerne fra indeks tilstand, vil eventuelle tidligere brugerdata, blive <u>overskrevet</u>. Med andre ord så fletter dette værktøj <u>ikke</u> informationen, men indlægger informationen påny. Når du er færdig med importen, så er det ikke muligt at hente den gamle information igen.<br /><br /><b>EKSPORTERE</b><br />Hvis du eksporterer brugerinformationen fra din SQL-database til indeks tilstand filer, vil værktøjet gemme filen <i>authenticate.php</i> og flere <i>.dat</i>-filer i din \"index\" mappe. Hvis der allerede findes filer med samme navn, vil du blive spurgt, om de skal overskrives. Efter at du har skiftet til indeks tilstand, vil al information være tilgængelig direkte.<br /><br /><b>NB!</b> Efter at du har skiftet til indeks tilstand, SKAL du importere dine GEDCOM-filer påny.<br /><br />";
$pgv_lang["um_tool_help"] = "~#pgv_lang[um_header]#~<br /><br />#pgv_lang[um_explain]#";
$pgv_lang["um_sql_index_help"] = "~Flyt brugere fra SQL til Index mode~<br /><br />#pgv_lang[um_sql_index]#";
$pgv_lang["um_index_sql_help"] = "~Flyt brugere fra Index til SQL mode~<br /><br />#pgv_lang[um_index_sql]#";
$pgv_lang["um_imp_users"] = "Importerer brugere";
$pgv_lang["um_imp_blocks"] = "Importerer rammer";
$pgv_lang["um_imp_favorites"] = "Importerer favoritter";
$pgv_lang["um_imp_messages"] = "Importerer meddelelser";
$pgv_lang["um_imp_news"] = "Importerer nyheder";
$pgv_lang["um_nousers"] = "Fandt ikke filen <i>authenticate.php</i> mappen index. Overførslen er afbrudt.";
$pgv_lang["um_imp_succ"] = "Importen er udført";
$pgv_lang["um_imp_fail"] = "Importen blev ikke fuldført";
$pgv_lang["um_backup"] = "Sikkerhedskopi";
$pgv_lang["um_zip_succ"] = "ZIP-fil er nu oprettet.";
$pgv_lang["um_zip_dl"] = "Download sikkerhedskopi (ZIP-fil)";
$pgv_lang["um_bu_explain"] = "Dette værktøj kan oprette en sikkerhedskopi af forskellige data i slægtsdatabasen (PhpGedView).<br /><br />Dataene, som du vælger at tage sikkerhedskopi af, vil blive samlet i en ZIP-fil, som det også er muligt at downloade ved at klikke nederst på siden, efter at sikkerhedskopieringen er udført.<br /><br />ZIP-filen vil forblive i din indeksmappe indtil du fjerner den manuelt.";
$pgv_lang["um_bu_help"] = "~#pgv_lang[um_backup]#~<br /><br />#pgv_lang[um_bu_explain]#";
$pgv_lang["um_bu_config"] = "PhpGedView konfigurationsfil";
$pgv_lang["um_bu_gedcoms"] = "GEDCOM-filer";
$pgv_lang["um_bu_gedsets"] = "GEDCOM-indstillinger, konfiguration og privatlivsfiler";
$pgv_lang["um_bu_logs"] = "GEDCOM-tællere, søgelogs og PhpGedView logfiler";
$pgv_lang["um_bu_media"]	= "Mediefiler";
$pgv_lang["um_bu_usinfo"] = "Bruger definitioner, Ramme indstillinger, Favoritter, Meddelelser, Nyheder";
$pgv_lang["um_mk_bu"] = "Oprette en sikkerhedskopi";
$pgv_lang["um_nofiles"] = "Ingen filer fundet til sikkerhedskopiering.";
$pgv_lang["um_files_exist"] = "En eller flere filer findes allerede. Ønsker du at overskrive dem?";
$pgv_lang["um_results"]		= "Resultater";
$pgv_lang["preview_faq_item"] = "Se alle FAQ i preview";
$pgv_lang["preview_faq_item_help"] = "~#pgv_lang[preview_faq_item]#~<br />Vælges dette kan en bruger med administratorrettigheder se FAQ-siden uden redigeringsmuligheder og links.<br /><br /> Med undtagelse af et enkelt <b>Rediger</b> link ovenover den første FAQ, så vil FAQ-siden være mage til den side en almindelig bruger kan se. Det specielle <b>Rediger</b> link vil genskabe den fulde redigeringsfunktionalitet for FAQ-siden.<br />";
$pgv_lang["restore_faq_edits"] = "Genskab funktionalitet til redigering af FAQ";
$pgv_lang["restore_faq_edits_help"] = "~#pgv_lang[restore_faq_edits]#~<br />Denne mulighed genskaber FAQ-siden til det en administrator normalt ser, således at de enkelte punkter på FAQ-siden kan redigeres.<br />";
$pgv_lang["add_faq_item"] = "Tilføj en FAQ";
$pgv_lang["add_faq_item_help"] = "~#pgv_lang[add_faq_item]#~<br />Klik her for at tilføje et punkt på FAQ-siden.<br /> FAQ er et akronym for Frequently Asked Questions, der på dansk kan oversættes til Oftest Stillede Spørgsmål.";
$pgv_lang["edit_faq_item"] = "Rediger en FAQ";
$pgv_lang["edit_faq_item_help"] = "~#pgv_lang[edit_faq_item]#~<br />Vælges denne mulighed kan du redigere et punkt på FAQ-siden.<br />";
$pgv_lang["delete_faq_item"] = "Slet en FAQ";
$pgv_lang["delete_faq_item_help"] = "~#pgv_lang[delete_faq_item]#~<br />Vælges denne mulighed kan du slette et punkt på FAQ-siden<br />";
$pgv_lang["moveup_faq_item"] = "Flyt en FAQ op";
$pgv_lang["moveup_faq_item_help"] = "~#pgv_lang[moveup_faq_item]#~<br />Vælges denne mulighed kan du flytte et punkt på FAQ-siden op.<br /><br />Hver gang du bruger denne valgmulighed, vil positionen af punktet reduceres med en.  Du kan opnå det samme ved at redigere et punkt og ændre FAQ-positionsfeltet.  Når der er flere FAQ-punkter med samme positionsnummer, vil kun en af dem være synlig.<br />";
$pgv_lang["movedown_faq_item"] = "Flyt en FAQ ned";
$pgv_lang["movedown_faq_item_help"] = "~#pgv_lang[movedown_faq_item]#~<br />Vælges denne mulighed kan du flytte et punkt på FAQ-siden ned.<br /><br />Hver gang du bruger denne valgmulighed, vil positionen af punktet forøges med en. Du kan opnå det samme ved at redigere et punkt og ændre FAQ-positionsfeltet. Når der er flere FAQ-punkter med samme positionsnummer, vil kun en af dem være synlig.<br />";
$pgv_lang["add_faq_header_help"] = "~FAQ-hoved~<br />Her skrives titlen eller emnet for et punkt på FAQ-siden.<br /><br />Titlen kan formatteres; HTML tags som &lt;b&gt; og &lt;br&gt; er tilladte, såvel som HTML koder som fx &amp;amp; og &amp;nbsp;.  Man kan ikke anvende HTML tags.<br />";
$pgv_lang["add_faq_body_help"] = "~FAQ-indhold~<br />FAQ-teksten skrives her.<br /><br />Teksten kan formatteres; HTML tags som &lt;b&gt; og &lt;br&gt; er tilladte, såvel som HTML koder som fx &amp;amp; og &amp;nbsp;.  Man kan ikke anvende HTML tags.<br />";
$pgv_lang["add_faq_order_help"] = "~FAQ-placering~<br />Dette felt styrer rækkefølgen af punkterne på FAQ-siden.<br /><br />Du behøver ikke at indsætte numrene i rækkefølge.  Hvis du laver huller i nummerrækkefølgen, kan du indsætte andre FAQ-punkter senere.  For eksempel, hvis du anvender numrene 1, 6, 11, 16, så kan du senere indsætte et punkt og nummerere det med et af de manglende numre i rækkefølgen.  Negative numre og nul er tilladte, og kan anvendes til at indsætte punkter foran det første i rækken.<br /><br />Når mere end et punkt på FAQ-siden har det samme positionsnummer, så kan kun en af disse punkter ses.<br />";
$pgv_lang["time_limit_help"]			= "~#pgv_lang[time_limit]#~<br /><br />Den maximale importtid for en GEDCOM-fil.";

// Media items 
$pgv_lang["media_import_help"] = "~#pgv_lang[media_import]#~<br />Denne import vil konvertere multimedie links i din GEDCOM-fil til multimedie poster. For eksempel så vil de følgende medie links ændres fra:<blockquote><code>1 OBJE<br />2 FORM jpg<br />2 FILE media/farmor.jpg<br />2 TITL Foto af farmor</code></blockquote>til:<blockquote><code>0 @M1@ OBJE<br />1 FORM jpg<br />1 FILE media/farmor.jpg<br />1 TITL Foto af farmor</code></blockquote>Den nye multimedie post vil blive gemt separat i databasen. Links til eksterne multimedie filer vil blive ændret til referencer til den nye multimedie post, som til gengæld vil indeholde en reference til den eksterne fil. For eksempel så vil den følgende GEDCOM-post blive ændret fra:<blockquote><code>0 @I1@ INDI<br />1 NAME Dit/Navn/<br />1 OBJE<br />2 FORM jpg<br />2 FILE media/farmor.jpg<br />2 TITL Foto af farmor</code></blockquote>til:<blockquote><code>0 @I1@ INDI<br />1 NAME Dit/Navn/<br />1 OBJE @M1@<br /></code></blockquote>Fordelen ved at bruge multimedie poster er, at du let kan administrere dine mediefiler. Når du ændrer titlen på en multimedie post, ændres den i alle GEDCOM-poster, der linker til den. Adskillige personer, familier eller kilder kan linkes til den samme multimedie post.";

$pgv_lang["new_gedcom_title"]		= "Slægtsforskning fra [#GEDCOMFILE#]";
$pgv_lang["USE_MEDIA_VIEWER"]			= "Brug mediefremviser";
$pgv_lang["SHOW_PRIVATE_RELATIONSHIPS"]	= "Vis private relationer";
$pgv_lang["SYNC_GEDCOM_FILE"]			= "Synkroniser ændringer ind i GEDCOM filen";
?>
