/* -*- c++ -*-

This is Picprog, Microchip PIC programmer software for the serial port device.
Copyright © 1997,2002,2003,2004 Jaakko Hyvätti

This program is free software; you can redistribute it and/or modify
it under the terms of the GNU General Public License version 2 as
published by the Free Software Foundation.

This program is distributed in the hope that it will be useful,
but WITHOUT ANY WARRANTY; without even the implied warranty of
MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
GNU General Public License for more details.

You should have received a copy of the GNU General Public License
along with this program; if not, write to the Free Software Foundation,
Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.

The author may be contacted at:

Email: Jaakko.Hyvatti@iki.fi
URL:   http://www.iki.fi/hyvatti/
Phone: +358 40 5011222

Please send any suggestions, bug reports, success stories etc. to the
Email address above.

*/


#ifndef H_PICPORT
#define H_PICPORT

#include <termios.h>
#include <sys/ioctl.h>
#include <time.h>

class picport {

  int fd;
  struct termios saved, termstate;
  unsigned long addr;
  int debug_on;
  char *portname;
  int W[16];

  int modembits;
  void set_clock_data (int rts, int dtr);

  void p_out (int b);
  int p_in ();

#if defined(__x86_64__) || defined(__i386__)
#define RDTSC_WORKS
#endif
// How many tsc clocks (cpu clock cycles) per 1000 ns
  static unsigned int tsc_1000ns;
  static int use_nanosleep;
  static int slow_loops;

public:

  static void delay (long ns);

  enum commands {
    load_conf = 0, data_for_prog = 2, data_from_prog = 4,
    inc_addr = 6, beg_prog = 010, data_for_data = 3,
    data_from_data = 5, erase_prog = 011, erase_data = 013,     
    command1 = 1, command7 = 7, end_prog = 016,
    end_prog_only = 027, beg_prog_only = 030, chip_erase = 037
  };

  enum commands18 {
    instr = 000,
    shift_out = 002,
    tread = 010,
    tread_inc = 011,
    tread_dec = 012,
    inc_tread = 013,
    twrite = 014,
    twrite_inc2 = 015,
    twrite_dec2 = 016,
    twrite_prog = 017,

    // flag for command18() method to implement programming delay by
    // holding fourth command clock cycle up.
    nop_prog = 0100,
    // Flag for erase delay
    nop_erase = 0200,
  };

  enum commands30 {
    SIX = 0,
    REGOUT = 1,
  };

  picport (const char *tty, bool nordtsc, bool slow);

  ~picport ();

  int command (enum commands comm, int data = 0);
  int command18 (enum commands18 comm, int data = 0);
  int command30 (enum commands30 comm, int data = 0);
  void setaddress (unsigned long a);
  void setaddress30 (unsigned long a);

  unsigned long address () { return addr; }

  void force ();
  void reset ();
  const char *port () { return portname; }

  void debug (int d) { debug_on = d; }
};

#endif // H_PICPORT
