<?xml version="1.0"?>
<xsl:stylesheet xmlns:xsl="http://www.w3.org/1999/XSL/Transform" xmlns:qof-qsf="http://qof.sourceforge.net/" xmlns:html="http://www.w3.org/1999/xhtml" xmlns:dt="http://xsltsl.org/date-time" xmlns:str="http://xsltsl.org/string" xmlns:date="http://exslt.org/dates-and-times" version="1.0" exclude-result-prefixes="qof-qsf html date dt str">
  <xsl:import href="date-time.xsl"/>
  <xsl:import href="string.xsl"/>
  <xsl:import href="date.difference.xsl"/>
<!-- our own pilot-qof standard routines -->
  <xsl:import href="pilot-qof-std.xsl"/>
<!--This stylesheet converts the output from pilot-qof invoice-city
  or invoice-vendor options into summary of mileage claims. -->
<!--This is only a working prototype - it needs cleaning up -->
<!-- Licence

  This file is free software; you can redistribute it and/or modify
  it under the terms of the GNU General Public License as published by
  the Free Software Foundation; either version 2 of the License, or
  (at your option) any later version.

  This program is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
  GNU General Public License for more details.

  You should have received a copy of the GNU General Public License
  along with this program; if not, write to the Free Software
  Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
-->
  <xsl:output method="html" encoding="utf-8"/>
<!-- Translation support via external parameters -->
  <xsl:param name="miles">miles</xsl:param>
  <xsl:param name="total">Total</xsl:param>
<!-- end configuration -->
  <xsl:template match="/">
    <xsl:message>.</xsl:message>
    <xsl:message>This stylesheet is part of pilot-qof.</xsl:message>
    <xsl:message>pilot-qof is free software (GPL) and comes with NO WARRANTY.</xsl:message>
    <xsl:message>See 'COPYING' in the pilot-qof source for more information.</xsl:message>
    <xsl:message>Parameters are mileage-rate and hourly-rate.</xsl:message>
    <xsl:message>Writing pilot-qof data to HTML mileage summary:</xsl:message>
        <html>
          <xsl:attribute name="lang">
            <xsl:value-of select="$html_lang"/>
          </xsl:attribute>
          <head>
            <title>
              <xsl:text>Mileage Summary </xsl:text>
            </title>
            <link rel="stylesheet" href="invoice.css" type="text/css"/>
          </head>
          <body>
                  <xsl:variable name="mileage_total">
                    <xsl:variable name="check_value">
                      <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_expenses']">
                        <xsl:call-template name="calc_mileage"/>
                      </xsl:for-each>
                    </xsl:variable>
                    <xsl:choose>
                      <xsl:when test="$check_value &gt; 0">
                        <xsl:value-of select="number($check_value)"/>
                      </xsl:when>
                      <xsl:otherwise>0</xsl:otherwise>
                    </xsl:choose>
                  </xsl:variable>
            <h1>
           <xsl:value-of select="number($mileage_total)"/>
           </h1>
          <ul>
          <xsl:for-each select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_expenses']">
            <li>
                <xsl:value-of select="qof-qsf:string[@type='expense_city']"/>
                <xsl:text> : </xsl:text>
                  <xsl:variable name="numeric">
                    <xsl:call-template name="numeric_to_double">
                      <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
                    </xsl:call-template>
                  </xsl:variable>
                  <xsl:value-of select="$numeric"/>
                  <xsl:text> : </xsl:text>
              <xsl:call-template name="dt:format-date-time">
                <xsl:with-param name="xsd-date-time" select="qof-qsf:time[@type='expense_date']"/>
                <xsl:with-param name="format" select="'%A, %d %B %Y'"/>
              </xsl:call-template>
            </li>
    </xsl:for-each>
    </ul>
          </body>
        </html>
  </xsl:template>

  <xsl:template match="*|@*|node()"/>
  <xsl:template name="calc_date">
    <xsl:variable name="diff_string">
      <xsl:call-template name="date:difference">
        <xsl:with-param name="start" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='start_time']"/>
        <xsl:with-param name="end" select="/*/qof-qsf:book/qof-qsf:object[@type='pilot_datebook']/qof-qsf:time[@type='end_time']"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="diff_secs" select="date:seconds($diff_string)"/>
    <xsl:choose>
      <xsl:when test="$diff_secs &gt; 0">
        <xsl:value-of select="number($diff_secs div 3600 * $hourly-rate)"/>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="calc_mileage">
    <xsl:variable name="numeric">
      <xsl:call-template name="numeric_to_double">
        <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="type" select="qof-qsf:string[@type='type_of_expense']"/>
    <xsl:choose>
      <xsl:when test="$type='Mileage'">
        <xsl:variable name="miles" select="number($numeric)"/>
        <xsl:choose>
          <xsl:when test="$miles &gt; 0">
            <xsl:variable name="subtotal" select="number($miles * 1)"/>
            <xsl:value-of select="$subtotal"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:when>
      <xsl:otherwise>0</xsl:otherwise>
    </xsl:choose>
  </xsl:template>
  <xsl:template name="calc_expense">
    <xsl:variable name="numeric">
      <xsl:call-template name="numeric_to_double">
        <xsl:with-param name="numeric_string" select="qof-qsf:numeric"/>
      </xsl:call-template>
    </xsl:variable>
    <xsl:variable name="type" select="qof-qsf:string[@type='type_of_expense']"/>
    <xsl:choose>
      <xsl:when test="$type='Mileage'">0</xsl:when>
      <xsl:otherwise>
        <xsl:choose>
          <xsl:when test="$numeric &gt; 0">
            <xsl:value-of select="number($numeric)"/>
          </xsl:when>
          <xsl:otherwise>0</xsl:otherwise>
        </xsl:choose>
      </xsl:otherwise>
    </xsl:choose>
  </xsl:template>


</xsl:stylesheet>
