/*
 * PIMPPA - FileSearch
 *
 * Takes a filename pattern as argument, returns matched filenames
 * from database
 *
 * Note: Uses SQL-style wildcards '% for *' and '_ for ?'.
 *
 * Usage: Add -p to print pathnames as well
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include <unistd.h>

#include "pimppa.h"

void usage(char *name)
{
	fprintf(stderr, "Usage: %s [-dpv] <pattern>\n\n"
			"-d      Try to match file descriptions instead\n"
			"-p      Print paths as well\n"
			"-v      Verbose, print file descriptions\n", 
			name);
}

int main(int argc, char *argv[])
{
	char *temp_fn=NULL;
	MYSQL *db;
	MYSQL_RES *sql_result;
	MYSQL_ROW sql_row;
	int files_found=0;
	int go=1,path_too=0,is_desc=0,verbose=0;
	
	if(argc<2)
	{
		usage(argv[0]);
		return(0);
	}

	while(go)
	{
		switch(getopt(argc, argv, "dhpvV"))
		{
			case 'd':
				is_desc=1;
				break;
			case 'p':
				path_too=1;
				break;
			case -1:
				go=0;
				break;
			case 'h':
				usage(argv[0]);
				return(0);
				break;
			case 'v':
				verbose=1;
				break;
			case 'V':
				printf("%s %s %s\n", PACKAGE, argv[0], VERSION);
				return(0);
				break;
			default:
				break;
		}
	}

	db=p_connect();
	if(!db)
		return(-1);

//	mysql_escape_string(escaped_fn, argv[1], strlen(argv[1]) );
	
	temp_fn=argv[optind];

	do
	{
		go=0;

		p_query(db, "SELECT file_name, file_backup, "
			    "  file_integ,file_desc %s "
			    "FROM p_files %s "
			    "WHERE %s like '%s' %s "
			    "ORDER BY file_name", 
			(path_too ? ",area_path" : ""),
			(path_too ? ",p_areas" : ""),
			(is_desc ? "file_desc" : "file_name"),
			temp_fn,
			(path_too ? "AND file_area=area_id" : ""));
		if(mysql_error(db)[0])
		{
			printf("%s\n", mysql_error(db));
			break;
		}
		
		sql_result=mysql_use_result(db);
		if(sql_result)
		{
			while((sql_row=mysql_fetch_row(sql_result)))
			{
				int file_integ=atoi(sql_row[2]);
			
				if(path_too)
					printf("%s%s %s%s\n", sql_row[4], sql_row[0], 
						(sql_row[1][0]=='0' ? "" : sql_row[1]), 
						(file_integ==INTEG_FAILED ? " (check failed!)" : ""));
				else
					printf("%s %s%s\n", sql_row[0], 
						(sql_row[1][0]=='0' ?  "" : sql_row[1]), 
						(file_integ==INTEG_FAILED ? " (check failed!)" : ""));
				if(verbose)
					printf("   %s\n", sql_row[3]);

				files_found++;
			}	
			
			mysql_free_result(sql_result);
		}
		if(path_too && files_found==0)
		{
			path_too=0;
			go=1;
		}
	} while (go);
	
	mysql_close(db);
		
	return(0);
}

