
light spotlight_rts(
    float intensity = 1;
    float falloff=2.0;
    color lightcolor = 1;
    point from = point "shader" (0,0,0);
    point to = point "shader" (0,0,1);
    float coneangle=radians(30);
    float conedeltaangle=radians(5);
    float samples=1;
    float blur=0;
    float bias=0;
    )
{
  uniform vector A = (to-from)/length(to-from);
  uniform float cosoutside= cos(coneangle);
  uniform float cosinside = cos(coneangle-conedeltaangle);
  float atten, cosangle;
  float strength, ldist;
  color Ct;
  
  illuminate(from,A,coneangle)
    {   
      cosangle = L.A / length(L);
      atten = smoothstep( cosoutside, cosinside, cosangle );
      ldist=length(L);
      strength = pow((1+ldist),-falloff);
      Cl = strength*atten*intensity*lightcolor;  // light

      Ct = transmission(Ps, from, "samples", samples, "samplecone", blur);
      Cl *= Ct;
    }

}