/* Plagiat gallery creation tool for Jakub Steiner's O.R.I.G.I.N.A.L 
 * photo gallery.
 * Copyright (C) 2005 Robert Staudinger <robert.staudinger@gmail.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA
 * 02111-1307, USA.
 */


#ifndef __PGT_MAINWIN_H__
#define __PGT_MAINWIN_H__

#include <glib.h>
#include <glib-object.h>
#include <gtk/gtk.h>
#include "pgt-utils.h"

G_BEGIN_DECLS

#define PGT_TYPE_MAINWIN                  (pgt_mainwin_get_gtype ())
#define PGT_MAINWIN(obj)                  (G_TYPE_CHECK_INSTANCE_CAST ((obj), PGT_TYPE_MAINWIN, PgtMainwin))
#define PGT_MAINWIN_CLASS(klass)          (G_TYPE_CHECK_CLASS_CAST ((klass), PGT_TYPE_MAINWIN, PgtMainwinClass))
#define PGT_IS_MAINWIN(obj)               (G_TYPE_CHECK_INSTANCE_TYPE ((obj), PGT_TYPE_MAINWIN))
#define PGT_IS_MAINWIN_CLASS(klass)       (G_TYPE_CHECK_CLASS_TYPE ((klass), PGT_TYPE_MAINWIN))
#define PGT_MAINWIN_GET_CLASS(obj)        (G_TYPE_INSTANCE_GET_CLASS ((obj), PGT_TYPE_MAINWIN, PgtMainwinClass))

typedef struct _PgtMainwin PgtMainwin;
typedef struct _PgtMainwinClass PgtMainwinClass;

GType pgt_mainwin_get_gtype (void);

PgtMainwin*   pgt_mainwin_new (GtkTreeModel *gallerystore);

GtkWidget* pgt_mainwin_get_window (PgtMainwin *self);

gchar const * pgt_mainwin_get_gallery_name (PgtMainwin *self);
gchar const * pgt_mainwin_get_album_name (PgtMainwin *self);
gchar const * pgt_mainwin_get_album_date (PgtMainwin *self);
gchar const * pgt_mainwin_get_album_desc (PgtMainwin *self);
gchar*        pgt_mainwin_get_photo_dir (PgtMainwin *self);
gboolean      pgt_mainwin_get_option (PgtMainwin *self, PgtConvertOption opt);

void pgt_mainwin_set_progress_value (PgtMainwin *self, gfloat val);
void pgt_mainwin_set_progress_text (PgtMainwin *self, gchar const *text);

void pgt_mainwin_connect_gallery_changed (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_manage_galleries (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_album_changed (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_sourcedir_changed (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_option_changed (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_prefs (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_convert (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_close (PgtMainwin *self, GCallback handler, gpointer data);
void pgt_mainwin_connect_delete (PgtMainwin *self, GCallback handler, gpointer data);

G_END_DECLS

#endif /* __PGT_MAINWIN_H__ */
