/*
 *  PlanFacile (Easy plan, in french) is a small tool to help people to
 *  write a document on a particular subject.
 *  Copyright (C) 2005  Julien BRUGUIER
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; version 2 of the License.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

#include "messageparametres.h"

static Resultat messageparametres_ajout(TRAVAIL(MessageParametres) messageparametres)
{
	/* Ajoute des positions mmoire, de sorte qu'une place libre se trouve en
	 * fin de tableau.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation.
	 */
	TABLEAU_(STOCKAGE_SCALAIRE(Pointeur)) nouveau;
	if(T_S_(CHAMP(messageparametres , taille))>=T_S_(CHAMP(messageparametres , memoire)))
	{
		if((nouveau=(TABLEAU_(STOCKAGE_SCALAIRE(Pointeur)))(malloc(SIZEOF_(COREFERENCE_SCALAIRE(STOCKAGE_SCALAIRE(Pointeur)))*T_S_(CHAMP(messageparametres , memoire))*T_S_(MULTTAILLE))))==NULL)
			return RESULTAT_ERREUR_MEMOIRE;
		CHAMP(messageparametres , memoire)*=T_S_(MULTTAILLE);
		CHAMP(messageparametres , parametre)=nouveau;
	}
	return RESULTAT_OK;
}

Resultat messageparametres_initialisation(TRAVAIL(MessageParametres) messageparametres)
{
	/* Cre une structure de paramtres de message.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE si une allocation choue.
	 */
	if((S_T(messageparametres)=(STOCKAGE(MessageParametres))(malloc(SIZEOF(CONTENEUR(MessageParametres)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	if((CHAMP(messageparametres , parametre)=(TABLEAU_(STOCKAGE_SCALAIRE(Pointeur)))(malloc(SIZEOF_(COREFERENCE_SCALAIRE(STOCKAGE_SCALAIRE(Pointeur)))*T_S_(TAILLEINIT))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	CHAMP(messageparametres , memoire)=TAILLEINIT;
	CHAMP(messageparametres , taille)=0;
	return RESULTAT_OK;
}

Resultat messageparametres_ajout_entier(TRAVAIL(MessageParametres) messageparametres , TRAVAIL_SCALAIRE(Entier) entier)
{
	COREFERENCE_SCALAIRE(Entier) pointeur;
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_ajout(messageparametres));
	if((pointeur=(COREFERENCE_SCALAIRE(Entier))(malloc(SIZEOF_(CONTENEUR_SCALAIRE(Entier)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	S_C_(pointeur)=entier;
	ELEMENT(CHAMP(messageparametres , parametre) , T_S_(CHAMP(messageparametres , taille)))=(STOCKAGE_SCALAIRE(Pointeur))(pointeur);
	T_S_(CHAMP(messageparametres , taille))++;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messageparametres_ajout_reel(TRAVAIL(MessageParametres) messageparametres , TRAVAIL_SCALAIRE(Reel) reel)
{
	COREFERENCE_SCALAIRE(Reel) pointeur;
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_ajout(messageparametres));
	if((pointeur=(COREFERENCE_SCALAIRE(Reel))(malloc(SIZEOF_(CONTENEUR_SCALAIRE(Reel)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	S_C_(pointeur)=reel;
	ELEMENT(CHAMP(messageparametres , parametre) , T_S_(CHAMP(messageparametres , taille)))=(STOCKAGE_SCALAIRE(Pointeur))(pointeur);
	T_S_(CHAMP(messageparametres , taille))++;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messageparametres_ajout_caractere(TRAVAIL(MessageParametres) messageparametres , TRAVAIL_SCALAIRE(Caractere) caractere)
{
	COREFERENCE_SCALAIRE(Caractere) pointeur;
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_ajout(messageparametres));
	if((pointeur=(COREFERENCE_SCALAIRE(Caractere))(malloc(SIZEOF_(CONTENEUR_SCALAIRE(Caractere)))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	S_C_(pointeur)=caractere;
	ELEMENT(CHAMP(messageparametres , parametre) , T_S_(CHAMP(messageparametres , taille)))=(STOCKAGE_SCALAIRE(Pointeur))(pointeur);
	T_S_(CHAMP(messageparametres , taille))++;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messageparametres_ajout_chaine(TRAVAIL(MessageParametres) messageparametres , TRAVAIL_SCALAIRE(Chaine) chaine)
{
	STOCKAGE_SCALAIRE(Chaine) pointeur;
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_ajout(messageparametres));
	if((pointeur=(STOCKAGE_SCALAIRE(Chaine))(strdup((char*)(chaine))))==NULL)
		return RESULTAT_ERREUR_MEMOIRE;
	ELEMENT(CHAMP(messageparametres , parametre) , T_S_(CHAMP(messageparametres , taille)))=(STOCKAGE_SCALAIRE(Pointeur))(pointeur);
	T_S_(CHAMP(messageparametres , taille))++;
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messageparametres_ajout_pointeur(TRAVAIL(MessageParametres) messageparametres , TRAVAIL_SCALAIRE(Pointeur) pointeur)
{
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_ajout(messageparametres));
	ELEMENT(CHAMP(messageparametres , parametre) , T_S_(CHAMP(messageparametres , taille)))=(STOCKAGE_SCALAIRE(Pointeur))(pointeur);
	T_S_(CHAMP(messageparametres , taille))++;
	FINZONESECURISEE
	return RESULTAT_OK;
}


/* Ces fonctions permettent d'assigner une valeur  un paramtre de message.
 * Une copie est toujours ralise, sauf dans le cas du pointeur,
 * et RESULTAT_ERREUR_MEMOIRE est renvoy dans
 * le cas o une allocation mmoire choue.
 * RESULTAT_ERREUR est renvoy si messageparametres est NULL.
 */

Resultat messageparametres_copie(TRAVAIL(MessageParametres) messageparametres , TRAVAIL(MessageParametres) copie)
{
	/* Cre une copie de la structure de paramtres de message.
	 * Renvoie RESULTAT_ERREUR_MEMOIRE en cas d'chec de l'allocation.
	 * Renvoie RESULTAT_ERREUR si messageparametres est NULL.
	 * Attention ! Si *copie est diffrent de NULL, la copie tente une
	 * destruction pralable de la valeur prsume dans la copie.
	 * Attention ! les zones pointes (les paramtres eux-mmes) ne sont
	 * pas dupliqus.
	 */
	STOCKAGE_SCALAIRE(Indice) indice;
	DEBUTZONESECURISEE
	if(S_T(messageparametres)==NULL)
		return RESULTAT_ERREUR;
	SECURISE(messageparametres_destruction(copie));
	SECURISE(messageparametres_initialisation(copie));
	for(indice=0 ; T_S_(indice)<T_S_(CHAMP(messageparametres , taille)) ; T_S_(indice)++)
	{
		SECURISE(messageparametres_ajout_pointeur(copie,T_S_(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(indice)))));
	}
	FINZONESECURISEE
	return RESULTAT_OK;
}

Resultat messageparametres_destruction(TRAVAIL(MessageParametres) messageparametres)
{
	/* Dtruit une structure de paramtres de message.
	 */
	STOCKAGE_SCALAIRE(Indice) indice;
	if(S_T(messageparametres)==NULL)
		return RESULTAT_OK;
	for(indice=0 ; T_S_(indice)<T_S_(CHAMP(messageparametres , taille)) ; T_S_(indice)++)
		free(ELEMENT(CHAMP(messageparametres , parametre) , T_S_(indice)));
	free(CHAMP(messageparametres , parametre));
	free(S_T(messageparametres));
	S_T(messageparametres)=NULL;
	return RESULTAT_OK;
}

