/*
 * snooze - put Linux/PPC Powerbooks to sleep.
 * At present this supports the PB2400/3400/3500,
 * the 1999 G3 Powerbooks (aka "Lombard"), and the 
 * previous generation of G3 Powerbooks (aka "Wallstreet").
 *
 * Copyright 1999 Paul Mackerras.
 * Copyright 2000 Stephan Leemburg
 *
 *  This program is free software; you can redistribute it and/or
 *  modify it under the terms of the GNU General Public License
 *  as published by the Free Software Foundation; either version
 *  2 of the License, or (at your option) any later version.
 *
 * $Log: snooze.c,v $
 * Revision 1.1.1.1  2001/12/07 11:31:47  sleemburg
 * Initial CVS import of the unreleased pmud-0.8 to apmud (new project name
 * because of a name clash at sourceforge.net).
 *
 * Revision 1.6  2001/11/09 10:55:29  stephan
 * use "pmu.h"
 *
 * Revision 1.5  2001/11/09 10:48:07  stephan
 * location of pmu.h changed
 *
 * Revision 1.4  2000/05/11 14:55:01  stephan
 * pseudo apm compatibility
 *
 * Revision 1.3  2000/03/25 21:26:40  stephan
 * pmud-0.5 changes
 *
 * Revision 1.2  2000/03/09 13:03:27  stephan
 * now call pmud for putting machine to sleep
 *
 * Revision 1.1  2000/01/06 13:48:19  stephan
 * Initial revision
 *
 */
static char *rcsid = "@(#)$Id: snooze.c,v 1.1.1.1 2001/12/07 11:31:47 sleemburg Exp $";

#include <sys/ioctl.h>
#include <sys/types.h>
#include <sys/stat.h>
#include <fcntl.h>
#include <stdio.h>
#include <unistd.h>
#include <errno.h>
#include <linux/ioctl.h>
#include <getopt.h>
#include <stdlib.h>
#include <string.h>
#include "pmu.h"
#include "pmud.h"
#include "tcp.h"

static int usage(char *, int);
static int do_sleep();
static int net_sleep(int);

int main(int ac, char **av)
{
	struct option options[] = 
	{
		{"force", 0, 0, 'f'},
		{"help", 0, 0, 'h'},
		{"port", 1, 0, 'p'},
		{"snooze", 1, 0, 's'},
		{"standby", 1, 0, 'S'},
		{"version", 0, 0, 'v'},
		{0, 0, 0, 0}
	};
	int opt;
	unsigned short port = PORT;
	int force = 0;

	// there is a bug in basename() 

	char *p = strrchr(*av, '/');

	p = p ? p + 1 : *av;

	while((opt=getopt_long(ac, av, "fhp:sSv", options, 0))!= EOF)
		switch(opt)
		{
		case 'p':
			port = atoi(optarg);
			break;

		case 'f':
			force++;
			break;

		case 'v':
			printf("%s\n", rcsid);
			return 0;

		case 's':
		case 'S':
			/* for compatibility with wmapm/apm only */
			break;

		case 'h':
		default :
			return usage(p, opt == 'h' ? EXIT_SUCCESS:EXIT_FAILURE);
		}

	return force ? do_sleep() : net_sleep(port);
}

static int usage(char *name, int ret)
{
	printf("usage: %s [args]\n\n"
		"\twhere [args] is:\n\n"
		"\t-f           : force snooze to put the machine to sleep\n"
		"\t               this is NOT recommended, as you will mis\n"
		"\t               all the facilities pmud and pwrctl are\n"
		"\t               able to provide\n"
		"\t-h           : this text.\n"
		"\t-p <port>    : connect to pmud on <port> for sleep request\n"
		"\t-v           : print the version string of %s.\n\n"
		"\tfor the following flags, you can also use long-flags\n\n"
		"\t-f           : --force\n"
		"\t-h           : --help\n"
		"\t-p <port>    : --port <port>\n"
		"\t-v           : --version\n",
		name,
		name
		);

	return ret;
}

static int do_sleep()
{
	int fd = open(PMU_FILE, 0);
	if (fd < 0) 
		fd = open(PMU_DEVFS_FILE, 0);

	if (fd < 0) 
	{
		perror(PMU_FILE);
		return EXIT_FAILURE;
	}

	// direct call will not provide all facilities pmud -> pwrctl does

	printf("be warned, calling snooze with force is not advised\n");

	sync();

	if (ioctl(fd, PMU_IOC_SLEEP, 0) == -1) 
	{
		perror("PMU_IOC_SLEEP");
		return EXIT_FAILURE;
	}
	return EXIT_SUCCESS;
}

static int net_sleep(int port)
{
	char buf[35];
	int fd = tcp_open("localhost", PMUD_SERVICE, port);
	if (fd < 0) 
	{
		perror("connect");
		return EXIT_FAILURE;
	}
	tcp_printf(fd, "sleep\n");

	// read some bytes, in order to prevent pmud complaining about
	// dropped connections, before ever handling the 'sleep' command

	tcp_printf(fd, "\n");

	alarm(6);
	tcp_read(fd, buf, sizeof(buf));

	tcp_close(fd);

	return EXIT_SUCCESS;
}
