//
// NamedMutex_VMS.cpp
//
// $Id: //poco/1.2/Foundation/src/NamedMutex_VMS.cpp#1 $
//
// Library: Foundation
// Package: Processes
// Module:  NamedMutex
//
// Copyright (c) 2004-2006, Applied Informatics Software Engineering GmbH.
// and Contributors.
//
// Permission is hereby granted, free of charge, to any person or organization
// obtaining a copy of the software and accompanying documentation covered by
// this license (the "Software") to use, reproduce, display, distribute,
// execute, and transmit the Software, and to prepare derivative works of the
// Software, and to permit third-parties to whom the Software is furnished to
// do so, all subject to the following:
// 
// The copyright notices in the Software and this entire statement, including
// the above license grant, this restriction and the following disclaimer,
// must be included in all copies of the Software, in whole or in part, and
// all derivative works of the Software, unless such copies or derivative
// works are solely in the form of machine-executable object code generated by
// a source language processor.
// 
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
// FITNESS FOR A PARTICULAR PURPOSE, TITLE AND NON-INFRINGEMENT. IN NO EVENT
// SHALL THE COPYRIGHT HOLDERS OR ANYONE DISTRIBUTING THE SOFTWARE BE LIABLE
// FOR ANY DAMAGES OR OTHER LIABILITY, WHETHER IN CONTRACT, TORT OR OTHERWISE,
// ARISING FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
// DEALINGS IN THE SOFTWARE.
//


#include "Poco/NamedMutex_VMS.h"
#include <starlet.h>
#include <iodef.h>


namespace Poco {


NamedMutexImpl::NamedMutexImpl(const std::string& name):
	_name(name)
{
	_nameDesc.dsc$w_length  = _name.length();
	_nameDesc.dsc$b_dtype   = DSC$K_DTYPE_T;
	_nameDesc.dsc$b_class   = DSC$K_CLASS_S;
	_nameDesc.dsc$a_pointer = _name.data();
	int status = sys$enqw(0, LCK$K_NLMODE, (struct _lksb*) &_lksb, 0, &_nameDesc, 0, 0, 0, 0, 0, 0);
	if (status != 1)
		throw SystemException("cannot create named mutex", _name);
}


NamedMutexImpl::~NamedMutexImpl()
{
	sys$deq(m_lksb[1], 0, 0, 0);
}


void NamedMutexImpl::lockImpl()
{
	int status = sys$enqw(0, LCK$K_EXMODE, (struct _lksb*) &_lksb, LCK$M_CONVERT, &_nameDesc, 0, 0, 0, 0, 0, 0);
	if (status != 1)
		throw SystemException("cannot lock named mutex", _name);
}


bool NamedMutexImpl::tryLockImpl()
{
	int status = sys$enqw(0, LCK$K_EXMODE, (struct _lksb*) &_lksb, LCK$M_CONVERT | LCK$M_NOQUEUE, &_nameDesc, 0, 0, 0, 0, 0, 0);
	return status == 1;
}


void NamedMutexImpl::unlockImpl()
{
	int status = sys$enqw(0, LCK$K_NLMODE, (struct _lksb*) &_lksb, LCK$M_CONVERT, &_nameDesc, 0, 0, 0, 0, 0, 0);
	if (status != 1)
		throw SystemException("cannot unlock named mutex", _name);
}


} // namespace Poco
