#include <stdio.h>
#include <stdlib.h>
#include "gettext.h"
#include "domain.h"
#include "config.h"

extern struct loaded_domain *load_domain (char *domain_file);

void write_header(int nstrings) {
	FILE *fp;
	fp=fopen("lang.h","w");
	fprintf(fp,
"/* lang.h automatically generated by gen-header. */\n"
"\n"
"#ifndef _LANG_H\n"
"#define _LANG_H 1\n"
	);
	fprintf(fp,
"\n"
"#define TOTALNSTRINGS %u\n",nstrings);
	fprintf(fp,
"\n"
"char *%s[%u];\n",VARNAME,nstrings);
	fprintf(fp,
"\n"
"int load_trmfile (char *file, char **messages_table, int tstrings);\n"
	);
	fprintf(fp,
"\n"
"#define LOAD_TRMFILE(fname) load_trmfile(fname,%s,%u)\n",
			VARNAME,nstrings);
	fprintf(fp,
"\n"
"#endif	/* lang.h */"
	);
	fclose(fp);
}

int main(int argc, char **argv) {
	struct loaded_domain *domain;
	if (argc != 2) {
		fprintf(stderr,"Usage: %s MO-file\n",argv[0]);
		exit(-1);
	}
	domain=load_domain(argv[1]);
	if (domain == NULL) {
		fprintf(stderr,"Error loading file:%s\n",argv[1]);
		exit(-1);
	}
	write_header(domain->nstrings);
	exit(0);
}
