#! /usr/bin/env python

# Creates
import sys, getopt, os

def main():
    try:
        opts, args = getopt.getopt(sys.argv[1:], "h", ["help"])
    except getopt.GetoptError:
        # print help information and exit:
        usage()
        sys.exit(2)
    for o, a in opts:
        if o in ("-h", "--help"):
            usage()
            sys.exit()
    if len(args) != 0:
        usage()
        sys.exit(2)

    new_orders_dir = os.path.abspath('orders')
    if not (os.path.exists(new_orders_dir)):
        os.makedirs(new_orders_dir)
    paid_orders_dir = os.path.abspath('paid')
    if not (os.path.exists(paid_orders_dir)):
        os.makedirs(paid_orders_dir)
    tc = file('typegen.conf', 'w')
    tc.write('name ecomm\n')
    tc.write('\n')
    tc.write('tedir .\n')
    tc.write('fcdir .\n')
    tc.write('\n')
    id = os.popen("/usr/bin/id", "r")
    line = id.readline()
    field = line.strip().split(':')
    tc.write('role ' + field[-2] + ' types ' + field[-1] + '\n')
    tc.write('\n')
    tc.write('exec esales ' + os.path.abspath('esales.py') + '\n')
    tc.write('exec acct_rcv ' + os.path.abspath('acct_rcv.py') + '\n')
    tc.write('exec shipping ' + os.path.abspath('shipping.py') + '\n')
    tc.write('\n')
    tc.write('dir new_orders ' + new_orders_dir + '(/.*)?\n')
    tc.write('dir paid_orders ' + paid_orders_dir + '(/.*)?\n')
    tc.close()

def usage():
    print "Usage: " + sys.argv[0] + " [-h]"

if __name__ == "__main__":
    main()
