from util import *
from os.path import basename, dirname

class Action:
    def __init__(self, desc, direction, friends):
        self.desc = desc
        self.direction = direction
        self.friends = friends
        actions[desc] = self

# examples

Action('read', 'in', [])
Action('write', 'out', ['create'])
Action('socket_read', 'in', [])
Action('socket_write', 'out', [])
Action('activate', 'out', [])
Action('spawn', 'in', [])
Action('open', 'out', [])
Action('clone', 'out', [])
Action('exec', 'out', [])

resource_types = ['Process', 'File', 'Pipe', 'Fifo_file', 'SharedMemory', \
                  'Unix_Stream_Socket', 'Dir', 'Bind', 'Accept', 'SockPr']

class Stype:
    def __init__(self, value, support, setter = 'polgen'):
        self.value = value
        self.support = support
        self.setter = setter

class Resource:
    special_name = None
    stype = Stype("", "default")
    default_type = 'polgen_temp'
    def __init__(self, name, id, parent = None):
        #print "Creating " + self.__class__.__name__ + " " + name
        self.name = name
        self.id = id
        self.source = get_current_program().current_source
        self.path = None
        self.uid = self.__class__.__name__.lower() + uid_gen.bump()
        uid2name[self.uid] = name
        self.is_distinguished_wrt = []
        self.roles = []
        self.in_edges = [] # set of Transitions
        self.out_edges = [] # set of Transitions
        resources_dict[id] = self
        trans[self] = {}
        self.original_context = None
        self.stype = Stype("", "default")
        self.u_and_r = ""
        self.children = []
        self.context_assignment_status = 'default'
        self.security_context = None
        self.alt_assignment = None
        self.type_contributors = []
        self.sc_extent = "dir/name.*"
##        self.is_exec_t = 0
        self.parent = parent # e.g., directory containing a file
        if parent != None:
            parent.children.append(self)
            
    def is_process(self):
        if self.__class__.__name__ == 'Process':
            return 1
        else:
            return 0
    def get_sc (self):
        return self.security_context

    def set_sc (self, value, support, setter = 'polgen'):
        self.security_context = value
        self.stype = Stype(value, support, setter)
        
    def is_local(self):
        pos = self.original_context.find('polgen_temp')
        if pos == -1:
            return 0
        else:
            return 1
            
    def out_to (self, action = None, see_if_there = True):
        if action == None:
            return [x.range for x in self.out_edges]
        elif  see_if_there == True:
            return [x.range for x in self.out_edges if x.action == action]
        else:
            return [x.range for x in self.out_edges if x.action != action]

        
    def in_from (self, action = None, see_if_there = True):
        if action == None:
            return [x.domain for x in self.in_edges]
        elif see_if_there == True:
            return [x.domain for x in self.in_edges if x.action == action]
        else:
            return [x.domain for x in self.in_edges if x.action != action]

    def add_transition(self, action, holder_name, type):
        if contains_str(holder_name, ':' + type):
            holder_id = holder_name
        else:
            holder_id = holder_name + ':' + type
        # error checking
        #error if going from a file to a file
        if the_type(self) == 'File' and self == resources_dict[holder_id]:
            print "ERROR"
        actobj = actions[action]
        direction = actobj.direction
        keys = resources_dict.keys()
        for k in keys:
            if contains_str(k,holder_id):
                holder_id = k
                break
        trans = Transition(self, action, resources_dict[holder_id])
        # more error checking
        if action == 'read' and the_type(trans.domain) == 'Process':
            print "Problem at " + str(self) + ' reading ' + holder_id

class Process (Resource):
    def __init__(self, name, id, parent = None):
        self.name = name
        self.id = id # name:Process
        self.uid = self.__class__.__name__.lower() + uid_gen.bump()
        uid2name[self.uid] = name
        self.is_distinguished_wrt = []
        self.roles = []
        self.in_edges = [] # set of Transitions
        self.out_edges = [] # set of Transitions
        resources_dict[id] = self
        trans[self] = {}
        self.processes = {}
        self.assoc_binary_file = ""
        self.with_accepts = []
        self.group = 'n/a'
        self.with_binds = []
        self.path = None
        self.source = get_current_program().current_source
        self.pid = 0
        self.client_binding_to = []
        self.pipes = {}
        self.sending_to = []
        self.type_contributors = []
        self.receiving_from = [] # a set of processes
        self.failures = []
        self.original_context = None
        self.children = []
        self.special_calls = []
        self.executing = []
        self.executed_by = []
        self.context_assignment_status = 'default'
        self.security_context = None
        self.alt_assignment = None
        self.sc_extent = ""
        self.parent = parent # e.g., directory containing a file
        if parent != None:
            parent.children.append(self)

    def __repr__(self):
        return "<Process " + self.name + " " + self.id +  ">"


    def compute_out_processes(self):
        """ Identifies process-to-process interactions"""
        for t in self.out_edges:
            resource = t.range
            if the_type(resource)  == 'Process':
                self.executing.append(resource)
                resource.executed_by.append(self)
            else:
                for rt in resource.out_edges:
                    if rt.action == 'write':
                        target = rt.range
                        if target != self:
                            self.sending_to.append(rt.range)
                            rt.range.receiving_from.append(self)
    def gen_allow(self):
        """ Preliminary thoughts on generating rules"""
        for t in self.out_edges:
            act = actions[t.action]
            allowables = act.friends + [act.desc]
            holder = t.range
            parent = holder.parent
            print "allow " + self.name + "_t " + parent.name \
                  + "_t:" + holder.__class__.__name__ \
                  +  strip_commas(allowables)



class Holder (Resource):
    def __repr__(self):
        return "<Holder " + self.name + " " + self.id + ">"

class Fifo_file (Resource):
    def __init__(self, name, id, creator, nbrs):
        #print "Creating " + self.__class__.__name__ + " " + name
        prgm = get_current_program()
        self.name = name
        if id[-10:] != ':Fifo_file':
            id = id + ':Fifo_file'
        self.id = id #name:Fifo
        self.nbrs = nbrs
        self.path = None
        self.sc_from = 'typegen'
        self.client_binding_to = []
        self.source = get_current_program().current_source
        self.creator = creator
        creator.pipes[id] = self
        self.is_distinguished_wrt = []
        self.roles = []
        self.in_edges = [] # set of Transitions
        self.out_edges = [] # set of Transitions
        resources_dict[id] = self
        trans[self] = {}
        self.type_contributors = []
        self.context_assignment_status = 'new'
        self.security_context = 'self'
        self.original_context = 'self'
    def __repr__(self):
        return "<Pipe " + self.name + " " + self.id + ">"

class Dir(Resource):
    def __repr__(self):
        parent = ""
        if self.parent != None:
            parent = self.parent.name
        return "<Dir" + parent + ": " + self.name + ">"

class File(Resource):
    def __repr__(self):
        return "<File " +  self.name  + " " + self.id +  ">"

class SharedMemory (Resource):
    def __repr__(self):
        return "<Shared Memory " + self.name + " " + self.id +  ">"

class SockPr (Fifo_file):
    def __repr__(self):
        return "<Socket Pair " + self.name +  " " + self.id + ">"
    
class Unix_Stream_Socket (Resource):
    special_name = 'socket'
    def __repr__(self):
        return "<Socket " + self.name + " " + self.id + ">"

class Spawn (Resource):
    def __repr__(self):
        return "<Spawn " + self.name + " " + self.id + ">"

class Transition:
    def __init__(self, process, action, holder):
        self.action = action #'read','write', etc
        self.actobj = actions[action]
        direction = self.actobj.direction
        self.meanings = []
        self.marked = [] #non-empty will indicate this transition is covered by approved pattern assertions
        if direction == 'out': # writing
            self.domain = process
            self.range = holder
            process.out_edges.append(self)
            holder.in_edges.append(self)
        elif direction == 'in': # reading
            self.domain = holder
            self.range = process
            process.in_edges.append(self)
            holder.out_edges.append(self)
        self.name = self.domain.name + "-->" + self.range.name
        self.security_context = None
        trans[self.domain][self.range] = self

    def not_obj(self, obj):
        #print str(self) + " for " + obj.name
        if self.domain == obj:
            return self.range
        elif self.range == obj:
            return self.domain
    def __repr__(self):
        return "<" + self.domain.name + "-->" + self.range.name + ">"
    
def construct_nt_key(process_context, holder_context, holder_type, action):
    return process_context + "--" + holder_context + ":" + holder_type + "--" + action

class NormalizedTransition:
    def __init__(self, process_context, action, holder_context, holder_type):
        self.action = action #'read','write', etc
        actobj = actions[action]
        self.final = 0
        self.direction = actobj.direction
        self.holder_type = holder_type
        self.evidence_for = []
        if self.direction == 'out': # writing
            self.domain_context = process_context
            self.range_context = holder_context
        elif self.direction == 'in': # reading
            self.domain_context = holder_context
            self.range_context = process_context
        normalized_trans[construct_nt_key(process_context, holder_context, holder_type, self.action)] = self
    def __repr__(self):
        type = self.holder_type
        if self.direction == 'out':
            begin = self.domain_context
            end = self.range_context
        else:
            begin = self.range_context
            end = self.domain_context
        return write_allow_instance(begin, end, type, self.action)
    def is_covered (self):
        coveredp = 0
        if self.domain_context == 'tbd' or self.range_context == 'tbd':
            return 0
        #see if user has accepted a pattern assertion with a realization
        #using this transition
        evidence = self.evidence_for
        for e in evidence:
            if len(e.marked) > 0: 
                coveredp = 1
                break
        return coveredp
    def report (self):
        if self.action != 'spawn':
            evidence = self.evidence_for
            markings = []
            for e in evidence:
                markings = markings + e.marked
            prefix = "  "
            if len(markings) == 0:
                prefix = "%%"
            print prefix + str(self) + "\t" + str(remove_duplicates([x.pattern.name for x in markings]))
    def report_uncovered (self):
        if self.action not in ['spawn', 'activate', 'exec']:
            evidence = self.evidence_for
            markings = []
            if self.domain_context.find('polgen_temp') == -1 and self.range_context.find('polgen_temp') == -1:
                for e in evidence:
                    markings = markings + e.marked
                if len(markings) == 0:
                    print str(self) 


def setup_normalized_transitions(finalp = 0):
    #global normalized_trans
    normalized_trans= {}
    for k in trans.keys():
        for j in trans[k].keys():
            tranobj = trans[k][j]
            if tranobj.actobj.direction == 'out':
                p = tranobj.domain
                h = tranobj.range
            else:
                p = tranobj.range
                h = tranobj.domain
            if p.get_sc() != None and h.get_sc() != None:
                    key = construct_nt_key(p.get_sc(), h.get_sc(), h.__class__.__name__, tranobj.action)
                    if key not in normalized_trans.keys():
                        nt = NormalizedTransition(p.get_sc(), tranobj.action, h.get_sc(), h.__class__.__name__)
                    else:
                        nt = normalized_trans[key]
                    if finalp:
                        nt.final = 1
                    nt.evidence_for.append(tranobj) 
class Bind:
    def __init__(self, processObj, portnbrStr, trackerStr):
        self.port = portnbrStr
        self.tracker = trackerStr
        processObj.with_binds.append(self)

class Accept:
    def __init__(self, processObj, parenttrackerStr, read_flag, write_flag):
        self.parent_tracker = parenttrackerStr
        self.process = processObj
        self.reads = read_flag
        self.writes = write_flag
        processObj.with_accepts.append(self)
    def the_assoc_bind(self):
        """find 'bind' call whose tracker id is the parent id of the 'accept'"""
        p = self.process
        parenttracker = self.parent_tracker
        #print "parent nbr is " + str(parent)
        bind = None
        binds = p.with_binds
        #print len(binds)
        for b in binds:
            #print b.tracker_nbr
            if b.tracker == parenttracker:
                bind = b
                break
        return bind
    def listening_on (self):
        bind = self.the_assoc_bind()
        if bind != None: # shouldn't be here
            return bind.port
        else:
            return None

def write_allow_instance (begin, end, type, action):
    if action == 'read':
        action = '{getattr read}'
    if type == 'Dir':
        action = '{getattr search}'
    elif type == 'Fifo_file':
        action = '{read write getattr}'
    elif type == 'Unix_Stream_Socket':
        action = 'create_socket_perms'
    elif type in ['Bind', 'Accept']:
        action = '{bind listen accept read write}'
    btype = context2type(begin)
    etype = context2type(end)
    return "allow " + btype + " " + etype + ":" + type.lower() + " " + action + "; \n"
    #return "AllowR('" + begin + "','" + end + "','" + type + "','" + action + "')"


   
class Matcher:
    """ information may be impoverished in one source and richer in another.
    Degenerate modes include process name without indication of the directory
    that it runs out of and/or use of file prefix, environmental variable, or
    user supplied directory. Idea is that dictionary key should be unique and
    as descriptive as possible"""
    def __init__(self, uniqueid, dict):
        self.uniqueid = uniqueid
        self.dictionary = dict
    def result (self, sobj):
        dict = self.dictionary
        if check_keysp(self.uniqueid, dict):
            return dict[self.uniqueid]
        else:
            return None
    

def check_keysp (path_and_type, dict):
    toreturn = False
    if dict.has_key(path_and_type):
          toreturn = True
    return toreturn

def update_stale_resource (old_key, new_key, new_name, dict):
    t1 = old_key.split(':')[-1]
    t2 = new_key.split(':')[-1]
    if t1 != t2:
        dtrace("Problem with " + old_key + " -> " + new-key)
    obj = dict.pop(old_key)
    obj.name = new_name
    obj.id = new_key
    obj.source = get_current_program().current_source
    dict[new_key]= obj
    return obj
    
class ProcessMatcher (Matcher):
    def result (self, sobj):
        toreturn = None
        dict = self.dictionary
        new_key = self.uniqueid
        name = new_key[:-8]
        if check_keysp(new_key, dict):
            toreturn = dict[new_key]
        else:
            abridged_name = process_name(name)
            old_key = abridged_name + ':Process'
            if abridged_name == name:
                #new may be degenerate description
                # might be old that has same name
                for pair in dict.items():
                    if pair[0] == old_key:
                        toreturn = pair[1]
                        break
            else: # new is not degenerate
                if check_keysp(old_key, dict):
                    #there is a degenerate that needs to be updated"
                    print "should replace old for " + new_key + " over " + old_key
                    toreturn = update_stale_resource(old_key, new_key,\
                                                     name, dict)
        return toreturn

                   

class FileMatcher (Matcher):
    def result (self, sobj):
        toreturn = None
        dict = self.dictionary
        new_key = self.uniqueid
        type = new_key.split(':')[-1]
        if check_keysp(new_key, dict):
            toreturn = dict[new_key]
        else:
            for pair in dict.items():
                old_key = pair[0]
                old_type = old_key.split(':')[-1]
                if old_type != type:
                    continue
                v = pair[1]
                if use_oldp(old_key, v.source.name,\
                            new_key, sobj.name == 'tracked'):
                    if old_key != new_key:
                        new_name = new_key[:-5]
                        v = update_stale_resource(old_key, new_key, new_name, dict)
                        toreturn = v
        return toreturn

def from_dirname (new_path, bool):
    if bool: # results of dynamic analysis - assume we have a file
        new_dir = dirname(new_path)
    else:
        #default is it is a directory:
        is_filename = False
        if contains_str(basename(new_path),'.'):
            is_filename = True
        if not is_filename:
            new_dir = new_path
        else: #its a filename
            new_spec = basename(new_path)
            new_dir = new_path[:-len(new_spec)]
    return new_dir

def use_oldp (old_path, old_dynamicp, new_path, new_dynamicp):
    toreturn = False
    new_dir = from_dirname(new_path, new_dynamicp)
    old_dir = from_dirname(old_path, old_dynamicp)
    if contains_str(old_path, '$prefix/'):
        old_path = old_path[8:]
    if contains_str(new_path, old_path):
        #new is more specific
        if new_dir >=  old_dir:
##            print new_path + ' overrides ' +  old_path
            #have a realization
            if new_dynamicp: # unless just a subdirectory
                 toreturn = True
    elif contains_str(old_path, new_path):
        #new could be a generalization
##        print new_path + ' generalizes ' +  old_path
        if new_dir == old_dir:
            toreturn = True
    return toreturn
                    

def resource_factory (sourceobj, uniqueid, type, context = "default_context_for_resource"):
    """Creating a resource; must determine if one already exists - uniqueid is
    typically a pathname"""
    #strip quotes if necessary
    if uniqueid == '':
        print "Problem with building a " + type
    if uniqueid[0] == '"':
        uniqueid = uniqueid[1:-1] + ':' + type
    name = uniqueid #this is the default
    uniqueid = uniqueid + ":" + type
    if type == 'File':
        matcher = FileMatcher(uniqueid, resources_dict)
        use = matcher.result(sourceobj)
    elif type == 'Process':
        matcher = ProcessMatcher(uniqueid, resources_dict)
        use = matcher.result(sourceobj)
    else:
        matcher = Matcher(uniqueid, resources_dict)
        use = matcher.result(sourceobj)
    if use == None:
        #must create a new one
        new = eval(type + "(name, uniqueid)")
        resources_dict[uniqueid] = new
        new.set_sc(context, 'default')
        new.original_context = context
        if type != "Process":
            if context == "???":
                new.context_assignment_status = 'default'
            elif context != None:
                new.context_assignment_status = 'external'
            else: #None
                new.context_assignment_status = 'none'
    else: # have seen it
        new = use
        if new.get_sc() == '???' and context != 'tbd':
            new.set_sc(context, 'default')
            new.original_context = context
    if uniqueid not in  sourceobj.resources.keys():
        sourceobj.resources[uniqueid] = new
    if set_by_typegen(new.get_sc()):
        new.sc_from = 'typegen'
    else:
        new.sc_from = 'environment'
    return new



def set_by_typegen (scStr):
    indicator = 'polgen_temp'
    if scStr.find(indicator) == -1:
        return 0
    else:
        return 1
