import config
from util import *
from domain_model import *
from psl_parsing import *

import os
import stat

class Event:
    def __repr__(self):
        return "<" + self.__class__.__name__ + ">"

class OpenEvent (Event):
    def handle(self, sobj, start_process, responsible_process, fields):
        #print fields            responsible_process.ition('activate', link_name)
        rname = the_resource_name(fields)
        resource_sc = the_resource_sc(fields)
        if is_directory(fields):
            dirobj = resource_factory(sobj, rname, 'File', resource_sc)
            responsible_process.add_transition('open', rname, 'File')
        elif is_file(fields):
            fileobj = resource_factory(sobj, rname, 'File', resource_sc)
            if the_type(fileobj) != 'File':
                print "problem in open event"
            if  readerp(fields):
                responsible_process.add_transition('read', rname, 'File')
            elif writerp(fields):
                responsible_process.add_transition('write', rname, 'File')

class PipeEvent (Event):
    def handle(self, sobj, start_process,responsible_process, fields):
        #need to set up read or write events between responsible_process and process at other end of pipe
        #each pipe statement sets up two fd's
        #actions on either constitute R/W events
        fd2 = fields[-2]
        fd1 = the_resource_name(fields)
        pwp = pipe_writerp(fields)
        prp = pipe_readerp(fields)
        if pwp or prp:
            direct = switch(fd2, fd1)
            reverse = switch(fd1, fd2)
            if direct in resources_dict.keys():
                pipe = resources_dict[direct]
            elif reverse in resources_dict.keys():
                pipe = resources_dict[reverse]
            else:
                pipe = Fifo_file(direct,direct, responsible_process, [fd1, fd2])
            r_or_w = 'write'
            if prp:
                r_or_w = 'read'
            responsible_process.add_transition(r_or_w, pipe.name, 'Fifo_file')



class CloneorShareEvent(Event):
    def handle (self,sobj, start_process, responsible_process, fields):
            #create a new process
            if the_type(responsible_process) != 'Process':
                dtrace(str(responsible_process) + ' not process')
            new_pid = the_resource_name(fields)
            new_process = resource_factory(sobj, responsible_process.name + "_" + str(new_pid), 'Process',  the_process_sc(fields))
            start_process.processes[new_pid] = new_process
            new_process.pid = new_pid
            link_name = responsible_process.name +'-execs-' + new_process.name
            spawn_link = resource_factory(sobj, link_name, 'Spawn', responsible_process.get_sc())
            responsible_process.add_transition('clone', link_name, 'Spawn')
            new_process.add_transition('spawn', link_name, 'Spawn')

class CloneEvent(CloneorShareEvent):
    share = 0

class ShareEvent(CloneorShareEvent):
    share = 1

class ExecEvent(Event):
    def handle (self, sobj, start_process,responsible_process, fields):
        #print "---"
        #print fields
        ok = succeeds(fields)
        #print ok
        if ok: # exec works
            #create a read event for the responsible process
            filestr = the_resource_name(fields)
            #file gets its sc from the line; process gets its sc by removing exec_ from files sc
            file_sc = fields[3]
            file = resource_factory(sobj, filestr, 'File', file_sc) # might have _exec_t in it
            process_sc = get_sc_for_exec_call(fields)
            process = resource_factory(sobj, filestr, 'Process', process_sc) # was the_resource_sc(fields))
            process.assoc_binary_file = file
            if filestr.find('python') == -1 and filestr.find('perl') == -1:
                start_process.processes[fields[0]] = process # exec takes over            #
            when_exec (sobj, responsible_process, process, filestr)
        else:
            start_process.failures.append(fields)



    
def get_sc_for_exec_call (fields):
    file_sc = fields[3]
    if contains_str(file_sc, 'exec'):
        #remove exec_
        process_sc =  file_sc[0:-7] + file_sc[-2:]
    elif file_sc == '???':
        file_sc = 'root:system_r:unconfined_t'
    elif file_sc.find('bin_t'):
        process_sc = file_sc
    else:
        # might be looking at interpreter
        process_sc = fields[-1] # was 'unknown'
    return process_sc

                
class StreamEvent(Event):
    def handle (self, sobj, start_process,responsible_process, fields):
        return 'Not handling stream events yet'

class MiscEvent(Event):
    def handle (self, sobj, start_process,responsible_process, fields):
        responsible_process.special_calls.append(fields[2])
        
    
class UnlinkEvent(Event):
    def handle (self, sobj, start_process,responsible_process, fields):
        return 'Not handling unlink events yet'

class SockPrEvent (Event):
    def handle (self, sobj, start_process,responsible_process, fields):
        return 'Not handling sockpr events yet'
    
class SocketEvent(Event):
    #pid|Socket|operation|parent_tracker|addr_info|R or ""|??? or ""|W or ""|??? or ""|fd|tracker_id|security_context
    # 0    1        2          3            4        5        6         7       8       9   10          11
    def handle (self,sobj, start_process, responsible_process, fields):
        operation = fields[2]
        port= the_port(fields)
        tracker = the_tracker_nbr(fields)
        id = port
        if operation == 'bind':
            Bind(responsible_process, port, tracker)
        elif operation == 'accept':
            Accept(responsible_process, the_parent_tracker_nbr(fields), writerp(fields), readerp(fields))
        else: # connects
            iden = 'port-' + id + '-from-' + responsible_process.name
            sock = resource_factory(sobj, iden, 'Unix_Stream_Socket', 'self')
            sock.responsible_process = responsible_process
            if writerp(fields):
                responsible_process.add_transition('socket_write', iden, 'Unix_Stream_Socket')
            if readerp(fields):
                responsible_process.add_transition('socket_read', iden, 'Unix_Stream_Socket')

class TrackReader (Reader):
        def readlines (self, sobj = None):
            out = self.out
            out.write('<h1> Tracker File </h1> \n')
            out.write('<html><table border = 10 width = 80%> <font size = 1>\n')
            global resources_dict
            start_process = resources_dict[self.name[0:-8] + ':Process']
            no_fork = 1
            count = 0
            for l in self.file.readlines():
                count = count + 1
                #valid lines come in several forms
                #file operations - pid|Open|filename|sc at file open time|file vs. directory|R or ""|sc of file read|W or ""|sc of file written to|fd|sc of invoking process
                #execs - pid|Exec|filename|sc of file|return code|sc of invoking process
                #clones - pid|Clone|pid of clone|sc of invoking process and clone
                #pipe - pid|Pipe| fd of complement pipe at creation time|R or ""|sc of file read|W or ""|sc of file written to| its fd|sc of process
                #stream - pid|Stream| ... ignore for now
                fields = l.split('\t')
                remainder = count % 3
                color = 'ffffff'
                if remainder == 1:
                    color = 'ffbbbb'
                elif remainder == 2:
                    color = 'bbbbff'
                out.write('<tr bgcolor = "' + color + '">')
                for item in fields:
                      out.write('<td>' + item + '</td>')
                out.write('</tr>')
                #print fields
                if len(fields) != 0:
                    #print fields
                    pid = the_pid(fields)
                    sc = the_process_sc(fields)
                    action = the_action(fields)
                    if self.first_line:
                         sc = get_sc_for_exec_call(fields)
                         start_process.set_sc(sc, 'default') # so that application will always have a sc
                         start_process.original_context = sc
                         start_process.pid = pid
                         start_process.processes[pid] = start_process
                         self.first_line = 0
                    if pid in start_process.processes.keys():
                        # pid seen before
                        responsible_process = start_process.processes[pid]
                        if responsible_process.get_sc() == 'unknown':
                            #didn't know how to set sc
                            print "handling " + responsible_process.name
                            responsible_process.set_sc(sc, 'default')
                            responsible_process.original_context = sc
                    else:
                        print "pid problem" #should not be here
                        print fields
                        responsible_process = processes[pid]
                    pipes = {}

                    obj = eval(action + 'Event()')
                    obj.handle(sobj, start_process,responsible_process, fields)
            out.write('</table>')

        def close(self):
            self.file.close()

#################### accessors #############################

def the_process_sc (fields):
    return fields[-1][0:-1] # strip off \n

def the_pid(fields):
    return fields[0]

def the_action(fields):
    return fields[1]

def the_return_code(fields):
    return fields[4]

def succeeds (fields):
    if the_return_code(fields) == '-1':
        return 0
    else:
        return 1

def the_resource_name(fields):
    rname = fields[2]
    if rname[0] == '"':
        rname = rname[1:-1]
    return rname

def the_resource_sc(fields):
    """ for Open actions"""
    if the_action(fields) not in ['Open', 'Exec']:
        print "Inappropriate resource_sc query on " + str(fields)
        toreturn = 'unknown'
    toreturn = fields[3] # for execs
    if the_action(fields) != 'Exec':
        if writerp(fields):
            toreturn = fields[8]
        elif readerp(fields):
            toreturn = fields[6]
    return toreturn

def the_file_descriptor(fields):
    return fields[9]

def readerp (fields):
    return fields[5] == 'R'

def writerp (fields):
    return fields[7] == 'W'

def pipe_readerp (fields):
    return fields[3] == 'R'

def pipe_writerp (fields):
    return fields[5] == 'W'

def the_tracker_nbr (fields):
    return fields[-2]

def the_parent_tracker_nbr (fields):
    return fields[3]

def the_port(fields):
    #print fields[4]
    toreturn = "-1000" #  fields[-3] # file descriptor
    start = fields[4].split(',')
    for s in start:
        pos = s.find('_port')
        if pos != -1:
            toreturn = s[pos + 12:-1]
            break
    #print toreturn
    return toreturn

#################### utilities ###############################
def remove_string(str, toremove):
    loc = str.find(toremove)
    if loc == -1:
        return str
    else: # its there
        return str[0:loc] + str[loc + len(toremove):]

def is_file (fields):
    if fields[4] == 'FILE':
        return 1
##    elif len(fields) == 4 and fields[2] in ['W', 'R']:
##        #old test
##        return 1
    else:
        return 0

def is_directory (fields):
    #temporary ad hoc
    #return fields[0][-1] == '/'
    return fields[4] == 'DIRECTORY'

def visit_files(prgm_name,folder, sources = ['tracked']):
    """Visit the structures for each file in data_directory"""
    #print "Reading from " + config.data_directory + "/" + folder
    global PRGM
    PRGM = Program(prgm_name)
    base = config.data_directory + "/"
    print "data_directory is " + config.data_directory
    for s in sources:
        sobj = Source(s)
        PRGM.current_source = sobj
        files = [x for x in os.listdir(base) if x[-(len(s) + 1):] == "." + s]
        sobj.files = files
        for f in files:
            print f
            if stat.S_ISREG(os.stat(base + f)[0]): # test for file vs. directory
                pname = f[0:-(len(s) + 1)]
                #print pname
                p = resource_factory(sobj, pname, 'Process', 'system_u:object_r:polgen_temp_t')
                applications.append(p)
                if s == 'tracked':
                    r = TrackReader(f, folder)
                    r.readlines(sobj)
                    r.file.close()
                elif s == 'psl':
                    r = PSLReader(f, folder)
                    r.readlines(sobj)
                    psl2objects(r, sobj)
                    r.file.close()

def fix_accepts():
    for p in [v for v in resources_dict.values() if v.is_process()]:
        for a in p.with_accepts:
            port = a.listening_on() # port might be unknown
            port_holders = [x for x in resources_dict.keys() if contains_str(x, 'port-' + str(port))]
            for ph in port_holders:
                if a.writes:
                    p.add_transition('socket_write', ph, 'Unix_Stream_Socket')
                if a.reads:
                    p.add_transition('socket_read', ph, 'Unix_Stream_Socket')


def psl2objects (reader, sobj):
    """This function transfroms components in a psl
    file to resources with in and out edges"""
    file = reader.file
    sp = SpecParser(reader)
    sp.do_it(sobj) # creates nodes dictionary
    s2html = Spec2Html(reader)
    s2html.do_it(sobj)
    prgm_name = PRGM.name
    print prgm_name
    topnodeobj= nodes[prgm_name]
    startobj = setup_process(topnodeobj, 1000)
    pid = new_pid()
    found_app = False
    for nobj in nodes.values():
        if nobj.type == 'application':
            found_app = True
            required = nobj.requires
            for r in required:
                #mark as external
                nodes[r].location = 'external'
            break
    if not found_app:
        print 'Problem: must have an application component'
    for nobj in nodes.values():
        #print "nobj.name is "
        #print nobj.name
        #print get_resource_name(nobj.name)
        n_name = get_resource_name(nobj.name)
        #node can be a process or a file
        if nobj.type.lower() in ['process', 'daemon']:
            if n_name != prgm_name:
                #setup new process
                pid = new_pid()
                setup_process (nobj, pid) #includes setting up an exe file
        elif nobj.type.lower() in ['data_file']:
            #have a file
            build_file_resource(sobj, n_name, True)

    node_processobjs = [p for p in nodes.values() if p.type.lower() in ['process', 'daemon']]
    #print node_processobjs
    for nobj in node_processobjs:
        n_name = nobj.name + ':Process'
        pobj = resources_dict[n_name]
        for item in nobj.get_extended_reads():
            rname = get_resource_name(item)
            if rname not in resources_dict.keys():
                #must create an external file resource
                build_file_resource(sobj,rname)
            pobj.add_transition('read', rname, 'File')
        for item in nobj.get_extended_writes():
            rname = get_resource_name(item)
            if rname not in resources_dict.keys():
                #must create an external file resource
                build_file_resource(sobj, rname)
            pobj.add_transition('write', rname, 'File')
        #print "execs are "
        #print nobj.get_extended_execs()
        for pname in nobj.get_extended_execs():
              obj = resource_factory(sobj, pname, 'Process', \
                                   get_process_sc_from_type(pname))
              do_execs(obj, pobj)
        for pname in nobj.get_extended_connects_at():
            obj = resource_factory(sobj, pname, 'Process', \
                                   get_process_sc_from_type(pname))
            do_socket_connect(sobj, obj, pobj)
        for pname in nobj.get_extended_listens_at():
            obj = resource_factory(sobj, pname, 'Process', \
                                   get_process_sc_from_type(pname))
            do_socket_listen(sobj, obj, pobj)
            
def do_socket_connect (sobj, connection, client):
    iden = 'port-' + str(new_pid()) + '-from-' + client.name
    sock = resource_factory(sobj, iden, 'Unix_Stream_Socket', 'self')
    sock.responsible_process = client
    client.add_transition('socket_write', iden, 'Unix_Stream_Socket')
    client.add_transition('socket_read', iden,'Unix_Stream_Socket')
    connection.add_transition('socket_write', iden, 'Unix_Stream_Socket')
    connection.add_transition('socket_read', iden, 'Unix_Stream_Socket')

def do_socket_listen (sobj, connection, server):
    Bind(server, new_pid(), new_pid())

    
def build_file_resource (sobj, name, owned = False):
    #print "resource name is " + name
    #print "building file named " + name
    return resource_factory(sobj, name, 'File', file_sc_from_type(name, owned))

def switch (fd1, fd2):
    return fd2+"&"+fd1
