#! /usr/bin/env python

# Copyright 2004, The MITRE Corporation

copyright = "Copyright  2004, The MITRE Corporation"

### defaults and advanced settings

import sys, os, os.path

import config

def usage(errString="", usageString=""):
   if errString:
       print "%s: %s" % (sys.argv[0], errString)
       usageString = "usage: "
   print "%s%s -n <program-name> -d <tracked-data> -o <results-data> [-h] [-r] [-g] [-p]" \
         % (usageString, sys.argv[0])
   print "\t-h\thelp"
   print "\t-r\tregenerate pattern recognizers - extending spar - for expert users"


global no_gui
no_gui = False

global no_pattern_based_override
no_pattern_based_override = False

platform = "unix"

global image_dir
def print_prgm_help():
    print "SYNOPSIS"
    usage()

def read_prgm_args():
    global prgm_name
    global output_dir
    global data_dir
    global image_dir
    global no_gui
    setting_data_dir = 0
    setting_prgm_name = 0
    setting_output_dir = 0
    setting_image_dir = 0
    arg_len = len(sys.argv)
    for arg in sys.argv[1:arg_len]:
        if setting_image_dir:
            image_dir = arg
            setting_image_dir =0
        elif setting_data_dir:
            data_dir = arg
            setting_data_dir = 0
        elif setting_prgm_name:
            next = arg.replace('-', '_')
            prgm_name = next.replace(' ', '')
            setting_prgm_name = 0
        elif setting_output_dir:
            output_dir = arg
            setting_output_dir = 0
        elif arg == '-h':
            print_prgm_help()
            sys.exit()
        elif arg == '-d':
            setting_data_dir = 1
        elif arg == '-i':
            setting_image_dir = 1
        elif arg == '-n':
            setting_prgm_name = 1
        elif arg == '-o':
            setting_output_dir = 1
        elif arg == '-p':
            no_pattern_based_override = True
        elif arg == '-g':
            no_gui = True
        else:
            usage("invalid option -- " + arg)
            sys.exit()

# set defaults

prgm_name = 0
if config.data_directory == "unknown":
    cwd = os.getcwd()
    data_dir = cwd
else:
    data_dir = config.data_directory

output_dir = data_dir + '/' +  "results"
image_dir = config.prgmPath + '/' + 'images'
read_prgm_args()

print "images at " + image_dir
config.image_directory = image_dir
config.results_directory = output_dir
if not os.path.exists(output_dir):
        os.mkdir(output_dir)

config.data_directory = data_dir
if not prgm_name: # -n option not used
   start = os.path.basename(data_dir) or os.path.basename(cwd)
   next = start.replace('-', '_')
   prgm_name = next.replace(' ', '')


#### from here insert imports and all actions to be performed
#######################################################
#######################################################

import util
import domain_model
import patterns
import specs
import extract


sources = ['psl', 'tracked']
#sources = ['psl']
print("Reading Data")
extract.visit_files(prgm_name, "", sources)

import pat2cls

extract.fix_accepts()

for x in util.process_ids():
    util.resources_dict[x].compute_out_processes()


the_program = util.get_current_program()
the_program.outsiders_mutable = not no_pattern_based_override
the_program.no_directory_constraints = True
the_program.unlimited_typing = True
the_program.platform = platform
the_program.unconfined_domain = 'unconfined_t'
the_program.no_gui = no_gui
the_program.debug = False


print "Looking for Patterns"
print " "
pat2cls.do_recognition()


import presentations

presentations.do_reports(no_gui)

import xmlOutput
xml_file_name = prgm_name + '.xml'
xml_out_file = os.path.join(config.results_directory, xml_file_name)
xmlOutput.writeFile(xml_out_file)

###############################################################
###############################################################
print "Input directory is %s" % config.data_directory
print "Results directory is %s" % config.results_directory

print "\nAnalysis completed."
