from gui import get_analyst_input
from util import *
from pres_util import *
from specs import SPECIFIERS
import config
import patterns
import os
import role_fillers
import walk
import hreports
import pat2cls
import macro_defs
import rutil
from futil import writes_to
from domain_model import NormalizedTransition, write_allow_instance,\
     setup_normalized_transitions, resource_types
from pr import *
import sys
import home
from results import show
import te_gen_util

class Meaning:
    def __init__(self, transobj, recogObj, domain_type, range_type):
        self.parent = transobj
        self.recog = recogObj
        self.pattern = recogObj.pattern.name
        self.detection = recogObj.detection
        self.used = 0
        self.domain_type = domain_type
        self.range_type = range_type
        self.domain = transobj.domain
        self.range = transobj.range
 
    def __repr__(self):
        return self.pattern + ": " + self.domain_type + "->" + self.range_type


def do_reports(no_gui):
    populate_all_meanings()
    pat2cls.adjust_contexts()
    setup_normalized_transitions()
    macro_defs.add_templates()
    pattern_assertion_strings = []
    for recog in SPECIFIERS:
       if len(PRGM.pattern_instances[recog.__name__]) != 0:
            for instance in PRGM.pattern_instances[recog.__name__]:
                gen_pattern_instances(recog, instance, 0)
    if not no_gui:
        gen_html_pages(0)
    gen_policy_spec(no_gui)
    gen_html_pages()


                    
def gen_html_pages (finalp = 1):
    gen_meanings_report()
    gen_applications_report()
    gen_to_do()
    home.gen()
    rutil.init_reports()
    hreports.gen_recog_results_browser(finalp)
    hreports.gen_security_context_report()
    hreports.gen_interface_page()
    hreports.gen_cgi_page()
    hreports.gen_diff_report()
    hreports.gen_anomalies_page()
    hreports.gen_override_issues()
    hreports.gen_boundary_crossing_report()
   
def populate_meanings (node, recog, finalp = 0):
    """node is an instance tree
    called recursively on nodes of tree"""
    #if pattern realization for node.focus  is no longer active, we should exit
    #Issue: may not know directionality of connection between node.focus and next
    role = walk.get_role(node)
    focus = node.focus
    if focus.__class__.__name__ == 'Transition':
        focus = focus.domain
    focus.roles.append([recog.pattern, role])
    if recog.pattern.distinguished_role == role:
        focus.is_distinguished_wrt.append(recog.pattern.name)
    #walking the tree
    for nr in node.with.keys():
        next_nodes = walk.next_nodes_of(node, nr)
        for nn in next_nodes:
            nfocus = nn.focus
            new_meaning = None
            if nfocus.__class__.__name__ == 'Transition':
                    nfocus = nfocus.domain
            if nfocus in trans[focus].keys():
                 transition  = trans[focus][nfocus]
                 new_meaning = Meaning(transition, recog, role, nr)
            elif node.focus in trans[nfocus].keys():
                transition = trans[nfocus][focus]
                new_meaning = Meaning(transition, recog, nr, role)
            if new_meaning != None:
                transition.meanings.append(new_meaning) #caching
            populate_meanings(nn, recog)


def gen_to_do():
    prgm = get_current_program()
    pname = prgm.name
    fileid  = 'ToDo.html'
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    out.write('<hr>')
    no_context_resources = [x for x in resources_dict.values() if x.get_sc() in ['???',  'tbd']]
    if len(no_context_resources) > 0:
        out.write('<h3>Possible occurrance of failed attempt to open a file.</h3>\n')
        for r in no_context_resources:
            out.write('<br>May want to assign security context to ' + obj2href(r) + '. \n<hr>')
    multi_assignment = [x for x in resources_dict.values() if x.context_assignment_status == 'problematic']
    if len(multi_assignment) > 0:
        out.write('<h3>More than one constraint on type generation for resources</h3> \n')
        for r in multi_assignment:
            out.write('<br> Possible ' + str([x[0].name + ':' + x[1] for x in r.roles]) + \
                      ' constraints on ' + resource2href(r, 'PolicyHelp.html') + '.\n')
            out.write('Verify or modify security context. \n')
        out.write('<hr>')
    new = [x for x in resources_dict.values() if x.__class__.__name__ != 'Fifo_file' and x.get_sc() != x.original_context]
    if len(new) > 0:
        out.write('<h3> Other Polgen type assignments </h3> \n')
        for r in new:
            out.write('<br> Polgen assigned security_context to ' \
                      + resource2href(r, 'PolicyHelp.html') + '.  Verify or modify. \n')                  
    out.close()



def gen_policy_spec(no_gui):
    #print pattern_assertions.values()
    get_analyst_input(pattern_assertions.values(), no_gui)

                 
def create_patternR(recog, individual):
    individual.append(0)
    pattern = recog.pattern
    genstr = eval(pattern.name + 'R')
    obj = apply(genstr, individual)
    obj.constellation = individual
    obj.pattern = pattern
    obj.treat_as = recog.detection
##   active is to be determined by user; this sets defaults
    if obj.treat_as.name in ['out__of__scope', 'violator']:
        obj.active = 0
        obj.reason = "Recognition out of scope or violator"
    else:
        obj.active = 1
        obj.reason = "Found by pattern recognition"
    obj.participants = individual[:-1]
    obj.uid = pattern.name + uid_gen.bump()
    all_pattern_realizations[obj.uid] = obj
    return obj

    
def gen_pattern_instances(recog, instance, alternatives = 1):
    """ Generate a set of macro statements - one for each path thru the instance tree"""
    #need to account for multiple recog for a pattern
    for individual in walk.instance2individuals(instance):
        preal = create_patternR(recog, individual)
        spec = preal.spec()
        pattern_assertion_factory(spec, preal, recog.detection)


def populate_all_meanings (finalp = 0):
    for recog in SPECIFIERS:
        sname = recog.__name__
        instances = PRGM.pattern_instances[sname]
        for node in instances:
            populate_meanings(node, recog, finalp)
    

def display_meanings ():
    for r in [r for r in resources_dict.values() if r.__class__.__name__ != 'Process']:
        print "--"
        print r.name
        for t in r.out_edges:
            print "allow " + t.range.name + " " + r.name \
                      + ":" \
                      + r.__class__.__name__.lower() + " " + t.action
            print "   because " + str(t.meanings)
        for t in r.in_edges:
            print "allow " + t.domain.name + " " + r.name + ":" \
                      + r.__class__.__name__.lower() + " " + t.action
            print "   because " + str(t.meanings)



def meanings2html (strm):
    strm.write('<table border= 3>')
    for item in resource_types:
        resources = [x for x in resources_dict.values() if the_type(x) == item]
        if len(resources) > 0:
            strm.write('<tr><td>' + item + '</td><td>  \n')
            for r in resources:
                strm.write('<a href = #' + r.id + '>' + r.name + \
                       '</a>---')
            strm.write('</td></tr>')
    strm.write('</table>')
    for cname in resource_types:
        resources = [x for x in resources_dict.values() if x.__class__.__name__ == cname]
        if len(resources) > 0:
            strm.write('<h2>' + cname + '</h2>')
            for r in resources:
                strm.write('<hr><hr>')
                context = r.get_sc()
                strm.write('<a name = ' + str(r.id) + '><h3>' \
                           + r.name + " a " + cname + '</h3> \n')
                strm.write('with security context =  <font color = ff00ff><a href=Security-Context.html#' \
                           + str(context) + ">" + str(context) + "</a></font><br>\n")
                for its_role in r.roles:
                    role = its_role[1]
                    pattern = its_role[0]
                    #print pattern.name
                    strm.write("<br>Playing " + role + " role for a " \
                               + "<a href=Pattern-Instances.html#" + pattern.name + \
                               ">" + pattern.name + "</a> \n")
                    if role in pattern.to_avoid.keys():
                        strm.write(pattern.to_avoid[role].display(r))
                if r.__class__.__name__ != 'Process':
                    count = 0
                    for t in r.out_edges:
                        count = count + 1
                        strm.write('<br>----' + str(count) + ') ' + capitalize_it(t.action) + \
                                       ' resource for '  + \
                                        t.range.name + ' \n')
                        m = "<br>--- not part of a pattern"
                        if len(t.meanings) > 0:
                            m = "<br>----   pattern participation: "
                            for meaning in t.meanings:
                                m = m + handle_meaning(meaning, 'out')
                        #strm.write("<br><table border = 2><tr><td bgcolor = ffff44>allow  " + resource2href(t.range) + "  " + str(context) \
                        #          + ": " \
                        #          + r.__class__.__name__.lower() + "  " + t.action + '</td></tr></table> \n')
                        strm.write(m)
                    count = 0
                    for t in r.in_edges:
                        count = count + 1
                        strm.write('<br>---' + str(count) + ') ' + capitalize_it(t.action) + \
                                   ' target for ' + \
                                    t.domain.name + ' \n')
                        m = "<br>--- not part of a pattern"
                        if len(t.meanings) > 0:
                            m = "<br>----   pattern participation: "
                            for meaning in t.meanings:
                                m = m + handle_meaning(meaning, 'in')
                        strm.write(m)
                else: #  r.__class__.__name__ == 'Process'
                    strm.write('<br>Reading from: <br>')
                    for t in [t for t in r.in_edges if t.domain.__class__.__name__ == 'File']:
                        strm.write('----' + obj2href(t.domain) + " : " + t.domain.get_sc() + '<br> \n')
                    strm.write('<br>Writing to: <br>')
                    for t in writes_to(r):
                        strm.write('----' + obj2href(t) +  " : " + t.get_sc() + '<br> \n')
                
def handle_meaning(meaningObj, direction = 'in'):
    "Given a meaning returns a string"
    if direction == 'out':
        whatami = meaningObj.domain_type
        partner_role = meaningObj.range_type
        partner = meaningObj.range.name
    else:
        whatami = meaningObj.range_type
        partner_role = meaningObj.domain_type
        partner = meaningObj.domain.name
    return "<br>---- playing " + whatami + " role in an instance of " + meaningObj.pattern + \
           " and connecting to " + partner + ":" + partner_role 
    
    
def gen_meanings_report ():
    """ creates web-page showing all creation events"""
    prgm = get_current_program()
    pname = prgm.name
    if pname == "":
        pname = "e-commerce" # temp hack
    fileid  = "PolicyHelp.html"
    fileStr = os.path.join(config.results_directory, fileid)
    out = open(fileStr, "w")
    #print "Writing to " + fileStr
    top_of_file(out, "Policy Authoring for " + capitalize_it(pname))
    #out.write("<br> Go to <a href=Pattern-Instances.html> Pattern Instance Report </a> \n")
    meanings2html(out)
    out.close()

def gen_applications_report ():
    prgm = get_current_program()
    pname = prgm.name
    fileid  = "Applications.html"
    fileStr = config.result_file(fileid)
    out = open(fileStr, "w")
    print "Writing to " + fileStr
    top_of_file(out, 'Applications and Processes for ' + capitalize_it(pname))
    seen = []
    for app in applications:
        if app.name not in seen:
            seen.append(app.name)            
            out.write('<h3>' + app.name + '</h3><br> \n')
            for source in PRGM.sources:
                out.write('<br> From file ' + app.name + '.' + source.name + ' \n')
            out.write('<br> Processes \n')
            for p in app.processes.keys():
                out.write('<br>---- ' + resource2href(app.processes[p], 'PolicyHelp.html') + '\n') 
    out.close()



def gen_instance_macro(strm, recog, instance):
    """ Generate a macro statement """
    pat = recog.pattern
    #print pat
    template = pat.template
    if template != None:
        #pattern has been defined
        tname = template.name
        troles = template.roles
        nbr_roles = len(troles)
        for individual in walk.instance2individuals(instance):
            #generate a line
            strm.write(tname + '(')
            count = 1
            for p in individual:
                if p.get_sc() != None:
                    strm.write(p.get_sc())
                else:
                    strm.write("unknown")
                count = count + 1
                if count != nbr_roles:
                    strm.write(', ')
            strm.write(') \n\n')

            
    



        

