
from util import *
import string

############ dictionaries and lists ########
alternatives = {}

""" The listing of the pattern types we recognize """
PATTERN_TYPES = []

############ classes ###################

class UnderstandingObj:
    desc = ""

class SpecObj(UnderstandingObj):
    """ SpecObjs detect patterns by applying sequenced or cascading Recogs
    to the classObjects in the search_set"""
    pattern = None
    do_rp = 1
    recall = 0
    precision = 0
    prerequisites = []
    prototypicality = "exact"
    stoppers = []
    description = ""
    collections = []
    focus_name = ""
    inputs = []
    search_set = "get_prgm_classes()"


class RecogAbs(UnderstandingObj):
    """ Recogs are used in creating specifications for the participants in patterns"""
    def __init__(self, collectorstr, collaborators = [], stoppers = []):
        self.collector = collectorstr.split()
        self.with = collaborators # a set of Recog's
        self.stoppers = stoppers
        
    def get_label (self):
        """ first word in string """
        return self.collector[0]
    
    def get_accessor (self):
        return self.collector[4]
        
    def get_code (self):
        return string.join(self.collector[5:])

    def get_recog_type (self):
        return self.collector[2]

    def __repr__(self):
        return "<" + self.collector + ">"


class Recog (RecogAbs):
    """ assuming collector is "label in|= code" """
            
    def get_label (self):
        """ first word in string """
        return self.collector[0]
    
    def get_accessor (self):
        #obsolete
        return "None"
        
    def get_code (self):
        return string.join(self.collector[2:])

    def get_recog_type (self):
        there = self.collector[1]
        if there == '=':
            return "set"
        else:
            return "element"





