%{
/*
 * Parses strace output into tab separated values.
 * Copyright (C) 2004 The MITRE Corporation
 *
 * This program is free software; you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation; either version 2 of the License, or
 * (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place, Suite 330, Boston, MA  02111-1307  USA
 */

#include <stdio.h>
#include "scanner.h"

static int
ps(const char* str)
{
  return printf("%s", str);
}
%}

%union {
  const char *str;
}

%token <str> LPAREN COMMA RPAREN
%token HERALD LBRACE RBRACE LBRACKET RBRACKET
%start start
%%

start:

| start line
;

/* A line is either an system call or a signal description. */
line:
  LPAREN { putchar('\t'); } args RPAREN { putchar('\t'); } any '\n'
| HERALD any '\n'
;

/* This is used to figure out where to output tabs between args. */
args:
  arg
| args COMMA { putchar('\t'); } arg
;

/* Sends an argument to the output with special attention paid to structs. */
arg:

| LBRACE quoted RBRACE
| LBRACKET quoted RBRACKET
;

/* Within struct displays, send almost everything to the output. */
quoted:

| quoted LPAREN { ps($2); }
| quoted RPAREN { ps($2); }
| quoted COMMA { ps($2); }
| quoted HERALD
| quoted LBRACE quoted RBRACE
| quoted LBRACKET quoted RBRACKET
;

/* Anything goes except a newline.  Everything is sent to the output. */
any:

| any LPAREN { ps($2); }
| any RPAREN { ps($2); }
| any COMMA { ps($2); }
| any HERALD
| any LBRACE
| any RBRACE
| any LBRACKET
| any RBRACKET
;
