/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_POLYMERSPEC_H
#define LIBPOLYXMASS_POLYMERSPEC_H


#include "libpolyxmass-globals.h"



typedef struct _PxmPolchemdefSpec PxmPolchemdefSpec;




struct _PxmPolchemdefSpec
{
  /* 
     Name of the polymer definition (ie polymer type, 'protein').
  */
  gchar *type;
  
  /*
    Polymer definition file (this is an absolute path name, like
    '/usr/share/polyxmass/polchem-defs/protein.xml').
  */
  gchar *file;

  /* 
     Polymer definition directory (mainly where pixmaps and accessory
     files are stored; this is an absolute path name, like
     '/usr/share/polyxmass/polchem-defs/protein').
   */
  gchar *dir;

  /* Finally we want to be able to trace from where the data for this
     polchemdefspec were read: system or user directory. Might be either
     CONFIG_SYSTEM or CONFIG_USER.
  */
  gint source;
};
  



/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmPolchemdefSpec *
libpolyxmass_polchemdefspec_new (void);

PxmPolchemdefSpec *
libpolyxmass_polchemdefspec_dup (PxmPolchemdefSpec *ps);

gboolean
libpolyxmass_polchemdefspec_set_type (PxmPolchemdefSpec *ps, gchar *type);

gboolean
libpolyxmass_polchemdefspec_set_file (PxmPolchemdefSpec *ps, gchar *file);

gboolean
libpolyxmass_polchemdefspec_set_dir (PxmPolchemdefSpec *ps, gchar *dir);





/*  LOCATING FUNCTIONS
 */
gint
libpolyxmass_polchemdefspec_get_index_by_type (GPtrArray *GPA, 
					    gchar *type);

gint
libpolyxmass_polchemdefspec_get_index_top_by_type (GPtrArray *GPA, 
						gchar *type);

gint
libpolyxmass_polchemdefspec_get_index_bottom_by_type (GPtrArray *GPA, 
						   gchar *type);

PxmPolchemdefSpec *
libpolyxmass_polchemdefspec_get_ptr_by_type (GPtrArray *GPA, 
					  gchar *type);

PxmPolchemdefSpec *
libpolyxmass_polchemdefspec_get_ptr_top_by_type (GPtrArray *GPA, 
					      gchar *type);

PxmPolchemdefSpec *
libpolyxmass_polchemdefspec_get_ptr_bottom_by_type (GPtrArray *GPA, 
						 gchar *type);





/* UTILITY FUNCTIONS
 */
gboolean
libpolyxmass_polchemdefspec_reset (PxmPolchemdefSpec *ps);

/* 
   The polchem-defs.cat catalogue files.
*/
gboolean
libpolyxmass_polchemdefspec_init_from_cat_line (gchar *line,
					     PxmPolchemdefSpec *ps) ;

gint
libpolyxmass_polchemdefspec_parse_polchem_defs_cat_file (gchar *file,
						      GPtrArray *GPA,
						      gchar *type,
						      PxmPolchemdefSpec **pps,
						      gint pre_ap_pend,
						      gint sys_user);

gint
libpolyxmass_polchemdefspec_parse_polchem_defs_cat_files (GPtrArray *GPA,
						       gint pre_ap_pend,
						       gint sys_user);








/* FREE'ING FUNCTIONS
 */
gint
libpolyxmass_polchemdefspec_free (PxmPolchemdefSpec *ps);




/* GPtrArray-RELATED FUNCTIONS
 */
gint
libpolyxmass_polchemdefspec_GPA_free (GPtrArray *GPA);















#endif
/*
  #ifndef LIBPOLYXMASS_POLYMERSPEC_H 
 */




