/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/

#ifndef LIBPOLYXMASS_PROP_H
#define LIBPOLYXMASS_PROP_H


#include "libpolyxmass-globals.h"


#ifdef __cplusplus
extern "C" {
#endif /* __cplusplus */


  typedef struct _PxmProp PxmProp;

  enum
    {
      PROP_NAME,
      PROP_DATA,
      PROP_BOTH
    };

  
  struct _PxmProp
  {
    gchar *name;
  
    gpointer data;
  
    PxmProp *(*custom_dup) (PxmProp *prop, PxmHowDup how_dup);
  
    gint (*custom_cmp) (PxmProp *prop1, PxmProp *prop2, PxmHowCmp how_cmp);
  
    gint (*custom_free) (PxmProp *prop);
  
  };



  /* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
   */
  PxmProp*
  libpolyxmass_prop_new (void);

  PxmProp *
  libpolyxmass_prop_dup (PxmProp *prop, PxmHowDup how_dup);

  PxmProp *
  libpolyxmass_prop_both_strings_new (gchar *name, gchar *data);

  PxmProp *
  libpolyxmass_prop_default_dup (PxmProp *prop, PxmHowDup how_dup);

  GPtrArray *
  libpolyxmass_prop_GPA_dup (GPtrArray *GPA, gint how_dup);
  
  gint 
  libpolyxmass_prop_GPA_copy (GPtrArray *destGPA, GPtrArray *srcGPA);
  



  /* DATA MODIFYING FUNCTIONS
   */
  gchar *
  libpolyxmass_prop_set_name (PxmProp *prop, gchar *name);




  /* LOCATING FUNCTIONS
   */
  PxmProp * 
  libpolyxmass_prop_find_prop (GPtrArray *GPA,
			   gint *idx,
			   gint (* libpolyxmass_prop_find_cmp_func) (),
			   gchar *name,
			   gpointer data,
			   PxmHowCmp how_cmp);
  



  /* COMPARISON FUNCTIONS
   */
  gint
  libpolyxmass_prop_cmp (PxmProp *prop1, PxmProp *prop2, PxmHowCmp how_cmp);
  
  gint
  libpolyxmass_prop_default_cmp (PxmProp *prop1,
				 PxmProp *prop2,
				 PxmHowCmp how_cmp);
  
 

  /* RENDERING FUNCTIONS - FORMATTER FUNCTIONS
   */
  gchar *
  libpolyxmass_prop_format_xml_prop_default (PxmProp *prop,
					     gchar *indent,
					     gint offset,
					     gpointer user_data);
  
  
  gchar *
  libpolyxmass_prop_format_txt_prop_default (PxmProp *prop,
					     gpointer user_data);
  
  
  PxmProp *
  libpolyxmass_prop_render_xml_prop_default (xmlDocPtr xml_doc,
					     xmlNodePtr xml_node,
					     gpointer user_data);
  
  
  
  


  /* FREE'ING FUNCTIONS
   */
  gint 
  libpolyxmass_prop_free (PxmProp *prop);

  gint 
  libpolyxmass_prop_default_free (PxmProp *prop);

  gint 
  libpolyxmass_prop_free_but_not_data (PxmProp *prop);

  gint 
  libpolyxmass_prop_GPA_free (GPtrArray *GPA);



#ifdef __cplusplus
}
#endif /* __cplusplus */



#endif






