/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#include "polyxmass-monicon.h"




/* NEW'ING FUNCTIONS, DUPLICATING FUNCTIONS ...
 */
PxmMonicon *
polyxmass_monicon_new (void)
{
  PxmMonicon *monicon = NULL;
  
  monicon = g_malloc0 (sizeof (PxmMonicon));
  
  return monicon;
}



/* FREE'ING FUNCTIONS
 */
gboolean
polyxmass_monicon_free (PxmMonicon *monicon)
{
  g_assert (monicon != NULL);
  
  /* It is important to remember here, that the pixbuf that is used to
     make the canvas_item ( with a call to gnome_canvas_item_new ())
     is automatically refcounted. So we can gtk_object_destroy () the
     non-NULL canvas_item and the pixbuf will be unreffed.

     Note also that because the canvas_item belongs to a monicon
     object that was allocated dynamically, we had to ref it once upon
     creation, so that upon this polyxmass_monicon_free() call, we
     could gtk_object_destroy() it safely. See the functions 

     polyxmass_pixbuf_rendering_cursor_monicon_render() and

     polyxmass_pixbuf_rendering_monicon_make_canvas_item()

     to see how this works.
   */
  
  /*
    debug_printf (("freeing monicon %p\n", monicon));
  */

  if (monicon->canvas_item != NULL)
    gtk_object_destroy (GTK_OBJECT (monicon->canvas_item));
  
  g_free (monicon);
  
  return TRUE;
}



/* GPtrArray-RELATED FUNCTIONS
 */
gint
polyxmass_monicon_GPA_empty (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmMonicon *monicon = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      monicon = g_ptr_array_remove_index (GPA, 0);
      polyxmass_monicon_free (monicon);
      count++;
    }
  
  /* Attention, here we do not free the GPA, we are only emptying it !
   */

  return count;
}


gint
polyxmass_monicon_GPA_free (GPtrArray *GPA)
{
  gint count = 0;
  
  PxmMonicon *monicon = NULL;
  

  g_assert (GPA != NULL);
  
  while (GPA->len > 0)
    {
      monicon = g_ptr_array_remove_index (GPA, 0);
      polyxmass_monicon_free (monicon);
      count++;
    }
  
  g_ptr_array_free (GPA, TRUE);

  return count;
}
