/* GNU polyxmass - the massist's program.
   -------------------------------------- 
   Copyright (C) 2000,2001,2002,2003,2004 Filippo Rusconi

   http://www.polyxmass.org

   This file is part of the "GNU polyxmass" project.
   
   The "GNU polyxmass" project is an official GNU project package (see
   www.gnu.org) released ---in its entirety--- under the GNU General
   Public License and was started at the Centre National de la
   Recherche Scientifique (FRANCE), that granted me the formal
   authorization to publish it under this Free Software License.

   This software is free software; you can redistribute it and/or
   modify it under the terms of the GNU  General Public
   License as published by the Free Software Foundation; either
   version 2 of the License, or (at your option) any later version.
   
   This software is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
   General Public License for more details.
   
   You should have received a copy of the GNU  General Public
   License along with this software; if not, write to the
   Free Software Foundation, Inc., 51 Franklin St, Fifth Floor,
   Boston, MA 02110-1301, USA.
*/
#ifndef POLYXMASS_UI_WINDOW_MGMT_H
#define POLYXMASS_UI_WINDOW_MGMT_H

#include "polyxedit-globals.h"
#include "polyxedit-editctxt.h"
#include "polyxmass-window-mngmt.h"
#include "polyxmass-ui-window-mngmt.h"


GtkWidget *
polyxmass_window_mngmt_wnd_setup (GtkWidget *parent_wnd);

gboolean
polyxmass_window_mngmt_wnd_setup_windows_treeview (GtkWidget *window);

void
polyxmass_window_mngmt_wnd_winmngmt_treeview_add_winmngmt (GtkWidget *window,
							   PxmWinMngmt *winmngmt,
							   GPtrArray *winmngmtGPA);

void
polyxmass_window_mngmt_wnd_winmngmt_treeview_remove_winmngmt (GtkWidget *window,
							      PxmWinMngmt *winmngmt);

void
polyxmass_window_mngmt_wnd_winmngmt_treeview_update (GtkWidget *window);

void
polyxmass_window_mngmt_wnd_winmngmt_treeview_selection_changed (GtkTreeSelection 
								*selection,
								gpointer data);


gint
polyxmass_window_mngmt_wnd_update_winmngmt_data (GtkWidget *window, 
						 PxmWinMngmt *winmngmt);

gint
polyxmass_window_mngmt_wnd_reset_winmngmt_data (GtkWidget *window);



gint
polyxmass_window_mngmt_wnd_show_window_button (GtkWidget *button,
					       gpointer data);


gint
polyxmass_window_mngmt_wnd_report_file_choose_button (GtkWidget *button,
						      gpointer data);


gint
polyxmass_window_mngmt_wnd_hide_window_button (GtkWidget *button,
					       gpointer data);


/* CLIPBOARD-HANDLING FUNCTIONS
 */
void
polyxmass_window_mngmt_wnd_clipboard_selection_get (GtkWidget *widget,
						    GtkSelectionData *
						    selection_data,
						    guint info,
						    guint time_stamp,
						    gpointer data);
gboolean
polyxmass_window_mngmt_wnd_clipboard_selection_clear (GtkWidget *widget,
						      GdkEventSelection *
						      event,
						      gpointer data);



/* ACTUAL WINDOW CONTENTS-REPORTING
 */
gchar *
polyxmass_window_mngmt_wnd_report_prepare (GtkWidget *window);

gint
polyxmass_window_mngmt_wnd_report_clipboard_button (GtkWidget *button,
						    gpointer data);

gint
polyxmass_window_mngmt_wnd_report_file_overwrite_button (GtkWidget *button,
							 gpointer data);


gint
polyxmass_window_mngmt_wnd_report_file_append_button (GtkWidget *button,
						      gpointer data);



gint
polyxmass_window_mngmt_wnd_delete_event  (GtkWidget *window, 
				      GdkEventAny *event, 
					  gpointer data);


gint
polyxmass_window_mngmt_wnd_destroy_event  (GtkWidget *window, 
					   GdkEventAny *event, 
					   gpointer data);









#endif /* POLYXMASS_UI_WINDOW_MGMT_H */
