/*                                            
Configuration.cc
*/

#include "Configuration.h"

Configuration::Configuration (const char *afnconf, bool aAbortInError)
  {
  fnconf = afnconf;
  AbortInError = aAbortInError;
  }
  
Configuration::~Configuration ()
  {
  }

void Configuration::Error (void)
  {
  if (AbortInError == true) 
    {
    printf ("Error reading configuration file \"%s\"! Aborting ...\n", fnconf.cstr()); 
    exit (1);
    }
  }  

void Configuration::setFileName (const char *afilename)
  {
  fnconf = afilename;
  }
      
const char *Configuration::getFileName (void)
  {
  return fnconf.cstr();
  }

bool Configuration::Reload (void)
  {
  return ConfRead ();
  }    

bool Configuration::Sync (void)
  {
  bool b;
  b = ConfSave ();
  Reload ();
  return b;
  }
  
//METO TODO EL FICHERO DE CONFIGURACION EN MEMORIA
bool Configuration::ConfRead (void)
  {
  char Buffer[XXBUFFERSIZE + 1];
  FILE *CfgFile;
  SLFile.Clear();
  CfgFile = fopen (fnconf.cstr(), "r");
  if (NULL == CfgFile) {Error(); return false;}
  while (NULL != fgets (Buffer, XXBUFFERSIZE, CfgFile))
    {
    if (IsEmpty(Buffer) == false) SLFile.Add (Buffer);              
    }
  fclose (CfgFile);
  return true;
  }
  
//GUARDO EN DISCO TODO EL FICHERO DE CONFIGURACION DE MEMORIA
bool Configuration::ConfSave (void)
  {
  TBuffer abuf;
  FILE *CfgFile;
  CfgFile = fopen (fnconf.cstr(), "w");
  if (NULL == CfgFile) {Error(); return false;}
  for (int yy = 0; yy < SLFile.Count(); ++yy)
    {
    xstrncpy (abuf, CMAXBUFFER, SLFile.getString(yy).cstr());
    QuitaRetornoCarroDeLinea (abuf);
    if (IsEmpty(abuf) == false) fprintf (CfgFile, "%s\n", abuf);
    }
  fclose (CfgFile);
  return true;
  }  

bool Configuration::newFile (const char *filecont)
  {
  FILE *CfgFile;
  CfgFile = fopen (fnconf.cstr(), "w");
  if (NULL == CfgFile) {Error(); return false;}
  fprintf (CfgFile, "%s", filecont);
  fclose (CfgFile);
  return true;  
  }    
 
void Configuration::dumpDebug (void)
  {
  for (int yy = 0; yy < SLFile.Count(); ++yy)
    {
    DEBUG ("%s", SLFile.getString(yy).cstr());  //of DEBUG, MUST BE UNCOMMENTED
    }
  }
 
//RETURNS A CONFIGURATION STRING. LIKE AS getprivateprofilestring OF WINDOWS API
char *Configuration::getString (const char *asection, const char *akey, const char *adefault, int amaxsize)
  {
  bool EncontradaSeccion = false;
  int i=0, maxsize;
  char cbegin, cend, *pos;
  TBuffer linea, seccion, key, result, upseccion, upkey;
  
  maxsize = amaxsize; if (maxsize > CMAXBUFFER) {maxsize = CMAXBUFFER;}
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  xstrncpy (upkey, CMAXBUFFER, akey); xucase (upkey);
  initStr(seccion); initStr (key); initStr (result);
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {EncontradaSeccion = true;}
          else {EncontradaSeccion = false;}
          }
        else
          {
          if (EncontradaSeccion == true)
            {
            pos = strchr (linea, '=');
            if (pos != NULL)
              {
              xstrncpy (key, CMAXBUFFER, linea); 
              key [pos - linea] = '\0'; trim (key); xucase (key);
              if (strcmp (key, upkey) == 0)
                {
                xstrncpy (result, maxsize, pos + 1); trim (result);
                }
              }
            }
          }  
        }
      }
    ++i;
    }
  if (strcmp (result, "") == 0) {xstrncpy (result, CMAXBUFFER, adefault);}  
  /*
  DEBUG ("*******************************");
  DEBUG ("SECCION=%s", asection);
  DEBUG ("KEY=%s", akey);
  DEBUG ("DEFAULT=%s", adefault);
  DEBUG ("RESULT=%s", result);
  */
  return xstrdup (result);  
  }  
  
bool Configuration::setString (const char *asection, const char *akey, const char *astring, int amaxsize)
  {
  bool EncontradaSeccion = false;
  int i=0, maxsize;
  char cbegin, cend, *pos;
  TBuffer linea, seccion, key, result, anewline, upseccion, upkey;
  
  maxsize = amaxsize; if (maxsize > CMAXBUFFER) {maxsize = CMAXBUFFER;}
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  xstrncpy (upkey, CMAXBUFFER, akey); xucase (upkey);
  initStr(seccion); initStr (key); initStr (result);
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          if (EncontradaSeccion == true)
            {
            //add a new line for new variable not in the ini file
            snprintf (anewline, CMAXBUFFER, "%s=%s", akey, astring);
            SLFile.insertElementAt (anewline, i);
            return true;
            }          
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {EncontradaSeccion = true;}
          else {EncontradaSeccion = false;}
          }
        else
          {
          if (EncontradaSeccion == true)
            {
            pos = strchr (linea, '=');
            if (pos != NULL)
              {
              xstrncpy (key, CMAXBUFFER, linea); 
              key [pos - linea] = '\0'; trim (key); xucase (key);
              if (strcmp (key, upkey) == 0)
                {
                xstrncpy (result, maxsize, pos + 1); trim (result);
                snprintf (linea, CMAXBUFFER, "%s=%s", akey, astring);
                SLFile.setElementAt (linea, i); 
                return true;
                }
              }
            }
          }  
        }
      }
    ++i;
    }
 if (EncontradaSeccion == true)
   {
   //add a new line for new variable not in the ini file
   snprintf (anewline, CMAXBUFFER, "%s=%s", akey, astring);
   SLFile.insertElementAt (anewline, i - 1);
   return true;
   }     
   
  if (IsThereSection (asection) == false)
    {
    snprintf (linea, CMAXBUFFER, "[%s]", asection);       SLFile.Add (linea);
    snprintf (linea, CMAXBUFFER, "%s=%s", akey, astring); SLFile.Add (linea);
    }
     
  return false;  
  }  
  
//DEVUELVE UN INTEGER DE CONFIGURATION. 
int Configuration::getInt (const char *asection, const char *akey, int adefault)
  {
  bool EncontradaSeccion = false;
  int i=0, maxsize, resint;
  char cbegin, cend, *pos;
  TBuffer linea, seccion, key, result, upseccion, upkey;
  
  maxsize = CMAXBUFFER;
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  xstrncpy (upkey, CMAXBUFFER, akey); xucase (upkey);
  initStr(seccion); initStr (key); initStr (result);
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {EncontradaSeccion = true;}
          else {EncontradaSeccion = false;}
          }
        else
          {
          if (EncontradaSeccion == true)
            {
            pos = strchr (linea, '=');
            if (pos != NULL)
              {
              xstrncpy (key, CMAXBUFFER, linea); 
              key [pos - linea] = '\0'; trim (key); xucase (key);
              if (strcmp (key, upkey) == 0)
                {
                xstrncpy (result, maxsize, pos + 1); trim (result);
                }
              }
            }
          }  
        }
      }
    ++i;
    }
  resint = xatoidef (result, adefault);
  /*
  DEBUG ("*******************************");
  DEBUG ("SECCION=%s", asection);
  DEBUG ("KEY=%s", akey);
  DEBUG ("DEFAULT=%d", adefault);
  DEBUG ("RESULT=%d", resint);
  */
  return resint;  
  }   
  
bool Configuration::setInt (const char *asection, const char *akey, int aint)
  {
  bool EncontradaSeccion = false;
  int i=0, maxsize;
  char cbegin, cend, *pos;
  TBuffer linea, seccion, key, result, anewline, upseccion, upkey;
  
  maxsize = CMAXBUFFER;
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  xstrncpy (upkey, CMAXBUFFER, akey); xucase (upkey);
  initStr(seccion); initStr (key); initStr (result);
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {          
          if (EncontradaSeccion == true)
            {
            //add a new line for new variable not in the ini file
            snprintf (anewline, CMAXBUFFER, "%s=%d", akey, aint);
            SLFile.insertElementAt (anewline, i);
            return true;
            }          
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {EncontradaSeccion = true;}
          else {EncontradaSeccion = false;}
          }
        else
          {
          if (EncontradaSeccion == true)
            {
            pos = strchr (linea, '=');
            if (pos != NULL)
              {
              xstrncpy (key, CMAXBUFFER, linea); 
              key [pos - linea] = '\0'; trim (key); xucase (key);
              if (strcmp (key, upkey) == 0)
                {
                xstrncpy (result, maxsize, pos + 1); trim (result);
                snprintf (linea, CMAXBUFFER, "%s=%d", akey, aint);
                SLFile.setElementAt (linea, i); 
                return true;
                }
              }
            }
          }  
        }
      }
    ++i;
    }
  if (EncontradaSeccion == true)
    {
    //add a new line for new variable not in the ini file
    snprintf (anewline, CMAXBUFFER, "%s=%d", akey, aint);
    SLFile.insertElementAt (anewline, i - 1);
    return true;
    }            
    
  if (IsThereSection (asection) == false)
    {
    snprintf (linea, CMAXBUFFER, "[%s]", asection);       SLFile.Add (linea);
    snprintf (linea, CMAXBUFFER, "%s=%d", akey, aint); SLFile.Add (linea);
    }
     
  return false;  
  }     
  
//EXISTE SECCION
bool Configuration::IsThereSection (const char *asection)
  {
  int i=0;
  char cbegin, cend;
  TBuffer seccion, linea, upseccion;
  
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  initStr(seccion); 
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {return true;}
          }
        }
      }
    ++i;
    }
  return false;  
  }    
  
//COGE EL CONTENIDO DE UNA SECCION ENTERA
bool Configuration::getSection (const char *asection, StringList *ASection)
  {
  bool HabiaSeccion = false, EncontradaSeccion = false;
  int i=0;
  char cbegin, cend;
  TBuffer seccion, linea, upseccion;
  
  ASection->Clear();
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  initStr(seccion); 
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((EncontradaSeccion == true) && (linea != NULL))
      {
      if (linea[0] != '[') {ASection->Add (linea);}
      }
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) {HabiaSeccion = true; EncontradaSeccion = true;}
          else {EncontradaSeccion = false;}
          }
        }
      }
    ++i;
    }
  return HabiaSeccion;  
  }      

//slot could be "name_%d"
int Configuration::getFreeSlot (const char *slot, int CMAX)
  {
  TBuffer sectname;
  int i = 0;   
  bool b; 
  do
    {
    ++i;
    xsnprintf (sectname, CMAXBUFFER, slot, i);
    b = IsThereSection (sectname);    
    }
  while ((b == true) && (i < CMAX)); 
  if (b == false) return i; else return -1;
  }



bool Configuration::deleteSection (const char *asection)
  {
  bool HabiaSeccion = false, EncontradaSeccion = false;
  int i=0;
  char cbegin, cend;
  TBuffer seccion, linea, upseccion;  
  
  xstrncpy (upseccion, CMAXBUFFER, asection); xucase (upseccion);
  initStr(seccion); 
  while (i < SLFile.Count())
    {
    xstrncpy (linea, CMAXBUFFER, SLFile.getString(i).trim().cstr());
    if ((EncontradaSeccion == true) && (linea != NULL))
      {
      if (linea[0] != '[') 
        {
        SLFile[i] = "";
        }
      }
    if ((strcmp (linea, "") != 0) && (linea != NULL) && (strcmp (linea, " ") != 0))
      {
      cbegin = linea[0]; cend = linea[strlen(linea) - 1];
      if (cbegin != ';')
        {
        if ((cbegin == '[') && (cend == ']'))
          {
          XString axs (SLFile.getString(i).trim());
          xstrncpy (seccion, CMAXBUFFER, axs.substring(1, axs.length() - 1).toUpperCase().cstr());
          if (strcmp (seccion, upseccion) == 0) 
            {
            HabiaSeccion = true; 
            EncontradaSeccion = true;
            SLFile[i] = "";
            }
          else 
            {
            EncontradaSeccion = false;
            }
          }
        }
      }
    ++i;
    }
  return HabiaSeccion;  
  }      


