/*                                                           
Cookie.cc
*/

#include "Cookie.h"

Cookie::Cookie (const char *user, const char *connid)
  {
  newCookie(connid);
  setSecure(false); 
  setName(user);
  setValue((char *)thecookie.cstr()); 
  setDomain(""); 
  setPath("");   
  }

Cookie::~Cookie()
  {
  }

void Cookie::newCookie (const char *connid)
  {
  char cookie_chars[] = ("ABCDEFGHIJKLMNOPQRSTUVWXYZabcdefghijklmnopqrstuvwxyz0123456789");
  int i, p;
  char rawid[24 + 1], letra[2];
  TSBuffer abuf;
  
  letra[1] = '\0';
  initStr (rawid);
  for (i = 1; i <= 24; ++i)
    {
    p = (int) Rand(62);
    letra[0] = cookie_chars[p];
    xstrncat (rawid, 24 + 1, letra);
    }
  xstrncpy (abuf, CSMALLBUFFER, connid); 
  xstrncat (abuf, CSMALLBUFFER, "@"); 
  xstrncat (abuf, CSMALLBUFFER, rawid);
  thecookie = abuf;        
  }

const char *Cookie::getSetFullCookieLine(void)
  {
  acook =  getName(); acook += '='; acook += getValue();
  if(fPath.empty() == false) {acook += "; Path="; acook += fPath;}  
  if(fDomain.empty() == false)  {acook += "; Domain="; acook += fDomain;}  
//  acook += "; Expires=Wednesday, 22-Nov-20 09:09:00 GMT";
  if(fSecure == true) {acook += "; Secure";}
  acook += "; Version=1";
  return acook.cstr();
  }

const char *Cookie::getSetClearFullCookieLine(void)
  {
  acook =  getName(); acook += '='; acook += getValue();
  if(fPath.empty() == false) {acook += "; Path="; acook += fPath;}  
  if(fDomain.empty() == false)  {acook += "; Domain="; acook += fDomain;}  
  acook += "; Expires=Wednesday, 22-Nov-00 09:09:00 GMT";
  if(fSecure == true) {acook += "; Secure";}
  acook += "; Version=1";
  return acook.cstr();
  }

const char *Cookie::getName (void)
  { 
  return fName.cstr(); 
  }

const char *Cookie::getValue (void)
  { 
  return fValue.cstr(); 
  }

const char *Cookie::getDomain (void)
  { 
  return fDomain.cstr(); 
  }

const char *Cookie::getPath (void)
  { 
  return fPath.cstr(); 
  }    

bool Cookie::isSecure() const 
  { 
  return fSecure; 
  }

void Cookie::setName(const char *name) 
  { 
  fName = name; 
  }

void Cookie::setValue(const char *value) 
  { 
  fValue = value; 
  }

void Cookie::setDomain(const char *domain) 
  { 
  fDomain = domain; 
  }

void Cookie::setPath(const char *path) 
  { 
  fPath = path; 
  }

void Cookie::setSecure(bool secure) 
  { 
  fSecure = secure; 
  }
  
bool Cookie::isGoodCookie (const char *acookiestring)
  {
  if (strcmp (acookiestring, getValue()) != 0) return false;
  else return true;              
  }
  

