/***************************************************************************
 *                                                                         *
 *                         Powersave Daemon                                *
 *                                                                         *
 *          Copyright (C) 2004,2005 SUSE Linux Products GmbH               *
 *                                                                         *
 * This program is free software; you can redistribute it and/or modify it *
 * under the terms of the GNU General Public License as published by the   *
 * Free Software Foundation; either version 2 of the License, or (at you   *
 * option) any later version.                                              *
 *                                                                         *
 * This program is distributed in the hope that it will be useful, but     *
 * WITHOUT ANY WARRANTY; without even the implied warranty of              *
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU       *
 * General Public License for more details.                                *
 *                                                                         *
 * You should have received a copy of the GNU General Public License along *
 * with this program; if not, write to the Free Software Foundation, Inc., *
 * 51 Franklin St, Fifth Floor, Boston, MA 02110-1301 USA                  *
 *                                                                         *
 ***************************************************************************/

#include "string.h"
#include "config.h"

#include "powerlib.h"

#define SLEEP_PROC_FILE "/proc/acpi/sleep"
#define SYSFS_SLEEP_FILE "/sys/power/state"

int64_t getSupportedSleepStates(void)
{

	char line[MAX_LINE_SIZE + 1];
	int test;
	FILE *fp;
	int ret = 0;
	test = checkACPI();
	if (test == ACPI) {
		if ((fp = fopen(SLEEP_PROC_FILE, "r")) == NULL) {
			pDebug(DBG_INFO, "Could not open '%s'", SLEEP_PROC_FILE);
			ret = 0;
		} else {
			if (fgets(line, MAX_LINE_SIZE, fp) == NULL) {
				ret = 0;
			} else {
				if (strstr(line, "S1") != NULL)
					ret |= ACPI_S1;
				if (strstr(line, "S2") != NULL)
					ret |= ACPI_S2;
				if (strstr(line, "S3") != NULL)
					ret |= ACPI_S3;
				if (strstr(line, "S3_bios") != NULL)
					ret |= ACPI_S3_BIOS;
				if (strstr(line, "S4") != NULL)
					ret |= ACPI_S4;
				if (strstr(line, "S4_bios") != NULL)
					ret |= ACPI_S4_BIOS;
			}
			fclose(fp);
		}

		if (ret == 0) {
			if ((fp = fopen(SYSFS_SLEEP_FILE, "r")) == NULL) {
				pDebug(DBG_WARN, "Could not open '%s'", SYSFS_SLEEP_FILE);
				ret = 0;
			} else {
				if (fgets(line, MAX_LINE_SIZE, fp) == NULL) {
					ret = 0;
				} else {
					if (strstr(line, "standby") != NULL)
						ret |= ACPI_S1;
					if (strstr(line, "mem") != NULL)
						ret |= ACPI_S3;
					if (strstr(line, "disk") != NULL)
						ret |= ACPI_S4;
				}
				fclose(fp);
			}
		}

	} else if (test == APM)
		/* do not evaluate APM any further for now */
		/* ToDO: are really both supported? */
		return APM_STANDBY + APM_SUSPEND;
	else {
		ret = 0;
	}
	return ret;
}
