/* Copyright (C) 1999-2000 Bernhard Trummer
 * Copyright (C) 2003      Benjamin Drieu
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: datenode.cc,v $
 * Revision 1.5  2003/03/06 14:54:21  benj
 * Update copyrigth where it is necessary
 *
 * Revision 1.4  2003/02/26 12:28:33  benj
 * Clean up options a bit
 * Fix a crash when images are not found
 * Command option '-l' now has an optional argument
 * .tex files are now based on xml presentation name
 *
 * Revision 1.3  2003/02/18 12:56:49  bdrieu
 * - Update to make prestimel compile with g++-3.2
 * - Use Magick++ instead of Magick
 *
 * Revision 1.2  2001/04/27 20:02:50  slash
 * Make use of xmlChildrenNode and xmlRootNode.
 *
 * Revision 1.1.1.1  2001/01/30 18:36:22  slash
 * Initial release.
 *
 */

#include "main.h"
#include "parameters.h"
#include "contentnode.h"
#include "datenode.h"


//---------------------------------------------------------------------------
DateNode::DateNode(xmlNodePtr node) : Node()
{
    for (node = node->xmlChildrenNode; node; node = node->next) {
        if (node->type == XML_TEXT_NODE) {
            child_nodes_.push_back(new ContentNode(node));
        } else {
            Number_Of_Errors_++;
        }
    }
}

//---------------------------------------------------------------------------
DateNode::~DateNode()
{
}


//---------------------------------------------------------------------------
void DateNode::writeHTML(int parameter) const
{
    Output_ << "<P class=\"date\">";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    Output_ << "</P>" << std::endl;
}

//---------------------------------------------------------------------------
void DateNode::writeLaTeX() const
{
    if (!Parameters_.isOutlineEnabled()) {
        Output_ << "\\noindent" << std::endl;
    }
    Output_ << std::endl
	    << "{\\large";;
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeLaTeX();
    }
    Output_ << "}" 
	    << std::endl;
}

//---------------------------------------------------------------------------
void DateNode::writeXML() const
{
    Output_ << "<date>";
    for (unsigned int i=0; i<child_nodes_.size(); i++) {
        child_nodes_[i]->writeXML();
    }
    Output_ << "</date>" << std::endl;
}
