/* Copyright (C) 1999-2000 Bernhard Trummer
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 *
 * $Log: enumeratenode.h,v $
 * Revision 1.2  2001/04/20 15:40:36  slash
 * Make use of the function xmlGetProp().
 *
 * Revision 1.1.1.1  2001/01/30 18:36:49  slash
 * Initial release.
 *
 */

#ifndef ENUMERATENODE_H
#define ENUMERATENODE_H

#include "listnode.h"

//---------------------------------------------------------------------------
/**
 * This class represents an enumerate-node.
 */
class EnumerateNode : public ListNode {
  public:
    //-----------------------------------------------------------------------
    /**
     * This enumeration defines the possible types of the enumerate-node.
     */
    enum Enumerate_Type {
        UNDEFINED, DECIMAL, UPPER_ALPHA, LOWER_ALPHA, UPPER_ROMAN, LOWER_ROMAN
    };

    //-----------------------------------------------------------------------
    /**
     * The constructor initializes the enumerate-node.
     *
     * @param node A pointer to the enumerate-node in the XML-tree.
     * @param level The level of the enumeration.
     * @param with_left_margin Indicates, if the HTML-output should have a
     *                         margin on the left side.
     */
    EnumerateNode(xmlNodePtr node,
                  unsigned int level = 0,
                  int with_left_margin = 1);

    //-----------------------------------------------------------------------
    /**
     * Destructor.
     */
    ~EnumerateNode();


    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be LaTeX.
     */
    void writeLaTeX() const;

    //-----------------------------------------------------------------------
    /**
     * This method writes the node to the global output filestream Output_.
     * The format of the output must be XML.
     */
    void writeXML() const;

    //-----------------------------------------------------------------------
    /**
     * This method signals, if the HTML-output of the enumeration should be
     * stepped.
     *
     * @return 1, if the HTML-output should be stepped, else 0.
     *
     * @see getNumberOfHTMLSteps
     */
    int isHTMLStepped() const;

    //-----------------------------------------------------------------------
    /**
     * This method returns the number of steps of the HTML-output.
     *
     * @return The number of steps.
     */
    unsigned int getNumberOfHTMLSteps() const;


  protected:     

    //-----------------------------------------------------------------------
    /**
     * This helper-method writes the HTML-header for the enumeration to the
     * global output filestream Output_.
     */
    void writeHTMLHeader() const;

    //-----------------------------------------------------------------------
    /**
     * This helper-method writes the HTML-footer for the enumeration to the
     * global output filestream Output_.
     */
    void writeHTMLFooter() const;


  private:

    //-----------------------------------------------------------------------
    /**
     * Indicates the type of the enumeration.
     */
    Enumerate_Type type_;

    //-----------------------------------------------------------------------
    /**
     * Indicates, if the HTML-output of the items should be stepped.
     * If -1, the step-property was not given in the itemize-markup.
     */
    int step_;

    //-----------------------------------------------------------------------
    /**
     * 1, if the HTML-output of the items should have a closing </P>, else 0.
     */
    int closing_p_;
};

#endif //ENUMERATENODE_H
