#!/usr/bin/perl -w

die "Cannot execute ../src/ntdpal" unless -x '../src/ntdpal';
$ENV{TC_SILENT} = '1';

# Test error handling on over-long input sequence:

print STDERR 'Long sequence error handling...';
$r = system '../src/ntdpal ACGTGTTCGTCGTAAATAACATGCTATATT GACGTAGACAACCCTGTGTTTAGCCTGCGTTTTGTGCCATCCTAATGCTTTACTAGATCACTGAGCCACCTCCCAAGGACTACACCTAGCGGTATTTCGTACATTAACTAGGATCCTTTTCCACATGGACTACAATGTCTGCCGAGCATGCGATGGGGTACCGCGCCCGCGCACATACGCGCGCAGAGCTTTTGGAGGCATACCTACACCGGCGAGGGGCTGCGGTTTATTGACACTGAAACGGGATAACGAGTCGCTGAATTGAGCCAAAAATATGCAAGCGTCACAAATTGTGACAAAAATTTTAAAGGAAAAATTAGACCATTGATTCTGAAGTGGTGCGTATAGGACCAGTCGTGGCAATGAGACCGATTTGAGTAGCACTAGCTCAAACACTGTCTGGGTCGCCATCAAGGCCACAAGAACTTAAGCAGCCGTCACCCTATAGAAGGTTAAGCGACGGTTAGGGCTTCTGGCAACGAAAGTTGTCGGTTCGTCCTGTGCCAACGTGTGGCAAAGTCTACTATGATTCGATTGTTGACGTGTCGACAGGCTGTTTCGCTGGATACCCCACCTTGATAATTTTTCTCGTCGAACGCTAGCAGTTTTTTTTTCAACGGCCCGGAATCTGTAAGAGGCCGTTGCAGGAACGCGTGTGTATGTAAATGCCCACTACTTCTGTTATGTACCCAAATGGCGTGCGGCGTGGATGTATAGTGTCGACCCTCCATAATCGGGCGGACGGTCGTGGGGTATGTATGATCTTCGGCACTGATTCGCCTCGAGTCTATATGTTCTTAATCCAGACCTTCGGGGAAAGCCTACTTTCCATCCGTTGTCTAGCGTCATGCCAGTGACTACTGTTGTATTGTCTGGTTCCTAAGATAGCCATGGATTCCGGACATCGACGATGCACAAGAGCGTTAGCGCTGGTGTGCAACGCAACGTCGCGAAGGCTGGGTTACAGCGTGATCTCCTGGCTGCACCCAGATGCAGAGGGACATACCTACGATGAATAGGTGCGTCTGTTTATAAACGCCCAATCCTAGCAAAAATCACAACTAAGACAGTGTATGGAAGACCCACCAGTTGTGGGCGAATGGTCAGGTATACAAGATCGTGTCAAGACGGAACTTAAGCTTCTGTGCGCTCTCCATGCGAGCTGGTACGTCTGGACGGCGAGGTATGAGTGAATGACCATCCATGGCAACTTTCGTGTTCTACGACAGATACGAGCTCGACGGACGACCTGGTGACCAGTAGTATATGCGCGTCCGTCGGCCAGACTTTCCAAACGCCCTTTCAACGAGATACATGCGAACACGCTACAATTTCTCGTTCCGTCTAAAGTCGATACTCGCAAGCCCAGGCCCGTTACTACAACGCTGTTAATAGGATCAGAAGGGCCATAAGACTTTGGCAGCGGTAGCTAGGAAAGTGATGGTTGTGATGGCCCTAGTAAGGAGTCAGCCATCTACCCAACTATTTGAATGGGACCATAGCCAAGGGACCCAGCTGTTCCTTAGAAACCTGGTGACTCCCTTAGCCAATTGTGTAACTTCGTGCGTGCCAGTATTACACCTATAATCACAAGACCCCTTCAATACGAGTCCTGTGGCGTAGTGTTCCATCAAAACAATCAAGAACAGATTTCCGGTCCCCGTTGTGTTGGGATCTAGCGGACGTTGTCGGTAGATCAATAACGTAAATGCGAATCGAAGTTCTCTGGCCTAAAACAACTGCGCGCAGGGCCTCCGGTCATTGCATCTTTCTTGTCTCTCGTGAGGGCGTGATTCGTTTACCTGGAGCGAGCCGGGCACAAGAGCTATGGATTATTGGCTGGTGCAAAAACCATTCTAGCTACAATTATACTCGCGTGTCGACGATAAGAGTGAAATCACTGCGTAGGCAAACTGCCGGGTCACCAAGAGAGGCTGATACCGCGGTTCACCC l > dpal.tmp 2>&1';
open X, 'dpal.tmp';
@foo = <X>;
close X;
print STDERR
    ($foo[1] eq "Sequence 2 longer than DPAL_MAX_ALIGN and alignment is requested\n"
     ? "OK\n" : "FAILED\n");

runtest('Default implementations + alignment',
	"perl dpal_gen.pl '../src/ntdpal' <dpal_input",
	'dpal_output');
system "cat dpal.tmp > dpal_output1.tmp";

runtest('Default implementations + NO alignment 1',
	"perl dpal_gen.pl '../src/ntdpal -s' <dpal_input",
	'dpal_score_output');
system "cat dpal.tmp > dpal_score_output1.tmp";

runtest('Default implementations + NO alignment 2',
	"perl dpal_gen.pl '../src/ntdpal -s' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal.tmp > dpal_long_score_output1.tmp";

runtest('Force _dpal_generic',
	"perl dpal_gen.pl '../src/ntdpal -s -f1' <dpal_input",
	'dpal_score_output');
system "cat dpal.tmp > dpal_score_output4.tmp";

runtest('Force _dpal_long_nopath_generic 1',
	"perl dpal_gen.pl '../src/ntdpal -s -f2' <dpal_input",
	'dpal_score_output');
system "cat dpal.tmp > dpal_score_output2.tmp";

runtest('Force _dpal_long_nopath_generic 2',
	"perl dpal_gen.pl '../src/ntdpal -s -f2' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal.tmp > dpal_long_score_output2.tmp";

runtest('Force long maxgap1 functions 1',
	"perl dpal_gen.pl '../src/ntdpal -s -f3' <dpal_input",
	'dpal_score_output');
system "cat dpal.tmp > dpal_score_output3.tmp";

runtest('Force long maxgap1 functions 2',
	"perl dpal_gen.pl '../src/ntdpal -s -f3' <dpal_long_input",
	'dpal_long_score_output');
system "cat dpal.tmp > dpal_long_score_output3.tmp";

exit;

sub runtest {
    my ($desc, $cmd, $benchfile) = @_;
    print STDERR $desc, '...';
    system $cmd .  ' > dpal.tmp';
    $r = system "diff $benchfile dpal.tmp";
    print STDERR $r == 0 ? "OK\n" : "FAILED\n";
}

