/*
 * prismstumbler wireless lan analyzing tool
 *
 * Copyright (C) 2000 and created by Jan Fernquist  <Jan.B.Fernquist@telia.com>
 * Copyright (C) 2003, 2004 Florian Boor <florian.boor@kernelconcepts.de>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; either version 2
 * of the License, or (at your option) any later version.
 * 
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 * 
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA  02111-1307, USA.
 *
 * scanner backend main 
 *
 */

#include <stdio.h>
#include <unistd.h>
#include <sys/socket.h>
#include <sys/types.h>
#include <sys/un.h>
#include <sys/stat.h>

#include <prismstumbler.h>
#include "ps_resolv.h"
#include "iface-wlan-14.h"

const char *dhcpcommands[] = {
	"/sbin/dhcpcd %s &",
	"/sbin/dhclient %s &",
	"/sbin/udhcpc -i %s &",
	"/usr/sbin/dhcpcd %s &",
	"/usr/sbin/udhcpc -i %s &"
};

#define HELPTEXT "Call with no parameters or with the following options\n\
	-S Channel   - Only listen on a specific Channel (1-14)\n\
	-w FileName  - Create (and update) Gpsdrive Waypointfile\n\
	-d Database only mode (scanner inactive)\n\
	-o Use orinoco driver interface\n\
	-h Use hostap driver interface\n\
	-i Interface - Use designated interface\n\
	-q Quiet mode, no output to stdout\n\n"

extern char * WPFileName;
extern FILE * WPFile;

psconfig_t cfg = { 0, "eth1", DT_ORINOCO, 40000, 0 ,0, TRUE,"\0", "/tmp/psdump.pcap", FALSE, 0};
unsigned int stop_sniffing = 0;
int newnet_count = 0;
int have_led = 0;
int QUIET_MODE = 1;

void stop_signal()
{
	// do something intelligent
	closePacket();
	shutCard();
	if (!QUIET_MODE) printf("term signal received - exiting...\n");
	if (WPFile) fclose(WPFile);
	unlink(PS_SOCKET);
	exit(0);
}

void pipe_signal()
{
	closePacket();
	shutCard();
}


/*
 * Help the poor guy!
 */

void
HelpAndBye (void)
{
	fprintf (stderr, "%s", HELPTEXT);
	exit (1);
}


int
main (int argc, char *argv[])
{
	int c;
	int lsock, csock;
	struct sockaddr_un laddr, caddr;
	socklen_t len;
	
	setuid(0);
	seteuid(0);
	
	while(  ( c = getopt(argc,argv,"dS:w:i:ohq") ) != EOF ){
		switch(c){
			case 'S':{
						cfg.singlechan = atoi(optarg);
						if( cfg.singlechan < 1 || cfg.singlechan > 14 ){
							HelpAndBye();
						}
						break;
					}
					
			case 'w':   snprintf(cfg.wpfile,255,"%s",optarg);
					break;
			case 'd': 	cfg.scan = FALSE;
					break;
			case 'o':	cfg.devtype = DT_ORINOCO;
					break;
			case 'h':	cfg.devtype = DT_HOSTAP;
					break;
			case 'i':  snprintf(cfg.device,5,"%s",optarg);				
					break;
			case '?':       HelpAndBye();
					break;
			case 'q':	QUIET_MODE = TRUE;
					break;
		}
	}

	if ((cfg.scan) && (geteuid()))
	{
		fprintf(stderr,"Seems like you don't have root permissions. \n" \
		               "Starting with scanner disabled.\n");
		cfg.scan = FALSE;
	}
	
	if( cfg.wpfile[0] ){
		if(( WPFile = fopen(cfg.wpfile,"w")) == NULL ){
			fprintf(stderr,"Cant open waypoint file %s for writing\n",cfg.wpfile);
			exit(1);
		}
	}

	/* check for led switching binary */
	if (access("/usr/bin/led",X_OK) == 0)
		have_led = TRUE;
		
	/* initialize socket server */
	lsock = socket(AF_LOCAL, SOCK_STREAM, 0);
	unlink(PS_SOCKET);
	bzero(&laddr,sizeof(laddr));
	laddr.sun_family = AF_LOCAL;
	strcpy(laddr.sun_path, PS_SOCKET);
	
	bind(lsock, (struct sockaddr *) &laddr, sizeof(laddr));
	listen(lsock, 1);
	
	signal (SIGINT, stop_signal);
	signal (SIGTERM, stop_signal);
	signal (SIGPIPE, pipe_signal);
	
	chmod(PS_SOCKET,S_IROTH | S_IWOTH | S_IRGRP | S_IWGRP | S_IRUSR | S_IWUSR);
	
	len = sizeof(caddr);
	
	for ( ;; )
	{
		if ((csock = accept(lsock, (struct sockaddr*)&caddr, &len)) < 0)
		{
			if (errno == EINTR)
				continue;
			else
			{
				fprintf(stderr,"Err: accept - %s\n",strerror(errno));
				close(lsock);
				unlink(PS_SOCKET);
				exit(1);
			}
		}
		else
		{
			stop_sniffing = FALSE;
			psmain(csock);
			if (!QUIET_MODE) printf("\nleft mainloop\n");
			close(csock);
			break;  /* return after connection exited */
		}
	}
	
	unlink(PS_SOCKET);
	return 0;
}
