/*
 * Decompiled with CFR 0.152.
 */
package proguard;

import proguard.classfile.LibraryClassFile;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.util.ClassUtil;
import proguard.classfile.util.WarningPrinter;
import proguard.classfile.visitor.ClassFileVisitor;

public class DuplicateClassFilePrinter
implements ClassFileVisitor {
    private WarningPrinter notePrinter;

    public DuplicateClassFilePrinter(WarningPrinter warningPrinter) {
        this.notePrinter = warningPrinter;
    }

    public void visitProgramClassFile(ProgramClassFile programClassFile) {
        this.notePrinter.print("Note: duplicate definition of program class [" + ClassUtil.externalClassName(programClassFile.getName()) + "]");
    }

    public void visitLibraryClassFile(LibraryClassFile libraryClassFile) {
        this.notePrinter.print("Note: duplicate definition of library class [" + ClassUtil.externalClassName(libraryClassFile.getName()) + "]");
    }
}

