/*
 * Decompiled with CFR 0.152.
 */
package proguard.classfile.attribute;

import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import proguard.classfile.ClassFile;
import proguard.classfile.MethodInfo;
import proguard.classfile.ProgramClassFile;
import proguard.classfile.attribute.AttrInfo;
import proguard.classfile.attribute.AttrInfoVisitor;
import proguard.classfile.visitor.CpInfoVisitor;

public class ExceptionsAttrInfo
extends AttrInfo {
    private static final int CONSTANT_FIELD_SIZE = 2;
    public int u2numberOfExceptions;
    public int[] u2exceptionIndexTable;

    protected ExceptionsAttrInfo() {
    }

    protected int getLength() {
        return 2 + 2 * this.u2numberOfExceptions;
    }

    protected void readInfo(DataInput dataInput, ClassFile classFile) throws IOException {
        this.u2numberOfExceptions = dataInput.readUnsignedShort();
        this.u2exceptionIndexTable = new int[this.u2numberOfExceptions];
        for (int i = 0; i < this.u2numberOfExceptions; ++i) {
            this.u2exceptionIndexTable[i] = dataInput.readUnsignedShort();
        }
    }

    protected void writeInfo(DataOutput dataOutput) throws IOException {
        dataOutput.writeShort(this.u2numberOfExceptions);
        for (int i = 0; i < this.u2numberOfExceptions; ++i) {
            dataOutput.writeShort(this.u2exceptionIndexTable[i]);
        }
    }

    public void accept(ClassFile classFile, AttrInfoVisitor attrInfoVisitor) {
    }

    public void accept(ClassFile classFile, MethodInfo methodInfo, AttrInfoVisitor attrInfoVisitor) {
        attrInfoVisitor.visitExceptionsAttrInfo(classFile, methodInfo, this);
    }

    public void exceptionEntriesAccept(ProgramClassFile programClassFile, CpInfoVisitor cpInfoVisitor) {
        for (int i = 0; i < this.u2numberOfExceptions; ++i) {
            programClassFile.constantPoolEntryAccept(this.u2exceptionIndexTable[i], cpInfoVisitor);
        }
    }
}

