/*
 * Decompiled with CFR 0.152.
 */
package proguard.gui.splash;

import java.awt.Color;
import java.awt.Composite;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.Image;
import java.awt.Paint;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.Shape;
import java.awt.Stroke;
import java.awt.font.FontRenderContext;
import java.awt.font.GlyphVector;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.awt.image.BufferedImageOp;
import java.awt.image.ImageObserver;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderableImage;
import java.text.AttributedCharacterIterator;
import java.util.Map;

class OverrideGraphics2D
extends Graphics2D {
    private Graphics2D graphics;
    private Color overrideColor;
    private Font overrideFont;
    private Paint overridePaint;
    private Stroke overrideStroke;
    private Color overrideXORMode;
    private Color color;
    private Font font;
    private Paint paint;
    private Stroke stroke;

    public OverrideGraphics2D(Graphics2D graphics2D) {
        this.graphics = graphics2D;
        this.color = graphics2D.getColor();
        this.font = graphics2D.getFont();
        this.paint = graphics2D.getPaint();
        this.stroke = graphics2D.getStroke();
    }

    public void setOverrideColor(Color color) {
        this.overrideColor = color;
        this.graphics.setColor(color != null ? color : this.color);
    }

    public void setOverrideFont(Font font) {
        this.overrideFont = font;
        this.graphics.setFont(font != null ? font : this.font);
    }

    public void setOverridePaint(Paint paint) {
        this.overridePaint = paint;
        this.graphics.setPaint(paint != null ? paint : this.paint);
    }

    public void setOverrideStroke(Stroke stroke) {
        this.overrideStroke = stroke;
        this.graphics.setStroke(stroke != null ? stroke : this.stroke);
    }

    public void setOverrideXORMode(Color color) {
        this.overrideXORMode = color;
        if (color != null) {
            this.graphics.setXORMode(color);
        } else {
            this.graphics.setPaintMode();
        }
    }

    public void setColor(Color color) {
        this.color = color;
        if (this.overrideColor == null) {
            this.graphics.setColor(color);
        }
    }

    public void setFont(Font font) {
        this.font = font;
        if (this.overrideFont == null) {
            this.graphics.setFont(font);
        }
    }

    public void setPaint(Paint paint) {
        this.paint = paint;
        if (this.overridePaint == null) {
            this.graphics.setPaint(paint);
        }
    }

    public void setStroke(Stroke stroke) {
        this.stroke = stroke;
        if (this.overrideStroke == null) {
            this.graphics.setStroke(stroke);
        }
    }

    public void setXORMode(Color color) {
        if (this.overrideXORMode == null) {
            this.graphics.setXORMode(color);
        }
    }

    public void setPaintMode() {
        if (this.overrideXORMode == null) {
            this.graphics.setPaintMode();
        }
    }

    public Color getColor() {
        return this.overrideColor != null ? this.color : this.graphics.getColor();
    }

    public Font getFont() {
        return this.overrideFont != null ? this.font : this.graphics.getFont();
    }

    public Paint getPaint() {
        return this.overridePaint != null ? this.paint : this.graphics.getPaint();
    }

    public Stroke getStroke() {
        return this.overrideStroke != null ? this.stroke : this.graphics.getStroke();
    }

    public Graphics create() {
        OverrideGraphics2D overrideGraphics2D = new OverrideGraphics2D((Graphics2D)this.graphics.create());
        overrideGraphics2D.setOverrideColor(this.overrideColor);
        overrideGraphics2D.setOverrideFont(this.overrideFont);
        overrideGraphics2D.setOverridePaint(this.overridePaint);
        overrideGraphics2D.setOverrideStroke(this.overrideStroke);
        return overrideGraphics2D;
    }

    public Graphics create(int n, int n2, int n3, int n4) {
        OverrideGraphics2D overrideGraphics2D = new OverrideGraphics2D((Graphics2D)this.graphics.create(n, n2, n3, n4));
        overrideGraphics2D.setOverrideColor(this.overrideColor);
        overrideGraphics2D.setOverrideFont(this.overrideFont);
        overrideGraphics2D.setOverridePaint(this.overridePaint);
        overrideGraphics2D.setOverrideStroke(this.overrideStroke);
        return overrideGraphics2D;
    }

    public void addRenderingHints(Map map) {
        this.graphics.addRenderingHints(map);
    }

    public void clearRect(int n, int n2, int n3, int n4) {
        this.graphics.clearRect(n, n2, n3, n4);
    }

    public void clip(Shape shape) {
        this.graphics.clip(shape);
    }

    public void clipRect(int n, int n2, int n3, int n4) {
        this.graphics.clipRect(n, n2, n3, n4);
    }

    public void copyArea(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.copyArea(n, n2, n3, n4, n5, n6);
    }

    public void dispose() {
        this.graphics.dispose();
    }

    public void draw(Shape shape) {
        this.graphics.draw(shape);
    }

    public void draw3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.graphics.draw3DRect(n, n2, n3, n4, bl);
    }

    public void drawArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawArc(n, n2, n3, n4, n5, n6);
    }

    public void drawBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        this.graphics.drawBytes(byArray, n, n2, n3, n4);
    }

    public void drawChars(char[] cArray, int n, int n2, int n3, int n4) {
        this.graphics.drawChars(cArray, n, n2, n3, n4);
    }

    public void drawGlyphVector(GlyphVector glyphVector, float f, float f2) {
        this.graphics.drawGlyphVector(glyphVector, f, f2);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, n5, n6, n7, n8, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, int n3, int n4, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, n3, n4, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, Color color, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, color, imageObserver);
    }

    public boolean drawImage(Image image, int n, int n2, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, n, n2, imageObserver);
    }

    public boolean drawImage(Image image, AffineTransform affineTransform, ImageObserver imageObserver) {
        return this.graphics.drawImage(image, affineTransform, imageObserver);
    }

    public void drawImage(BufferedImage bufferedImage, BufferedImageOp bufferedImageOp, int n, int n2) {
        this.graphics.drawImage(bufferedImage, bufferedImageOp, n, n2);
    }

    public void drawLine(int n, int n2, int n3, int n4) {
        this.graphics.drawLine(n, n2, n3, n4);
    }

    public void drawOval(int n, int n2, int n3, int n4) {
        this.graphics.drawOval(n, n2, n3, n4);
    }

    public void drawPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolygon(nArray, nArray2, n);
    }

    public void drawPolygon(Polygon polygon) {
        this.graphics.drawPolygon(polygon);
    }

    public void drawPolyline(int[] nArray, int[] nArray2, int n) {
        this.graphics.drawPolyline(nArray, nArray2, n);
    }

    public void drawRect(int n, int n2, int n3, int n4) {
        this.graphics.drawRect(n, n2, n3, n4);
    }

    public void drawRenderableImage(RenderableImage renderableImage, AffineTransform affineTransform) {
        this.graphics.drawRenderableImage(renderableImage, affineTransform);
    }

    public void drawRenderedImage(RenderedImage renderedImage, AffineTransform affineTransform) {
        this.graphics.drawRenderedImage(renderedImage, affineTransform);
    }

    public void drawRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.drawRoundRect(n, n2, n3, n4, n5, n6);
    }

    public void drawString(String string, float f, float f2) {
        this.graphics.drawString(string, f, f2);
    }

    public void drawString(String string, int n, int n2) {
        this.graphics.drawString(string, n, n2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, float f, float f2) {
        this.graphics.drawString(attributedCharacterIterator, f, f2);
    }

    public void drawString(AttributedCharacterIterator attributedCharacterIterator, int n, int n2) {
        this.graphics.drawString(attributedCharacterIterator, n, n2);
    }

    public boolean equals(Object object) {
        return this.graphics.equals(object);
    }

    public void fill(Shape shape) {
        this.graphics.fill(shape);
    }

    public void fill3DRect(int n, int n2, int n3, int n4, boolean bl) {
        this.graphics.fill3DRect(n, n2, n3, n4, bl);
    }

    public void fillArc(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillArc(n, n2, n3, n4, n5, n6);
    }

    public void fillOval(int n, int n2, int n3, int n4) {
        this.graphics.fillOval(n, n2, n3, n4);
    }

    public void fillPolygon(int[] nArray, int[] nArray2, int n) {
        this.graphics.fillPolygon(nArray, nArray2, n);
    }

    public void fillPolygon(Polygon polygon) {
        this.graphics.fillPolygon(polygon);
    }

    public void fillRect(int n, int n2, int n3, int n4) {
        this.graphics.fillRect(n, n2, n3, n4);
    }

    public void fillRoundRect(int n, int n2, int n3, int n4, int n5, int n6) {
        this.graphics.fillRoundRect(n, n2, n3, n4, n5, n6);
    }

    public Color getBackground() {
        return this.graphics.getBackground();
    }

    public Shape getClip() {
        return this.graphics.getClip();
    }

    public Rectangle getClipBounds() {
        return this.graphics.getClipBounds();
    }

    public Rectangle getClipBounds(Rectangle rectangle) {
        return this.graphics.getClipBounds(rectangle);
    }

    public Rectangle getClipRect() {
        return this.graphics.getClipRect();
    }

    public Composite getComposite() {
        return this.graphics.getComposite();
    }

    public GraphicsConfiguration getDeviceConfiguration() {
        return this.graphics.getDeviceConfiguration();
    }

    public FontMetrics getFontMetrics() {
        return this.graphics.getFontMetrics();
    }

    public FontMetrics getFontMetrics(Font font) {
        return this.graphics.getFontMetrics(font);
    }

    public FontRenderContext getFontRenderContext() {
        return this.graphics.getFontRenderContext();
    }

    public Object getRenderingHint(RenderingHints.Key key) {
        return this.graphics.getRenderingHint(key);
    }

    public RenderingHints getRenderingHints() {
        return this.graphics.getRenderingHints();
    }

    public AffineTransform getTransform() {
        return this.graphics.getTransform();
    }

    public int hashCode() {
        return this.graphics.hashCode();
    }

    public boolean hit(Rectangle rectangle, Shape shape, boolean bl) {
        return this.graphics.hit(rectangle, shape, bl);
    }

    public boolean hitClip(int n, int n2, int n3, int n4) {
        return this.graphics.hitClip(n, n2, n3, n4);
    }

    public void rotate(double d) {
        this.graphics.rotate(d);
    }

    public void rotate(double d, double d2, double d3) {
        this.graphics.rotate(d, d2, d3);
    }

    public void scale(double d, double d2) {
        this.graphics.scale(d, d2);
    }

    public void setBackground(Color color) {
        this.graphics.setBackground(color);
    }

    public void setClip(int n, int n2, int n3, int n4) {
        this.graphics.setClip(n, n2, n3, n4);
    }

    public void setClip(Shape shape) {
        this.graphics.setClip(shape);
    }

    public void setComposite(Composite composite) {
        this.graphics.setComposite(composite);
    }

    public void setRenderingHint(RenderingHints.Key key, Object object) {
        this.graphics.setRenderingHint(key, object);
    }

    public void setRenderingHints(Map map) {
        this.graphics.setRenderingHints(map);
    }

    public void setTransform(AffineTransform affineTransform) {
        this.graphics.setTransform(affineTransform);
    }

    public void shear(double d, double d2) {
        this.graphics.shear(d, d2);
    }

    public String toString() {
        return this.graphics.toString();
    }

    public void transform(AffineTransform affineTransform) {
        this.graphics.transform(affineTransform);
    }

    public void translate(double d, double d2) {
        this.graphics.translate(d, d2);
    }

    public void translate(int n, int n2) {
        this.graphics.translate(n, n2);
    }
}

