/*
 * GormWizardPanel.m
 *
 * Implementation of the GormWizardPanel class for the
 * WizardPalette palette
 *
 * Copyright (c) 2006, by Saso Kiselkov
 *
 * For license details please see the file COPYING included with this
 * source distribution package.
 */

#import "GormWizardPanel.h"

#import <Foundation/NSString.h>

#import <AppKit/NSImage.h>
#import <GNUstepGUI/GSNibTemplates.h>

#import "WizardPalette.h"

@interface WKWizardPanel (GormAllocation)

+ (id) alloc;

@end

@implementation WKWizardPanel (GormAllocation)

+ (id) alloc
{
  if (self == [WKWizardPanel class])
    {
      return [GormWizardPanel alloc];
    }
  else
    {
      return [super alloc];
    }
}

@end

@implementation GormWizardPanel

static NSImage * image = nil;

+ (BOOL) canSubstituteForClass: (Class) origClass
{
  return NO;
}

- (id) initWithContentRect: (NSRect)contentRect
                 styleMask: (unsigned int)aStyle
                   backing: (NSBackingStoreType)bufferingType
                     defer: (BOOL)flag
                    screen: (NSScreen*)aScreen
{
  wizardStyleMask = aStyle;
  aStyle = NSTitledWindowMask | NSClosableWindowMask | NSResizableWindowMask;
  autoPositionMask = GSWindowMaxXMargin | GSWindowMaxYMargin;

  return [super initWithContentRect: contentRect
                          styleMask: aStyle
                            backing: bufferingType
                              defer: flag
                             screen: aScreen];
}

- (NSImage *) imageForViewer
{
  if (image == nil)
    {
      image = [[NSImage alloc] initByReferencingFile: [[NSBundle
        bundleForClass: [WizardPalette class]]
        pathForResource: @"WizardPalette" ofType: @"tiff"]];
    }

  return image;
}

- (NSString *) objectNameForInspectorTitle
{
  return @"Wizard Panel";
}

- (NSString*) inspectorClassName
{
  return @"WizardPanelInspector";
}

- (NSString *) sizeInspectorClassName
{
  return @"GormWizardPanelSizeInspector";
}

- (NSString *) className
{
  return @"WKWizardPanel";
}

- (void) setStyleMask: (unsigned int) aMask
{
  wizardStyleMask = aMask;
}

- (unsigned int) styleMask
{
  return wizardStyleMask;
}

- (unsigned int) autoPositionMask
{
  return autoPositionMask;
}

- (void) setAutoPositionMask: (unsigned int)mask
{
  autoPositionMask = mask;
}

- (void) encodeWithCoder: (NSCoder *) aCoder
{
  unsigned int savedMask;

  savedMask = _styleMask;

  _styleMask = wizardStyleMask;
  [super encodeWithCoder: aCoder];
  _styleMask = savedMask;
}

@end
