/***************************************************************************
                          gui_playlist.h  -  description
                             -------------------
    begin                : Thu Mar 7 2002
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de

    This file contributed by Tim Lee ;)
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef GUI_PLAYLIST_H
#define GUI_PLAYLIST_H

#include "prokyon.h"
#include "configuration.h"

#include "lvi_playlist.h"
#include "lvi_playlisttrack.h"
#include "progressdialogscroll.h"

#ifdef HAVE_MEXTRAS
#include "job_callmusicextras.h"
#endif /* HAVE_MEXTRAS */

#include <qframe.h>
#include <qlabel.h>
#include <qlineedit.h>
#include <qcombobox.h>
#include <qpushbutton.h>
#include <qptrlist.h>
#include <qlistview.h>
#include <qtabwidget.h>
#include <qspinbox.h>
#include <qcombobox.h>
#include <qcheckbox.h>
#include <qsplitter.h>
#include <qevent.h>
#include <qiconview.h>
#include <qtextedit.h>
#include <qpixmap.h>
#include <qevent.h>
#include <qdialog.h>
#include <qlayout.h>
#include <qsize.h>
#include <qtabwidget.h>
#include <qnetworkprotocol.h>

class GUI_Playlist : public QTabWidget  {
  Q_OBJECT
 public: 
  GUI_Playlist(QWidget *parent, const char *name=0);
  
  ~GUI_Playlist();

#ifdef HAVE_MIXXX
  void setMixxxConnectionState(bool state);
#endif /* HAVE_MIXXX */
  
#ifdef HAVE_MEXTRAS
  void setArtistPixmap(const QIDPixmap &);
  void setCoverPixmap(const QIDPixmap &);
  void setLyrics(const QString &);
  void setYearsActive(const QString &);
  void setAlbumReview(const QString &);
  void setAlbumTracks(const QString &);
  void setBiography(const QString &);
  void setArtist(const QString &);
  void setAlbum(const QString &);
  void setTitle(const QString &);
#endif /* HAVE_MEXTRAS */
  
  void notifyNewPlaylistBasis(QList<PLAYLIST> *play_list);
  void notifyNewPlaylistTracksBasis(QList<PLAYLIST_TRACK> *tracks_list, int playlistID);
  void notifyNewPlaylist(PLAYLIST *playlist, bool isNewCreated=false);
  void notifyNewPlaylistTrack(PLAYLIST_TRACK *pl_track, int playlistID);

  void notifyRemovePlaylist(LVI_Playlist *playlist);
  void notifyRemovePlaylistTracks(QList<TRACK> *list, int playlistID);
  void notifyRemovePlaylistTracks(QList<LVI_PlaylistTrack> *pl_track_list);

  void notifyRenamePlaylist(LVI_Playlist *playlist, QString newname);
  void notifyMovePlaylistTrack();

  void notifyNewMediumBasis(QList<MEDIUM> *list);
  void notifyNewMedium(MEDIUM *medium);
  void notifyMediumRemoved(int id);
  void notifyMediumAvailabilityChanged(int mediumID, QString path, bool avail);
#ifdef HAVE_MEXTRAS
  void notifyNewExtraData(EXTRADATA_GUI *);
  void clear_IconView();
#endif /* HAVE_MEXTRAS */
  
  void clear();

  int getDisplayedPlaylistID();

  QListView*   getTracklist()   { return tracklist; }
  QSplitter*   getVsplit()   { return vsplit; }
  QListView*   getPlaylist_list()   { return playlist_list; }
#ifdef HAVE_MEXTRAS
  QSplitter*   getExtrasSplit()   { return extrasSplit; }

  QTextEdit *mexlog;
#endif /* HAVE_MEXTRAS */

 public slots:
  void slot_setConnectionState(bool state);

 protected:
  void customEvent ( QCustomEvent *e );
  void callRegularPlayerWithPlaylist(bool enqueue);
  void callRegularPlayerWithTracks(bool enqueue);
  QStringList getSelectedFileList();
  QString getCurrentFile();

 private:
  QListView *tracklist;
  QListView *current_tracklist;
  QListView *playlist_list;

  QList<QListViewItem> selectedItems;

  QPushButton *buttonNew, *buttonImport;
  QPushButton *buttonMoveUp, *buttonMoveDown;
  QPushButton *buttonAbortRefreshFromInternet;
  QSpinBox *generatorSpinTracks;
  QSpinBox *generatorSpinMinTrackLength;
  QSpinBox *generatorSpinMaxTrackLength;
  QSpinBox *generatorSpinRating;
  QComboBox *generatorComboArtists;
  QCheckBox *generatorCheckBoxOnlyFavouriteArtists;
  QCheckBox *generatorCheckBoxOnlyHarddisk; 
  QFrame *pl_selframe;
  QFrame *tabGenerator;
#ifdef HAVE_MEXTRAS
  QTabWidget *tabmex;

  QFrame *extrasFrame;
#endif /* HAVE_MEXTRAS */

  QLabel *pl_tracks;
  QLabel *pl_time;
  QLabel *pl_size;
  
#ifdef HAVE_MEXTRAS
  QLabel *artistValueLyrics;
  QLabel *titleValueLyrics;
  QLabel *artistValueReview;
  QLabel *artistValueTracks;
  QLabel *albumValueReview;
  QLabel *albumValueTracks;
  QLabel *artistValueBiography;
  QLabel *yearsActiveValueBiography;
  
  QIconView *images;
  QTextEdit *lyrics;
  QTextEdit *review;
  QTextEdit *tracks;
  QTextEdit *biography;
  
  QIconViewItem *coverIconViewItem;
  QIconViewItem *artistIconViewItem;

  QSplitter *extrasSplit;
#endif /* HAVE_MEXTRAS */

  LVI_Playlist *displayed_playlist;

  QMap<int, LVI_PlaylistTrack*> mapCurrent;
  QMap<int, LVI_PlaylistTrack*> mapEditor;

  QMap<int, bool> mapAvail;
  QMap<int, int> mapType;
  QMap<int, QString> mapPath;

  void adjustPlaylistStatistics();
  void resetPlaylistStatistics();
  
  bool isConnected;
#ifdef HAVE_MIXXX
  bool isMixxxConnected;
  void mixxxLoadAtChannel(int channel);
  void mixxxLoadAndPlayAtChannel(int channel);
  void mixxxEnqueueTracksAtChannel(int channel);
  void enqueuePlaylistAtChannel(int channel);
#endif /* HAVE_MIXXX */
  void burnK3bCD(QString type);
  void getSelectedItems(bool current);
  bool existsPlaylist(const QString &s);

  QSplitter *vsplit;

  bool firsttime;
  
#ifdef HAVE_MEXTRAS
  Job_CallMusicextras *jobmusicextras;
  long last_coverID,last_artistID,last_bkgID;
#endif /* HAVE_MEXTRAS */

  ProgressDialogScroll *copyFilesProgressDialogScroll;
  bool fileCopyInProgress;
  int numberOfFilesToCopy;
  
 private slots:
  
  void slot_newButton();
  void slot_importPlaylist();
  
  void slot_refreshFromInternetButton();
  void slot_abortRefreshFromInternetButton();

  void slot_generateButton();
  void slot_resetButton();
  void slot_generatorMinTrackLength(int);
  void slot_generatorMaxTrackLength(int);

  
  void slot_movePlaylistTrackUp();
  void slot_movePlaylistTrackDown();
  void slot_savePlaylistTracks();
  void slot_menuPlaylistToSelection();

  void slot_contextMenu(QListViewItem *, const QPoint &, int);
  void slot_menuAddPlaylistToCurrent();
  void slot_menuRemovePlaylistTracks();

  void slot_menuPlayPlaylist();
  void slot_menuEnqueuePlaylist();
  void slot_menuBurnCD();
  void slot_menuBurnK3bAudioCD();
  void slot_menuBurnK3bDataCD();
  void slot_menuBurnK3bDataDVD();
  void slot_menuExport();
  void slot_menuCopyFiles();
  
  void slot_menuRemovePlaylist();
  void slot_menuRenamePlaylist();
  
  void slot_menuPlayPlaylistTracks();
  void slot_menuEnqueuePlaylistTracks();
  void slot_mixxxLoadAtChannel1();
  void slot_mixxxLoadAtChannel2();
  void slot_mixxxLoadAndPlayAtChannel1();
  void slot_mixxxLoadAndPlayAtChannel2();
  void slot_mixxxEnqueueTracksAtChannel1();
  void slot_mixxxEnqueueTracksAtChannel2();
  void slot_menuEnqueuePlaylistAtChannel1();
  void slot_menuEnqueuePlaylistAtChannel2();
  
  void slot_playlistSelectionChanged(QListViewItem *);
  void slot_trackSelectionChanged();

  void slot_tabChange(QWidget *);

  void slot_playlistDoubleClicked(QListViewItem *lvi);
  void slot_playlistTrackDoubleClicked(QListViewItem *lvi);

  void slot_ClickLyrics();
  void slot_ClickReview();
  void slot_ClickTracks();
  void slot_ClickBiography();
  void slot_ClickMexlog();
  
  void slot_startedNextCopy(const QPtrList<QNetworkOperation> &lst);
  
};

class ExtendedDropListView : public QListView {
 public: 
  ExtendedDropListView(QWidget *parent=0, const char *name=0);
  
 protected:
  void dragEnterEvent(QDragEnterEvent* event);
  void dropEvent(QDropEvent* event);
};

#endif
