/***************************************************************************
                          jobmanager.h  -  description
                             -------------------
    begin                : Thu May 3 2001
    copyright            : (C) 2001 by Holger Sattel
    email                : hsattel@rumms.uni-mannheim.de
 ***************************************************************************/

/***************************************************************************
 *                                                                         *
 *   This program is free software; you can redistribute it and/or modify  *
 *   it under the terms of the GNU General Public License as published by  *
 *   the Free Software Foundation; either version 2 of the License, or     *
 *   (at your option) any later version.                                   *
 *                                                                         *
 ***************************************************************************/

#ifndef JOBMANAGER_H
#define JOBMANAGER_H

#include "jobbase.h"
#include "prokyon.h"

#include <qthread.h>
#include <qptrlist.h>
#include <qptrqueue.h>
#include <qmap.h>

class JobManager {
 public: 
  JobManager();
	
  void addJob(JobBase *job, bool dequeuedMusicextrasJob = false);	

  void jobDone(JobBase *job);

  void incrJobCounter();
  void decrJobCounter();
  int getNumberOfJobsRunning();
  
  void lock()		{ mutex.lock(); }
  void unlock()	{ mutex.unlock(); }
  void setjob_mextras_max( int value)  { job_mextras_max = value; }
  
  bool terminateJob(JobBase *job);
#ifdef HAVE_MEXTRAS
  void terminateMusicextrasJob();
#endif /* HAVE_MEXTRAS */

  ~JobManager();

 private:
  void deleteFinishedJobs();
	
  bool job_connect_isRunning;
  bool job_disconnect_isRunning;
  bool job_connectMixxx_isRunning;
  bool job_disconnectMixxx_isRunning;
  bool job_query_isRunning;
  bool job_modify_isRunning;
  bool job_generate_isRunning;
  bool job_extradata_isRunning;
  int  job_mextras_Running;
  bool job_playalbum_isRunning;
  bool job_importplaylist_isRunning;
  
  QMap<int, bool>   job_synchronize_isRunning;
  QPtrQueue<JobBase> job_mextras_queue;
  QPtrList<JobBase> jobList;

  int  job_mextras_max;
  int  jobCounter;
	
  QMutex	    mutex;
};

#endif
