/*
 **************************************************************************
 *
 * Boot-ROM-Code to load an operating system across a TCP/IP network.
 *
 * Module:  arpa.h
 * Purpose: Header file for the higher internet protocols
 * Entries: none
 *
 **************************************************************************
 *
 * Copyright (C) 1995-1998 Gero Kuhlmann <gero@gkminix.han.de>
 *
 *  This program is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2 of the License, or
 *  any later version.
 *
 *  This program is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *
 *  You should have received a copy of the GNU General Public License
 *  along with this program; if not, write to the Free Software
 *  Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.
 */


/*
 **************************************************************************
 *
 * Tag values for RFC1048 vendor fields:
 */
#define VEND_NOP	0		/* NOP				*/
#define VEND_SUBNET	1		/* Subnet mask			*/
#define VEND_TOFFS	2		/* Time offset			*/
#define VEND_ROUTER	3		/* Router IP address list	*/
#define VEND_TIMES	4		/* Time server IP address	*/
#define VEND_NAMES	5		/* Name server IP address	*/
#define VEND_DNS	6		/* Domain name server IP addr	*/
#define VEND_LOGS	7		/* Log server IP address	*/
#define VEND_COOKIES	8		/* Cookie server IP address	*/
#define VEND_LPRS	9		/* LPR server IP address	*/
#define VEND_IMPRESS	10		/* IMPRESS server IP address	*/
#define VEND_RESOURCES	11		/* Resource location server IP	*/
#define VEND_HNAME	12		/* Client host name		*/
#define VEND_BFSIZE	13		/* Boot file size		*/
#define VEND_DUMPFILE	14		/* Merrit Dump file name	*/
#define VEND_DOMAIN	15		/* Client domain name		*/
#define VEND_SWAPS	16		/* Swap server IP address	*/
#define VEND_ROOTPATH	17		/* Root file system path name	*/
#define VEND_EXTFILE	18		/* Extensions file name		*/
#define VEND_END	255		/* End of option list		*/



/*
 **************************************************************************
 *
 * Size of one TFTP data segment
 */
#define SEGSIZE		512



/*
 **************************************************************************
 *
 * BOOTP packet:
 */
#define BOOTP_CHADDR_SIZE	16	/* size of chaddr field		*/
#define BOOTP_SNAME_SIZE	64	/* size of sname field		*/
#define BOOTP_FILE_SIZE		128	/* size of filename field	*/
#define BOOTP_VENDOR_SIZE	64	/* size of vendor area		*/
#define BOOTP_EXT_SIZE		2048	/* max size of tag extensions	*/

struct bootp
{
	unsigned char  bp_op;		/* BOOTP op code		*/
	unsigned char  bp_hwtype;	/* hardware type		*/
	unsigned char  bp_hlen;		/* length of hardware address	*/
	unsigned char  bp_hops;		/* hop-number, only used by gw	*/
	unsigned long  bp_xid;		/* transaction ID		*/
	unsigned short bp_secs;		/* time since client booted	*/
	unsigned short bp_unused;	/* unused			*/
	t_ipaddr       bp_ciaddr;	/* client IP address		*/
	t_ipaddr       bp_yiaddr;	/* your (client) IP address	*/
	t_ipaddr       bp_siaddr;	/* server IP address		*/
	t_ipaddr       bp_giaddr;	/* BOOTP gateway IP address	*/
					/* client hardware address	*/
	unsigned char  bp_chaddr[BOOTP_CHADDR_SIZE];
					/* server host name		*/
	unsigned char  bp_sname[BOOTP_SNAME_SIZE];
					/* boot file name		*/
	unsigned char  bp_file[BOOTP_FILE_SIZE];
					/* optional vendor information	*/
	unsigned char  bp_vend[BOOTP_VENDOR_SIZE];
					/* optional vendor extensions	*/
	unsigned char  bp_ext[BOOTP_EXT_SIZE];
};

extern struct bootp boot_rec;		/* current BOOTP record		*/



/*
 **************************************************************************
 *
 * Public routines of the internet protocols library:
 */

/* Get a BOOTP record from server */
extern int bootp(void);

#if 0
/* Get a vendor tag from a BOOTP record */
extern unsigned char *get_vend __P((int id));
#endif

/* Open a TFTP read connection */
extern char *tftp_open __P((t_ipaddr server, unsigned char *fname, int fnamlen));

/* Get next block */
extern int tftp_get __P((void));

#if 0
/* Initialize domain name resolver */
extern void res_config __P((void));

/* Resolve a host name */
extern t_ipaddr resolve __P((char *name));
#endif
