#ifndef __PS2EDEFS_H__
#define __PS2EDEFS_H__

/*
 *  PS2E Definitions v0.1.2 (beta)
 *
 *  Author: linuzappz@pcsx.net
 */

/*
 Notes: 
 * Since this is still beta things may change.

 * OSflags:
	__LINUX__ (linux OS)
	__WIN32__ (win32 OS)

 * common return values (for ie. GSinit):
	 0 - success
	-1 - error

 * reserved keys:
	F1 to F10 are reserved for the emulator

 * plugins should NOT change the current 
   working directory.
   (on win32, add flag OFN_NOCHANGEDIR for
    GetOpenFileName)

*/

#include "PS2Etypes.h"

#ifdef __LINUX__
#define CALLBACK
#endif

/* common defines */

// PS2EgetLibType returns 
#define PS2E_LT_GS	0x1
#define PS2E_LT_PAD	0x2

#if defined(GSdefs) || defined(PADdefs)

u32   CALLBACK PS2EgetLibType(void);
u32   CALLBACK PS2EgetLibVersion(void);
char* CALLBACK PS2EgetLibName(void);

#endif

// key values:
/* key values must be OS dependant:
	win32: the VK_XXX will be used (WinUser)
	linux: the XK_XXX will be used (XFree86)
*/

// event values:
#define KEYPRESS	1
#define KEYRELEASE	2

typedef struct {
	u32 key;
	u32 event;
} keyEvent;

/*
 * Button info
 */
typedef struct {
    unsigned char ok;
    unsigned char mode;
    unsigned char btns[2];
    // joysticks
    unsigned char rjoy_h;
    unsigned char rjoy_v;
    unsigned char ljoy_h;
    unsigned char ljoy_v;
    // pressure mode
    unsigned char left_p;
    unsigned char rigth_p;
    unsigned char up_p;
    unsigned char down_p;
    unsigned char triangle_p;
    unsigned char circle_p;
    unsigned char square_p;
    unsigned char cross_p;
    unsigned char unkn16[16];
}  padButtonStatus;


/* GS plugin API */

// if this file is included with this define
// the next api will not be skipped by the compiler
#ifdef GSdefs

// basic funcs

s32  CALLBACK GSinit();
s32  CALLBACK GSopen(void *pDsp, char *Title);
void CALLBACK GSclose();
void CALLBACK GSshutdown();
void CALLBACK GSvsync();
void CALLBACK GSdmaGIF(u32 *dmaAddr, char *pRam);
void CALLBACK GSwrite32(u32 mem, u32 value);
void CALLBACK GSwrite64(u32 mem, u64 value);
u32 CALLBACK GSread32(u32 mem);
u64 CALLBACK GSread64(u32 mem);

// extended funcs

// GSkeyEvent gets called when there is an keyEvent from the PAD plugin
void CALLBACK GSkeyEvent(keyEvent *ev);
void CALLBACK GSmakeSnapshot();
void CALLBACK GSconfigure();
void CALLBACK GSabout();
s32  CALLBACK GStest();

#endif

/* PAD plugin API */

// if this file is included with this define
// the next api will not be skipped by the compiler
#ifdef PADdefs

// basic funcs

s32  CALLBACK PADinit(u32 flags);
s32  CALLBACK PADopen(void *pDsp);
void CALLBACK PADclose();
void CALLBACK PADshutdown();
// PADkeyEvent is called every vsync (return NULL if no event)
keyEvent* CALLBACK PADkeyEvent();
// pad 1 or 2
void CALLBACK PADreadStatus(padButtonStatus *stat, int pad);
// returns: 1 if supported pad1
//			2 if supported pad2
//			3 if both are supported
u32  CALLBACK PADquery();

// extended funcs

void CALLBACK PADconfigure();
void CALLBACK PADabout();
s32  CALLBACK PADtest();

#endif

// might be useful for emulators
#ifdef PLUGINtypedefs

typedef u32  (CALLBACK* _PS2EgetLibType)(void);
typedef u32  (CALLBACK* _PS2EgetLibVersion)(void);
typedef char*(CALLBACK* _PS2EgetLibName)(void);

// GS
typedef s32  (CALLBACK* _GSinit)();
typedef s32  (CALLBACK* _GSopen)(void *pDsp, char *Title);
typedef void (CALLBACK* _GSclose)();
typedef void (CALLBACK* _GSshutdown)();
typedef void (CALLBACK* _GSvsync)();
typedef void (CALLBACK* _GSwrite32)(u32 mem, u32 value);
typedef void (CALLBACK* _GSwrite64)(u32 mem, u64 value);
typedef u32  (CALLBACK* _GSread32)(u32 mem);
typedef u64  (CALLBACK* _GSread64)(u32 mem);
typedef void (CALLBACK* _GSdmaGIF)(u32 *dmaAddr, s8 *pRam);
typedef void (CALLBACK* _GSkeyEvent)(keyEvent* ev);

typedef void (CALLBACK* _GSmakeSnapshot)();
typedef void (CALLBACK* _GSconfigure)();
typedef s32  (CALLBACK* _GStest)();
typedef void (CALLBACK* _GSabout)();

// PAD
typedef s32  (CALLBACK* _PADinit)(u32 flags);
typedef s32  (CALLBACK* _PADopen)(void *pDsp);
typedef void (CALLBACK* _PADclose)();
typedef void (CALLBACK* _PADshutdown)();
typedef keyEvent* (CALLBACK* _PADkeyEvent)();
typedef void (CALLBACK* _PADreadStatus)(padButtonStatus *data, int pad);
typedef u32  (CALLBACK* _PADquery)();

typedef void (CALLBACK* _PADconfigure)();
typedef s32  (CALLBACK* _PADtest)();
typedef void (CALLBACK* _PADabout)();

#endif

#ifdef PLUGINfuncs

// GS
_GSinit         GSinit;
_GSopen         GSopen;
_GSclose        GSclose;
_GSshutdown     GSshutdown;
_GSvsync        GSvsync;
_GSwrite32      GSwrite32;
_GSwrite64      GSwrite64;
_GSread32       GSread32;
_GSread64       GSread64;
_GSdmaGIF       GSdmaGIF;

_GSkeyEvent     GSkeyEvent;
_GSmakeSnapshot	GSmakeSnapshot;
_GSconfigure    GSconfigure;
_GStest         GStest;
_GSabout        GSabout;

// PAD1
_PADinit        PAD1init;
_PADopen        PAD1open;
_PADclose       PAD1close;
_PADshutdown    PAD1shutdown;
_PADkeyEvent    PAD1keyEvent;
_PADreadStatus  PAD1readStatus;
_PADquery       PAD1query;

_PADconfigure   PAD1configure;
_PADtest        PAD1test;
_PADabout       PAD1about;

// PAD2
_PADinit        PAD2init;
_PADopen        PAD2open;
_PADclose       PAD2close;
_PADshutdown    PAD2shutdown;
_PADkeyEvent    PAD2keyEvent;
_PADreadStatus  PAD2readStatus;
_PADquery       PAD2query;

_PADconfigure   PAD2configure;
_PADtest        PAD2test;
_PADabout       PAD2about;

#endif

#endif /* __PS2EDEFS_H__ */
