# -*- perl -*-
# Copyright (c) 2000, FundsXpress Financial Network, Inc.
# This library is free software released "AS IS WITH ALL FAULTS"
# and WITHOUT ANY WARRANTIES under the terms of the GNU Lesser
# General Public License, Version 2.1, a copy of which can be
# found in the "COPYING" file of this distribution.

# $Id: fieldspace.t,v 1.2 2000/12/03 15:18:46 muaddib Exp $

use strict;
use Test;
use Data::Dumper;
use CGI;
use HTMLIO::Text;
use AtomicData::List;
use AtomicData::Text;

plan tests => 1;

my ($fs,$cgi,$field);

ok $cgi = CGI->new("test_field=blah&gtest_field:5=hi");
#ok $cgi = CGI->new();

while (1)
{
 ok $fs = main::test_fieldspace->new();

 ok $fs->field_def('test_field' => {
     'type'      => 'HTMLIO::Text',
     'data'      => 'AtomicData::Text',
     'container' => 'AtomicData::List',
     'setup_sub' => 'main::test_field_setup',
     'blank_ok'  => '0',
     'group'     => undef,
     'value'     => 'undef'
 });
 ok $fs->field_def('gtest_field' => {
     'type'      => 'HTMLIO::Text',
     'data'      => 'AtomicData::Text',
     'container' => 'AtomicData::List',
     'setup_sub' => 'main::test_group::gtest_field_setup',
     'blank_ok'  => '0',
     'group'     => 'test_group',
     'value'     => 'undef'
 });
 ok $fs->group_def('test_group' => {
	name		=> 'test_group',
	grpvar		=> '$group',
	objvar		=> '$obj',
	numvar		=> '$i',
	number		=> 10,
	maxnum		=> 0,
	field_names	=> [qw(gtest_field)],
	package		=> 'main::test_group',
	dummy_ok	=> 0,
	setup_sub	=> 'main::test_group::setup'
 });

 ok defined $fs->initialize($cgi,'main');

 #$field = $fs->get_field("test_field");

 #print $fs->dumper();exit;
 $fs->free_internals();
}

sub main::test_field_setup {
  my ($fs,$field) = @_;
}

package main::test_fieldspace;
use PSP::FieldSpace;
use vars qw(@ISA);
BEGIN { @ISA = qw(PSP::FieldSpace); }

sub setup {
}

package main::test_group;
use PSP::FieldSpace::Group;
use vars qw(@ISA);
BEGIN { @ISA = qw(PSP::FieldSpace::Group); }

sub setup {
  my ($fs,$cgi) = @_; 
}

sub gtest_field_setup {
  my ($fs,$field) = @_;
}
1;
