#!/usr/bin/python
# setup.py
#
#  $Id: setup.py 95 2004-12-11 20:50:34Z henning $

from distutils.core import setup
import pycocumalib.__version__
import sys

if sys.platform == "win32":
    try:
        import py2exe
    except:
        print "INFO: py2exe not found."

class Win32Target:
   def __init__(self, **kw):
       self.__dict__.update(kw)
       self.version = pycocumalib.__version__.__version__.replace("-", ".")
       self.company_name = "Henning Jacobs"
       self.copyright = "(c)2004 Henning Jacobs"
       self.name = "PyCoCuMa"

setup(name="PyCoCuMa",
    version = pycocumalib.__version__.__version__,
    description = "Pythonic Contact and Customer Management",
    long_description =
"""PyCoCuMa (Pythonic Contact and Customer Management) provides an personal
information system for addresses, telephone numbers and other data associated
with personal contacts (also supports photographic pictures).

PyCoCuMa is purely written in Python with a Tk graphical interface.  PyCoCuMa
is based on an XML-RPC client-server architecture. The server stores it's data
in compatible vCard (ver. 3.0) files (*.vcf) which can be read by all modern
address programs (Evolution, KAddressbook, Outlook, GnomeCard, etc).""",
    author = "Henning Jacobs",
    author_email = "henning@srcco.de",
    url = "http://www.srcco.de",
    scripts = ["pycocuma","pycocuma-server"],
    packages = ["pycocumalib"],
    classifiers = ["Development Status :: 3 - Alpha",
	"Environment :: Win32 (MS Windows)",
	"Environment :: X11 Applications",
	"Intended Audience :: End Users/Desktop",
	"License :: OSI Approved :: GNU General Public License (GPL)",
	"Natural Language :: English",
	"Operating System :: Microsoft :: Windows :: Windows 95/98/2000",
	"Operating System :: Microsoft :: Windows :: Windows NT/2000",
	"Operating System :: POSIX",
	"Operating System :: Unix",
	"Programming Language :: Python",
	"Topic :: Office/Business"],
    # for py2exe:
    windows = [Win32Target(script = "pycocuma.pyw",
        icon_resources=[(1, "pycocuma.ico")])],
    zipfile = "pycocumalib.zip",
    options = {"py2exe": 
        {"compressed": 1,
         "optimize": 2,
         "dist_dir": "dist/win32",
         "includes": "JpegImagePlugin,PngImagePlugin,BmpImagePlugin,GifImagePlugin"}},
    )

