## hostsparser.py
## 
## Copyright (C) 2006 Mykola Lynnyk <pydefiner@gmail.com>
##
## This program is free software; you can redistribute it and/or modify
## it under the terms of the GNU General Public License as published
## by the Free Software Foundation; version 2 only.
##
## This program is distributed in the hope that it will be useful,
## but WITHOUT ANY WARRANTY; without even the implied warranty of
## MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
## GNU General Public License for more details.
##

import os
import string
from os import system, environ, path, getenv, mkdir, getcwd

separator = ":"

class HostsParser:
    #
    # Remove unuseful spaces
    #
    def unpad(self, str):
        if str == '':
            return str
        else:            
            splitted = str.split(" ")
            non_empty_list = []
            for sym in splitted:
                if sym == '':
                    pass
                else:
                    non_empty_list.append(sym)
            unpadded_line = string.join(non_empty_list)
            return unpadded_line
    
    #
    # Find netbios and ip from specified display name
    #
    def find(self, display_name):
        for item in self.hostslist:
            if item["display"] == display_name:
                return item
        return None

    #
    # Find display and ip from specified netbios name
    #
    def find_by_name(self, netbios_name):
        for item in self.hostslist:
            if string.upper(item["netbios"]) == string.upper(netbios_name):
                return item
        return None
    
    #
    # Find display and netbios from specified ip name
    #
    def find_by_ip(self, ip_name):
        for item in self.hostslist:
            if (item["ip"] == ip_name):
                return item
        return None

    #
    # Update existing list item
    #
    def update(self, old_display_name, display_name, netbios_name, ip_name):
        i = 0
        for item in self.hostslist:
            if (item["display"] == old_display_name):
                break
            i = i + 1
        self.hostslist[i]["display"] = display_name
        self.hostslist[i]["ip"] = ip_name
        self.hostslist[i]["netbios"] = netbios_name
        self.write(self.hostslist)
    #
    # Add new host to the list
    #
    def add(self, display_name, netbios_name, ip_name):
        dict = {}
        dict["display"] = display_name
        dict["netbios"] = netbios_name
        dict["ip"] = ip_name
        self.hostslist.append(dict)
        self.write(self.hostslist)
    
    #
    # Remove host from the list
    #
    def remove(self, display_name):
        item = self.find(display_name)
        self.hostslist.remove(item)
        self.write(self.hostslist)

    #
    # Parse hostslist file
    #
    def read(self):
        self.hostslist = []
        try:
            fd = open(self.filename)
        except:
            print "error: no such file or directory - %s" % self.filename
            if os.path.exists(self.filename):
                #we talk about a file
                print "error: cannot open %s for reading" % self.filename
            return

        for line in fd.readlines():
            try:
                line = line.decode('utf-8')
            except UnicodeDecodeError:
                line = line.decode(locale.getpreferredencoding())
            dict = {}
            index = line.find(separator)
            index_fin = line.rfind(separator)

            dict["display"] = line[0:index]
            dict["netbios"] = line[index + 1:index_fin]
            dict["ip"] = line[index_fin + 1:-1]
            
            self.hostslist.append(dict)
        fd.close()
    
    #
    # Write configuration file
    #
    def write(self, list):
        #
        # Clear the options file
        #
        fd = open(self.filename, 'w')
        fd.close()

        fd = open(self.filename, 'a')

        for item in list:
            fd.write(item["display"] + separator + item["netbios"] + separator + item["ip"] + "\n")

        fd.close()
        self.read()
        return

    def __init__(self, filename):
        self.filename = filename
        self.hostslist = []
        
        #
        # Check if the configuartion file exists. If no, 
        # create it with default values
        #
        try: 
            fd = open(self.filename, "r")
        except: 
            self.write([]) 

        #
        # Necessary to run with constructor
        #
        self.read()

