'''OpenGL extension OML.interlace

Overview (from the spec)
	
	This extension provides a way to interlace rows of pixels when
	drawing, reading, or copying pixel rectangles or texture images. In
	this context, interlacing means skiping over rows of pixels or
	texels in the destination. This is useful for dealing with video
	data since a single frame of video is typically composed from two
	images or fields: one image specifying the data for even rows of the
	frame and the other image specifying the data for odd rows of the
	frame.
	
	The functionality provided by this extension is a combination
	of the older SGIX_interlace and INGR_interlace_read extensions,
	with  changes applying interlacing to texture image queries.

The official definition of this extension is available here:
	http://oss.sgi.com/projects/ogl-sample/registry/OML/interlace.txt

Automatically generated by the get_gl_extensions script, do not edit!
'''
from OpenGL import platform, constants, constant, arrays
from OpenGL import extensions
from OpenGL.GL import glget
import ctypes
GL_INTERLACE_OML = constant.Constant( 'GL_INTERLACE_OML', 0x8980 )
glget.addGLGetConstant( GL_INTERLACE_OML, (1,) )
GL_INTERLACE_READ_OML = constant.Constant( 'GL_INTERLACE_READ_OML', 0x8981 )
glget.addGLGetConstant( GL_INTERLACE_READ_OML, (1,) )


def glInitInterlaceOML():
	'''Return boolean indicating whether this extension is available'''
	return extensions.hasGLExtension( 'GL_OML_interlace' )
