/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jna;

import com.sun.jna.Callback;
import com.sun.jna.CallbackReference;
import com.sun.jna.FromNativeContext;
import com.sun.jna.FromNativeConverter;
import com.sun.jna.IntegerType;
import com.sun.jna.Memory;
import com.sun.jna.Native;
import com.sun.jna.NativeLong;
import com.sun.jna.NativeMappedConverter;
import com.sun.jna.NativeString;
import com.sun.jna.Platform;
import com.sun.jna.Pointer;
import com.sun.jna.StructureReadContext;
import com.sun.jna.StructureWriteContext;
import com.sun.jna.ToNativeConverter;
import com.sun.jna.TypeMapper;
import com.sun.jna.WString;
import java.lang.reflect.Array;
import java.lang.reflect.Field;
import java.lang.reflect.Modifier;
import java.nio.Buffer;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.WeakHashMap;

public abstract class Structure {
    private static final boolean REVERSE_FIELDS;
    static final boolean isPPC;
    static final boolean isSPARC;
    public static final int ALIGN_DEFAULT = 0;
    public static final int ALIGN_NONE = 1;
    public static final int ALIGN_GNUC = 2;
    public static final int ALIGN_MSVC = 3;
    private static final int MAX_GNUC_ALIGNMENT;
    protected static final int CALCULATE_SIZE = -1;
    private static Map typeInfoMap;
    private Pointer memory;
    private int size = -1;
    private int alignType;
    private int structAlignment;
    private Map structFields = new LinkedHashMap();
    private Map nativeStrings = new HashMap();
    private TypeMapper typeMapper;
    private long typeInfo;
    static /* synthetic */ Class class$com$sun$jna$NativeMapped;

    protected Structure() {
        this(-1);
    }

    protected Structure(int size) {
        this(size, 0);
    }

    protected Structure(int size, int alignment) {
        this.setAlignType(alignment);
        this.setTypeMapper(null);
        this.allocateMemory(size);
    }

    Map fields() {
        return this.structFields;
    }

    protected void setTypeMapper(TypeMapper mapper) {
        Class<?> declaring;
        if (mapper == null && (declaring = this.getClass().getDeclaringClass()) != null) {
            mapper = Native.getTypeMapper(declaring);
        }
        this.typeMapper = mapper;
        this.size = -1;
        this.memory = null;
    }

    protected void setAlignType(int alignType) {
        if (alignType == 0) {
            Class<?> declaring = this.getClass().getDeclaringClass();
            if (declaring != null) {
                alignType = Native.getStructureAlignment(declaring);
            }
            if (alignType == 0) {
                alignType = Platform.isWindows() ? 3 : 2;
            }
        }
        this.alignType = alignType;
        this.size = -1;
        this.memory = null;
    }

    protected void useMemory(Pointer m) {
        this.useMemory(m, 0);
    }

    protected void useMemory(Pointer m, int offset) {
        this.memory = m.share(offset, this.size());
    }

    protected void allocateMemory() {
        this.allocateMemory(this.calculateSize(true));
    }

    protected void allocateMemory(int size) {
        if (size == -1) {
            size = this.calculateSize(false);
        } else if (size <= 0) {
            throw new IllegalArgumentException("Structure size must be greater than zero: " + size);
        }
        if (size != -1) {
            this.memory = new Memory(size);
            this.memory.clear(size);
            this.size = size;
            if (this instanceof ByValue) {
                this.typeInfo = this.getTypeInfo().peer;
            }
        }
    }

    public int size() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        return this.size;
    }

    public void clear() {
        this.memory.clear(this.size());
    }

    public Pointer getPointer() {
        return this.memory;
    }

    public void read() {
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            this.readField((StructField)i.next());
        }
    }

    public void readField(String name) {
        StructField f = (StructField)this.structFields.get(name);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name);
        }
        this.readField(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void readField(StructField structField) {
        Pointer p;
        int offset = structField.offset;
        Class nativeType = structField.type;
        FromNativeConverter readConverter = structField.readConverter;
        if (readConverter != null) {
            nativeType = readConverter.nativeType();
        }
        Object result = null;
        if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = null;
            try {
                s = (Structure)structField.field.get(this);
                if (ByReference.class.isAssignableFrom(nativeType)) {
                    Pointer p2 = this.memory.getPointer(offset);
                    if (p2 == null) {
                        s = null;
                    } else {
                        if (s == null || !p2.equals(s.getPointer())) {
                            s = Structure.newInstance(nativeType);
                            s.useMemory(p2);
                        }
                        s.read();
                    }
                } else {
                    s.useMemory(this.memory, offset);
                    s.read();
                }
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            result = s;
        } else if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            result = new Byte(this.memory.getByte(offset));
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            result = new Short(this.memory.getShort(offset));
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            result = new Character(this.memory.getChar(offset));
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            result = new Integer(this.memory.getInt(offset));
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            result = new Long(this.memory.getLong(offset));
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            result = new Float(this.memory.getFloat(offset));
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            result = new Double(this.memory.getDouble(offset));
        } else if (nativeType == Pointer.class) {
            result = this.memory.getPointer(offset);
        } else if (nativeType == String.class) {
            p = this.memory.getPointer(offset);
            result = p != null ? p.getString(0L) : null;
        } else if (nativeType == WString.class) {
            p = this.memory.getPointer(offset);
            result = p != null ? new WString(p.getString(0L, true)) : null;
        } else if (Callback.class.isAssignableFrom(nativeType)) {
            Pointer fp = this.memory.getPointer(offset);
            if (fp == null) {
                result = null;
            } else {
                try {
                    Callback cb = (Callback)structField.field.get(this);
                    Pointer oldfp = CallbackReference.getFunctionPointer(cb);
                    if (!fp.equals(oldfp)) {
                        cb = CallbackReference.getCallback(nativeType, fp);
                    }
                    result = cb;
                }
                catch (IllegalArgumentException e) {
                    return;
                }
                catch (IllegalAccessException e) {
                    return;
                }
            }
        } else {
            if (!nativeType.isArray()) throw new IllegalArgumentException("Unsupported field type \"" + nativeType + "\"");
            Class<?> cls = nativeType.getComponentType();
            int length = 0;
            try {
                Object o = structField.field.get(this);
                if (o == null) {
                    throw new IllegalStateException("Array field in Structure not initialized");
                }
                length = Array.getLength(o);
                result = o;
            }
            catch (IllegalArgumentException e) {
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            if (cls == Byte.TYPE) {
                this.memory.read((long)offset, (byte[])result, 0, length);
            } else if (cls == Short.TYPE) {
                this.memory.read((long)offset, (short[])result, 0, length);
            } else if (cls == Character.TYPE) {
                this.memory.read((long)offset, (char[])result, 0, length);
            } else if (cls == Integer.TYPE) {
                this.memory.read((long)offset, (int[])result, 0, length);
            } else if (cls == Long.TYPE) {
                this.memory.read((long)offset, (long[])result, 0, length);
            } else if (cls == Float.TYPE) {
                this.memory.read((long)offset, (float[])result, 0, length);
            } else if (cls == Double.TYPE) {
                this.memory.read((long)offset, (double[])result, 0, length);
            } else if (Pointer.class.isAssignableFrom(cls)) {
                this.memory.read((long)offset, (Pointer[])result, 0, length);
            } else {
                if (!Structure.class.isAssignableFrom(cls) || !ByReference.class.isAssignableFrom(cls)) throw new IllegalArgumentException("Array of " + cls + " not supported");
                Structure[] sarray = (Structure[])result;
                Pointer[] parray = this.memory.getPointerArray(offset, sarray.length);
                for (int i = 0; i < sarray.length; ++i) {
                    if (parray[i] == null) {
                        sarray[i] = null;
                        continue;
                    }
                    if (sarray[i] == null || !parray[i].equals(sarray[i].getPointer())) {
                        sarray[i] = Structure.newInstance(cls);
                        sarray[i].useMemory(parray[i]);
                    }
                    sarray[i].read();
                }
            }
        }
        if (readConverter != null) {
            result = readConverter.fromNative(result, structField.context);
        }
        try {
            structField.field.set(this, result);
            return;
        }
        catch (Exception e) {
            throw new Error("Exception setting field \"" + structField.name + "\" to " + result + ": " + e, e);
        }
    }

    public void write() {
        if (this.size == -1) {
            this.allocateMemory();
        }
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            StructField sf = (StructField)i.next();
            if (sf.isVolatile) continue;
            this.writeField(sf);
        }
    }

    public void writeField(String name) {
        StructField f = (StructField)this.structFields.get(name);
        if (f == null) {
            throw new IllegalArgumentException("No such field: " + name);
        }
        this.writeField(f);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    void writeField(StructField structField) {
        int offset = structField.offset;
        Object value = null;
        try {
            value = structField.field.get(this);
        }
        catch (Exception e) {
            throw new Error("Exception reading field \"" + structField.name + "\"", e);
        }
        Class nativeType = structField.type;
        ToNativeConverter converter = structField.writeConverter;
        if (converter != null) {
            Class clazz = nativeType = (value = converter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : Pointer.class;
        }
        if (String.class == nativeType || WString.class == nativeType) {
            boolean wide;
            boolean bl = wide = nativeType == WString.class;
            if (value != null) {
                NativeString nativeString = new NativeString(value.toString(), wide);
                this.nativeStrings.put(structField.name, nativeString);
                value = nativeString.getPointer();
            } else {
                value = null;
            }
        }
        if (nativeType == Byte.TYPE || nativeType == Byte.class) {
            this.memory.setByte(offset, (Byte)value);
            return;
        } else if (nativeType == Short.TYPE || nativeType == Short.class) {
            this.memory.setShort(offset, (Short)value);
            return;
        } else if (nativeType == Character.TYPE || nativeType == Character.class) {
            this.memory.setChar(offset, ((Character)value).charValue());
            return;
        } else if (nativeType == Integer.TYPE || nativeType == Integer.class) {
            this.memory.setInt(offset, (Integer)value);
            return;
        } else if (nativeType == Long.TYPE || nativeType == Long.class) {
            this.memory.setLong(offset, (Long)value);
            return;
        } else if (nativeType == Float.TYPE || nativeType == Float.class) {
            this.memory.setFloat(offset, ((Float)value).floatValue());
            return;
        } else if (nativeType == Double.TYPE || nativeType == Double.class) {
            this.memory.setDouble(offset, (Double)value);
            return;
        } else if (nativeType == Pointer.class) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType == String.class) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType == WString.class) {
            this.memory.setPointer(offset, (Pointer)value);
            return;
        } else if (nativeType.isArray()) {
            Class<?> cls = nativeType.getComponentType();
            if (cls == Byte.TYPE) {
                byte[] byArray = (byte[])value;
                this.memory.write((long)offset, byArray, 0, byArray.length);
                return;
            } else if (cls == Short.TYPE) {
                short[] sArray = (short[])value;
                this.memory.write((long)offset, sArray, 0, sArray.length);
                return;
            } else if (cls == Character.TYPE) {
                char[] cArray = (char[])value;
                this.memory.write((long)offset, cArray, 0, cArray.length);
                return;
            } else if (cls == Integer.TYPE) {
                int[] nArray = (int[])value;
                this.memory.write((long)offset, nArray, 0, nArray.length);
                return;
            } else if (cls == Long.TYPE) {
                long[] lArray = (long[])value;
                this.memory.write((long)offset, lArray, 0, lArray.length);
                return;
            } else if (cls == Float.TYPE) {
                float[] fArray = (float[])value;
                this.memory.write((long)offset, fArray, 0, fArray.length);
                return;
            } else if (cls == Double.TYPE) {
                double[] dArray = (double[])value;
                this.memory.write((long)offset, dArray, 0, dArray.length);
                return;
            } else if (Pointer.class.isAssignableFrom(cls)) {
                Pointer[] pointerArray = (Pointer[])value;
                this.memory.write((long)offset, pointerArray, 0, pointerArray.length);
                return;
            } else {
                if (!Structure.class.isAssignableFrom(cls) || !ByReference.class.isAssignableFrom(cls)) throw new IllegalArgumentException("Inline array of " + cls + " not supported");
                Structure[] structureArray = (Structure[])value;
                Pointer[] buf = new Pointer[structureArray.length];
                for (int i = 0; i < structureArray.length; ++i) {
                    buf[i] = structureArray[i] == null ? null : structureArray[i].getPointer();
                }
                this.memory.write((long)offset, buf, 0, buf.length);
            }
            return;
        } else if (Structure.class.isAssignableFrom(nativeType)) {
            Structure s = (Structure)value;
            if (ByReference.class.isAssignableFrom(nativeType)) {
                if (s == null) {
                    this.memory.setPointer(offset, null);
                    return;
                } else {
                    this.memory.setPointer(offset, s.getPointer());
                    s.write();
                }
                return;
            } else {
                s.useMemory(this.memory, offset);
                s.write();
            }
            return;
        } else if (Callback.class.isAssignableFrom(nativeType)) {
            this.memory.setPointer(offset, CallbackReference.getFunctionPointer((Callback)value));
            return;
        } else {
            String msg = "Structure field \"" + structField.name + "\" was declared as " + nativeType + ", which is not supported within a Structure";
            throw new IllegalArgumentException(msg);
        }
    }

    int calculateSize(boolean force) {
        int i;
        this.structAlignment = 1;
        int calculatedSize = 0;
        Field[] fields = this.getClass().getFields();
        if (REVERSE_FIELDS) {
            for (i = 0; i < fields.length / 2; ++i) {
                int idx = fields.length - 1 - i;
                Field tmp = fields[i];
                fields[i] = fields[idx];
                fields[idx] = tmp;
            }
        }
        for (i = 0; i < fields.length; ++i) {
            Field field = fields[i];
            int modifiers = field.getModifiers();
            if (Modifier.isStatic(modifiers) || !Modifier.isPublic(modifiers)) continue;
            Class type = field.getType();
            StructField structField = new StructField();
            structField.isVolatile = Modifier.isVolatile(modifiers);
            structField.field = field;
            structField.name = field.getName();
            structField.type = type;
            if ((class$com$sun$jna$Callback == null ? Structure.class$("com.sun.jna.Callback") : class$com$sun$jna$Callback).isAssignableFrom(type) && !type.isInterface()) {
                throw new IllegalArgumentException("Structure Callback field '" + field.getName() + "' must be an interface");
            }
            if (type.isArray() && (class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).equals(type.getComponentType())) {
                String msg = "Nested Structure arrays must use a derived Structure type so that the size of the elements can be determined";
                throw new IllegalArgumentException(msg);
            }
            int fieldAlignment = 1;
            try {
                Object value = field.get(this);
                if (value == null) {
                    if ((class$com$sun$jna$Structure == null ? Structure.class$("com.sun.jna.Structure") : class$com$sun$jna$Structure).isAssignableFrom(type) && !(class$com$sun$jna$Structure$ByReference == null ? Structure.class$("com.sun.jna.Structure$ByReference") : class$com$sun$jna$Structure$ByReference).isAssignableFrom(type)) {
                        try {
                            value = Structure.newInstance(type);
                            field.set(this, value);
                        }
                        catch (IllegalArgumentException e) {
                            String msg = "Can't determine size of nested structure: " + e.getMessage();
                            throw new IllegalArgumentException(msg);
                        }
                    } else if (type.isArray()) {
                        if (force) {
                            throw new IllegalStateException("Array fields must be initialized");
                        }
                        return -1;
                    }
                }
                Class nativeType = type;
                if ((class$com$sun$jna$NativeMapped == null ? Structure.class$("com.sun.jna.NativeMapped") : class$com$sun$jna$NativeMapped).isAssignableFrom(type)) {
                    NativeMappedConverter tc = new NativeMappedConverter(type);
                    value = tc.defaultValue();
                    nativeType = tc.nativeType();
                    structField.writeConverter = tc;
                    structField.readConverter = tc;
                    structField.context = new StructureReadContext(this, field);
                    field.set(this, value);
                } else if (this.typeMapper != null) {
                    ToNativeConverter writeConverter = this.typeMapper.getToNativeConverter(type);
                    FromNativeConverter readConverter = this.typeMapper.getFromNativeConverter(type);
                    if (writeConverter != null && readConverter != null) {
                        nativeType = (value = writeConverter.toNative(value, new StructureWriteContext(this, structField.field))) != null ? value.getClass() : (class$com$sun$jna$Pointer == null ? Structure.class$("com.sun.jna.Pointer") : class$com$sun$jna$Pointer);
                        structField.writeConverter = writeConverter;
                        structField.readConverter = readConverter;
                        structField.context = new StructureReadContext(this, field);
                    } else if (writeConverter != null || readConverter != null) {
                        String msg = "Structures require bidirectional type conversion for " + type;
                        throw new IllegalArgumentException(msg);
                    }
                }
                structField.size = this.getNativeSize(nativeType, value);
                fieldAlignment = this.getNativeAlignment(nativeType, value, i == 0);
            }
            catch (IllegalAccessException e) {
                // empty catch block
            }
            this.structAlignment = Math.max(this.structAlignment, fieldAlignment);
            if (calculatedSize % fieldAlignment != 0) {
                calculatedSize += fieldAlignment - calculatedSize % fieldAlignment;
            }
            structField.offset = calculatedSize;
            calculatedSize += structField.size;
            this.structFields.put(structField.name, structField);
        }
        if (calculatedSize > 0) {
            return this.calculateAlignedSize(calculatedSize);
        }
        throw new IllegalArgumentException("Structure " + this.getClass() + " has unknown size (ensure " + "all fields are public)");
    }

    int calculateAlignedSize(int calculatedSize) {
        if (this.alignType != 1 && calculatedSize % this.structAlignment != 0) {
            calculatedSize += this.structAlignment - calculatedSize % this.structAlignment;
        }
        return calculatedSize;
    }

    protected int getNativeAlignment(Class type, Object value, boolean firstElement) {
        int alignment = 1;
        int size = this.getNativeSize(type, value);
        if (type.isPrimitive() || Long.class == type || Integer.class == type || Short.class == type || Character.class == type || Byte.class == type || Float.class == type || Double.class == type) {
            alignment = size;
        } else if (Pointer.class == type || Buffer.class.isAssignableFrom(type) || Callback.class.isAssignableFrom(type) || WString.class == type || String.class == type) {
            alignment = Pointer.SIZE;
        } else if (Structure.class.isAssignableFrom(type)) {
            alignment = ByReference.class.isAssignableFrom(type) ? Pointer.SIZE : ((Structure)value).structAlignment;
        } else if (type.isArray()) {
            alignment = this.getNativeAlignment(type.getComponentType(), null, firstElement);
        } else {
            throw new IllegalArgumentException("Type " + type + " has unknown " + "native alignment");
        }
        if (this.alignType == 1) {
            return 1;
        }
        if (this.alignType == 3) {
            return Math.min(8, alignment);
        }
        if (!(this.alignType != 2 || firstElement && isPPC)) {
            return Math.min(MAX_GNUC_ALIGNMENT, alignment);
        }
        return alignment;
    }

    protected int getNativeSize(Class cls) {
        if (cls == Byte.TYPE || cls == Byte.class) {
            return 1;
        }
        if (cls == Short.TYPE || cls == Short.class) {
            return 2;
        }
        if (cls == Character.TYPE || cls == Character.class) {
            return Native.WCHAR_SIZE;
        }
        if (cls == Integer.TYPE || cls == Integer.class) {
            return 4;
        }
        if (cls == Long.TYPE || cls == Long.class) {
            return 8;
        }
        if (cls == Float.TYPE || cls == Float.class) {
            return 4;
        }
        if (cls == Double.TYPE || cls == Double.class) {
            return 8;
        }
        if (Pointer.class == cls || Callback.class.isAssignableFrom(cls) || String.class == cls || WString.class == cls) {
            return Pointer.SIZE;
        }
        throw new IllegalArgumentException("The type \"" + cls.getName() + "\" is not supported as a Structure field");
    }

    protected int getNativeSize(Class type, Object value) {
        if (Structure.class.isAssignableFrom(type)) {
            if (ByReference.class.isAssignableFrom(type)) {
                return Pointer.SIZE;
            }
            Structure s = (Structure)value;
            return s.size();
        }
        if (type.isArray()) {
            int len = Array.getLength(value);
            if (len > 0) {
                Object o = Array.get(value, 0);
                return len * this.getNativeSize(type.getComponentType(), o);
            }
            throw new IllegalArgumentException("Arrays of length zero not allowed in structure: " + this);
        }
        return this.getNativeSize(type);
    }

    public String toString() {
        String LS = System.getProperty("line.separator");
        String name = this.getClass().getName() + "(" + this.getPointer() + ")";
        String contents = "";
        Iterator i = this.structFields.values().iterator();
        while (i.hasNext()) {
            contents = contents + "  " + i.next();
            contents = contents + LS;
        }
        byte[] buf = this.getPointer().getByteArray(0L, this.size());
        int BYTES_PER_ROW = 4;
        contents = contents + "memory dump" + LS;
        for (int i2 = 0; i2 < buf.length; ++i2) {
            if (i2 % 4 == 0) {
                contents = contents + "[";
            }
            if (buf[i2] >= 0 && buf[i2] < 16) {
                contents = contents + "0";
            }
            contents = contents + Integer.toHexString(buf[i2] & 0xFF);
            if (i2 % 4 != 3 || i2 >= buf.length - 1) continue;
            contents = contents + "]" + LS;
        }
        contents = contents + "]";
        return name + LS + contents;
    }

    public Structure[] toArray(Structure[] array) {
        if (this.memory instanceof Memory) {
            Memory m = (Memory)this.memory;
            int requiredSize = array.length * this.size();
            if (m.getSize() < (long)requiredSize) {
                m = new Memory(requiredSize);
                m.clear();
                this.useMemory(m);
            }
        }
        array[0] = this;
        int size = this.size();
        for (int i = 1; i < array.length; ++i) {
            array[i] = Structure.newInstance(this.getClass());
            array[i].useMemory(this.memory.share(i * size, size));
            array[i].read();
        }
        return array;
    }

    public Structure[] toArray(int size) {
        return this.toArray((Structure[])Array.newInstance(this.getClass(), size));
    }

    public boolean equals(Object o) {
        return o == this || o != null && o.getClass() == this.getClass() && ((Structure)o).getPointer().equals(this.getPointer());
    }

    public int hashCode() {
        return this.getPointer().hashCode();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Pointer getTypeInfo() {
        Map map = typeInfoMap;
        synchronized (map) {
            Pointer info = (Pointer)typeInfoMap.get(this.getClass());
            if (info == null) {
                FFIType type = new FFIType(this);
                info = type.getPointer();
                typeInfoMap.put(this.getClass(), info);
            }
            return info;
        }
    }

    static Structure newInstance(Class type) throws IllegalArgumentException {
        try {
            Structure s = (Structure)type.newInstance();
            if (s instanceof ByValue) {
                s.allocateMemory();
            }
            return s;
        }
        catch (InstantiationException e) {
            String msg = "Can't instantiate " + type + " (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
        catch (IllegalAccessException e) {
            String msg = "Instantiation of " + type + " not allowed, is it public? (" + e + ")";
            throw new IllegalArgumentException(msg);
        }
    }

    static {
        Field[] fields = MemberOrder.class.getFields();
        REVERSE_FIELDS = "last".equals(fields[0].getName());
        if (!"middle".equals(fields[1].getName())) {
            throw new Error("This VM does not store fields in a predictable order");
        }
        String arch = System.getProperty("os.arch").toLowerCase();
        isPPC = "ppc".equals(arch) || "powerpc".equals(arch);
        isSPARC = "sparc".equals(arch);
        MAX_GNUC_ALIGNMENT = isSPARC ? 8 : NativeLong.SIZE;
        typeInfoMap = new WeakHashMap();
    }

    private static class FFIType
    extends Structure {
        private static final int FFI_TYPE_VOID = 0;
        private static final int FFI_TYPE_INT = 1;
        private static final int FFI_TYPE_FLOAT = 2;
        private static final int FFI_TYPE_DOUBLE = 3;
        private static final int FFI_TYPE_LONGDOUBLE = 4;
        private static final int FFI_TYPE_UINT8 = 5;
        private static final int FFI_TYPE_SINT8 = 6;
        private static final int FFI_TYPE_UINT16 = 6;
        private static final int FFI_TYPE_SINT16 = 8;
        private static final int FFI_TYPE_UINT32 = 9;
        private static final int FFI_TYPE_SINT32 = 10;
        private static final int FFI_TYPE_UINT64 = 11;
        private static final int FFI_TYPE_SINT64 = 12;
        private static final int FFI_TYPE_STRUCT = 13;
        private static final int FFI_TYPE_POINTER = 14;
        public size_t size;
        public short alignment;
        public short type = 0;
        public Pointer elements;

        public FFIType(Structure ref) {
            Pointer[] els = this.getFieldFFITypes(ref);
            this.init(els);
        }

        private FFIType(Class type, int length) {
            Pointer[] els = new Pointer[length + 1];
            Pointer p = this.getFFIType(type);
            for (int i = 0; i < length; ++i) {
                els[i] = p;
            }
            this.init(els);
        }

        private void init(Pointer[] els) {
            this.elements = new Memory(Pointer.SIZE * els.length);
            this.elements.write(0L, els, 0, els.length);
            this.allocateMemory();
            this.write();
        }

        private Pointer getFFIType(Class cls) {
            return this.getFFIType(cls, -1);
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        private Pointer getFFIType(Class cls, int length) {
            long value = 0L;
            if (cls == Byte.TYPE || cls == (class$java$lang$Byte == null ? (class$java$lang$Byte = Structure.class$("java.lang.Byte")) : class$java$lang$Byte)) {
                value = 6L;
                return new Pointer(value);
            } else if (cls == Short.TYPE || cls == (class$java$lang$Short == null ? (class$java$lang$Short = Structure.class$("java.lang.Short")) : class$java$lang$Short)) {
                value = 8L;
                return new Pointer(value);
            } else if (cls == Character.TYPE || cls == (class$java$lang$Character == null ? (class$java$lang$Character = Structure.class$("java.lang.Character")) : class$java$lang$Character)) {
                value = Native.WCHAR_SIZE == 2 ? 6L : 9L;
                return new Pointer(value);
            } else if (cls == Integer.TYPE || cls == (class$java$lang$Integer == null ? (class$java$lang$Integer = Structure.class$("java.lang.Integer")) : class$java$lang$Integer)) {
                value = 10L;
                return new Pointer(value);
            } else if (cls == Long.TYPE || cls == (class$java$lang$Long == null ? (class$java$lang$Long = Structure.class$("java.lang.Long")) : class$java$lang$Long)) {
                value = 12L;
                return new Pointer(value);
            } else if (cls == Float.TYPE || cls == (class$java$lang$Float == null ? (class$java$lang$Float = Structure.class$("java.lang.Float")) : class$java$lang$Float)) {
                value = 2L;
                return new Pointer(value);
            } else if (cls == Double.TYPE || cls == (class$java$lang$Double == null ? (class$java$lang$Double = Structure.class$("java.lang.Double")) : class$java$lang$Double)) {
                value = 3L;
                return new Pointer(value);
            } else if ((class$com$sun$jna$Pointer == null ? (class$com$sun$jna$Pointer = Structure.class$("com.sun.jna.Pointer")) : class$com$sun$jna$Pointer) == cls || (class$java$nio$Buffer == null ? (class$java$nio$Buffer = Structure.class$("java.nio.Buffer")) : class$java$nio$Buffer).isAssignableFrom(cls) || (class$com$sun$jna$Callback == null ? (class$com$sun$jna$Callback = Structure.class$("com.sun.jna.Callback")) : class$com$sun$jna$Callback).isAssignableFrom(cls) || (class$java$lang$String == null ? (class$java$lang$String = Structure.class$("java.lang.String")) : class$java$lang$String) == cls || (class$com$sun$jna$WString == null ? (class$com$sun$jna$WString = Structure.class$("com.sun.jna.WString")) : class$com$sun$jna$WString) == cls) {
                value = 14L;
                return new Pointer(value);
            } else if ((class$com$sun$jna$Structure == null ? (class$com$sun$jna$Structure = Structure.class$("com.sun.jna.Structure")) : class$com$sun$jna$Structure).isAssignableFrom(cls)) {
                if (!(class$com$sun$jna$Structure$ByReference == null ? (class$com$sun$jna$Structure$ByReference = Structure.class$("com.sun.jna.Structure$ByReference")) : class$com$sun$jna$Structure$ByReference).isAssignableFrom(cls)) return FFIType.newInstance(cls).getTypeInfo();
                value = 14L;
                return new Pointer(value);
            } else {
                if (!cls.isArray()) throw new IllegalArgumentException("Unsupported structure field type " + cls);
                return new FFIType(cls.getComponentType(), length).getPointer();
            }
        }

        private Pointer[] getFieldFFITypes(Structure s) {
            Pointer[] result = new Pointer[s.structFields.size() + 1];
            int idx = 0;
            Iterator i = s.structFields.values().iterator();
            while (i.hasNext()) {
                StructField sf = (StructField)i.next();
                int length = -1;
                if (sf.type.isArray()) {
                    try {
                        Object array = sf.field.get(s);
                        length = Array.getLength(array);
                    }
                    catch (IllegalArgumentException e) {
                    }
                    catch (IllegalAccessException e) {
                        // empty catch block
                    }
                }
                result[idx++] = this.getFFIType(sf.type, length);
            }
            result[idx] = null;
            return result;
        }

        public static class size_t
        extends IntegerType {
            public size_t() {
                this(0L);
            }

            public size_t(long v) {
                super(Pointer.SIZE, v);
            }
        }
    }

    class StructField {
        public String name;
        public Class type;
        public Field field;
        public int size = -1;
        public int offset = -1;
        public boolean isVolatile;
        public FromNativeConverter readConverter;
        public ToNativeConverter writeConverter;
        public FromNativeContext context;

        StructField() {
        }

        public String toString() {
            Object value = "<unavailable>";
            try {
                value = this.field.get(Structure.this);
            }
            catch (Exception exception) {
                // empty catch block
            }
            return this.type + " " + this.name + "@" + Integer.toHexString(this.offset) + "=" + value;
        }
    }

    private static class MemberOrder {
        public int first;
        public int middle;
        public int last;

        private MemberOrder() {
        }
    }

    protected static interface ByReference {
    }

    protected static interface ByValue {
    }
}

