
"""Python abstract syntax node definitions

This file is automatically generated by astgen.py
"""
from consts import CO_VARARGS, CO_VARKEYWORDS, OP_ASSIGN
from pypy.interpreter.baseobjspace import Wrappable
from pypy.interpreter.typedef import TypeDef, GetSetProperty, interp_attrproperty
from pypy.interpreter.gateway import interp2app, W_Root, ObjSpace
from pypy.interpreter.error import OperationError

def flatten(list):
    l = []
    for elt in list:
        t = type(elt)
        if t is tuple or t is list:
            for elt2 in flatten(elt):
                l.append(elt2)
        else:
            l.append(elt)
    return l

#def flatten_nodes(list):
#    return [n for n in flatten(list) if isinstance(n, Node)]

nodes = {}

class Node(Wrappable):
    """Abstract base class for ast nodes."""
    def __init__(self, lineno = -1):
        self.lineno = lineno
        self.filename = ""
        self.parent = None
        #self.scope = None
        
    def getChildren(self):
        pass # implemented by subclasses
    def __iter__(self):
        for n in self.getChildren():
            yield n
    def asList(self): # for backwards compatibility
        return self.getChildren()
    def getChildNodes(self):
        return [] # implemented by subclasses
    def accept(self, visitor):
        raise NotImplementedError
    def mutate(self, visitor):
        raise NotImplementedError
    def flatten(self):
        res = []
        nodes = self.getChildNodes()
        if nodes:
            for n in nodes:
                res.extend( n.flatten() )
        else:
            res.append( self )
        return res

    def __repr__(self):
        return "Node()"

    def descr_repr( self, space ):
        # most of the __repr__ are not RPython, more work is needed
        return space.wrap( self.__repr__() )
    
    def fget_parent(space, self):
        return space.wrap(self.parent)

    def fset_parent(space, self, w_parent):
        self.parent = space.interp_w(Node, w_parent, can_be_None=False)

    def descr_getChildNodes( self, space ):
        lst = self.getChildNodes()
        return space.newlist( [ space.wrap( it ) for it in lst ] )

    def get_value(self):
        pass

def descr_node_accept( space, w_self, w_visitor ):
    return space.call_method( w_visitor, 'visitNode', w_self )

def descr_node_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, 'visitNode', w_self)

def descr_Node_new(space, w_subtype, lineno=-1):
    node = space.allocate_instance(Node, w_subtype)
    node.lineno = lineno
    return space.wrap(node)

Node.typedef = TypeDef('ASTNode',
                       __new__ = interp2app(descr_Node_new, unwrap_spec=[ObjSpace, W_Root, int]),
                       #__repr__ = interp2app(Node.descr_repr, unwrap_spec=['self', ObjSpace] ),
                       getChildNodes = interp2app(Node.descr_getChildNodes, unwrap_spec=[ 'self', ObjSpace ] ),
                       accept = interp2app(descr_node_accept, unwrap_spec=[ ObjSpace, W_Root, W_Root ] ),
                       mutate = interp2app(descr_node_mutate, unwrap_spec=[ ObjSpace, W_Root, W_Root ] ),
                       lineno = interp_attrproperty('lineno', cls=Node),
                       filename = interp_attrproperty('filename', cls=Node),
                       parent=GetSetProperty(Node.fget_parent, Node.fset_parent),
                       )

Node.typedef.acceptable_as_base_class = False
        
class EmptyNode(Node):
    def accept(self, visitor):
        return visitor.visitEmptyNode(self)

class Expression(Node):
    # Expression is an artificial node class to support "eval"
    nodes["expression"] = "Expression"
    def __init__(self, node):
        Node.__init__(self)
        self.node = node

    def getChildren(self):
        return [self.node,]

    def getChildNodes(self):
        return [self.node,]

    def __repr__(self):
        return "Expression(%s)" % (repr(self.node))

    def accept(self, visitor):
        return visitor.visitExpression(self)
    def mutate(self, visitor):
        self.node = self.node.mutate(visitor)
        return visitor.visitExpression(self)

    def fget_node(space, self):
        return space.wrap(self.node)
    def fset_node(space, self, w_arg):
        self.node = space.interp_w(Node, w_arg, can_be_None=False)

def descr_expression_new(space, w_subtype, w_node, lineno=-1):
    self = space.allocate_instance(Expression, w_subtype)
    node = space.interp_w(Node, w_node, can_be_None=False)
    self.node = node
    self.lineno = lineno
    return space.wrap(self)

def descr_expression_accept(space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitExpression', w_self)

def descr_expression_mutate(space, w_self, w_visitor):
    w_node = space.getattr(w_self, space.wrap("node"))
    space.setattr(w_node, space.wrap('parent'), w_self)
    w_new_node = space.call_method(w_node, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("node"), w_new_node)

    return space.call_method(w_visitor, "visitExpression", w_self)

Expression.typedef = TypeDef('Expression', Node.typedef,
                     __new__ = interp2app(descr_expression_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_expression_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_expression_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     node=GetSetProperty(Expression.fget_node, Expression.fset_node ),
                    )

Expression.typedef.acceptable_as_base_class = False


class AbstractFunction(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "AbstractFunction()"

    def accept(self, visitor):
        return visitor.visitAbstractFunction(self)

    def mutate(self, visitor):
        return visitor.visitAbstractFunction(self)


def descr_AbstractFunction_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(AbstractFunction, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_AbstractFunction_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAbstractFunction', w_self)

def descr_AbstractFunction_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitAbstractFunction", w_self)

AbstractFunction.typedef = TypeDef('AbstractFunction', Node.typedef, 
                     __new__ = interp2app(descr_AbstractFunction_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_AbstractFunction_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AbstractFunction_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
AbstractFunction.typedef.acceptable_as_base_class = False

class AbstractTest(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "AbstractTest()"

    def accept(self, visitor):
        return visitor.visitAbstractTest(self)

    def mutate(self, visitor):
        return visitor.visitAbstractTest(self)


def descr_AbstractTest_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(AbstractTest, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_AbstractTest_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAbstractTest', w_self)

def descr_AbstractTest_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitAbstractTest", w_self)

AbstractTest.typedef = TypeDef('AbstractTest', Node.typedef, 
                     __new__ = interp2app(descr_AbstractTest_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_AbstractTest_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AbstractTest_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
AbstractTest.typedef.acceptable_as_base_class = False

class BinaryOp(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "BinaryOp()"

    def accept(self, visitor):
        return visitor.visitBinaryOp(self)

    def mutate(self, visitor):
        return visitor.visitBinaryOp(self)


def descr_BinaryOp_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(BinaryOp, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_BinaryOp_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBinaryOp', w_self)

def descr_BinaryOp_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitBinaryOp", w_self)

BinaryOp.typedef = TypeDef('BinaryOp', Node.typedef, 
                     __new__ = interp2app(descr_BinaryOp_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_BinaryOp_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_BinaryOp_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
BinaryOp.typedef.acceptable_as_base_class = False

class Add(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Add(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitAdd(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitAdd(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Add_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Add, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Add_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAdd', w_self)

def descr_Add_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitAdd", w_self)

Add.typedef = TypeDef('Add', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Add_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Add_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Add_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Add.fget_left, Add.fset_left ),
                    right=GetSetProperty(Add.fget_right, Add.fset_right ),
                    )
Add.typedef.acceptable_as_base_class = False

class And(AbstractTest):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "And(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitAnd(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitAnd(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_And_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(And, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_And_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAnd', w_self)

def descr_And_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitAnd", w_self)

And.typedef = TypeDef('And', AbstractTest.typedef, 
                     __new__ = interp2app(descr_And_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_And_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_And_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(And.fget_nodes, And.fset_nodes ),
                     insert_after=interp2app(And.descr_insert_after.im_func, unwrap_spec=[ObjSpace, And, Node, W_Root]),
                     insert_before=interp2app(And.descr_insert_before.im_func, unwrap_spec=[ObjSpace, And, Node, W_Root]),
                    )
And.typedef.acceptable_as_base_class = False

class AssAttr(Node):
    def __init__(self, expr, attrname, flags, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.attrname = attrname
        self.flags = flags

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr, self.attrname, self.flags

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "AssAttr(%s, %s, %s)" % (self.expr.__repr__(), self.attrname.__repr__(), self.flags.__repr__())

    def accept(self, visitor):
        return visitor.visitAssAttr(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitAssAttr(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_attrname( space, self):
        return space.wrap(self.attrname)
    def fset_attrname( space, self, w_arg):
        self.attrname = space.str_w(w_arg)
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)

def descr_AssAttr_new(space, w_subtype, w_expr, w_attrname, w_flags, lineno=-1):
    self = space.allocate_instance(AssAttr, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    attrname = space.str_w(w_attrname)
    self.attrname = attrname
    flags = space.int_w(w_flags)
    self.flags = flags
    self.lineno = lineno
    return space.wrap(self)

def descr_AssAttr_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssAttr', w_self)

def descr_AssAttr_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitAssAttr", w_self)

AssAttr.typedef = TypeDef('AssAttr', Node.typedef, 
                     __new__ = interp2app(descr_AssAttr_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_AssAttr_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AssAttr_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(AssAttr.fget_expr, AssAttr.fset_expr ),
                    attrname=GetSetProperty(AssAttr.fget_attrname, AssAttr.fset_attrname ),
                    flags=GetSetProperty(AssAttr.fget_flags, AssAttr.fset_flags ),
                    )
AssAttr.typedef.acceptable_as_base_class = False

class AssSeq(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "AssSeq()"

    def accept(self, visitor):
        return visitor.visitAssSeq(self)

    def mutate(self, visitor):
        return visitor.visitAssSeq(self)


def descr_AssSeq_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(AssSeq, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_AssSeq_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssSeq', w_self)

def descr_AssSeq_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitAssSeq", w_self)

AssSeq.typedef = TypeDef('AssSeq', Node.typedef, 
                     __new__ = interp2app(descr_AssSeq_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_AssSeq_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AssSeq_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
AssSeq.typedef.acceptable_as_base_class = False

class AssList(AssSeq):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "AssList(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitAssList(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitAssList(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_AssList_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(AssList, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_AssList_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssList', w_self)

def descr_AssList_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitAssList", w_self)

AssList.typedef = TypeDef('AssList', AssSeq.typedef, 
                     __new__ = interp2app(descr_AssList_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_AssList_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AssList_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(AssList.fget_nodes, AssList.fset_nodes ),
                     insert_after=interp2app(AssList.descr_insert_after.im_func, unwrap_spec=[ObjSpace, AssList, Node, W_Root]),
                     insert_before=interp2app(AssList.descr_insert_before.im_func, unwrap_spec=[ObjSpace, AssList, Node, W_Root]),
                    )
AssList.typedef.acceptable_as_base_class = False

class AssName(Node):
    def __init__(self, name, flags, lineno=-1):
        Node.__init__(self, lineno)
        self.name = name
        self.flags = flags

    def getChildren(self):
        "NOT_RPYTHON"
        return self.name, self.flags

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "AssName(%s, %s)" % (self.name.__repr__(), self.flags.__repr__())

    def accept(self, visitor):
        return visitor.visitAssName(self)

    def mutate(self, visitor):
        return visitor.visitAssName(self)

    def fget_name( space, self):
        return space.wrap(self.name)
    def fset_name( space, self, w_arg):
        self.name = space.str_w(w_arg)
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)

def descr_AssName_new(space, w_subtype, w_name, w_flags, lineno=-1):
    self = space.allocate_instance(AssName, w_subtype)
    name = space.str_w(w_name)
    self.name = name
    flags = space.int_w(w_flags)
    self.flags = flags
    self.lineno = lineno
    return space.wrap(self)

def descr_AssName_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssName', w_self)

def descr_AssName_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitAssName", w_self)

AssName.typedef = TypeDef('AssName', Node.typedef, 
                     __new__ = interp2app(descr_AssName_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_AssName_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AssName_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    name=GetSetProperty(AssName.fget_name, AssName.fset_name ),
                    flags=GetSetProperty(AssName.fget_flags, AssName.fset_flags ),
                    )
AssName.typedef.acceptable_as_base_class = False

class AssTuple(AssSeq):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def getArgNames(self):
        argnames = []
        for node in self.nodes:
            if isinstance(node, AssTuple):
                argnames.extend(node.getArgNames())
            elif isinstance(node, AssName):
                name = node.name
                assert isinstance(name, str)
                argnames.append(name)
            else:
                assert False, "should only have AssName and AssTuple as children"
        return argnames
    

    def __repr__(self):
        return "AssTuple(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitAssTuple(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitAssTuple(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_AssTuple_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(AssTuple, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_AssTuple_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssTuple', w_self)

def descr_AssTuple_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitAssTuple", w_self)

AssTuple.typedef = TypeDef('AssTuple', AssSeq.typedef, 
                     __new__ = interp2app(descr_AssTuple_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_AssTuple_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AssTuple_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(AssTuple.fget_nodes, AssTuple.fset_nodes ),
                     insert_after=interp2app(AssTuple.descr_insert_after.im_func, unwrap_spec=[ObjSpace, AssTuple, Node, W_Root]),
                     insert_before=interp2app(AssTuple.descr_insert_before.im_func, unwrap_spec=[ObjSpace, AssTuple, Node, W_Root]),
                    )
AssTuple.typedef.acceptable_as_base_class = False

class Assert(Node):
    def __init__(self, test, fail, lineno=-1):
        Node.__init__(self, lineno)
        self.test = test
        self.fail = fail

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.test)
        children.append(self.fail)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.test)
        if self.fail is not None:
            nodelist.append(self.fail)
        return nodelist

    def __repr__(self):
        return "Assert(%s, %s)" % (self.test.__repr__(), self.fail.__repr__())

    def accept(self, visitor):
        return visitor.visitAssert(self)

    def mutate(self, visitor):
        self.test = self.test.mutate(visitor)
        if self.fail is not None:
            self.fail = self.fail.mutate(visitor)
        return visitor.visitAssert(self)

    def fget_test( space, self):
        return space.wrap(self.test)
    def fset_test( space, self, w_arg):
        self.test = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_fail( space, self):
        if self.fail is None:
            return space.w_None
        else:
            return space.wrap(self.fail)
    def fset_fail( space, self, w_arg):
        self.fail = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Assert_new(space, w_subtype, w_test, w_fail, lineno=-1):
    self = space.allocate_instance(Assert, w_subtype)
    test = space.interp_w(Node, w_test, can_be_None=False)
    self.test = test
    fail = space.interp_w(Node, w_fail, can_be_None=True)
    self.fail = fail
    self.lineno = lineno
    return space.wrap(self)

def descr_Assert_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssert', w_self)

def descr_Assert_mutate(space, w_self, w_visitor): 
    w_test = space.getattr(w_self, space.wrap("test"))
    space.setattr(w_test, space.wrap("parent"), w_self)
    w_new_test = space.call_method(w_test, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("test"), w_new_test)

    w_fail = space.getattr(w_self, space.wrap("fail"))
    if not space.is_w(w_fail, space.w_None):
        space.setattr(w_fail, space.wrap("parent"), w_self)
        w_new_fail = space.call_method(w_fail, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("fail"), w_new_fail)

    return space.call_method(w_visitor, "visitAssert", w_self)

Assert.typedef = TypeDef('Assert', Node.typedef, 
                     __new__ = interp2app(descr_Assert_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Assert_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Assert_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    test=GetSetProperty(Assert.fget_test, Assert.fset_test ),
                    fail=GetSetProperty(Assert.fget_fail, Assert.fset_fail ),
                    )
Assert.typedef.acceptable_as_base_class = False

class Assign(Node):
    def __init__(self, nodes, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.extend(flatten(self.nodes))
        children.append(self.expr)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        nodelist.append(self.expr)
        return nodelist

    def __repr__(self):
        return "Assign(%s, %s)" % (self.nodes.__repr__(), self.expr.__repr__())

    def accept(self, visitor):
        return visitor.visitAssign(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        self.expr = self.expr.mutate(visitor)
        return visitor.visitAssign(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes
    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Assign_new(space, w_subtype, w_nodes, w_expr, lineno=-1):
    self = space.allocate_instance(Assign, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Assign_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAssign', w_self)

def descr_Assign_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitAssign", w_self)

Assign.typedef = TypeDef('Assign', Node.typedef, 
                     __new__ = interp2app(descr_Assign_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Assign_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Assign_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Assign.fget_nodes, Assign.fset_nodes ),
                     insert_after=interp2app(Assign.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Assign, Node, W_Root]),
                     insert_before=interp2app(Assign.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Assign, Node, W_Root]),
                    expr=GetSetProperty(Assign.fget_expr, Assign.fset_expr ),
                    )
Assign.typedef.acceptable_as_base_class = False

class AugAssign(Node):
    def __init__(self, node, op, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.node = node
        self.op = op
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.node, self.op, self.expr

    def getChildNodes(self):
        return [self.node, self.expr]

    def __repr__(self):
        return "AugAssign(%s, %s, %s)" % (self.node.__repr__(), self.op.__repr__(), self.expr.__repr__())

    def accept(self, visitor):
        return visitor.visitAugAssign(self)

    def mutate(self, visitor):
        self.node = self.node.mutate(visitor)
        self.expr = self.expr.mutate(visitor)
        return visitor.visitAugAssign(self)

    def fget_node( space, self):
        return space.wrap(self.node)
    def fset_node( space, self, w_arg):
        self.node = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_op( space, self):
        return space.wrap(self.op)
    def fset_op( space, self, w_arg):
        self.op = space.str_w(w_arg)
    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_AugAssign_new(space, w_subtype, w_node, w_op, w_expr, lineno=-1):
    self = space.allocate_instance(AugAssign, w_subtype)
    node = space.interp_w(Node, w_node, can_be_None=False)
    self.node = node
    op = space.str_w(w_op)
    self.op = op
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_AugAssign_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitAugAssign', w_self)

def descr_AugAssign_mutate(space, w_self, w_visitor): 
    w_node = space.getattr(w_self, space.wrap("node"))
    space.setattr(w_node, space.wrap("parent"), w_self)
    w_new_node = space.call_method(w_node, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("node"), w_new_node)

    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitAugAssign", w_self)

AugAssign.typedef = TypeDef('AugAssign', Node.typedef, 
                     __new__ = interp2app(descr_AugAssign_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_AugAssign_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_AugAssign_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    node=GetSetProperty(AugAssign.fget_node, AugAssign.fset_node ),
                    op=GetSetProperty(AugAssign.fget_op, AugAssign.fset_op ),
                    expr=GetSetProperty(AugAssign.fget_expr, AugAssign.fset_expr ),
                    )
AugAssign.typedef.acceptable_as_base_class = False

class UnaryOp(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "UnaryOp()"

    def accept(self, visitor):
        return visitor.visitUnaryOp(self)

    def mutate(self, visitor):
        return visitor.visitUnaryOp(self)


def descr_UnaryOp_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(UnaryOp, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_UnaryOp_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitUnaryOp', w_self)

def descr_UnaryOp_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitUnaryOp", w_self)

UnaryOp.typedef = TypeDef('UnaryOp', Node.typedef, 
                     __new__ = interp2app(descr_UnaryOp_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_UnaryOp_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_UnaryOp_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
UnaryOp.typedef.acceptable_as_base_class = False

class Backquote(UnaryOp):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Backquote(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitBackquote(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitBackquote(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Backquote_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(Backquote, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Backquote_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBackquote', w_self)

def descr_Backquote_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitBackquote", w_self)

Backquote.typedef = TypeDef('Backquote', UnaryOp.typedef, 
                     __new__ = interp2app(descr_Backquote_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Backquote_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Backquote_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Backquote.fget_expr, Backquote.fset_expr ),
                    )
Backquote.typedef.acceptable_as_base_class = False

class BitOp(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "BitOp()"

    def accept(self, visitor):
        return visitor.visitBitOp(self)

    def mutate(self, visitor):
        return visitor.visitBitOp(self)


def descr_BitOp_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(BitOp, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_BitOp_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBitOp', w_self)

def descr_BitOp_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitBitOp", w_self)

BitOp.typedef = TypeDef('BitOp', Node.typedef, 
                     __new__ = interp2app(descr_BitOp_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_BitOp_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_BitOp_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
BitOp.typedef.acceptable_as_base_class = False

class Bitand(BitOp):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Bitand(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitBitand(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitBitand(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Bitand_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Bitand, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Bitand_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBitand', w_self)

def descr_Bitand_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitBitand", w_self)

Bitand.typedef = TypeDef('Bitand', BitOp.typedef, 
                     __new__ = interp2app(descr_Bitand_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Bitand_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Bitand_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Bitand.fget_nodes, Bitand.fset_nodes ),
                     insert_after=interp2app(Bitand.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Bitand, Node, W_Root]),
                     insert_before=interp2app(Bitand.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Bitand, Node, W_Root]),
                    )
Bitand.typedef.acceptable_as_base_class = False

class Bitor(BitOp):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Bitor(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitBitor(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitBitor(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Bitor_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Bitor, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Bitor_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBitor', w_self)

def descr_Bitor_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitBitor", w_self)

Bitor.typedef = TypeDef('Bitor', BitOp.typedef, 
                     __new__ = interp2app(descr_Bitor_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Bitor_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Bitor_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Bitor.fget_nodes, Bitor.fset_nodes ),
                     insert_after=interp2app(Bitor.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Bitor, Node, W_Root]),
                     insert_before=interp2app(Bitor.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Bitor, Node, W_Root]),
                    )
Bitor.typedef.acceptable_as_base_class = False

class Bitxor(BitOp):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Bitxor(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitBitxor(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitBitxor(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Bitxor_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Bitxor, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Bitxor_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBitxor', w_self)

def descr_Bitxor_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitBitxor", w_self)

Bitxor.typedef = TypeDef('Bitxor', BitOp.typedef, 
                     __new__ = interp2app(descr_Bitxor_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Bitxor_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Bitxor_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Bitxor.fget_nodes, Bitxor.fset_nodes ),
                     insert_after=interp2app(Bitxor.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Bitxor, Node, W_Root]),
                     insert_before=interp2app(Bitxor.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Bitxor, Node, W_Root]),
                    )
Bitxor.typedef.acceptable_as_base_class = False

class Break(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Break()"

    def accept(self, visitor):
        return visitor.visitBreak(self)

    def mutate(self, visitor):
        return visitor.visitBreak(self)


def descr_Break_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(Break, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_Break_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitBreak', w_self)

def descr_Break_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitBreak", w_self)

Break.typedef = TypeDef('Break', Node.typedef, 
                     __new__ = interp2app(descr_Break_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_Break_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Break_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
Break.typedef.acceptable_as_base_class = False

class CallFunc(Node):
    def __init__(self, node, args, star_args = None, dstar_args = None, lineno=-1):
        Node.__init__(self, lineno)
        self.node = node
        self.args = args
        self.star_args = star_args
        self.dstar_args = dstar_args

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.node)
        children.extend(flatten(self.args))
        children.append(self.star_args)
        children.append(self.dstar_args)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.node)
        nodelist.extend(self.args)
        if self.star_args is not None:
            nodelist.append(self.star_args)
        if self.dstar_args is not None:
            nodelist.append(self.dstar_args)
        return nodelist

    def __repr__(self):
        return "CallFunc(%s, %s, %s, %s)" % (self.node.__repr__(), self.args.__repr__(), self.star_args.__repr__(), self.dstar_args.__repr__())

    def accept(self, visitor):
        return visitor.visitCallFunc(self)

    def mutate(self, visitor):
        self.node = self.node.mutate(visitor)
        visitor._mutate_list(self.args)
        if self.star_args is not None:
            self.star_args = self.star_args.mutate(visitor)
        if self.dstar_args is not None:
            self.dstar_args = self.dstar_args.mutate(visitor)
        return visitor.visitCallFunc(self)

    def fget_node( space, self):
        return space.wrap(self.node)
    def fset_node( space, self, w_arg):
        self.node = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_args( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.args] )
    def fset_args( space, self, w_arg):
        del self.args[:]
        for w_itm in space.unpackiterable(w_arg):
            self.args.append( space.interp_w(Node, w_itm))
    def fget_star_args( space, self):
        if self.star_args is None:
            return space.w_None
        else:
            return space.wrap(self.star_args)
    def fset_star_args( space, self, w_arg):
        self.star_args = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_dstar_args( space, self):
        if self.dstar_args is None:
            return space.w_None
        else:
            return space.wrap(self.dstar_args)
    def fset_dstar_args( space, self, w_arg):
        self.dstar_args = space.interp_w(Node, w_arg, can_be_None=True)

def descr_CallFunc_new(space, w_subtype, w_node, w_args, w_star_args, w_dstar_args, lineno=-1):
    self = space.allocate_instance(CallFunc, w_subtype)
    node = space.interp_w(Node, w_node, can_be_None=False)
    self.node = node
    args = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_args)]
    self.args = args
    star_args = space.interp_w(Node, w_star_args, can_be_None=True)
    self.star_args = star_args
    dstar_args = space.interp_w(Node, w_dstar_args, can_be_None=True)
    self.dstar_args = dstar_args
    self.lineno = lineno
    return space.wrap(self)

def descr_CallFunc_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitCallFunc', w_self)

def descr_CallFunc_mutate(space, w_self, w_visitor): 
    w_node = space.getattr(w_self, space.wrap("node"))
    space.setattr(w_node, space.wrap("parent"), w_self)
    w_new_node = space.call_method(w_node, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("node"), w_new_node)

    w_list = space.getattr(w_self, space.wrap("args"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("args"), w_newlist)
    w_star_args = space.getattr(w_self, space.wrap("star_args"))
    if not space.is_w(w_star_args, space.w_None):
        space.setattr(w_star_args, space.wrap("parent"), w_self)
        w_new_star_args = space.call_method(w_star_args, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("star_args"), w_new_star_args)

    w_dstar_args = space.getattr(w_self, space.wrap("dstar_args"))
    if not space.is_w(w_dstar_args, space.w_None):
        space.setattr(w_dstar_args, space.wrap("parent"), w_self)
        w_new_dstar_args = space.call_method(w_dstar_args, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("dstar_args"), w_new_dstar_args)

    return space.call_method(w_visitor, "visitCallFunc", w_self)

CallFunc.typedef = TypeDef('CallFunc', Node.typedef, 
                     __new__ = interp2app(descr_CallFunc_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_CallFunc_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_CallFunc_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    node=GetSetProperty(CallFunc.fget_node, CallFunc.fset_node ),
                    args=GetSetProperty(CallFunc.fget_args, CallFunc.fset_args ),
                    star_args=GetSetProperty(CallFunc.fget_star_args, CallFunc.fset_star_args ),
                    dstar_args=GetSetProperty(CallFunc.fget_dstar_args, CallFunc.fset_dstar_args ),
                    )
CallFunc.typedef.acceptable_as_base_class = False

class Class(Node):
    def __init__(self, name, bases, w_doc, code, lineno=-1):
        Node.__init__(self, lineno)
        self.name = name
        self.bases = bases
        self.w_doc = w_doc
        self.code = code

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.name)
        children.extend(flatten(self.bases))
        children.append(self.w_doc)
        children.append(self.code)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.bases)
        nodelist.append(self.code)
        return nodelist

    def __repr__(self):
        return "Class(%s, %s, %s, %s)" % (self.name.__repr__(), self.bases.__repr__(), self.w_doc.__repr__(), self.code.__repr__())

    def accept(self, visitor):
        return visitor.visitClass(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.bases)
        self.code = self.code.mutate(visitor)
        return visitor.visitClass(self)

    def fget_name( space, self):
        return space.wrap(self.name)
    def fset_name( space, self, w_arg):
        self.name = space.str_w(w_arg)
    def fget_bases( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.bases] )
    def fset_bases( space, self, w_arg):
        del self.bases[:]
        for w_itm in space.unpackiterable(w_arg):
            self.bases.append( space.interp_w(Node, w_itm))
    def fget_w_doc( space, self):
        return self.w_doc
    def fset_w_doc( space, self, w_arg):
        self.w_doc = w_arg
    def fget_code( space, self):
        return space.wrap(self.code)
    def fset_code( space, self, w_arg):
        self.code = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Class_new(space, w_subtype, w_name, w_bases, w_w_doc, w_code, lineno=-1):
    self = space.allocate_instance(Class, w_subtype)
    name = space.str_w(w_name)
    self.name = name
    bases = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_bases)]
    self.bases = bases
    # This dummy assingment is auto-generated, astgen.py should be fixed to avoid that
    w_doc = w_w_doc
    self.w_doc = w_doc
    code = space.interp_w(Node, w_code, can_be_None=False)
    self.code = code
    self.lineno = lineno
    return space.wrap(self)

def descr_Class_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitClass', w_self)

def descr_Class_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("bases"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("bases"), w_newlist)
    w_code = space.getattr(w_self, space.wrap("code"))
    space.setattr(w_code, space.wrap("parent"), w_self)
    w_new_code = space.call_method(w_code, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("code"), w_new_code)

    return space.call_method(w_visitor, "visitClass", w_self)

Class.typedef = TypeDef('Class', Node.typedef, 
                     __new__ = interp2app(descr_Class_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Class_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Class_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    name=GetSetProperty(Class.fget_name, Class.fset_name ),
                    bases=GetSetProperty(Class.fget_bases, Class.fset_bases ),
                    w_doc=GetSetProperty(Class.fget_w_doc, Class.fset_w_doc ),
                    code=GetSetProperty(Class.fget_code, Class.fset_code ),
                    )
Class.typedef.acceptable_as_base_class = False

class Compare(Node):
    def __init__(self, expr, ops, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        # ops is a list of couples (op_name, node)
        self.ops = ops

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.extend(flatten(self.ops))
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        # ops is a list of couples (op_name, node)
        for op_name, node in self.ops:
            nodelist.append(node)
        return nodelist

    def fset_ops( space, self, w_arg ):
        del self.ops[:]
        for w_obj in space.unpackiterable( w_arg ):
            w_opname = space.getitem( w_obj, space.wrap(0) )
            w_node = space.getitem( w_obj, space.wrap(1) )
            ops = space.str_w(w_opname)
            node = space.interp_w(Node, w_node)
            self.ops.append( (ops,node) )
    

    def fget_ops( space, self ):
        lst = []
        for op_name, node in self.ops:
            lst.append( space.newtuple( [ space.wrap(op_name), space.wrap(node) ] ) )
        return space.newlist( lst )
    

    def __repr__(self):
        return "Compare(%s, %s)" % (self.expr.__repr__(), self.ops.__repr__())

    def accept(self, visitor):
        return visitor.visitCompare(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        for i in range(len(self.ops)):

            op_name, node = self.ops[i]

            self.ops[i] = op_name, node.mutate(visitor)

        return visitor.visitCompare(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Compare_new(space, w_subtype, w_expr, w_ops, lineno=-1):
    self = space.allocate_instance(Compare, w_subtype)
    self.expr = space.interp_w(Node, w_expr)
    ops = []
    for w_tuple in space.unpackiterable(w_ops):
        w_opname = space.getitem(w_tuple, space.wrap(0))
        w_node = space.getitem(w_tuple, space.wrap(1))
        opname = space.str_w(w_opname)
        node = space.interp_w(Node, w_node)
        ops.append((opname, node))
    self.ops = ops
    self.lineno = lineno
    return space.wrap(self)



def descr_Compare_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitCompare', w_self)

def descr_Compare_mutate(space, w_self, w_visitor):
    w_expr = space.getattr(w_self, space.wrap("expr"))
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_list = space.getattr(w_self, space.wrap("ops"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        w_opname, w_node = space.unpackiterable(w_item, 2)
        
        w_newnode = space.call_method(w_node, "mutate", w_visitor)
        
        newlist_w.append(space.newtuple([w_opname, w_newnode]))
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("ops"), w_newlist)
    return space.call_method(w_visitor, "visitCompare", w_self)



Compare.typedef = TypeDef('Compare', Node.typedef, 
                     __new__ = interp2app(descr_Compare_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Compare_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Compare_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Compare.fget_expr, Compare.fset_expr ),
                    ops=GetSetProperty(Compare.fget_ops, Compare.fset_ops ),
                    )
Compare.typedef.acceptable_as_base_class = False

class CondExpr(Node):
    def __init__(self, test, true_expr, false_expr, lineno=-1):
        Node.__init__(self, lineno)
        self.test = test
        self.true_expr = true_expr
        self.false_expr = false_expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.test, self.true_expr, self.false_expr

    def getChildNodes(self):
        return [self.test, self.true_expr, self.false_expr]

    def __repr__(self):
        return "CondExpr(%s, %s, %s)" % (self.test.__repr__(), self.true_expr.__repr__(), self.false_expr.__repr__())

    def accept(self, visitor):
        return visitor.visitCondExpr(self)

    def mutate(self, visitor):
        self.test = self.test.mutate(visitor)
        self.true_expr = self.true_expr.mutate(visitor)
        self.false_expr = self.false_expr.mutate(visitor)
        return visitor.visitCondExpr(self)

    def fget_test( space, self):
        return space.wrap(self.test)
    def fset_test( space, self, w_arg):
        self.test = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_true_expr( space, self):
        return space.wrap(self.true_expr)
    def fset_true_expr( space, self, w_arg):
        self.true_expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_false_expr( space, self):
        return space.wrap(self.false_expr)
    def fset_false_expr( space, self, w_arg):
        self.false_expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_CondExpr_new(space, w_subtype, w_test, w_true_expr, w_false_expr, lineno=-1):
    self = space.allocate_instance(CondExpr, w_subtype)
    test = space.interp_w(Node, w_test, can_be_None=False)
    self.test = test
    true_expr = space.interp_w(Node, w_true_expr, can_be_None=False)
    self.true_expr = true_expr
    false_expr = space.interp_w(Node, w_false_expr, can_be_None=False)
    self.false_expr = false_expr
    self.lineno = lineno
    return space.wrap(self)

def descr_CondExpr_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitCondExpr', w_self)

def descr_CondExpr_mutate(space, w_self, w_visitor): 
    w_test = space.getattr(w_self, space.wrap("test"))
    space.setattr(w_test, space.wrap("parent"), w_self)
    w_new_test = space.call_method(w_test, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("test"), w_new_test)

    w_true_expr = space.getattr(w_self, space.wrap("true_expr"))
    space.setattr(w_true_expr, space.wrap("parent"), w_self)
    w_new_true_expr = space.call_method(w_true_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("true_expr"), w_new_true_expr)

    w_false_expr = space.getattr(w_self, space.wrap("false_expr"))
    space.setattr(w_false_expr, space.wrap("parent"), w_self)
    w_new_false_expr = space.call_method(w_false_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("false_expr"), w_new_false_expr)

    return space.call_method(w_visitor, "visitCondExpr", w_self)

CondExpr.typedef = TypeDef('CondExpr', Node.typedef, 
                     __new__ = interp2app(descr_CondExpr_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_CondExpr_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_CondExpr_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    test=GetSetProperty(CondExpr.fget_test, CondExpr.fset_test ),
                    true_expr=GetSetProperty(CondExpr.fget_true_expr, CondExpr.fset_true_expr ),
                    false_expr=GetSetProperty(CondExpr.fget_false_expr, CondExpr.fset_false_expr ),
                    )
CondExpr.typedef.acceptable_as_base_class = False

class Const(Node):
    def __init__(self, value, lineno=-1):
        Node.__init__(self, lineno)
        self.value = value

    def getChildren(self):
        "NOT_RPYTHON"
        return self.value,

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Const(%s)" % (self.value.__repr__(),)

    def accept(self, visitor):
        return visitor.visitConst(self)

    def mutate(self, visitor):
        return visitor.visitConst(self)

    def fget_value( space, self):
        return self.value
    def fset_value( space, self, w_arg):
        self.value = w_arg

def descr_Const_new(space, w_subtype, w_value, lineno=-1):
    self = space.allocate_instance(Const, w_subtype)
    # This dummy assingment is auto-generated, astgen.py should be fixed to avoid that
    value = w_value
    self.value = value
    self.lineno = lineno
    return space.wrap(self)

def descr_Const_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitConst', w_self)

def descr_Const_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitConst", w_self)

Const.typedef = TypeDef('Const', Node.typedef, 
                     __new__ = interp2app(descr_Const_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Const_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Const_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    value=GetSetProperty(Const.fget_value, Const.fset_value ),
                    )
Const.typedef.acceptable_as_base_class = False

class Continue(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Continue()"

    def accept(self, visitor):
        return visitor.visitContinue(self)

    def mutate(self, visitor):
        return visitor.visitContinue(self)


def descr_Continue_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(Continue, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_Continue_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitContinue', w_self)

def descr_Continue_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitContinue", w_self)

Continue.typedef = TypeDef('Continue', Node.typedef, 
                     __new__ = interp2app(descr_Continue_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_Continue_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Continue_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
Continue.typedef.acceptable_as_base_class = False

class Decorators(Node):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Decorators(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitDecorators(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitDecorators(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Decorators_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Decorators, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Decorators_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitDecorators', w_self)

def descr_Decorators_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitDecorators", w_self)

Decorators.typedef = TypeDef('Decorators', Node.typedef, 
                     __new__ = interp2app(descr_Decorators_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Decorators_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Decorators_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Decorators.fget_nodes, Decorators.fset_nodes ),
                     insert_after=interp2app(Decorators.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Decorators, Node, W_Root]),
                     insert_before=interp2app(Decorators.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Decorators, Node, W_Root]),
                    )
Decorators.typedef.acceptable_as_base_class = False

class Dict(Node):
    def __init__(self, items, lineno=-1):
        Node.__init__(self, lineno)
        # items is a list of couples (node (key), node (value))
        self.items = items

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.items))

    def getChildNodes(self):
        nodelist = []
        # items is a list of couples (node (key), node (value))
        for key, value in self.items:
            nodelist.append(key)
            nodelist.append(value)
        return nodelist

    def fset_items( space, self, w_arg ):
        del self.items[:]
        for w_tup in space.unpackiterable( w_arg ):
            w_key = space.getitem( w_tup, space.wrap(0) )
            w_value = space.getitem( w_tup, space.wrap(1) )
            key = space.interp_w(Node, w_key)
            value = space.interp_w(Node, w_value)
            self.items.append( (key,value) )
    
    

    def fget_items(space, self):
        return space.newlist( [ space.newtuple( [ space.wrap(key), space.wrap(value) ] )
                                for key, value in self.items ] )
    

    def __repr__(self):
        return "Dict(%s)" % (self.items.__repr__(),)

    def accept(self, visitor):
        return visitor.visitDict(self)

    def mutate(self, visitor):
        for i in range(len(self.items)):

            n, o = self.items[i]

            self.items[i] = n.mutate(visitor), o.mutate(visitor)

        return visitor.visitDict(self)


def descr_Dict_new(space, w_subtype, w_items, lineno=-1):
    self = space.allocate_instance(Dict, w_subtype)
    items = []
    for w_tuple in space.unpackiterable(w_items):
        w_key = space.getitem(w_tuple, space.wrap(0))
        w_value = space.getitem(w_tuple, space.wrap(1))
        key = space.interp_w(Node, w_key)
        value = space.interp_w(Node, w_value)
        items.append((key, value))
    self.items = items
    self.lineno = lineno
    return space.wrap(self)



def descr_Dict_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitDict', w_self)

def descr_Dict_mutate(space, w_self, w_visitor):
    w_list = space.getattr(w_self, space.wrap("items"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        w_key, w_value = space.unpackiterable(w_item, 2)
        
        w_newkey = space.call_method(w_key, "mutate", w_visitor)
        w_newvalue = space.call_method(w_value, "mutate", w_visitor)
        
        newlist_w.append(space.newtuple([w_newkey, w_newvalue]))
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("items"), w_newlist)
    return space.call_method(w_visitor, "visitDict", w_self)



Dict.typedef = TypeDef('Dict', Node.typedef, 
                     __new__ = interp2app(descr_Dict_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Dict_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Dict_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    items=GetSetProperty(Dict.fget_items, Dict.fset_items ),
                    )
Dict.typedef.acceptable_as_base_class = False

class Discard(Node):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Discard(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitDiscard(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitDiscard(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Discard_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(Discard, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Discard_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitDiscard', w_self)

def descr_Discard_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitDiscard", w_self)

Discard.typedef = TypeDef('Discard', Node.typedef, 
                     __new__ = interp2app(descr_Discard_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Discard_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Discard_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Discard.fget_expr, Discard.fset_expr ),
                    )
Discard.typedef.acceptable_as_base_class = False

class Div(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Div(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitDiv(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitDiv(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Div_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Div, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Div_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitDiv', w_self)

def descr_Div_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitDiv", w_self)

Div.typedef = TypeDef('Div', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Div_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Div_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Div_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Div.fget_left, Div.fset_left ),
                    right=GetSetProperty(Div.fget_right, Div.fset_right ),
                    )
Div.typedef.acceptable_as_base_class = False

class Ellipsis(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Ellipsis()"

    def accept(self, visitor):
        return visitor.visitEllipsis(self)

    def mutate(self, visitor):
        return visitor.visitEllipsis(self)


def descr_Ellipsis_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(Ellipsis, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_Ellipsis_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitEllipsis', w_self)

def descr_Ellipsis_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitEllipsis", w_self)

Ellipsis.typedef = TypeDef('Ellipsis', Node.typedef, 
                     __new__ = interp2app(descr_Ellipsis_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_Ellipsis_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Ellipsis_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
Ellipsis.typedef.acceptable_as_base_class = False

class Exec(Node):
    def __init__(self, expr, locals, globals, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.locals = locals
        self.globals = globals

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.append(self.locals)
        children.append(self.globals)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        if self.locals is not None:
            nodelist.append(self.locals)
        if self.globals is not None:
            nodelist.append(self.globals)
        return nodelist

    def __repr__(self):
        return "Exec(%s, %s, %s)" % (self.expr.__repr__(), self.locals.__repr__(), self.globals.__repr__())

    def accept(self, visitor):
        return visitor.visitExec(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        if self.locals is not None:
            self.locals = self.locals.mutate(visitor)
        if self.globals is not None:
            self.globals = self.globals.mutate(visitor)
        return visitor.visitExec(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_locals( space, self):
        if self.locals is None:
            return space.w_None
        else:
            return space.wrap(self.locals)
    def fset_locals( space, self, w_arg):
        self.locals = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_globals( space, self):
        if self.globals is None:
            return space.w_None
        else:
            return space.wrap(self.globals)
    def fset_globals( space, self, w_arg):
        self.globals = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Exec_new(space, w_subtype, w_expr, w_locals, w_globals, lineno=-1):
    self = space.allocate_instance(Exec, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    locals = space.interp_w(Node, w_locals, can_be_None=True)
    self.locals = locals
    globals = space.interp_w(Node, w_globals, can_be_None=True)
    self.globals = globals
    self.lineno = lineno
    return space.wrap(self)

def descr_Exec_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitExec', w_self)

def descr_Exec_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_locals = space.getattr(w_self, space.wrap("locals"))
    if not space.is_w(w_locals, space.w_None):
        space.setattr(w_locals, space.wrap("parent"), w_self)
        w_new_locals = space.call_method(w_locals, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("locals"), w_new_locals)

    w_globals = space.getattr(w_self, space.wrap("globals"))
    if not space.is_w(w_globals, space.w_None):
        space.setattr(w_globals, space.wrap("parent"), w_self)
        w_new_globals = space.call_method(w_globals, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("globals"), w_new_globals)

    return space.call_method(w_visitor, "visitExec", w_self)

Exec.typedef = TypeDef('Exec', Node.typedef, 
                     __new__ = interp2app(descr_Exec_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Exec_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Exec_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Exec.fget_expr, Exec.fset_expr ),
                    locals=GetSetProperty(Exec.fget_locals, Exec.fset_locals ),
                    globals=GetSetProperty(Exec.fget_globals, Exec.fset_globals ),
                    )
Exec.typedef.acceptable_as_base_class = False

class FloorDiv(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "FloorDiv(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitFloorDiv(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitFloorDiv(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_FloorDiv_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(FloorDiv, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_FloorDiv_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitFloorDiv', w_self)

def descr_FloorDiv_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitFloorDiv", w_self)

FloorDiv.typedef = TypeDef('FloorDiv', BinaryOp.typedef, 
                     __new__ = interp2app(descr_FloorDiv_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_FloorDiv_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_FloorDiv_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(FloorDiv.fget_left, FloorDiv.fset_left ),
                    right=GetSetProperty(FloorDiv.fget_right, FloorDiv.fset_right ),
                    )
FloorDiv.typedef.acceptable_as_base_class = False

class For(Node):
    def __init__(self, assign, list, body, else_, lineno=-1):
        Node.__init__(self, lineno)
        self.assign = assign
        self.list = list
        self.body = body
        self.else_ = else_

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.assign)
        children.append(self.list)
        children.append(self.body)
        children.append(self.else_)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.assign)
        nodelist.append(self.list)
        nodelist.append(self.body)
        if self.else_ is not None:
            nodelist.append(self.else_)
        return nodelist

    def __repr__(self):
        return "For(%s, %s, %s, %s)" % (self.assign.__repr__(), self.list.__repr__(), self.body.__repr__(), self.else_.__repr__())

    def accept(self, visitor):
        return visitor.visitFor(self)

    def mutate(self, visitor):
        self.assign = self.assign.mutate(visitor)
        self.list = self.list.mutate(visitor)
        self.body = self.body.mutate(visitor)
        if self.else_ is not None:
            self.else_ = self.else_.mutate(visitor)
        return visitor.visitFor(self)

    def fget_assign( space, self):
        return space.wrap(self.assign)
    def fset_assign( space, self, w_arg):
        self.assign = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_list( space, self):
        return space.wrap(self.list)
    def fset_list( space, self, w_arg):
        self.list = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_body( space, self):
        return space.wrap(self.body)
    def fset_body( space, self, w_arg):
        self.body = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_else_( space, self):
        if self.else_ is None:
            return space.w_None
        else:
            return space.wrap(self.else_)
    def fset_else_( space, self, w_arg):
        self.else_ = space.interp_w(Node, w_arg, can_be_None=True)

def descr_For_new(space, w_subtype, w_assign, w_list, w_body, w_else_, lineno=-1):
    self = space.allocate_instance(For, w_subtype)
    assign = space.interp_w(Node, w_assign, can_be_None=False)
    self.assign = assign
    list = space.interp_w(Node, w_list, can_be_None=False)
    self.list = list
    body = space.interp_w(Node, w_body, can_be_None=False)
    self.body = body
    else_ = space.interp_w(Node, w_else_, can_be_None=True)
    self.else_ = else_
    self.lineno = lineno
    return space.wrap(self)

def descr_For_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitFor', w_self)

def descr_For_mutate(space, w_self, w_visitor): 
    w_assign = space.getattr(w_self, space.wrap("assign"))
    space.setattr(w_assign, space.wrap("parent"), w_self)
    w_new_assign = space.call_method(w_assign, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("assign"), w_new_assign)

    w_list = space.getattr(w_self, space.wrap("list"))
    space.setattr(w_list, space.wrap("parent"), w_self)
    w_new_list = space.call_method(w_list, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("list"), w_new_list)

    w_body = space.getattr(w_self, space.wrap("body"))
    space.setattr(w_body, space.wrap("parent"), w_self)
    w_new_body = space.call_method(w_body, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("body"), w_new_body)

    w_else_ = space.getattr(w_self, space.wrap("else_"))
    if not space.is_w(w_else_, space.w_None):
        space.setattr(w_else_, space.wrap("parent"), w_self)
        w_new_else_ = space.call_method(w_else_, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("else_"), w_new_else_)

    return space.call_method(w_visitor, "visitFor", w_self)

For.typedef = TypeDef('For', Node.typedef, 
                     __new__ = interp2app(descr_For_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_For_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_For_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    assign=GetSetProperty(For.fget_assign, For.fset_assign ),
                    list=GetSetProperty(For.fget_list, For.fset_list ),
                    body=GetSetProperty(For.fget_body, For.fset_body ),
                    else_=GetSetProperty(For.fget_else_, For.fset_else_ ),
                    )
For.typedef.acceptable_as_base_class = False

class From(Node):
    def __init__(self, modname, names, lineno=-1):
        Node.__init__(self, lineno)
        self.modname = modname
        self.names = names

    def getChildren(self):
        "NOT_RPYTHON"
        return self.modname, self.names

    def getChildNodes(self):
        return []

    def fget_names( space, self ):
        return space.newlist( [ space.newtuple( [ space.wrap(name), space.wrap(as_name) ] )
                                for name, as_name in self.names ] )
    

    def fset_names( space, self, w_arg ):
        del self.names[:]
        for w_tup in space.unpackiterable( w_arg ):
            w_name = space.getitem( w_tup, space.wrap(0) )
            w_as_name = space.getitem( w_tup, space.wrap(1) )
            name = space.str_w( w_name )
            as_name = None
            if not space.is_w( w_as_name, space.w_None ):
                as_name = space.str_w( w_as_name )
            self.names.append( (name, as_name) )
    

    def __repr__(self):
        return "From(%s, %s)" % (self.modname.__repr__(), self.names.__repr__())

    def accept(self, visitor):
        return visitor.visitFrom(self)

    def mutate(self, visitor):
        return visitor.visitFrom(self)

    def fget_modname( space, self):
        return space.wrap(self.modname)
    def fset_modname( space, self, w_arg):
        self.modname = space.str_w(w_arg)

def descr_From_new(space, w_subtype, w_modname, w_names, lineno=-1):
    self = space.allocate_instance(From, w_subtype)
    modname = space.str_w(w_modname)
    self.modname = modname
    names = []
    for w_tuple in space.unpackiterable(w_names):
        w_name = space.getitem(w_tuple, space.wrap(0))
        w_as_name = space.getitem(w_tuple, space.wrap(1))
        name = space.str_w(w_name)
        as_name = None
        if not space.is_w(w_as_name, space.w_None):
            as_name = space.str_w(w_as_name)
        names.append((name, as_name))
    self.names = names
    self.lineno = lineno
    return space.wrap(self)




def descr_From_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitFrom', w_self)

def descr_From_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitFrom", w_self)

From.typedef = TypeDef('From', Node.typedef, 
                     __new__ = interp2app(descr_From_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_From_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_From_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    modname=GetSetProperty(From.fget_modname, From.fset_modname ),
                    names=GetSetProperty(From.fget_names, From.fset_names ),
                    )
From.typedef.acceptable_as_base_class = False

class Function(AbstractFunction):
    def __init__(self, decorators, name, argnames, defaults, flags, w_doc, code, lineno=-1):
        Node.__init__(self, lineno)
        self.decorators = decorators
        self.name = name
        self.argnames = argnames
        self.defaults = defaults
        self.flags = flags
        self.w_doc = w_doc
        self.code = code
        self.varargs = self.kwargs = 0
        if flags & CO_VARARGS:
            self.varargs = 1
        if flags & CO_VARKEYWORDS:
            self.kwargs = 1
    


    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.decorators)
        children.append(self.name)
        children.extend(flatten(self.argnames))
        children.extend(flatten(self.defaults))
        children.append(self.flags)
        children.append(self.w_doc)
        children.append(self.code)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        if self.decorators is not None:
            nodelist.append(self.decorators)
        nodelist.extend(self.argnames)
        nodelist.extend(self.defaults)
        nodelist.append(self.code)
        return nodelist

    def __repr__(self):
        return "Function(%s, %s, %s, %s, %s, %s, %s)" % (self.decorators.__repr__(), self.name.__repr__(), self.argnames.__repr__(), self.defaults.__repr__(), self.flags.__repr__(), self.w_doc.__repr__(), self.code.__repr__())

    def accept(self, visitor):
        return visitor.visitFunction(self)

    def mutate(self, visitor):
        if self.decorators is not None:
            self.decorators = self.decorators.mutate(visitor)
        visitor._mutate_list(self.argnames)
        visitor._mutate_list(self.defaults)
        self.code = self.code.mutate(visitor)
        return visitor.visitFunction(self)

    def fget_decorators( space, self):
        if self.decorators is None:
            return space.w_None
        else:
            return space.wrap(self.decorators)
    def fset_decorators( space, self, w_arg):
        self.decorators = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_name( space, self):
        return space.wrap(self.name)
    def fset_name( space, self, w_arg):
        self.name = space.str_w(w_arg)
    def fget_argnames( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.argnames] )
    def fset_argnames( space, self, w_arg):
        del self.argnames[:]
        for w_itm in space.unpackiterable(w_arg):
            self.argnames.append( space.interp_w(Node, w_itm))
    def fget_defaults( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.defaults] )
    def fset_defaults( space, self, w_arg):
        del self.defaults[:]
        for w_itm in space.unpackiterable(w_arg):
            self.defaults.append( space.interp_w(Node, w_itm))
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)
    def fget_w_doc( space, self):
        return self.w_doc
    def fset_w_doc( space, self, w_arg):
        self.w_doc = w_arg
    def fget_code( space, self):
        return space.wrap(self.code)
    def fset_code( space, self, w_arg):
        self.code = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Function_new(space, w_subtype, w_decorators, w_name, w_argnames, w_defaults, w_flags, w_doc, w_code, lineno=-1):
    self = space.allocate_instance(Function, w_subtype)
    decorators = space.interp_w(Node, w_decorators, can_be_None=True)
    self.decorators = decorators
    name = space.str_w(w_name)
    self.name = name
    argnames = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_argnames)]
    self.argnames = argnames
    defaults = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_defaults)]
    self.defaults = defaults
    flags = space.int_w(w_flags)
    self.flags = flags    
    self.w_doc = w_doc
    code = space.interp_w(Node, w_code, can_be_None=False)
    self.code = code
    self.lineno = lineno

    self.varargs = 0
    self.kwargs = 0
    if flags & CO_VARARGS:
        self.varargs = 1
    if flags & CO_VARKEYWORDS:
        self.kwargs = 1
    return space.wrap(self)



def descr_Function_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitFunction', w_self)

def descr_Function_mutate(space, w_self, w_visitor): 
    w_decorators = space.getattr(w_self, space.wrap("decorators"))
    if not space.is_w(w_decorators, space.w_None):
        space.setattr(w_decorators, space.wrap("parent"), w_self)
        w_new_decorators = space.call_method(w_decorators, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("decorators"), w_new_decorators)

    w_list = space.getattr(w_self, space.wrap("argnames"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("argnames"), w_newlist)
    w_list = space.getattr(w_self, space.wrap("defaults"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("defaults"), w_newlist)
    w_code = space.getattr(w_self, space.wrap("code"))
    space.setattr(w_code, space.wrap("parent"), w_self)
    w_new_code = space.call_method(w_code, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("code"), w_new_code)

    return space.call_method(w_visitor, "visitFunction", w_self)

Function.typedef = TypeDef('Function', AbstractFunction.typedef, 
                     __new__ = interp2app(descr_Function_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Function_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Function_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    decorators=GetSetProperty(Function.fget_decorators, Function.fset_decorators ),
                    name=GetSetProperty(Function.fget_name, Function.fset_name ),
                    argnames=GetSetProperty(Function.fget_argnames, Function.fset_argnames ),
                    defaults=GetSetProperty(Function.fget_defaults, Function.fset_defaults ),
                    flags=GetSetProperty(Function.fget_flags, Function.fset_flags ),
                    w_doc=GetSetProperty(Function.fget_w_doc, Function.fset_w_doc ),
                    code=GetSetProperty(Function.fget_code, Function.fset_code ),
                    )
Function.typedef.acceptable_as_base_class = False

class GenExpr(AbstractFunction):
    def __init__(self, code, lineno=-1):
        Node.__init__(self, lineno)
        self.code = code
        self.argnames = [AssName('[outmost-iterable]', OP_ASSIGN)]
        self.varargs = self.kwargs = 0
    


    def getChildren(self):
        "NOT_RPYTHON"
        return self.code,

    def getChildNodes(self):
        return [self.code,]

    def __repr__(self):
        return "GenExpr(%s)" % (self.code.__repr__(),)

    def accept(self, visitor):
        return visitor.visitGenExpr(self)

    def mutate(self, visitor):
        self.code = self.code.mutate(visitor)
        return visitor.visitGenExpr(self)

    def fget_code( space, self):
        return space.wrap(self.code)
    def fset_code( space, self, w_arg):
        self.code = space.interp_w(Node, w_arg, can_be_None=False)

def descr_GenExpr_new(space, w_subtype, w_code, lineno=-1):
    self = space.allocate_instance(GenExpr, w_subtype)
    code = space.interp_w(Node, w_code, can_be_None=False)
    self.code = code
    self.lineno = lineno
    return space.wrap(self)

def descr_GenExpr_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGenExpr', w_self)

def descr_GenExpr_mutate(space, w_self, w_visitor): 
    w_code = space.getattr(w_self, space.wrap("code"))
    space.setattr(w_code, space.wrap("parent"), w_self)
    w_new_code = space.call_method(w_code, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("code"), w_new_code)

    return space.call_method(w_visitor, "visitGenExpr", w_self)

GenExpr.typedef = TypeDef('GenExpr', AbstractFunction.typedef, 
                     __new__ = interp2app(descr_GenExpr_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_GenExpr_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_GenExpr_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    code=GetSetProperty(GenExpr.fget_code, GenExpr.fset_code ),
                    )
GenExpr.typedef.acceptable_as_base_class = False

class GenExprFor(Node):
    def __init__(self, assign, iter, ifs, lineno=-1):
        Node.__init__(self, lineno)
        self.assign = assign
        self.iter = iter
        self.ifs = ifs
        self.is_outmost = False
    


    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.assign)
        children.append(self.iter)
        children.extend(flatten(self.ifs))
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.assign)
        nodelist.append(self.iter)
        nodelist.extend(self.ifs)
        return nodelist

    def __repr__(self):
        return "GenExprFor(%s, %s, %s)" % (self.assign.__repr__(), self.iter.__repr__(), self.ifs.__repr__())

    def accept(self, visitor):
        return visitor.visitGenExprFor(self)

    def mutate(self, visitor):
        self.assign = self.assign.mutate(visitor)
        self.iter = self.iter.mutate(visitor)
        visitor._mutate_list(self.ifs)
        return visitor.visitGenExprFor(self)

    def fget_assign( space, self):
        return space.wrap(self.assign)
    def fset_assign( space, self, w_arg):
        self.assign = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_iter( space, self):
        return space.wrap(self.iter)
    def fset_iter( space, self, w_arg):
        self.iter = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_ifs( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.ifs] )
    def fset_ifs( space, self, w_arg):
        del self.ifs[:]
        for w_itm in space.unpackiterable(w_arg):
            self.ifs.append( space.interp_w(Node, w_itm))

def descr_GenExprFor_new(space, w_subtype, w_assign, w_iter, w_ifs, lineno=-1):
    self = space.allocate_instance(GenExprFor, w_subtype)
    assign = space.interp_w(Node, w_assign, can_be_None=False)
    self.assign = assign
    iter = space.interp_w(Node, w_iter, can_be_None=False)
    self.iter = iter
    ifs = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_ifs)]
    self.ifs = ifs
    self.lineno = lineno
    return space.wrap(self)

def descr_GenExprFor_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGenExprFor', w_self)

def descr_GenExprFor_mutate(space, w_self, w_visitor): 
    w_assign = space.getattr(w_self, space.wrap("assign"))
    space.setattr(w_assign, space.wrap("parent"), w_self)
    w_new_assign = space.call_method(w_assign, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("assign"), w_new_assign)

    w_iter = space.getattr(w_self, space.wrap("iter"))
    space.setattr(w_iter, space.wrap("parent"), w_self)
    w_new_iter = space.call_method(w_iter, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("iter"), w_new_iter)

    w_list = space.getattr(w_self, space.wrap("ifs"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("ifs"), w_newlist)
    return space.call_method(w_visitor, "visitGenExprFor", w_self)

GenExprFor.typedef = TypeDef('GenExprFor', Node.typedef, 
                     __new__ = interp2app(descr_GenExprFor_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_GenExprFor_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_GenExprFor_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    assign=GetSetProperty(GenExprFor.fget_assign, GenExprFor.fset_assign ),
                    iter=GetSetProperty(GenExprFor.fget_iter, GenExprFor.fset_iter ),
                    ifs=GetSetProperty(GenExprFor.fget_ifs, GenExprFor.fset_ifs ),
                    )
GenExprFor.typedef.acceptable_as_base_class = False

class GenExprIf(Node):
    def __init__(self, test, lineno=-1):
        Node.__init__(self, lineno)
        self.test = test

    def getChildren(self):
        "NOT_RPYTHON"
        return self.test,

    def getChildNodes(self):
        return [self.test,]

    def __repr__(self):
        return "GenExprIf(%s)" % (self.test.__repr__(),)

    def accept(self, visitor):
        return visitor.visitGenExprIf(self)

    def mutate(self, visitor):
        self.test = self.test.mutate(visitor)
        return visitor.visitGenExprIf(self)

    def fget_test( space, self):
        return space.wrap(self.test)
    def fset_test( space, self, w_arg):
        self.test = space.interp_w(Node, w_arg, can_be_None=False)

def descr_GenExprIf_new(space, w_subtype, w_test, lineno=-1):
    self = space.allocate_instance(GenExprIf, w_subtype)
    test = space.interp_w(Node, w_test, can_be_None=False)
    self.test = test
    self.lineno = lineno
    return space.wrap(self)

def descr_GenExprIf_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGenExprIf', w_self)

def descr_GenExprIf_mutate(space, w_self, w_visitor): 
    w_test = space.getattr(w_self, space.wrap("test"))
    space.setattr(w_test, space.wrap("parent"), w_self)
    w_new_test = space.call_method(w_test, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("test"), w_new_test)

    return space.call_method(w_visitor, "visitGenExprIf", w_self)

GenExprIf.typedef = TypeDef('GenExprIf', Node.typedef, 
                     __new__ = interp2app(descr_GenExprIf_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_GenExprIf_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_GenExprIf_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    test=GetSetProperty(GenExprIf.fget_test, GenExprIf.fset_test ),
                    )
GenExprIf.typedef.acceptable_as_base_class = False

class GenExprInner(Node):
    def __init__(self, expr, quals, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.quals = quals

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.extend(flatten(self.quals))
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        nodelist.extend(self.quals)
        return nodelist

    def __repr__(self):
        return "GenExprInner(%s, %s)" % (self.expr.__repr__(), self.quals.__repr__())

    def accept(self, visitor):
        return visitor.visitGenExprInner(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        visitor._mutate_list(self.quals)
        return visitor.visitGenExprInner(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_quals( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.quals] )
    def fset_quals( space, self, w_arg):
        del self.quals[:]
        for w_itm in space.unpackiterable(w_arg):
            self.quals.append( space.interp_w(Node, w_itm))

def descr_GenExprInner_new(space, w_subtype, w_expr, w_quals, lineno=-1):
    self = space.allocate_instance(GenExprInner, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    quals = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_quals)]
    self.quals = quals
    self.lineno = lineno
    return space.wrap(self)

def descr_GenExprInner_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGenExprInner', w_self)

def descr_GenExprInner_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_list = space.getattr(w_self, space.wrap("quals"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("quals"), w_newlist)
    return space.call_method(w_visitor, "visitGenExprInner", w_self)

GenExprInner.typedef = TypeDef('GenExprInner', Node.typedef, 
                     __new__ = interp2app(descr_GenExprInner_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_GenExprInner_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_GenExprInner_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(GenExprInner.fget_expr, GenExprInner.fset_expr ),
                    quals=GetSetProperty(GenExprInner.fget_quals, GenExprInner.fset_quals ),
                    )
GenExprInner.typedef.acceptable_as_base_class = False

class Getattr(Node):
    def __init__(self, expr, attrname, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.attrname = attrname

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr, self.attrname

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Getattr(%s, %s)" % (self.expr.__repr__(), self.attrname.__repr__())

    def accept(self, visitor):
        return visitor.visitGetattr(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitGetattr(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_attrname( space, self):
        return space.wrap(self.attrname)
    def fset_attrname( space, self, w_arg):
        self.attrname = space.str_w(w_arg)

def descr_Getattr_new(space, w_subtype, w_expr, w_attrname, lineno=-1):
    self = space.allocate_instance(Getattr, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    attrname = space.str_w(w_attrname)
    self.attrname = attrname
    self.lineno = lineno
    return space.wrap(self)

def descr_Getattr_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGetattr', w_self)

def descr_Getattr_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitGetattr", w_self)

Getattr.typedef = TypeDef('Getattr', Node.typedef, 
                     __new__ = interp2app(descr_Getattr_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Getattr_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Getattr_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Getattr.fget_expr, Getattr.fset_expr ),
                    attrname=GetSetProperty(Getattr.fget_attrname, Getattr.fset_attrname ),
                    )
Getattr.typedef.acceptable_as_base_class = False

class Global(Node):
    def __init__(self, names, lineno=-1):
        Node.__init__(self, lineno)
        self.names = names

    def getChildren(self):
        "NOT_RPYTHON"
        return self.names,

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Global(%s)" % (self.names.__repr__(),)

    def accept(self, visitor):
        return visitor.visitGlobal(self)

    def mutate(self, visitor):
        return visitor.visitGlobal(self)

    def fget_names( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.names] )
    def fset_names( space, self, w_arg):
        del self.names[:]
        for itm in space.unpackiterable(w_arg):
            self.names.append( space.str_w(itm) )

def descr_Global_new(space, w_subtype, w_names, lineno=-1):
    self = space.allocate_instance(Global, w_subtype)
    names = [space.str_w(w_str) for w_str in space.unpackiterable(w_names)]
    self.names = names
    self.lineno = lineno
    return space.wrap(self)

def descr_Global_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitGlobal', w_self)

def descr_Global_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitGlobal", w_self)

Global.typedef = TypeDef('Global', Node.typedef, 
                     __new__ = interp2app(descr_Global_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Global_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Global_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    names=GetSetProperty(Global.fget_names, Global.fset_names ),
                    )
Global.typedef.acceptable_as_base_class = False

class If(Node):
    def __init__(self, tests, else_, lineno=-1):
        Node.__init__(self, lineno)
        # tests is a list of couples (node (test), node (suite))
        self.tests = tests
        self.else_ = else_

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.extend(flatten(self.tests))
        children.append(self.else_)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        # tests is a list of couples (node (test), node (suite))
        for test, suite in self.tests:
            nodelist.append(test)
            nodelist.append(suite)
        if self.else_ is not None:
            nodelist.append(self.else_)
        return nodelist

    def fset_tests( space, self, w_arg ):
        del self.tests[:]
        for w_tup in space.unpackiterable( w_arg ):
            w_test = space.getitem( w_tup, space.wrap(0) )
            w_suite = space.getitem( w_tup, space.wrap(1) )
            test = space.interp_w(Node, w_test)
            suite = space.interp_w(Node, w_suite)
            self.tests.append( (test,suite) )
    
    

    def fget_tests( space, self ):
        return space.newlist( [ space.newtuple( [ space.wrap(test),
                                                  space.wrap(suite) ] )
                                for test, suite in self.tests ] )
    

    def __repr__(self):
        return "If(%s, %s)" % (self.tests.__repr__(), self.else_.__repr__())

    def accept(self, visitor):
        return visitor.visitIf(self)

    def mutate(self, visitor):
        for i in range(len(self.tests)):

            n, o = self.tests[i]

            self.tests[i] = n.mutate(visitor), o.mutate(visitor)

        if self.else_ is not None:
            self.else_ = self.else_.mutate(visitor)
        return visitor.visitIf(self)

    def fget_else_( space, self):
        if self.else_ is None:
            return space.w_None
        else:
            return space.wrap(self.else_)
    def fset_else_( space, self, w_arg):
        self.else_ = space.interp_w(Node, w_arg, can_be_None=True)

def descr_If_new(space, w_subtype, w_tests, w_else_, lineno=-1):
    self = space.allocate_instance(If, w_subtype)
    tests = []
    for w_tuple in space.unpackiterable(w_tests):
        w_test = space.getitem(w_tuple, space.wrap(0))
        w_suite = space.getitem(w_tuple, space.wrap(1))
        test = space.interp_w(Node, w_test)
        suite = space.interp_w(Node, w_suite)
        tests.append((test, suite))
    self.tests = tests
    self.else_ = space.interp_w(Node, w_else_, can_be_None=True)
    self.lineno = lineno
    return space.wrap(self)



def descr_If_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitIf', w_self)

def descr_If_mutate(space, w_self, w_visitor):
    w_list = space.getattr(w_self, space.wrap("tests"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        w_test, w_suite = space.unpackiterable(w_item, 2)

        w_newtest = space.call_method(w_test, "mutate", w_visitor)
        w_newsuite = space.call_method(w_suite, "mutate", w_visitor)
        newlist_w.append(space.newtuple([w_newtest, w_newsuite]))
    
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("tests"), w_newlist)
    w_else_ = space.getattr(w_self, space.wrap("else_"))
    if not space.is_w(w_else_, space.w_None):
        w_new_else_ = space.call_method(w_else_, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("else_"), w_new_else_)




If.typedef = TypeDef('If', Node.typedef, 
                     __new__ = interp2app(descr_If_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_If_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_If_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    tests=GetSetProperty(If.fget_tests, If.fset_tests ),
                    else_=GetSetProperty(If.fget_else_, If.fset_else_ ),
                    )
If.typedef.acceptable_as_base_class = False

class Import(Node):
    def __init__(self, names, lineno=-1):
        Node.__init__(self, lineno)
        self.names = names

    def getChildren(self):
        "NOT_RPYTHON"
        return self.names,

    def getChildNodes(self):
        return []

    def fget_names( space, self ):
        return space.newlist( [ space.newtuple( [ space.wrap(name), space.wrap(as_name) ] )
                                for name, as_name in self.names ] )
    

    def fset_names( space, self, w_arg ):
        del self.names[:]
        for w_tup in space.unpackiterable( w_arg ):
            w_name = space.getitem( w_tup, space.wrap(0) )
            w_as_name = space.getitem( w_tup, space.wrap(1) )
            name = space.str_w( w_name )
            as_name = None
            if not space.is_w( w_as_name, space.w_None ):
                as_name = space.str_w( w_as_name )
            self.names.append( (name, as_name) )
    

    def __repr__(self):
        return "Import(%s)" % (self.names.__repr__(),)

    def accept(self, visitor):
        return visitor.visitImport(self)

    def mutate(self, visitor):
        return visitor.visitImport(self)


def descr_Import_new(space, w_subtype, w_names, lineno=-1):
    self = space.allocate_instance(Import, w_subtype)
    names = []
    for w_tuple in space.unpackiterable(w_names):
        w_name = space.getitem(w_tuple, space.wrap(0))
        w_as_name = space.getitem(w_tuple, space.wrap(1))
        name = space.str_w(w_name)
        as_name = None
        if not space.is_w(w_as_name, space.w_None):
            as_name = space.str_w(w_as_name)
        names.append((name, as_name))
    self.names = names
    self.lineno = lineno
    return space.wrap(self)



def descr_Import_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitImport', w_self)

def descr_Import_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitImport", w_self)

Import.typedef = TypeDef('Import', Node.typedef, 
                     __new__ = interp2app(descr_Import_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Import_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Import_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    names=GetSetProperty(Import.fget_names, Import.fset_names ),
                    )
Import.typedef.acceptable_as_base_class = False

class Invert(UnaryOp):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Invert(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitInvert(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitInvert(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Invert_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(Invert, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Invert_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitInvert', w_self)

def descr_Invert_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitInvert", w_self)

Invert.typedef = TypeDef('Invert', UnaryOp.typedef, 
                     __new__ = interp2app(descr_Invert_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Invert_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Invert_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Invert.fget_expr, Invert.fset_expr ),
                    )
Invert.typedef.acceptable_as_base_class = False

class Keyword(Node):
    def __init__(self, name, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.name = name
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.name, self.expr

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Keyword(%s, %s)" % (self.name.__repr__(), self.expr.__repr__())

    def accept(self, visitor):
        return visitor.visitKeyword(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitKeyword(self)

    def fget_name( space, self):
        return space.wrap(self.name)
    def fset_name( space, self, w_arg):
        self.name = space.str_w(w_arg)
    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Keyword_new(space, w_subtype, w_name, w_expr, lineno=-1):
    self = space.allocate_instance(Keyword, w_subtype)
    name = space.str_w(w_name)
    self.name = name
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Keyword_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitKeyword', w_self)

def descr_Keyword_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitKeyword", w_self)

Keyword.typedef = TypeDef('Keyword', Node.typedef, 
                     __new__ = interp2app(descr_Keyword_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Keyword_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Keyword_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    name=GetSetProperty(Keyword.fget_name, Keyword.fset_name ),
                    expr=GetSetProperty(Keyword.fget_expr, Keyword.fset_expr ),
                    )
Keyword.typedef.acceptable_as_base_class = False

class Lambda(AbstractFunction):
    def __init__(self, argnames, defaults, flags, code, lineno=-1):
        Node.__init__(self, lineno)
        self.argnames = argnames
        self.defaults = defaults
        self.flags = flags
        self.code = code
        self.varargs = self.kwargs = 0
        if flags & CO_VARARGS:
            self.varargs = 1
        if flags & CO_VARKEYWORDS:
            self.kwargs = 1
    


    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.extend(flatten(self.argnames))
        children.extend(flatten(self.defaults))
        children.append(self.flags)
        children.append(self.code)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.argnames)
        nodelist.extend(self.defaults)
        nodelist.append(self.code)
        return nodelist

    def __repr__(self):
        return "Lambda(%s, %s, %s, %s)" % (self.argnames.__repr__(), self.defaults.__repr__(), self.flags.__repr__(), self.code.__repr__())

    def accept(self, visitor):
        return visitor.visitLambda(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.argnames)
        visitor._mutate_list(self.defaults)
        self.code = self.code.mutate(visitor)
        return visitor.visitLambda(self)

    def fget_argnames( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.argnames] )
    def fset_argnames( space, self, w_arg):
        del self.argnames[:]
        for w_itm in space.unpackiterable(w_arg):
            self.argnames.append( space.interp_w(Node, w_itm))
    def fget_defaults( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.defaults] )
    def fset_defaults( space, self, w_arg):
        del self.defaults[:]
        for w_itm in space.unpackiterable(w_arg):
            self.defaults.append( space.interp_w(Node, w_itm))
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)
    def fget_code( space, self):
        return space.wrap(self.code)
    def fset_code( space, self, w_arg):
        self.code = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Lambda_new(space, w_subtype, w_argnames, w_defaults, w_flags, w_code, lineno=-1):
    self = space.allocate_instance(Lambda, w_subtype)
    argnames = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_argnames)]
    self.argnames = argnames
    defaults = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_defaults)]
    self.defaults = defaults
    flags = space.int_w(w_flags)
    self.flags = flags
    code = space.interp_w(Node, w_code, can_be_None=False)
    self.code = code
    self.lineno = lineno
    self.varargs = 0
    self.kwargs = 0
    if flags & CO_VARARGS:
        self.varargs = 1
    if flags & CO_VARKEYWORDS:
        self.kwargs = 1
    return space.wrap(self)



def descr_Lambda_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitLambda', w_self)

def descr_Lambda_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("argnames"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("argnames"), w_newlist)
    w_list = space.getattr(w_self, space.wrap("defaults"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("defaults"), w_newlist)
    w_code = space.getattr(w_self, space.wrap("code"))
    space.setattr(w_code, space.wrap("parent"), w_self)
    w_new_code = space.call_method(w_code, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("code"), w_new_code)

    return space.call_method(w_visitor, "visitLambda", w_self)

Lambda.typedef = TypeDef('Lambda', AbstractFunction.typedef, 
                     __new__ = interp2app(descr_Lambda_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Lambda_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Lambda_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    argnames=GetSetProperty(Lambda.fget_argnames, Lambda.fset_argnames ),
                    defaults=GetSetProperty(Lambda.fget_defaults, Lambda.fset_defaults ),
                    flags=GetSetProperty(Lambda.fget_flags, Lambda.fset_flags ),
                    code=GetSetProperty(Lambda.fget_code, Lambda.fset_code ),
                    )
Lambda.typedef.acceptable_as_base_class = False

class LeftShift(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "LeftShift(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitLeftShift(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitLeftShift(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_LeftShift_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(LeftShift, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_LeftShift_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitLeftShift', w_self)

def descr_LeftShift_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitLeftShift", w_self)

LeftShift.typedef = TypeDef('LeftShift', BinaryOp.typedef, 
                     __new__ = interp2app(descr_LeftShift_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_LeftShift_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_LeftShift_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(LeftShift.fget_left, LeftShift.fset_left ),
                    right=GetSetProperty(LeftShift.fget_right, LeftShift.fset_right ),
                    )
LeftShift.typedef.acceptable_as_base_class = False

class List(Node):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "List(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitList(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitList(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_List_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(List, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_List_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitList', w_self)

def descr_List_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitList", w_self)

List.typedef = TypeDef('List', Node.typedef, 
                     __new__ = interp2app(descr_List_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_List_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_List_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(List.fget_nodes, List.fset_nodes ),
                     insert_after=interp2app(List.descr_insert_after.im_func, unwrap_spec=[ObjSpace, List, Node, W_Root]),
                     insert_before=interp2app(List.descr_insert_before.im_func, unwrap_spec=[ObjSpace, List, Node, W_Root]),
                    )
List.typedef.acceptable_as_base_class = False

class ListComp(Node):
    def __init__(self, expr, quals, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.quals = quals

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.extend(flatten(self.quals))
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        nodelist.extend(self.quals)
        return nodelist

    def __repr__(self):
        return "ListComp(%s, %s)" % (self.expr.__repr__(), self.quals.__repr__())

    def accept(self, visitor):
        return visitor.visitListComp(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        visitor._mutate_list(self.quals)
        return visitor.visitListComp(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_quals( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.quals] )
    def fset_quals( space, self, w_arg):
        del self.quals[:]
        for w_itm in space.unpackiterable(w_arg):
            self.quals.append( space.interp_w(Node, w_itm))

def descr_ListComp_new(space, w_subtype, w_expr, w_quals, lineno=-1):
    self = space.allocate_instance(ListComp, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    quals = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_quals)]
    self.quals = quals
    self.lineno = lineno
    return space.wrap(self)

def descr_ListComp_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitListComp', w_self)

def descr_ListComp_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_list = space.getattr(w_self, space.wrap("quals"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("quals"), w_newlist)
    return space.call_method(w_visitor, "visitListComp", w_self)

ListComp.typedef = TypeDef('ListComp', Node.typedef, 
                     __new__ = interp2app(descr_ListComp_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_ListComp_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_ListComp_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(ListComp.fget_expr, ListComp.fset_expr ),
                    quals=GetSetProperty(ListComp.fget_quals, ListComp.fset_quals ),
                    )
ListComp.typedef.acceptable_as_base_class = False

class ListCompFor(Node):
    def __init__(self, assign, list, ifs, lineno=-1):
        Node.__init__(self, lineno)
        self.assign = assign
        self.list = list
        self.ifs = ifs

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.assign)
        children.append(self.list)
        children.extend(flatten(self.ifs))
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.assign)
        nodelist.append(self.list)
        nodelist.extend(self.ifs)
        return nodelist

    def __repr__(self):
        return "ListCompFor(%s, %s, %s)" % (self.assign.__repr__(), self.list.__repr__(), self.ifs.__repr__())

    def accept(self, visitor):
        return visitor.visitListCompFor(self)

    def mutate(self, visitor):
        self.assign = self.assign.mutate(visitor)
        self.list = self.list.mutate(visitor)
        visitor._mutate_list(self.ifs)
        return visitor.visitListCompFor(self)

    def fget_assign( space, self):
        return space.wrap(self.assign)
    def fset_assign( space, self, w_arg):
        self.assign = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_list( space, self):
        return space.wrap(self.list)
    def fset_list( space, self, w_arg):
        self.list = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_ifs( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.ifs] )
    def fset_ifs( space, self, w_arg):
        del self.ifs[:]
        for w_itm in space.unpackiterable(w_arg):
            self.ifs.append( space.interp_w(Node, w_itm))

def descr_ListCompFor_new(space, w_subtype, w_assign, w_list, w_ifs, lineno=-1):
    self = space.allocate_instance(ListCompFor, w_subtype)
    assign = space.interp_w(Node, w_assign, can_be_None=False)
    self.assign = assign
    list = space.interp_w(Node, w_list, can_be_None=False)
    self.list = list
    ifs = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_ifs)]
    self.ifs = ifs
    self.lineno = lineno
    return space.wrap(self)

def descr_ListCompFor_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitListCompFor', w_self)

def descr_ListCompFor_mutate(space, w_self, w_visitor): 
    w_assign = space.getattr(w_self, space.wrap("assign"))
    space.setattr(w_assign, space.wrap("parent"), w_self)
    w_new_assign = space.call_method(w_assign, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("assign"), w_new_assign)

    w_list = space.getattr(w_self, space.wrap("list"))
    space.setattr(w_list, space.wrap("parent"), w_self)
    w_new_list = space.call_method(w_list, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("list"), w_new_list)

    w_list = space.getattr(w_self, space.wrap("ifs"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("ifs"), w_newlist)
    return space.call_method(w_visitor, "visitListCompFor", w_self)

ListCompFor.typedef = TypeDef('ListCompFor', Node.typedef, 
                     __new__ = interp2app(descr_ListCompFor_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_ListCompFor_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_ListCompFor_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    assign=GetSetProperty(ListCompFor.fget_assign, ListCompFor.fset_assign ),
                    list=GetSetProperty(ListCompFor.fget_list, ListCompFor.fset_list ),
                    ifs=GetSetProperty(ListCompFor.fget_ifs, ListCompFor.fset_ifs ),
                    )
ListCompFor.typedef.acceptable_as_base_class = False

class ListCompIf(Node):
    def __init__(self, test, lineno=-1):
        Node.__init__(self, lineno)
        self.test = test

    def getChildren(self):
        "NOT_RPYTHON"
        return self.test,

    def getChildNodes(self):
        return [self.test,]

    def __repr__(self):
        return "ListCompIf(%s)" % (self.test.__repr__(),)

    def accept(self, visitor):
        return visitor.visitListCompIf(self)

    def mutate(self, visitor):
        self.test = self.test.mutate(visitor)
        return visitor.visitListCompIf(self)

    def fget_test( space, self):
        return space.wrap(self.test)
    def fset_test( space, self, w_arg):
        self.test = space.interp_w(Node, w_arg, can_be_None=False)

def descr_ListCompIf_new(space, w_subtype, w_test, lineno=-1):
    self = space.allocate_instance(ListCompIf, w_subtype)
    test = space.interp_w(Node, w_test, can_be_None=False)
    self.test = test
    self.lineno = lineno
    return space.wrap(self)

def descr_ListCompIf_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitListCompIf', w_self)

def descr_ListCompIf_mutate(space, w_self, w_visitor): 
    w_test = space.getattr(w_self, space.wrap("test"))
    space.setattr(w_test, space.wrap("parent"), w_self)
    w_new_test = space.call_method(w_test, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("test"), w_new_test)

    return space.call_method(w_visitor, "visitListCompIf", w_self)

ListCompIf.typedef = TypeDef('ListCompIf', Node.typedef, 
                     __new__ = interp2app(descr_ListCompIf_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_ListCompIf_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_ListCompIf_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    test=GetSetProperty(ListCompIf.fget_test, ListCompIf.fset_test ),
                    )
ListCompIf.typedef.acceptable_as_base_class = False

class Mod(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Mod(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitMod(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitMod(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Mod_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Mod, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Mod_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitMod', w_self)

def descr_Mod_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitMod", w_self)

Mod.typedef = TypeDef('Mod', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Mod_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Mod_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Mod_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Mod.fget_left, Mod.fset_left ),
                    right=GetSetProperty(Mod.fget_right, Mod.fset_right ),
                    )
Mod.typedef.acceptable_as_base_class = False

class Module(Node):
    def __init__(self, w_doc, node, lineno=-1):
        Node.__init__(self, lineno)
        self.w_doc = w_doc
        self.node = node

    def getChildren(self):
        "NOT_RPYTHON"
        return self.w_doc, self.node

    def getChildNodes(self):
        return [self.node,]

    def __repr__(self):
        return "Module(%s, %s)" % (self.w_doc.__repr__(), self.node.__repr__())

    def accept(self, visitor):
        return visitor.visitModule(self)

    def mutate(self, visitor):
        self.node = self.node.mutate(visitor)
        return visitor.visitModule(self)

    def fget_w_doc( space, self):
        return self.w_doc
    def fset_w_doc( space, self, w_arg):
        self.w_doc = w_arg
    def fget_node( space, self):
        return space.wrap(self.node)
    def fset_node( space, self, w_arg):
        self.node = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Module_new(space, w_subtype, w_w_doc, w_node, lineno=-1):
    self = space.allocate_instance(Module, w_subtype)
    # This dummy assingment is auto-generated, astgen.py should be fixed to avoid that
    w_doc = w_w_doc
    self.w_doc = w_doc
    node = space.interp_w(Node, w_node, can_be_None=False)
    self.node = node
    self.lineno = lineno
    return space.wrap(self)

def descr_Module_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitModule', w_self)

def descr_Module_mutate(space, w_self, w_visitor): 
    w_node = space.getattr(w_self, space.wrap("node"))
    space.setattr(w_node, space.wrap("parent"), w_self)
    w_new_node = space.call_method(w_node, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("node"), w_new_node)

    return space.call_method(w_visitor, "visitModule", w_self)

Module.typedef = TypeDef('Module', Node.typedef, 
                     __new__ = interp2app(descr_Module_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Module_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Module_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    w_doc=GetSetProperty(Module.fget_w_doc, Module.fset_w_doc ),
                    node=GetSetProperty(Module.fget_node, Module.fset_node ),
                    )
Module.typedef.acceptable_as_base_class = False

class Mul(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Mul(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitMul(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitMul(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Mul_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Mul, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Mul_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitMul', w_self)

def descr_Mul_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitMul", w_self)

Mul.typedef = TypeDef('Mul', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Mul_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Mul_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Mul_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Mul.fget_left, Mul.fset_left ),
                    right=GetSetProperty(Mul.fget_right, Mul.fset_right ),
                    )
Mul.typedef.acceptable_as_base_class = False

class Name(Node):
    def __init__(self, varname, lineno=-1):
        Node.__init__(self, lineno)
        self.varname = varname

    def getChildren(self):
        "NOT_RPYTHON"
        return self.varname,

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Name(%s)" % (self.varname.__repr__(),)

    def accept(self, visitor):
        return visitor.visitName(self)

    def mutate(self, visitor):
        return visitor.visitName(self)

    def fget_varname( space, self):
        return space.wrap(self.varname)
    def fset_varname( space, self, w_arg):
        self.varname = space.str_w(w_arg)

def descr_Name_new(space, w_subtype, w_varname, lineno=-1):
    self = space.allocate_instance(Name, w_subtype)
    varname = space.str_w(w_varname)
    self.varname = varname
    self.lineno = lineno
    return space.wrap(self)

def descr_Name_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitName', w_self)

def descr_Name_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitName", w_self)

Name.typedef = TypeDef('Name', Node.typedef, 
                     __new__ = interp2app(descr_Name_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Name_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Name_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    varname=GetSetProperty(Name.fget_varname, Name.fset_varname ),
                    )
Name.typedef.acceptable_as_base_class = False

class NoneConst(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "NoneConst()"

    def accept(self, visitor):
        return visitor.visitNoneConst(self)

    def mutate(self, visitor):
        return visitor.visitNoneConst(self)


def descr_NoneConst_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(NoneConst, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_NoneConst_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitNoneConst', w_self)

def descr_NoneConst_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitNoneConst", w_self)

NoneConst.typedef = TypeDef('NoneConst', Node.typedef, 
                     __new__ = interp2app(descr_NoneConst_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_NoneConst_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_NoneConst_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
NoneConst.typedef.acceptable_as_base_class = False

class Not(UnaryOp):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "Not(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitNot(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitNot(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Not_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(Not, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_Not_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitNot', w_self)

def descr_Not_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitNot", w_self)

Not.typedef = TypeDef('Not', UnaryOp.typedef, 
                     __new__ = interp2app(descr_Not_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Not_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Not_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Not.fget_expr, Not.fset_expr ),
                    )
Not.typedef.acceptable_as_base_class = False

class Or(AbstractTest):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Or(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitOr(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitOr(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Or_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Or, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Or_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitOr', w_self)

def descr_Or_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitOr", w_self)

Or.typedef = TypeDef('Or', AbstractTest.typedef, 
                     __new__ = interp2app(descr_Or_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Or_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Or_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Or.fget_nodes, Or.fset_nodes ),
                     insert_after=interp2app(Or.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Or, Node, W_Root]),
                     insert_before=interp2app(Or.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Or, Node, W_Root]),
                    )
Or.typedef.acceptable_as_base_class = False

class Pass(Node):
    def __init__(self, lineno=-1):
        Node.__init__(self, lineno)

    def getChildren(self):
        "NOT_RPYTHON"
        return []

    def getChildNodes(self):
        return []

    def __repr__(self):
        return "Pass()"

    def accept(self, visitor):
        return visitor.visitPass(self)

    def mutate(self, visitor):
        return visitor.visitPass(self)


def descr_Pass_new(space, w_subtype, lineno=-1):
    self = space.allocate_instance(Pass, w_subtype)
    self.lineno = lineno
    return space.wrap(self)

def descr_Pass_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitPass', w_self)

def descr_Pass_mutate(space, w_self, w_visitor): 
    return space.call_method(w_visitor, "visitPass", w_self)

Pass.typedef = TypeDef('Pass', Node.typedef, 
                     __new__ = interp2app(descr_Pass_new, unwrap_spec=[ObjSpace, W_Root, int]),
                     accept=interp2app(descr_Pass_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Pass_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    )
Pass.typedef.acceptable_as_base_class = False

class Power(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Power(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitPower(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitPower(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Power_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Power, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Power_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitPower', w_self)

def descr_Power_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitPower", w_self)

Power.typedef = TypeDef('Power', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Power_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Power_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Power_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Power.fget_left, Power.fset_left ),
                    right=GetSetProperty(Power.fget_right, Power.fset_right ),
                    )
Power.typedef.acceptable_as_base_class = False

class Print(Node):
    def __init__(self, nodes, dest, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes
        self.dest = dest

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.extend(flatten(self.nodes))
        children.append(self.dest)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        if self.dest is not None:
            nodelist.append(self.dest)
        return nodelist

    def __repr__(self):
        return "Print(%s, %s)" % (self.nodes.__repr__(), self.dest.__repr__())

    def accept(self, visitor):
        return visitor.visitPrint(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        if self.dest is not None:
            self.dest = self.dest.mutate(visitor)
        return visitor.visitPrint(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes
    def fget_dest( space, self):
        if self.dest is None:
            return space.w_None
        else:
            return space.wrap(self.dest)
    def fset_dest( space, self, w_arg):
        self.dest = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Print_new(space, w_subtype, w_nodes, w_dest, lineno=-1):
    self = space.allocate_instance(Print, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    dest = space.interp_w(Node, w_dest, can_be_None=True)
    self.dest = dest
    self.lineno = lineno
    return space.wrap(self)

def descr_Print_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitPrint', w_self)

def descr_Print_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    w_dest = space.getattr(w_self, space.wrap("dest"))
    if not space.is_w(w_dest, space.w_None):
        space.setattr(w_dest, space.wrap("parent"), w_self)
        w_new_dest = space.call_method(w_dest, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("dest"), w_new_dest)

    return space.call_method(w_visitor, "visitPrint", w_self)

Print.typedef = TypeDef('Print', Node.typedef, 
                     __new__ = interp2app(descr_Print_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Print_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Print_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Print.fget_nodes, Print.fset_nodes ),
                     insert_after=interp2app(Print.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Print, Node, W_Root]),
                     insert_before=interp2app(Print.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Print, Node, W_Root]),
                    dest=GetSetProperty(Print.fget_dest, Print.fset_dest ),
                    )
Print.typedef.acceptable_as_base_class = False

class Printnl(Node):
    def __init__(self, nodes, dest, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes
        self.dest = dest

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.extend(flatten(self.nodes))
        children.append(self.dest)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        if self.dest is not None:
            nodelist.append(self.dest)
        return nodelist

    def __repr__(self):
        return "Printnl(%s, %s)" % (self.nodes.__repr__(), self.dest.__repr__())

    def accept(self, visitor):
        return visitor.visitPrintnl(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        if self.dest is not None:
            self.dest = self.dest.mutate(visitor)
        return visitor.visitPrintnl(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes
    def fget_dest( space, self):
        if self.dest is None:
            return space.w_None
        else:
            return space.wrap(self.dest)
    def fset_dest( space, self, w_arg):
        self.dest = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Printnl_new(space, w_subtype, w_nodes, w_dest, lineno=-1):
    self = space.allocate_instance(Printnl, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    dest = space.interp_w(Node, w_dest, can_be_None=True)
    self.dest = dest
    self.lineno = lineno
    return space.wrap(self)

def descr_Printnl_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitPrintnl', w_self)

def descr_Printnl_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    w_dest = space.getattr(w_self, space.wrap("dest"))
    if not space.is_w(w_dest, space.w_None):
        space.setattr(w_dest, space.wrap("parent"), w_self)
        w_new_dest = space.call_method(w_dest, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("dest"), w_new_dest)

    return space.call_method(w_visitor, "visitPrintnl", w_self)

Printnl.typedef = TypeDef('Printnl', Node.typedef, 
                     __new__ = interp2app(descr_Printnl_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Printnl_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Printnl_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Printnl.fget_nodes, Printnl.fset_nodes ),
                     insert_after=interp2app(Printnl.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Printnl, Node, W_Root]),
                     insert_before=interp2app(Printnl.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Printnl, Node, W_Root]),
                    dest=GetSetProperty(Printnl.fget_dest, Printnl.fset_dest ),
                    )
Printnl.typedef.acceptable_as_base_class = False

class Raise(Node):
    def __init__(self, expr1, expr2, expr3, lineno=-1):
        Node.__init__(self, lineno)
        self.expr1 = expr1
        self.expr2 = expr2
        self.expr3 = expr3

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr1)
        children.append(self.expr2)
        children.append(self.expr3)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        if self.expr1 is not None:
            nodelist.append(self.expr1)
        if self.expr2 is not None:
            nodelist.append(self.expr2)
        if self.expr3 is not None:
            nodelist.append(self.expr3)
        return nodelist

    def __repr__(self):
        return "Raise(%s, %s, %s)" % (self.expr1.__repr__(), self.expr2.__repr__(), self.expr3.__repr__())

    def accept(self, visitor):
        return visitor.visitRaise(self)

    def mutate(self, visitor):
        if self.expr1 is not None:
            self.expr1 = self.expr1.mutate(visitor)
        if self.expr2 is not None:
            self.expr2 = self.expr2.mutate(visitor)
        if self.expr3 is not None:
            self.expr3 = self.expr3.mutate(visitor)
        return visitor.visitRaise(self)

    def fget_expr1( space, self):
        if self.expr1 is None:
            return space.w_None
        else:
            return space.wrap(self.expr1)
    def fset_expr1( space, self, w_arg):
        self.expr1 = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_expr2( space, self):
        if self.expr2 is None:
            return space.w_None
        else:
            return space.wrap(self.expr2)
    def fset_expr2( space, self, w_arg):
        self.expr2 = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_expr3( space, self):
        if self.expr3 is None:
            return space.w_None
        else:
            return space.wrap(self.expr3)
    def fset_expr3( space, self, w_arg):
        self.expr3 = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Raise_new(space, w_subtype, w_expr1, w_expr2, w_expr3, lineno=-1):
    self = space.allocate_instance(Raise, w_subtype)
    expr1 = space.interp_w(Node, w_expr1, can_be_None=True)
    self.expr1 = expr1
    expr2 = space.interp_w(Node, w_expr2, can_be_None=True)
    self.expr2 = expr2
    expr3 = space.interp_w(Node, w_expr3, can_be_None=True)
    self.expr3 = expr3
    self.lineno = lineno
    return space.wrap(self)

def descr_Raise_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitRaise', w_self)

def descr_Raise_mutate(space, w_self, w_visitor): 
    w_expr1 = space.getattr(w_self, space.wrap("expr1"))
    if not space.is_w(w_expr1, space.w_None):
        space.setattr(w_expr1, space.wrap("parent"), w_self)
        w_new_expr1 = space.call_method(w_expr1, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("expr1"), w_new_expr1)

    w_expr2 = space.getattr(w_self, space.wrap("expr2"))
    if not space.is_w(w_expr2, space.w_None):
        space.setattr(w_expr2, space.wrap("parent"), w_self)
        w_new_expr2 = space.call_method(w_expr2, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("expr2"), w_new_expr2)

    w_expr3 = space.getattr(w_self, space.wrap("expr3"))
    if not space.is_w(w_expr3, space.w_None):
        space.setattr(w_expr3, space.wrap("parent"), w_self)
        w_new_expr3 = space.call_method(w_expr3, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("expr3"), w_new_expr3)

    return space.call_method(w_visitor, "visitRaise", w_self)

Raise.typedef = TypeDef('Raise', Node.typedef, 
                     __new__ = interp2app(descr_Raise_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Raise_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Raise_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr1=GetSetProperty(Raise.fget_expr1, Raise.fset_expr1 ),
                    expr2=GetSetProperty(Raise.fget_expr2, Raise.fset_expr2 ),
                    expr3=GetSetProperty(Raise.fget_expr3, Raise.fset_expr3 ),
                    )
Raise.typedef.acceptable_as_base_class = False

class Return(Node):
    def __init__(self, value, lineno=-1):
        Node.__init__(self, lineno)
        self.value = value

    def getChildren(self):
        "NOT_RPYTHON"
        return (self.value,)

    def getChildNodes(self):
        nodelist = []
        if self.value is not None:
            nodelist.append(self.value)
        return nodelist

    def __repr__(self):
        return "Return(%s)" % (self.value.__repr__(),)

    def accept(self, visitor):
        return visitor.visitReturn(self)

    def mutate(self, visitor):
        if self.value is not None:
            self.value = self.value.mutate(visitor)
        return visitor.visitReturn(self)

    def fget_value( space, self):
        if self.value is None:
            return space.w_None
        else:
            return space.wrap(self.value)
    def fset_value( space, self, w_arg):
        self.value = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Return_new(space, w_subtype, w_value, lineno=-1):
    self = space.allocate_instance(Return, w_subtype)
    value = space.interp_w(Node, w_value, can_be_None=True)
    self.value = value
    self.lineno = lineno
    return space.wrap(self)

def descr_Return_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitReturn', w_self)

def descr_Return_mutate(space, w_self, w_visitor): 
    w_value = space.getattr(w_self, space.wrap("value"))
    if not space.is_w(w_value, space.w_None):
        space.setattr(w_value, space.wrap("parent"), w_self)
        w_new_value = space.call_method(w_value, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("value"), w_new_value)

    return space.call_method(w_visitor, "visitReturn", w_self)

Return.typedef = TypeDef('Return', Node.typedef, 
                     __new__ = interp2app(descr_Return_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Return_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Return_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    value=GetSetProperty(Return.fget_value, Return.fset_value ),
                    )
Return.typedef.acceptable_as_base_class = False

class RightShift(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "RightShift(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitRightShift(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitRightShift(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_RightShift_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(RightShift, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_RightShift_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitRightShift', w_self)

def descr_RightShift_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitRightShift", w_self)

RightShift.typedef = TypeDef('RightShift', BinaryOp.typedef, 
                     __new__ = interp2app(descr_RightShift_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_RightShift_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_RightShift_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(RightShift.fget_left, RightShift.fset_left ),
                    right=GetSetProperty(RightShift.fget_right, RightShift.fset_right ),
                    )
RightShift.typedef.acceptable_as_base_class = False

class Slice(Node):
    def __init__(self, expr, flags, lower, upper, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.flags = flags
        self.lower = lower
        self.upper = upper

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.append(self.flags)
        children.append(self.lower)
        children.append(self.upper)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        if self.lower is not None:
            nodelist.append(self.lower)
        if self.upper is not None:
            nodelist.append(self.upper)
        return nodelist

    def __repr__(self):
        return "Slice(%s, %s, %s, %s)" % (self.expr.__repr__(), self.flags.__repr__(), self.lower.__repr__(), self.upper.__repr__())

    def accept(self, visitor):
        return visitor.visitSlice(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        if self.lower is not None:
            self.lower = self.lower.mutate(visitor)
        if self.upper is not None:
            self.upper = self.upper.mutate(visitor)
        return visitor.visitSlice(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)
    def fget_lower( space, self):
        if self.lower is None:
            return space.w_None
        else:
            return space.wrap(self.lower)
    def fset_lower( space, self, w_arg):
        self.lower = space.interp_w(Node, w_arg, can_be_None=True)
    def fget_upper( space, self):
        if self.upper is None:
            return space.w_None
        else:
            return space.wrap(self.upper)
    def fset_upper( space, self, w_arg):
        self.upper = space.interp_w(Node, w_arg, can_be_None=True)

def descr_Slice_new(space, w_subtype, w_expr, w_flags, w_lower, w_upper, lineno=-1):
    self = space.allocate_instance(Slice, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    flags = space.int_w(w_flags)
    self.flags = flags
    lower = space.interp_w(Node, w_lower, can_be_None=True)
    self.lower = lower
    upper = space.interp_w(Node, w_upper, can_be_None=True)
    self.upper = upper
    self.lineno = lineno
    return space.wrap(self)

def descr_Slice_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitSlice', w_self)

def descr_Slice_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_lower = space.getattr(w_self, space.wrap("lower"))
    if not space.is_w(w_lower, space.w_None):
        space.setattr(w_lower, space.wrap("parent"), w_self)
        w_new_lower = space.call_method(w_lower, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("lower"), w_new_lower)

    w_upper = space.getattr(w_self, space.wrap("upper"))
    if not space.is_w(w_upper, space.w_None):
        space.setattr(w_upper, space.wrap("parent"), w_self)
        w_new_upper = space.call_method(w_upper, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("upper"), w_new_upper)

    return space.call_method(w_visitor, "visitSlice", w_self)

Slice.typedef = TypeDef('Slice', Node.typedef, 
                     __new__ = interp2app(descr_Slice_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Slice_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Slice_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Slice.fget_expr, Slice.fset_expr ),
                    flags=GetSetProperty(Slice.fget_flags, Slice.fset_flags ),
                    lower=GetSetProperty(Slice.fget_lower, Slice.fset_lower ),
                    upper=GetSetProperty(Slice.fget_upper, Slice.fset_upper ),
                    )
Slice.typedef.acceptable_as_base_class = False

class Sliceobj(Node):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Sliceobj(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitSliceobj(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitSliceobj(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Sliceobj_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Sliceobj, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Sliceobj_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitSliceobj', w_self)

def descr_Sliceobj_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitSliceobj", w_self)

Sliceobj.typedef = TypeDef('Sliceobj', Node.typedef, 
                     __new__ = interp2app(descr_Sliceobj_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Sliceobj_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Sliceobj_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Sliceobj.fget_nodes, Sliceobj.fset_nodes ),
                     insert_after=interp2app(Sliceobj.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Sliceobj, Node, W_Root]),
                     insert_before=interp2app(Sliceobj.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Sliceobj, Node, W_Root]),
                    )
Sliceobj.typedef.acceptable_as_base_class = False

class Stmt(Node):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Stmt(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitStmt(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitStmt(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Stmt_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Stmt, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Stmt_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitStmt', w_self)

def descr_Stmt_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitStmt", w_self)

Stmt.typedef = TypeDef('Stmt', Node.typedef, 
                     __new__ = interp2app(descr_Stmt_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Stmt_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Stmt_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Stmt.fget_nodes, Stmt.fset_nodes ),
                     insert_after=interp2app(Stmt.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Stmt, Node, W_Root]),
                     insert_before=interp2app(Stmt.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Stmt, Node, W_Root]),
                    )
Stmt.typedef.acceptable_as_base_class = False

class Sub(BinaryOp):
    def __init__(self, left, right, lineno=-1):
        Node.__init__(self, lineno)
        self.left = left
        self.right = right

    def getChildren(self):
        "NOT_RPYTHON"
        return self.left, self.right

    def getChildNodes(self):
        return [self.left, self.right]

    def __repr__(self):
        return "Sub(%s, %s)" % (self.left.__repr__(), self.right.__repr__())

    def accept(self, visitor):
        return visitor.visitSub(self)

    def mutate(self, visitor):
        self.left = self.left.mutate(visitor)
        self.right = self.right.mutate(visitor)
        return visitor.visitSub(self)

    def fget_left( space, self):
        return space.wrap(self.left)
    def fset_left( space, self, w_arg):
        self.left = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_right( space, self):
        return space.wrap(self.right)
    def fset_right( space, self, w_arg):
        self.right = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Sub_new(space, w_subtype, w_left, w_right, lineno=-1):
    self = space.allocate_instance(Sub, w_subtype)
    left = space.interp_w(Node, w_left, can_be_None=False)
    self.left = left
    right = space.interp_w(Node, w_right, can_be_None=False)
    self.right = right
    self.lineno = lineno
    return space.wrap(self)

def descr_Sub_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitSub', w_self)

def descr_Sub_mutate(space, w_self, w_visitor): 
    w_left = space.getattr(w_self, space.wrap("left"))
    space.setattr(w_left, space.wrap("parent"), w_self)
    w_new_left = space.call_method(w_left, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("left"), w_new_left)

    w_right = space.getattr(w_self, space.wrap("right"))
    space.setattr(w_right, space.wrap("parent"), w_self)
    w_new_right = space.call_method(w_right, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("right"), w_new_right)

    return space.call_method(w_visitor, "visitSub", w_self)

Sub.typedef = TypeDef('Sub', BinaryOp.typedef, 
                     __new__ = interp2app(descr_Sub_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Sub_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Sub_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    left=GetSetProperty(Sub.fget_left, Sub.fset_left ),
                    right=GetSetProperty(Sub.fget_right, Sub.fset_right ),
                    )
Sub.typedef.acceptable_as_base_class = False

class Subscript(Node):
    def __init__(self, expr, flags, sub, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.flags = flags
        self.sub = sub

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr, self.flags, self.sub

    def getChildNodes(self):
        return [self.expr, self.sub]

    def __repr__(self):
        return "Subscript(%s, %s, %s)" % (self.expr.__repr__(), self.flags.__repr__(), self.sub.__repr__())

    def accept(self, visitor):
        return visitor.visitSubscript(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        self.sub = self.sub.mutate(visitor)
        return visitor.visitSubscript(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_flags( space, self):
        return space.wrap(self.flags)
    def fset_flags( space, self, w_arg):
        self.flags = space.int_w(w_arg)
    def fget_sub( space, self):
        return space.wrap(self.sub)
    def fset_sub( space, self, w_arg):
        self.sub = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Subscript_new(space, w_subtype, w_expr, w_flags, w_sub, lineno=-1):
    self = space.allocate_instance(Subscript, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    flags = space.int_w(w_flags)
    self.flags = flags
    sub = space.interp_w(Node, w_sub, can_be_None=False)
    self.sub = sub
    self.lineno = lineno
    return space.wrap(self)

def descr_Subscript_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitSubscript', w_self)

def descr_Subscript_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_sub = space.getattr(w_self, space.wrap("sub"))
    space.setattr(w_sub, space.wrap("parent"), w_self)
    w_new_sub = space.call_method(w_sub, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("sub"), w_new_sub)

    return space.call_method(w_visitor, "visitSubscript", w_self)

Subscript.typedef = TypeDef('Subscript', Node.typedef, 
                     __new__ = interp2app(descr_Subscript_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_Subscript_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Subscript_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(Subscript.fget_expr, Subscript.fset_expr ),
                    flags=GetSetProperty(Subscript.fget_flags, Subscript.fset_flags ),
                    sub=GetSetProperty(Subscript.fget_sub, Subscript.fset_sub ),
                    )
Subscript.typedef.acceptable_as_base_class = False

class TryExcept(Node):
    def __init__(self, body, handlers, else_, lineno=-1):
        Node.__init__(self, lineno)
        self.body = body
        # handlers is a list of triplets (expr1, expr2, body)
        self.handlers = handlers
        self.else_ = else_

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.body)
        children.extend(flatten(self.handlers))
        children.append(self.else_)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.body)
        # handlers is a list of triplets (expr1, expr2, body)
        for expr1, expr2, body in self.handlers:
            if expr1 is not None:
                nodelist.append(expr1)
            if expr2 is not None:
                nodelist.append(expr2)
            if body is not None:
                nodelist.append(body)
        if self.else_ is not None:
            nodelist.append(self.else_)
        return nodelist

    def fget_handlers( space, self ):
        return space.newlist( [ space.newtuple( [ space.wrap(expr1),
                                                  space.wrap(expr2),
                                                  space.wrap(body) ] )
                                for expr1, expr2, body in self.handlers ] )
    

    def fset_handlers( space, self, w_arg ):
        del self.handlers[:]
        for w_tup in space.unpackiterable( w_arg ):
            w_expr1 = space.getitem( w_tup, space.wrap(0) )
            w_expr2 = space.getitem( w_tup, space.wrap(1) )
            w_body = space.getitem( w_tup, space.wrap(2) )
            expr1 = space.interp_w(Node,  w_expr1, can_be_None=True)
            expr2 = space.interp_w(Node,  w_expr2, can_be_None=True)
            body = space.interp_w(Node,  w_body, can_be_None=False)
            self.handlers.append( (expr1,expr2,body) )
    

    def __repr__(self):
        return "TryExcept(%s, %s, %s)" % (self.body.__repr__(), self.handlers.__repr__(), self.else_.__repr__())

    def accept(self, visitor):
        return visitor.visitTryExcept(self)

    def mutate(self, visitor):
        self.body = self.body.mutate(visitor)
        for i in range(len(self.handlers)):

            expr1, expr2, body = self.handlers[i]

            if expr1 is not None:

                expr1 = expr1.mutate(visitor)

            if expr2 is not None:

                expr2 = expr2.mutate(visitor)

            if body is not None:

                body = body.mutate(visitor)

            self.handlers[i] = expr1, expr2, body

        if self.else_ is not None:
            self.else_ = self.else_.mutate(visitor)
        return visitor.visitTryExcept(self)

    def fget_body( space, self):
        return space.wrap(self.body)
    def fset_body( space, self, w_arg):
        self.body = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_else_( space, self):
        if self.else_ is None:
            return space.w_None
        else:
            return space.wrap(self.else_)
    def fset_else_( space, self, w_arg):
        self.else_ = space.interp_w(Node, w_arg, can_be_None=True)

def descr_TryExcept_new(space, w_subtype, w_body, w_handlers, w_else_, lineno=-1):
    self = space.allocate_instance(TryExcept, w_subtype)
    self.body = space.interp_w(Node, w_body)
    handlers = []
    for w_tuple in space.unpackiterable( w_handlers ):
        w_expr1 = space.getitem( w_tuple, space.wrap(0) )
        w_expr2 = space.getitem( w_tuple, space.wrap(1) )
        w_body = space.getitem( w_tuple, space.wrap(2) )
        expr1 = space.interp_w(Node, w_expr1, can_be_None=True)
        expr2 = space.interp_w(Node, w_expr2, can_be_None=True)
        body = space.interp_w(Node, w_body, can_be_None=False)
        handlers.append((expr1, expr2, body))
    self.handlers = handlers
    self.else_ = space.interp_w(Node, w_else_, can_be_None=True)
    self.lineno = lineno
    return space.wrap(self)



def descr_TryExcept_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitTryExcept', w_self)

def descr_TryExcept_mutate(space, w_self, w_visitor):
    w_body = space.getattr(w_self, space.wrap("body"))
    w_new_body = space.call_method(w_body, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("body"), w_new_body)

    w_list = space.getattr(w_self, space.wrap("handlers"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        w_expr1, w_expr2, w_body = space.unpackiterable(w_item, 3)

        if space.is_w(w_expr1, space.w_None):
            w_newexpr1 = w_expr1
        else:
            w_newexpr1 = space.call_method(w_expr1, "mutate", w_visitor)
        
        if space.is_w(w_expr2, space.w_None):
            w_newexpr2 = w_expr2
        else:
            w_newexpr2 = space.call_method(w_expr2, "mutate", w_visitor)

        if space.is_w(w_body, space.w_None):
            w_newbody = w_body
        else:
            w_newbody = space.call_method(w_body, "mutate", w_visitor)
        
        newlist_w.append(space.newtuple([w_newexpr1, w_newexpr2, w_newbody]))
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("handlers"), w_newlist)
    w_else_ = space.getattr(w_self, space.wrap("else_"))
    if not space.is_w(w_else_, space.w_None):
        w_new_else_ = space.call_method(w_else_, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("else_"), w_new_else_)

    return space.call_method(w_visitor, "visitTryExcept", w_self)


TryExcept.typedef = TypeDef('TryExcept', Node.typedef, 
                     __new__ = interp2app(descr_TryExcept_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_TryExcept_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_TryExcept_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    body=GetSetProperty(TryExcept.fget_body, TryExcept.fset_body ),
                    handlers=GetSetProperty(TryExcept.fget_handlers, TryExcept.fset_handlers ),
                    else_=GetSetProperty(TryExcept.fget_else_, TryExcept.fset_else_ ),
                    )
TryExcept.typedef.acceptable_as_base_class = False

class TryFinally(Node):
    def __init__(self, body, final, lineno=-1):
        Node.__init__(self, lineno)
        self.body = body
        self.final = final

    def getChildren(self):
        "NOT_RPYTHON"
        return self.body, self.final

    def getChildNodes(self):
        return [self.body, self.final]

    def __repr__(self):
        return "TryFinally(%s, %s)" % (self.body.__repr__(), self.final.__repr__())

    def accept(self, visitor):
        return visitor.visitTryFinally(self)

    def mutate(self, visitor):
        self.body = self.body.mutate(visitor)
        self.final = self.final.mutate(visitor)
        return visitor.visitTryFinally(self)

    def fget_body( space, self):
        return space.wrap(self.body)
    def fset_body( space, self, w_arg):
        self.body = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_final( space, self):
        return space.wrap(self.final)
    def fset_final( space, self, w_arg):
        self.final = space.interp_w(Node, w_arg, can_be_None=False)

def descr_TryFinally_new(space, w_subtype, w_body, w_final, lineno=-1):
    self = space.allocate_instance(TryFinally, w_subtype)
    body = space.interp_w(Node, w_body, can_be_None=False)
    self.body = body
    final = space.interp_w(Node, w_final, can_be_None=False)
    self.final = final
    self.lineno = lineno
    return space.wrap(self)

def descr_TryFinally_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitTryFinally', w_self)

def descr_TryFinally_mutate(space, w_self, w_visitor): 
    w_body = space.getattr(w_self, space.wrap("body"))
    space.setattr(w_body, space.wrap("parent"), w_self)
    w_new_body = space.call_method(w_body, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("body"), w_new_body)

    w_final = space.getattr(w_self, space.wrap("final"))
    space.setattr(w_final, space.wrap("parent"), w_self)
    w_new_final = space.call_method(w_final, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("final"), w_new_final)

    return space.call_method(w_visitor, "visitTryFinally", w_self)

TryFinally.typedef = TypeDef('TryFinally', Node.typedef, 
                     __new__ = interp2app(descr_TryFinally_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_TryFinally_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_TryFinally_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    body=GetSetProperty(TryFinally.fget_body, TryFinally.fset_body ),
                    final=GetSetProperty(TryFinally.fget_final, TryFinally.fset_final ),
                    )
TryFinally.typedef.acceptable_as_base_class = False

class Tuple(Node):
    def __init__(self, nodes, lineno=-1):
        Node.__init__(self, lineno)
        self.nodes = nodes

    def getChildren(self):
        "NOT_RPYTHON"
        return tuple(flatten(self.nodes))

    def getChildNodes(self):
        nodelist = []
        nodelist.extend(self.nodes)
        return nodelist

    def __repr__(self):
        return "Tuple(%s)" % (self.nodes.__repr__(),)

    def accept(self, visitor):
        return visitor.visitTuple(self)

    def mutate(self, visitor):
        visitor._mutate_list(self.nodes)
        return visitor.visitTuple(self)

    def fget_nodes( space, self):
        return space.newlist( [space.wrap(itm) for itm in self.nodes] )
    def fset_nodes( space, self, w_arg):
        del self.nodes[:]
        for w_itm in space.unpackiterable(w_arg):
            self.nodes.append( space.interp_w(Node, w_itm))
    def descr_insert_after(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node) + 1
        self.nodes[index:index] = added_nodes

    def descr_insert_before(space, self, node, w_added_nodes):
        added_nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_added_nodes)]
        index = self.nodes.index(node)
        self.nodes[index:index] = added_nodes

def descr_Tuple_new(space, w_subtype, w_nodes, lineno=-1):
    self = space.allocate_instance(Tuple, w_subtype)
    nodes = [space.interp_w(Node, w_node) for w_node in space.unpackiterable(w_nodes)]
    self.nodes = nodes
    self.lineno = lineno
    return space.wrap(self)

def descr_Tuple_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitTuple', w_self)

def descr_Tuple_mutate(space, w_self, w_visitor): 
    w_list = space.getattr(w_self, space.wrap("nodes"))
    list_w = space.unpackiterable(w_list)
    newlist_w = []
    for w_item in list_w:
        space.setattr(w_item, space.wrap("parent"), w_self)
        w_newitem = space.call_method(w_item, "mutate", w_visitor)
        if not space.is_w(w_newitem, space.w_None):
            newlist_w.append(w_newitem)
    w_newlist = space.newlist(newlist_w)
    space.setattr(w_self, space.wrap("nodes"), w_newlist)
    return space.call_method(w_visitor, "visitTuple", w_self)

Tuple.typedef = TypeDef('Tuple', Node.typedef, 
                     __new__ = interp2app(descr_Tuple_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Tuple_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Tuple_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    nodes=GetSetProperty(Tuple.fget_nodes, Tuple.fset_nodes ),
                     insert_after=interp2app(Tuple.descr_insert_after.im_func, unwrap_spec=[ObjSpace, Tuple, Node, W_Root]),
                     insert_before=interp2app(Tuple.descr_insert_before.im_func, unwrap_spec=[ObjSpace, Tuple, Node, W_Root]),
                    )
Tuple.typedef.acceptable_as_base_class = False

class UnaryAdd(UnaryOp):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "UnaryAdd(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitUnaryAdd(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitUnaryAdd(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_UnaryAdd_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(UnaryAdd, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_UnaryAdd_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitUnaryAdd', w_self)

def descr_UnaryAdd_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitUnaryAdd", w_self)

UnaryAdd.typedef = TypeDef('UnaryAdd', UnaryOp.typedef, 
                     __new__ = interp2app(descr_UnaryAdd_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_UnaryAdd_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_UnaryAdd_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(UnaryAdd.fget_expr, UnaryAdd.fset_expr ),
                    )
UnaryAdd.typedef.acceptable_as_base_class = False

class UnarySub(UnaryOp):
    def __init__(self, expr, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr

    def getChildren(self):
        "NOT_RPYTHON"
        return self.expr,

    def getChildNodes(self):
        return [self.expr,]

    def __repr__(self):
        return "UnarySub(%s)" % (self.expr.__repr__(),)

    def accept(self, visitor):
        return visitor.visitUnarySub(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        return visitor.visitUnarySub(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)

def descr_UnarySub_new(space, w_subtype, w_expr, lineno=-1):
    self = space.allocate_instance(UnarySub, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    self.lineno = lineno
    return space.wrap(self)

def descr_UnarySub_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitUnarySub', w_self)

def descr_UnarySub_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    return space.call_method(w_visitor, "visitUnarySub", w_self)

UnarySub.typedef = TypeDef('UnarySub', UnaryOp.typedef, 
                     __new__ = interp2app(descr_UnarySub_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_UnarySub_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_UnarySub_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(UnarySub.fget_expr, UnarySub.fset_expr ),
                    )
UnarySub.typedef.acceptable_as_base_class = False

class While(Node):
    def __init__(self, test, body, else_, lineno=-1):
        Node.__init__(self, lineno)
        self.test = test
        self.body = body
        self.else_ = else_

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.test)
        children.append(self.body)
        children.append(self.else_)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.test)
        nodelist.append(self.body)
        if self.else_ is not None:
            nodelist.append(self.else_)
        return nodelist

    def __repr__(self):
        return "While(%s, %s, %s)" % (self.test.__repr__(), self.body.__repr__(), self.else_.__repr__())

    def accept(self, visitor):
        return visitor.visitWhile(self)

    def mutate(self, visitor):
        self.test = self.test.mutate(visitor)
        self.body = self.body.mutate(visitor)
        if self.else_ is not None:
            self.else_ = self.else_.mutate(visitor)
        return visitor.visitWhile(self)

    def fget_test( space, self):
        return space.wrap(self.test)
    def fset_test( space, self, w_arg):
        self.test = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_body( space, self):
        return space.wrap(self.body)
    def fset_body( space, self, w_arg):
        self.body = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_else_( space, self):
        if self.else_ is None:
            return space.w_None
        else:
            return space.wrap(self.else_)
    def fset_else_( space, self, w_arg):
        self.else_ = space.interp_w(Node, w_arg, can_be_None=True)

def descr_While_new(space, w_subtype, w_test, w_body, w_else_, lineno=-1):
    self = space.allocate_instance(While, w_subtype)
    test = space.interp_w(Node, w_test, can_be_None=False)
    self.test = test
    body = space.interp_w(Node, w_body, can_be_None=False)
    self.body = body
    else_ = space.interp_w(Node, w_else_, can_be_None=True)
    self.else_ = else_
    self.lineno = lineno
    return space.wrap(self)

def descr_While_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitWhile', w_self)

def descr_While_mutate(space, w_self, w_visitor): 
    w_test = space.getattr(w_self, space.wrap("test"))
    space.setattr(w_test, space.wrap("parent"), w_self)
    w_new_test = space.call_method(w_test, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("test"), w_new_test)

    w_body = space.getattr(w_self, space.wrap("body"))
    space.setattr(w_body, space.wrap("parent"), w_self)
    w_new_body = space.call_method(w_body, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("body"), w_new_body)

    w_else_ = space.getattr(w_self, space.wrap("else_"))
    if not space.is_w(w_else_, space.w_None):
        space.setattr(w_else_, space.wrap("parent"), w_self)
        w_new_else_ = space.call_method(w_else_, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("else_"), w_new_else_)

    return space.call_method(w_visitor, "visitWhile", w_self)

While.typedef = TypeDef('While', Node.typedef, 
                     __new__ = interp2app(descr_While_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_While_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_While_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    test=GetSetProperty(While.fget_test, While.fset_test ),
                    body=GetSetProperty(While.fget_body, While.fset_body ),
                    else_=GetSetProperty(While.fget_else_, While.fset_else_ ),
                    )
While.typedef.acceptable_as_base_class = False

class With(Node):
    def __init__(self, expr, body, var, lineno=-1):
        Node.__init__(self, lineno)
        self.expr = expr
        self.body = body
        self.var = var

    def getChildren(self):
        "NOT_RPYTHON"
        children = []
        children.append(self.expr)
        children.append(self.body)
        children.append(self.var)
        return tuple(children)

    def getChildNodes(self):
        nodelist = []
        nodelist.append(self.expr)
        nodelist.append(self.body)
        if self.var is not None:
            nodelist.append(self.var)
        return nodelist

    def __repr__(self):
        return "With(%s, %s, %s)" % (self.expr.__repr__(), self.body.__repr__(), self.var.__repr__())

    def accept(self, visitor):
        return visitor.visitWith(self)

    def mutate(self, visitor):
        self.expr = self.expr.mutate(visitor)
        self.body = self.body.mutate(visitor)
        if self.var is not None:
            self.var = self.var.mutate(visitor)
        return visitor.visitWith(self)

    def fget_expr( space, self):
        return space.wrap(self.expr)
    def fset_expr( space, self, w_arg):
        self.expr = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_body( space, self):
        return space.wrap(self.body)
    def fset_body( space, self, w_arg):
        self.body = space.interp_w(Node, w_arg, can_be_None=False)
    def fget_var( space, self):
        if self.var is None:
            return space.w_None
        else:
            return space.wrap(self.var)
    def fset_var( space, self, w_arg):
        self.var = space.interp_w(Node, w_arg, can_be_None=True)

def descr_With_new(space, w_subtype, w_expr, w_body, w_var, lineno=-1):
    self = space.allocate_instance(With, w_subtype)
    expr = space.interp_w(Node, w_expr, can_be_None=False)
    self.expr = expr
    body = space.interp_w(Node, w_body, can_be_None=False)
    self.body = body
    var = space.interp_w(Node, w_var, can_be_None=True)
    self.var = var
    self.lineno = lineno
    return space.wrap(self)

def descr_With_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitWith', w_self)

def descr_With_mutate(space, w_self, w_visitor): 
    w_expr = space.getattr(w_self, space.wrap("expr"))
    space.setattr(w_expr, space.wrap("parent"), w_self)
    w_new_expr = space.call_method(w_expr, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("expr"), w_new_expr)

    w_body = space.getattr(w_self, space.wrap("body"))
    space.setattr(w_body, space.wrap("parent"), w_self)
    w_new_body = space.call_method(w_body, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("body"), w_new_body)

    w_var = space.getattr(w_self, space.wrap("var"))
    if not space.is_w(w_var, space.w_None):
        space.setattr(w_var, space.wrap("parent"), w_self)
        w_new_var = space.call_method(w_var, "mutate", w_visitor)
        space.setattr(w_self, space.wrap("var"), w_new_var)

    return space.call_method(w_visitor, "visitWith", w_self)

With.typedef = TypeDef('With', Node.typedef, 
                     __new__ = interp2app(descr_With_new, unwrap_spec=[ObjSpace, W_Root, W_Root, W_Root, W_Root, int]),
                     accept=interp2app(descr_With_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_With_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    expr=GetSetProperty(With.fget_expr, With.fset_expr ),
                    body=GetSetProperty(With.fget_body, With.fset_body ),
                    var=GetSetProperty(With.fget_var, With.fset_var ),
                    )
With.typedef.acceptable_as_base_class = False

class Yield(Node):
    def __init__(self, value, lineno=-1):
        Node.__init__(self, lineno)
        self.value = value

    def getChildren(self):
        "NOT_RPYTHON"
        return self.value,

    def getChildNodes(self):
        return [self.value,]

    def __repr__(self):
        return "Yield(%s)" % (self.value.__repr__(),)

    def accept(self, visitor):
        return visitor.visitYield(self)

    def mutate(self, visitor):
        self.value = self.value.mutate(visitor)
        return visitor.visitYield(self)

    def fget_value( space, self):
        return space.wrap(self.value)
    def fset_value( space, self, w_arg):
        self.value = space.interp_w(Node, w_arg, can_be_None=False)

def descr_Yield_new(space, w_subtype, w_value, lineno=-1):
    self = space.allocate_instance(Yield, w_subtype)
    value = space.interp_w(Node, w_value, can_be_None=False)
    self.value = value
    self.lineno = lineno
    return space.wrap(self)

def descr_Yield_accept( space, w_self, w_visitor):
    return space.call_method(w_visitor, 'visitYield', w_self)

def descr_Yield_mutate(space, w_self, w_visitor): 
    w_value = space.getattr(w_self, space.wrap("value"))
    space.setattr(w_value, space.wrap("parent"), w_self)
    w_new_value = space.call_method(w_value, "mutate", w_visitor)
    space.setattr(w_self, space.wrap("value"), w_new_value)

    return space.call_method(w_visitor, "visitYield", w_self)

Yield.typedef = TypeDef('Yield', Node.typedef, 
                     __new__ = interp2app(descr_Yield_new, unwrap_spec=[ObjSpace, W_Root, W_Root, int]),
                     accept=interp2app(descr_Yield_accept, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                     mutate=interp2app(descr_Yield_mutate, unwrap_spec=[ObjSpace, W_Root, W_Root] ),
                    value=GetSetProperty(Yield.fget_value, Yield.fset_value ),
                    )
Yield.typedef.acceptable_as_base_class = False


class ASTVisitor(object):
    """This is a visitor base class used to provide the visit
    method in replacement of the former visitor.visit = walker.dispatch
    It could also use to identify base type for visit arguments of AST nodes
    """

    def default(self, node):
        """This method is only suitable for when we use accept(visitor),
        not mutate(visitor).  In the latter case it *must* be overridden
        by the visitor, typically to just return an unmodified "node".
        """
        for child in node.getChildNodes():
            child.accept(self)

    def _mutate_list(self, lst):
        i = 0
        while i < len(lst):
            item = lst[i].mutate(self)
            if item is not None:
                lst[i] = item
                i += 1
            else:
                del lst[i]

    def visitExpression(self, node):
        return self.default(node)

    def visitEmptyNode(self, node):
        return self.default(node)


    def visitAbstractFunction(self, node):
        return self.default( node )
    def visitAbstractTest(self, node):
        return self.default( node )
    def visitAdd(self, node):
        return self.default( node )
    def visitAnd(self, node):
        return self.default( node )
    def visitAssAttr(self, node):
        return self.default( node )
    def visitAssList(self, node):
        return self.default( node )
    def visitAssName(self, node):
        return self.default( node )
    def visitAssSeq(self, node):
        return self.default( node )
    def visitAssTuple(self, node):
        return self.default( node )
    def visitAssert(self, node):
        return self.default( node )
    def visitAssign(self, node):
        return self.default( node )
    def visitAugAssign(self, node):
        return self.default( node )
    def visitBackquote(self, node):
        return self.default( node )
    def visitBinaryOp(self, node):
        return self.default( node )
    def visitBitOp(self, node):
        return self.default( node )
    def visitBitand(self, node):
        return self.default( node )
    def visitBitor(self, node):
        return self.default( node )
    def visitBitxor(self, node):
        return self.default( node )
    def visitBreak(self, node):
        return self.default( node )
    def visitCallFunc(self, node):
        return self.default( node )
    def visitClass(self, node):
        return self.default( node )
    def visitCompare(self, node):
        return self.default( node )
    def visitCondExpr(self, node):
        return self.default( node )
    def visitConst(self, node):
        return self.default( node )
    def visitContinue(self, node):
        return self.default( node )
    def visitDecorators(self, node):
        return self.default( node )
    def visitDict(self, node):
        return self.default( node )
    def visitDiscard(self, node):
        return self.default( node )
    def visitDiv(self, node):
        return self.default( node )
    def visitEllipsis(self, node):
        return self.default( node )
    def visitExec(self, node):
        return self.default( node )
    def visitFloorDiv(self, node):
        return self.default( node )
    def visitFor(self, node):
        return self.default( node )
    def visitFrom(self, node):
        return self.default( node )
    def visitFunction(self, node):
        return self.default( node )
    def visitGenExpr(self, node):
        return self.default( node )
    def visitGenExprFor(self, node):
        return self.default( node )
    def visitGenExprIf(self, node):
        return self.default( node )
    def visitGenExprInner(self, node):
        return self.default( node )
    def visitGetattr(self, node):
        return self.default( node )
    def visitGlobal(self, node):
        return self.default( node )
    def visitIf(self, node):
        return self.default( node )
    def visitImport(self, node):
        return self.default( node )
    def visitInvert(self, node):
        return self.default( node )
    def visitKeyword(self, node):
        return self.default( node )
    def visitLambda(self, node):
        return self.default( node )
    def visitLeftShift(self, node):
        return self.default( node )
    def visitList(self, node):
        return self.default( node )
    def visitListComp(self, node):
        return self.default( node )
    def visitListCompFor(self, node):
        return self.default( node )
    def visitListCompIf(self, node):
        return self.default( node )
    def visitMod(self, node):
        return self.default( node )
    def visitModule(self, node):
        return self.default( node )
    def visitMul(self, node):
        return self.default( node )
    def visitName(self, node):
        return self.default( node )
    def visitNoneConst(self, node):
        return self.default( node )
    def visitNot(self, node):
        return self.default( node )
    def visitOr(self, node):
        return self.default( node )
    def visitPass(self, node):
        return self.default( node )
    def visitPower(self, node):
        return self.default( node )
    def visitPrint(self, node):
        return self.default( node )
    def visitPrintnl(self, node):
        return self.default( node )
    def visitRaise(self, node):
        return self.default( node )
    def visitReturn(self, node):
        return self.default( node )
    def visitRightShift(self, node):
        return self.default( node )
    def visitSlice(self, node):
        return self.default( node )
    def visitSliceobj(self, node):
        return self.default( node )
    def visitStmt(self, node):
        return self.default( node )
    def visitSub(self, node):
        return self.default( node )
    def visitSubscript(self, node):
        return self.default( node )
    def visitTryExcept(self, node):
        return self.default( node )
    def visitTryFinally(self, node):
        return self.default( node )
    def visitTuple(self, node):
        return self.default( node )
    def visitUnaryAdd(self, node):
        return self.default( node )
    def visitUnaryOp(self, node):
        return self.default( node )
    def visitUnarySub(self, node):
        return self.default( node )
    def visitWhile(self, node):
        return self.default( node )
    def visitWith(self, node):
        return self.default( node )
    def visitYield(self, node):
        return self.default( node )


nodeclasses = []
for name, obj in globals().items():
    if isinstance(obj, type) and issubclass(obj, Node):
        nodes[name.lower()] = obj
        nodeclasses.append(name)

