# KInterbasDB Python Package - Type Conv : Python 2.1 Compatibility Utils
#
# Version 3.1
#
# The following contributors hold Copyright (C) over their respective
# portions of code (see license.txt for details):
#
# [Original Author (maintained through version 2.0-0.3.1):]
#   1998-2001 [alex]  Alexander Kuznetsov   <alexan@users.sourceforge.net>
# [Maintainers (after version 2.0-0.3.1):]
#   2001-2002 [maz]   Marek Isalski         <kinterbasdb@maz.nu>
#   2002-2004 [dsr]   David Rushby          <woodsplitter@rocketmail.com>
# [Contributors:]
#   2001      [eac]   Evgeny A. Cherkashin  <eugeneai@icc.ru>
#   2001-2002 [janez] Janez Jere            <janez.jere@void.si>

from __future__ import nested_scopes

import sys

# Override isinstance on Python 2.1 so that it can take a sequence of types
# as its second argument, as the official version can with Python 2.2 and later.
if sys.version_info < (2,2):
    _official_isinstance = isinstance
    def isinstance(obj, types):
        try:
            n_types = len(types)
        except TypeError:
            # types is not a sequence.
            return _official_isinstance(obj, types)

        for tp in types:
            if _official_isinstance(obj, tp):
                return 1
        else:
            return 0
