/*
 * Copyright (c) 2006 Bea Lam. All rights reserved.
 * 
 * Permission is hereby granted, free of charge, to any person
 * obtaining a copy of this software and associated documentation files
 * (the "Software"), to deal in the Software without restriction,
 * including without limitation the rights to use, copy, modify, merge,
 * publish, distribute, sublicense, and/or sell copies of the Software,
 * and to permit persons to whom the Software is furnished to do so,
 * subject to the following conditions:
 * 
 * The above copyright notice and this permission notice shall be
 * included in all copies or substantial portions of the Software.
 * 
 * THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND,
 * EXPRESS OR IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.
 * IN NO EVENT SHALL THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY
 * CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER IN AN ACTION OF CONTRACT,
 * TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN CONNECTION WITH THE
 * SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.
 */

#ifndef BTOBEXSERVER_H
#define BTOBEXSERVER_H

typedef struct {
	/* The time in seconds that the server should wait each
	   time for client data. If zero, will block until data 
	   arrives. (Defaults to zero) */
	int timeout;	
	
	/* called when a client has connected */
	void (*connect_complete)(obex_t *handle);
	
	/* called when a client has disconnected */
	void (*disconnect_complete)(obex_t *handle);		
	
	/* return 0 to deny PUT */
	/* Given name may be NULL if client did not provide one. */
	/* TODO should pass total filelen as well, if client sent one */
	int (*put_requested)(obex_t *handle, char *name);	
	
	/* return 0 to deny PUT */
	/* Given buf could be NULL if client did not send body data. */
	int (*put_progressed)(obex_t *handle, const uint8_t *buf, uint32_t buflen);
	
	void (*put_complete)(obex_t *handle);
	
	/* Called when an error occurs while processing incoming data.
	The given error number is 0 on timeout, or -1 on error. 
	last_evt and last_cmd indicate the last event and last client
	command received by the server prior to the error. */
	void (*error_handling_input)(obex_t *handle, int error, int last_evt, int last_cmd);
	
	/* Called when the transport connection is lost. */
	void (*transport_broken)(obex_t *handle);
	
	/* arbitrary user data */
	void *usrdata;
} btobexserver_usrconfig_t;


obex_t *btobexserver_init(int serverfd, unsigned int flags);

void btobexserver_cleanup(obex_t *handle);

int btobexserver_run(obex_t *handle);

/* Once stopped, the server cannot be restarted. */
void btobexserver_stop(obex_t *handle);	

void btobexserver_setusrconfig(obex_t *handle, btobexserver_usrconfig_t *usrconfig);

/* if server has been stopped, clean up will have been done, and
 this will return NULL */
btobexserver_usrconfig_t *btobexserver_getusrconfig(obex_t *handle);

#endif
