/*****************************************************/
/******** Periodic Finite Difference Formulae ********/
/*****************************************************/
/* Author: Pearu Peterson, September 2002            */
/*                                                   */
/* This file is automatically generated using        */
/* genpfdf.cc utility from fdf package and it        */
/* contains the following C function                 */
/*                                                   */
/*  void periodic_finite_difference(int n,           */
/*    double *x, double *y, double h, int k, int m); */
/* where                                             */
/*  n -- length of arrays x and y                    */
/*  x -- input array                                 */
/*  y -- output array                                */
/*  h -- discretization step of arrays x and y       */
/*  k -- the order of derivative                     */
/*  m -- number of grid intervals used to evaluate   */
/*       finite differences at the center point. The */
/*       error is O(h^(2*(m-1))) within numerical    */
/*       accuracy.                                   */
/*****************************************************/
/* Reference:                                        */
/*   http://epubs.siam.org/sam-bin/dbq/article/32250 */
/*****************************************************/
/* Parameters to genpfdf n=25 m=10 */
#include <stdio.h>
#include <math.h>
static double fd_coeffs_1_1[] = {
 0.5
};
static double fd_coeffs_2_1[] = {
 0.5
};
static double fd_coeffs_2_2[] = {
 -2.0,
 1.0
};
static double fd_coeffs_3_1[] = {
 0.5625,
 -0.020833333333333333334
};
static double fd_coeffs_3_2[] = {
 -0.125,
 0.125
};
static double fd_coeffs_3_3[] = {
 -0.375,
 0.125
};
static double fd_coeffs_4_1[] = {
 0.6666666666666666667,
 -0.083333333333333333336
};
static double fd_coeffs_4_2[] = {
 -2.5,
 1.3333333333333333334,
 -0.083333333333333333336
};
static double fd_coeffs_4_3[] = {
 -1.0,
 0.5
};
static double fd_coeffs_4_4[] = {
 6.0,
 -4.0,
 1.0
};
static double fd_coeffs_5_1[] = {
 0.5859375,
 -0.032552083333333333332,
 0.00234375
};
static double fd_coeffs_5_2[] = {
 -0.17708333333333333333,
 0.203125,
 -0.026041666666666666666
};
static double fd_coeffs_5_3[] = {
 -0.53125,
 0.203125,
 -0.015625
};
static double fd_coeffs_5_4[] = {
 0.0625,
 -0.09375,
 0.03125
};
static double fd_coeffs_5_5[] = {
 0.3125,
 -0.15625,
 0.03125
};
static double fd_coeffs_6_1[] = {
 0.75,
 -0.15,
 0.016666666666666666667
};
static double fd_coeffs_6_2[] = {
 -2.7222222222222222222,
 1.5,
 -0.15,
 0.011111111111111111111
};
static double fd_coeffs_6_3[] = {
 -1.625,
 1.0,
 -0.125
};
static double fd_coeffs_6_4[] = {
 9.333333333333333333,
 -6.5,
 2.0,
 -0.16666666666666666667
};
static double fd_coeffs_6_5[] = {
 2.5,
 -2.0,
 0.5
};
static double fd_coeffs_6_6[] = {
 -20.0,
 15.0,
 -6.0,
 1.0
};
static double fd_coeffs_7_1[] = {
 0.59814453125,
 -0.039876302083333333332,
 0.00478515625,
 -3.4877232142857142856E-4
};
static double fd_coeffs_7_2[] = {
 -0.20518663194444444444,
 0.2537109375,
 -0.054144965277777777777,
 0.0056206597222222222224
};
static double fd_coeffs_7_3[] = {
 -0.6155598958333333333,
 0.2537109375,
 -0.032486979166666666666,
 0.0024088541666666666667
};
static double fd_coeffs_7_4[] = {
 0.108072916666666666664,
 -0.17578125,
 0.076822916666666666664,
 -0.009114583333333333333
};
static double fd_coeffs_7_5[] = {
 0.5403645833333333333,
 -0.29296875,
 0.076822916666666666664,
 -0.0065104166666666666665
};
static double fd_coeffs_7_6[] = {
 -0.0390625,
 0.0703125,
 -0.0390625,
 0.0078125
};
static double fd_coeffs_7_7[] = {
 -0.2734375,
 0.1640625,
 -0.0546875,
 0.0078125
};
static double fd_coeffs_8_1[] = {
 0.8,
 -0.2,
 0.03809523809523809524,
 -0.0035714285714285714287
};
static double fd_coeffs_8_2[] = {
 -2.8472222222222222222,
 1.6,
 -0.2,
 0.025396825396825396825,
 -0.0017857142857142857143
};
static double fd_coeffs_8_3[] = {
 -2.0333333333333333333,
 1.4083333333333333333,
 -0.3,
 0.029166666666666666667
};
static double fd_coeffs_8_4[] = {
 11.375,
 -8.133333333333333333,
 2.8166666666666666666,
 -0.4,
 0.029166666666666666667
};
static double fd_coeffs_8_5[] = {
 4.8333333333333333335,
 -4.3333333333333333335,
 1.5,
 -0.16666666666666666667
};
static double fd_coeffs_8_6[] = {
 -37.5,
 29.0,
 -13.0,
 3.0,
 -0.25
};
static double fd_coeffs_8_7[] = {
 -7.0,
 7.0,
 -3.0,
 0.5
};
static double fd_coeffs_8_8[] = {
 70.0,
 -56.0,
 28.0,
 -8.0,
 1.0
};
static double fd_coeffs_9_1[] = {
 0.605621337890625,
 -0.04486083984375,
 0.00692138671875,
 -8.828299386160714286E-4,
 5.9339735243055555557E-5
};
static double fd_coeffs_9_2[] = {
 -0.222705078125,
 0.28874782986111111112,
 -0.07917131696428571429,
 0.0143798828125,
 -0.0012513175843253968254
};
static double fd_coeffs_9_3[] = {
 -0.668115234375,
 0.28874782986111111112,
 -0.04750279017857142857,
 0.0061628069196428571427,
 -4.171058614417989418E-4
};
static double fd_coeffs_9_4[] = {
 0.14020182291666666667,
 -0.2400390625,
 0.122721354166666666664,
 -0.025179036458333333333,
 0.002294921875
};
static double fd_coeffs_9_5[] = {
 0.7010091145833333333,
 -0.40006510416666666666,
 0.122721354166666666664,
 -0.017985026041666666666,
 0.0012749565972222222222
};
static double fd_coeffs_9_6[] = {
 -0.080078125,
 0.15234375,
 -0.09765625,
 0.0283203125,
 -0.0029296875
};
static double fd_coeffs_9_7[] = {
 -0.560546875,
 0.35546875,
 -0.13671875,
 0.0283203125,
 -0.0022786458333333333333
};
static double fd_coeffs_9_8[] = {
 0.02734375,
 -0.0546875,
 0.0390625,
 -0.013671875,
 0.001953125
};
static double fd_coeffs_9_9[] = {
 0.24609375,
 -0.1640625,
 0.0703125,
 -0.017578125,
 0.001953125
};
static double fd_coeffs_10_1[] = {
 0.8333333333333333333,
 -0.23809523809523809523,
 0.05952380952380952381,
 -0.009920634920634920635,
 7.936507936507936508E-4
};
static double fd_coeffs_10_2[] = {
 -2.9272222222222222222,
 1.6666666666666666666,
 -0.23809523809523809523,
 0.03968253968253968254,
 -0.0049603174603174603174,
 3.174603174603174603E-4
};
static double fd_coeffs_10_3[] = {
 -2.3180555555555555556,
 1.7337301587301587302,
 -0.4830357142857142857,
 0.08339947089947089947,
 -0.0067791005291005291007
};
static double fd_coeffs_10_4[] = {
 12.741666666666666667,
 -9.272222222222222222,
 3.4674603174603174603,
 -0.6440476190476190476,
 0.08339947089947089947,
 -0.0054232804232804232802
};
static double fd_coeffs_10_5[] = {
 6.7291666666666666665,
 -6.5,
 2.71875,
 -0.52777777777777777775,
 0.04513888888888888889
};
static double fd_coeffs_10_6[] = {
 -51.15,
 40.375,
 -19.5,
 5.4375,
 -0.7916666666666666667,
 0.054166666666666666667
};
static double fd_coeffs_10_7[] = {
 -15.75,
 17.0,
 -8.625,
 2.1666666666666666667,
 -0.20833333333333333333
};
static double fd_coeffs_10_8[] = {
 154.0,
 -126.0,
 68.0,
 -23.0,
 4.3333333333333333335,
 -0.33333333333333333334
};
static double fd_coeffs_10_9[] = {
 21.0,
 -24.0,
 13.5,
 -4.0,
 0.5
};
static double fd_coeffs_10_10[] = {
 -252.0,
 210.0,
 -120.0,
 45.0,
 -10.0,
 1.0
};
static double fd_coeffs_11_1[] = {
 0.610668182373046875,
 -0.048465728759765625,
 0.0087238311767578125,
 -0.0014836447579520089286,
 1.7950269911024305556E-4,
 -1.0923905806107954545E-5
};
static double fd_coeffs_11_2[] = {
 -0.23465464274088541667,
 0.31435403975229414683,
 -0.10050982520693824405,
 0.024337853325737847222,
 -0.0038119385734437003968,
 2.845134432353670635E-4
};
static double fd_coeffs_11_3[] = {
 -0.70396392822265625,
 0.31435403975229414683,
 -0.060305895124162946428,
 0.0104305085681733630955,
 -0.0012706461911479001323,
 7.7594575427827380955E-5
};
static double fd_coeffs_11_4[] = {
 0.16364067925347222222,
 -0.29026518322172619049,
 0.16457645476810515873,
 -0.04471141673900462963,
 0.0073175339471726190477,
 -5.580680080191798942E-4
};
static double fd_coeffs_11_5[] = {
 0.8182033962673611111,
 -0.48377530536954365078,
 0.16457645476810515873,
 -0.031936726242146164022,
 0.004065296637318121693,
 -2.5366727637235449736E-4
};
static double fd_coeffs_11_6[] = {
 -0.1157958984375,
 0.2288818359375,
 -0.16143798828125,
 0.058085123697916666668,
 -0.01058349609375,
 8.5042317708333333334E-4
};
static double fd_coeffs_11_7[] = {
 -0.8105712890625,
 0.5340576171875,
 -0.22601318359375,
 0.058085123697916666668,
 -0.008231608072916666667,
 5.411783854166666667E-4
};
static double fd_coeffs_11_8[] = {
 0.06494140625,
 -0.13525390625,
 0.106201171875,
 -0.045003255208333333332,
 0.010009765625,
 -8.951822916666666667E-4
};
static double fd_coeffs_11_9[] = {
 0.58447265625,
 -0.40576171875,
 0.191162109375,
 -0.057861328125,
 0.010009765625,
 -7.32421875E-4
};
static double fd_coeffs_11_10[] = {
 -0.0205078125,
 0.0439453125,
 -0.03662109375,
 0.01708984375,
 -0.00439453125,
 4.8828125E-4
};
static double fd_coeffs_12_1[] = {
 0.85714285714285714287,
 -0.26785714285714285715,
 0.07936507936507936508,
 -0.017857142857142857143,
 0.0025974025974025974027,
 -1.8037518037518037518E-4
};
static double fd_coeffs_12_2[] = {
 -2.9827777777777777777,
 1.7142857142857142857,
 -0.26785714285714285715,
 0.052910052910052910053,
 -0.008928571428571428571,
 0.0010389610389610389611,
 -6.012506012506012506E-5
};
static double fd_coeffs_12_3[] = {
 -2.5271428571428571428,
 1.9950892857142857143,
 -0.65727513227513227514,
 0.15309523809523809524,
 -0.022619047619047619048,
 0.0015839947089947089947
};
static double fd_coeffs_12_4[] = {
 13.717407407407407408,
 -10.108571428571428571,
 3.9901785714285714286,
 -0.8763668430335097002,
 0.15309523809523809524,
 -0.018095238095238095238,
 0.0010559964726631393298
};
static double fd_coeffs_12_5[] = {
 8.246031746031746032,
 -8.396081349206349206,
 3.9828042328042328043,
 -1.0333994708994708995,
 0.16005291005291005292,
 -0.011491402116402116402
};
static double fd_coeffs_12_6[] = {
 -61.768055555555555554,
 49.476190476190476192,
 -25.18824404761904762,
 7.9656084656084656086,
 -1.5500992063492063492,
 0.19206349206349206349,
 -0.011491402116402116402
};
static double fd_coeffs_12_7[] = {
 -24.275,
 27.65625,
 -15.729166666666666667,
 5.0083333333333333332,
 -0.8541666666666666667,
 0.06458333333333333333
};
static double fd_coeffs_12_8[] = {
 233.56666666666666667,
 -194.2,
 110.625,
 -41.944444444444444444,
 10.0166666666666666664,
 -1.3666666666666666667,
 0.08611111111111111111
};
static double fd_coeffs_12_9[] = {
 54.0,
 -65.25,
 41.0,
 -15.0,
 3.0,
 -0.25
};
static double fd_coeffs_12_10[] = {
 -637.0,
 540.0,
 -326.25,
 136.66666666666666667,
 -37.5,
 6.0,
 -0.41666666666666666666
};
static double fd_coeffs_13_1[] = {
 0.6143031120300292969,
 -0.051191926002502441406,
 0.010238385200500488281,
 -0.002089466367449079241,
 3.4472677442762586804E-4,
 -3.8461251692338423294E-5,
 2.1182573758638822115E-6
};
static double fd_coeffs_13_2[] = {
 -0.24332125588068886408,
 0.33385391931685190353,
 -0.118565269248195426174,
 0.034448901988841869214,
 -0.0073573712215451107053,
 0.0010067312048856543485,
 -6.5656160150026116824E-5
};
static double fd_coeffs_13_3[] = {
 -0.72996376764206659225,
 0.33385391931685190353,
 -0.0711391615489172557,
 0.0147638151380750868054,
 -0.0024524570738483702352,
 2.7456305587790573143E-4,
 -1.5151421573082950036E-5
};
static double fd_coeffs_13_4[] = {
 0.18137577682575851521,
 -0.3301691527593703497,
 0.20152457471036826912,
 -0.06540236390667197145,
 0.014572801135835193452,
 -0.00203599280570970431,
 1.3435679979004767416E-4
};
static double fd_coeffs_13_5[] = {
 0.90687888412879257607,
 -0.5502819212656172495,
 0.20152457471036826912,
 -0.04671597421905140818,
 0.008096000631019551918,
 -9.2545127532259286815E-4,
 5.167569222694141314E-5
};
static double fd_coeffs_13_6[] = {
 -0.14570670960441468254,
 0.2961811610630580357,
 -0.22375217821232225529,
 0.09298107005931712963,
 -0.022819737025669642856,
 0.003342990774326223545,
 -2.2659705429480820106E-4
};
static double fd_coeffs_13_7[] = {
 -1.0199469672309027778,
 0.69108937581380208335,
 -0.3132530494972511574,
 0.09298107005931712963,
 -0.017748684353298611112,
 0.002127357765480324074,
 -1.2201379846643518518E-4
};
static double fd_coeffs_13_8[] = {
 0.10392659505208333333,
 -0.2229705810546875,
 0.18742031521267361111,
 -0.09048597547743055556,
 0.025958251953125,
 -0.004143948025173611111,
 2.9534233940972222222E-4
};
static double fd_coeffs_13_9[] = {
 0.93533935546875,
 -0.6689117431640625,
 0.3373565673828125,
 -0.116339111328125,
 0.025958251953125,
 -0.0033905029296875,
 2.044677734375E-4
};
static double fd_coeffs_13_10[] = {
 -0.055419921875,
 0.12249755859375,
 -0.109354654947916666664,
 0.057820638020833333332,
 -0.0186767578125,
 0.0033976236979166666667,
 -2.6448567708333333334E-4
};
static double fd_coeffs_14_1[] = {
 0.875,
 -0.29166666666666666666,
 0.09722222222222222222,
 -0.026515151515151515152,
 0.0053030303030303030304,
 -6.7987567987567987567E-4,
 4.1625041625041625042E-5
};
static double fd_coeffs_14_2[] = {
 -3.0235941043083900226,
 1.75,
 -0.29166666666666666666,
 0.064814814814814814815,
 -0.013257575757575757576,
 0.0021212121212121212122,
 -2.2662522662522662522E-4,
 1.1892869035726178583E-5
};
static double fd_coeffs_14_3[] = {
 -2.6869345238095238095,
 2.20814484126984127,
 -0.8170667989417989418,
 0.23056998556998556999,
 -0.046829906204906204906,
 0.006053691678691678692,
 -3.7247474747474747474E-4
};
static double fd_coeffs_14_4[] = {
 14.447883597883597884,
 -10.747738095238095238,
 4.41628968253968254,
 -1.0894223985890652557,
 0.23056998556998556999,
 -0.037463924963924963926,
 0.0040357944524611191277,
 -2.1284271284271284271E-4
};
static double fd_coeffs_14_5[] = {
 9.4708002645502645505,
 -10.029106040564373898,
 5.207572751322751323,
 -1.62722663139329806,
 0.34562389770723104057,
 -0.04575066137566137566,
 0.0028549382716049382716
};
static double fd_coeffs_14_6[] = {
 -70.16646825396825397,
 56.824801587301587303,
 -30.087318121693121692,
 10.415145502645502646,
 -2.44083994708994709,
 0.4147486772486772487,
 -0.04575066137566137566,
 0.00244708994708994709
};
static double fd_coeffs_14_7[] = {
 -31.996006944444444445,
 37.950925925925925924,
 -23.450173611111111111,
 8.751851851851851852,
 -2.0240162037037037037,
 0.28055555555555555556,
 -0.017997685185185185186
};
static double fd_coeffs_14_8[] = {
 304.15873015873015872,
 -255.96805555555555556,
 151.8037037037037037,
 -62.533796296296296297,
 17.503703703703703704,
 -3.238425925925925926,
 0.37407407407407407407,
 -0.020568783068783068783
};
static double fd_coeffs_14_9[] = {
 91.5375,
 -115.3,
 78.5375,
 -33.2,
 8.6875,
 -1.3,
 0.0875
};
static double fd_coeffs_14_10[] = {
 -1066.0,
 915.375,
 -576.5,
 261.79166666666666666,
 -83.0,
 17.375,
 -2.1666666666666666667,
 0.125
};
static double fd_coeffs_15_1[] = {
 0.6170455366373062134,
 -0.053324922919273376465,
 0.011518183350563049316,
 -0.0026711927992956978933,
 5.386355850431654188E-4,
 -8.320943875746293501E-5,
 8.510855528024526743E-6,
 -4.2617321014404296876E-7
};
static double fd_coeffs_15_2[] = {
 -0.24989236070185291524,
 0.3491864972329013562,
 -0.13389784716424487886,
 0.04420599702632788456,
 -0.011538983380467688711,
 0.0021861602753509968628,
 -2.6478054867014887898E-4,
 1.5317260655394058626E-5
};
static double fd_coeffs_15_3[] = {
 -0.7496770821055587457,
 0.3491864972329013562,
 -0.080338708298546927314,
 0.01894542729699766481,
 -0.0038463277934892295702,
 5.962255296411809626E-4,
 -6.1103203539265125915E-5,
 3.0634521310788117254E-6
};
static double fd_coeffs_15_4[] = {
 0.19522055739448184059,
 -0.36247364075305810893,
 0.23382906270405602833,
 -0.085959765357200545494,
 0.023383116043204582327,
 -0.0045209534206087627107,
 5.538956049028757159E-4,
 -3.227221577790984936E-5
};
static double fd_coeffs_15_5[] = {
 0.97610278697240920295,
 -0.6041227345884301815,
 0.23382906270405602833,
 -0.06139983239800038964,
 0.0129906200240025457374,
 -0.0020549788275494375958,
 2.1303677111649065995E-4,
 -1.075740525930328312E-5
};
static double fd_coeffs_15_6[] = {
 -0.17064858466859847781,
 0.354378869546153558,
 -0.28194988669541777758,
 0.13001597545765064381,
 -0.038691839339241148935,
 0.0078197375807181867976,
 -9.824114501791656333E-4,
 5.813956891418134094E-5
};
static double fd_coeffs_15_7[] = {
 -1.1945400926801893446,
 0.82688402894102496865,
 -0.3947298413735848886,
 0.13001597545765064381,
 -0.030093652819409782504,
 0.0049761966422752097802,
 -5.289907808657045718E-4,
 2.7131798826617959105E-5
};
static double fd_coeffs_15_8[] = {
 0.140817230466812376,
 -0.30904873035572193288,
 0.27349846451370804398,
 -0.14526297957808883102,
 0.049434110853407118054,
 -0.0107653441252531828705,
 0.0014132403822802992725,
 -8.5992157143890542326E-5
};
static double fd_coeffs_15_9[] = {
 1.267355074201311384,
 -0.92714619106716579863,
 0.49229723612467447916,
 -0.18676668802897135416,
 0.049434110853407118054,
 -0.008808008829752604166,
 9.78397187732514881E-4,
 -5.1595294286334325397E-5
};
static double fd_coeffs_15_10[] = {
 -0.097423553466796875,
 0.22050603230794270833,
 -0.207363128662109375,
 0.120189666748046875,
 -0.045406341552734375,
 0.010936737060546875,
 -0.001537322998046875,
 9.7910563151041666664E-5
};
static double fd_coeffs_16_1[] = {
 0.8888888888888888889,
 -0.3111111111111111111,
 0.11313131313131313131,
 -0.035353535353535353535,
 0.008702408702408702409,
 -0.0015540015540015540016,
 1.7760017760017760018E-4,
 -9.7125097125097125096E-6
};
static double fd_coeffs_16_2[] = {
 -3.0548441043083900226,
 1.7777777777777777778,
 -0.3111111111111111111,
 0.07542087542087542087,
 -0.017676767676767676768,
 0.0034809634809634809634,
 -5.1800051800051800053E-4,
 5.074290788576502862E-5,
 -2.4281274281274281274E-6
};
static double fd_coeffs_16_3[] = {
 -2.8129176114890400604,
 2.3845211640211640212,
 -0.9613746993746993747,
 0.31074104136604136604,
 -0.077664927664927664926,
 0.013982697196982911268,
 -0.0016058756058756058756,
 8.810006131434702863E-5
};
static double fd_coeffs_16_4[] = {
 15.014807492441421013,
 -11.251670445956160242,
 4.7690423280423280424,
 -1.2818329324995991663,
 0.31074104136604136604,
 -0.06213194213194213194,
 0.0093217981313219408455,
 -9.176432033574890718E-4,
 4.4050030657173514316E-5
};
static double fd_coeffs_16_5[] = {
 10.474125514403292181,
 -11.433761390358612581,
 6.3568362193362193363,
 -2.265706335845224734,
 0.59119301480412591524,
 -0.108897005772005772006,
 0.012677702955480733258,
 -7.016260488482710705E-4
};
static double fd_coeffs_16_6[] = {
 -76.93891369047619048,
 62.844753086419753087,
 -34.301284171075837742,
 12.713672438672438673,
 -3.3985595037678371013,
 0.70943161776495109827,
 -0.108897005772005772006,
 0.010866602533269199936,
 -5.2621953663620330285E-4
};
static double fd_coeffs_16_7[] = {
 -38.817746913580246912,
 47.50136188271604938,
 -31.264166666666666666,
 13.092959104938271605,
 -3.6936728395061728396,
 0.70989583333333333335,
 -0.08478395061728395062,
 0.004770447530864197531
};
static double fd_coeffs_16_8[] = {
 365.55438988095238095,
 -310.5419753086419753,
 190.00544753086419753,
 -83.371111111111111114,
 26.18591820987654321,
 -5.909876543209876543,
 0.9465277777777777778,
 -0.096895943562610229275,
 0.004770447530864197531
};
static double fd_coeffs_16_9[] = {
 129.55734126984126985,
 -168.52777777777777778,
 122.0875,
 -57.394444444444444445,
 17.993055555555555556,
 -3.6928571428571428572,
 0.45972222222222222223,
 -0.026587301587301587302
};
static double fd_coeffs_16_10[] = {
 -1493.7232142857142857,
 1295.5734126984126984,
 -842.6388888888888889,
 406.95833333333333334,
 -143.4861111111111111,
 35.986111111111111112,
 -6.154761904761904762,
 0.65674603174603174606,
 -0.03323412698412698413
};
static double fd_coeffs_17_1[] = {
 0.6191880558617413044,
 -0.05503893829882144928,
 0.012608920410275459289,
 -0.00321656132915190288,
 7.483927119109365675E-4,
 -1.431400464339689775E-4,
 2.0496977063325735239E-5,
 -1.9244384020566940308E-6,
 8.8133246583097121296E-8
};
static double fd_coeffs_17_2[] = {
 -0.25504508095871564213,
 0.3615530258493719007,
 -0.14701386236353182001,
 0.053387207665828743367,
 -0.01607914248791316834,
 0.0037716126620779897496,
 -6.3952384007834719766E-4,
 6.936677383926881613E-5,
 -3.6033008789249838336E-6
};
static double fd_coeffs_17_3[] = {
 -0.76513524287614692636,
 0.3615530258493719007,
 -0.08820831741811909201,
 0.022880231856783747156,
 -0.00535971416263772278,
 0.0010286216351121790226,
 -1.4758242463346473793E-4,
 1.3873354767853763226E-5,
 -6.358766256926442059E-7
};
static double fd_coeffs_17_4[] = {
 0.20631058824801210733,
 -0.38908971480153074912,
 0.26205823214940579825,
 -0.10572018396894538443,
 0.03315475162044104114,
 -0.007933270606310383248,
 0.0013604433033414405703,
 -1.4860121074501054951E-4,
 7.755266331140046677E-6
};
static double fd_coeffs_17_5[] = {
 1.0315529412400605367,
 -0.6484828580025512485,
 0.26205823214940579825,
 -0.07551441712067527459,
 0.018419306455800578411,
 -0.0036060320937774469312,
 5.2324742436209252704E-4,
 -4.9533736915003516506E-5,
 2.2809606856294254933E-6
};
static double fd_coeffs_17_6[] = {
 -0.19157658920506741425,
 0.40460608043367900545,
 -0.33522117097006597943,
 0.16730587444990438511,
 -0.057131899280465526498,
 0.014259123591939398011,
 -0.0025044481437405428291,
 2.7766409202399535956E-4,
 -1.4634968207320934575E-5
};
static double fd_coeffs_17_7[] = {
 -1.3410361244354718997,
 0.94408085434525101275,
 -0.4693096393580923712,
 0.16730587444990438511,
 -0.04443592166258429839,
 0.009073987740325071461,
 -0.0013485490004756769079,
 1.2957657627786450113E-4,
 -6.0261633794850907076E-6
};
static double fd_coeffs_17_8[] = {
 0.17448784842482740076,
 -0.3898582134549579923,
 0.3592054920432008343,
 -0.20525789884873378424,
 0.079101928075154622395,
 -0.021125534266180882799,
 0.0038620125974086647101,
 -4.3918045740278940353E-4,
 2.3545886683926590746E-5
};
static double fd_coeffs_17_9[] = {
 1.5703906358234466068,
 -1.169574640364873977,
 0.6465698856777615017,
 -0.26390301280551486544,
 0.079101928075154622395,
 -0.017284528035966176835,
 0.0026737010289752294147,
 -2.635082744416736421E-4,
 1.2465469420902312748E-5
};
static double fd_coeffs_17_10[] = {
 -0.14176721421499100942,
 0.32693081810360863094,
 -0.32023790147569444444,
 0.19920200771755642361,
 -0.0844783782958984375,
 0.024580940367683531746,
 -0.0047623165070064484126,
 5.630538577125186012E-4,
 -3.1009552970765128967E-5
};
static double fd_coeffs_18_1[] = {
 0.9,
 -0.32727272727272727271,
 0.12727272727272727273,
 -0.044055944055944055943,
 0.012587412587412587413,
 -0.0027972027972027972027,
 4.4955044955044955046E-4,
 -4.627725215960510078E-5,
 2.285296402943461767E-6
};
static double fd_coeffs_18_2[] = {
 -3.0795354623330813807,
 1.8,
 -0.32727272727272727271,
 0.084848484848484848486,
 -0.022027972027972027972,
 0.005034965034965034965,
 -9.324009324009324009E-4,
 1.284429855858427287E-4,
 -1.1569313039901275195E-5,
 5.0784364509854705933E-7
};
static double fd_coeffs_18_3[] = {
 -2.9147457482993197279,
 2.532634817563388992,
 -1.0909741462241462241,
 0.39049454711954711955,
 -0.1132691713048855906,
 0.025376055161769447483,
 -0.0040981726606726606727,
 4.2319882498453927025E-4,
 -2.0943672729387015101E-5
};
static double fd_coeffs_18_4[] = {
 15.467376989375997313,
 -11.6589829931972789115,
 5.065269635126777984,
 -1.4546321949655282988,
 0.39049454711954711955,
 -0.09061533704390847248,
 0.016917370107846298323,
 -0.0023418129489558060987,
 2.1159941249226963512E-4,
 -9.308298990838673378E-6
};
static double fd_coeffs_18_5[] = {
 11.308281486205593348,
 -12.647079167525596097,
 7.4184892743573299127,
 -2.9190312927812927812,
 0.88285594200772772204,
 -0.20222914247715835017,
 0.033094107859732859734,
 -0.003446688893117464546,
 1.7156642776682459222E-4
};
static double fd_coeffs_18_6[] = {
 -82.499953502491531594,
 67.84968891723356009,
 -37.94123750257678829,
 14.836978548714659825,
 -4.378546939171939172,
 1.0594271304092732664,
 -0.20222914247715835017,
 0.028366378165485308343,
 -0.0025850166698380984095,
 1.1437761851121639481E-4
};
static double fd_coeffs_18_7[] = {
 -44.801884645061728397,
 56.205562219416386083,
 -38.88034196127946128,
 17.779836209315375981,
 -5.786028689674523008,
 1.3794497053872053872,
 -0.2312488601290684624,
 0.024463208473625140291,
 -0.0012307975589225589225
};
static double fd_coeffs_18_8[] = {
 418.74672527189888302,
 -358.41507716049382717,
 224.82224887766554433,
 -103.68091189674523008,
 35.559672418630751962,
 -9.2576459034792368125,
 1.8392662738496071829,
 -0.26428441157607824276,
 0.024463208473625140291,
 -0.0010940422745978301534
};
static double fd_coeffs_18_9[] = {
 166.11278025793650794,
 -221.69932539682539682,
 168.61260416666666667,
 -86.02527777777777778,
 30.774677579365079366,
 -7.782976190476190476,
 1.3544357638888888889,
 -0.14688492063492063492,
 0.007518601190476190476
};
static double fd_coeffs_18_10[] = {
 -1899.8947585978835979,
 1661.1278025793650793,
 -1108.4966269841269841,
 562.0420138888888889,
 -215.06319444444444444,
 61.549355158730158732,
 -12.971626984126984127,
 1.934908234126984127,
 -0.18360615079365079365,
 0.008354001322751322751
};
static double fd_coeffs_19_1[] = {
 0.6209080226835794747,
 -0.05644618388032540679,
 0.013547084131278097629,
 -0.003721726409691785063,
 9.6489203214231464597E-4,
 -2.1530648651109500365E-4,
 3.8538587082607241776E-5,
 -5.1082519348710775376E-6,
 4.4189030578469528872E-7,
 -1.8618792589557798286E-8
};
static double fd_coeffs_19_2[] = {
 -0.25919347316061063725,
 0.37173544307220507063,
 -0.15832765927779089768,
 0.06191606995503943268,
 -0.020778719667682323676,
 0.005686255216798756738,
 -0.0012052136857913010806,
 1.8455248902968929003E-4,
 -1.8108168717718673139E-5,
 8.532275199290405474E-7
};
static double fd_coeffs_19_3[] = {
 -0.7775804194818319118,
 0.37173544307220507063,
 -0.094996595566674538606,
 0.026535458552159756863,
 -0.0069262398892274412254,
 0.0015507968773087518376,
 -2.7812623518260794168E-4,
 3.6910497805937858005E-5,
 -3.1955591854797658481E-6,
 1.3472013472563798117E-7
};
static double fd_coeffs_19_4[] = {
 0.21538517591399155125,
 -0.41136370270893483873,
 0.28680710760207700895,
 -0.12437702854095906634,
 0.04343505373155062097,
 -0.012121541836762434291,
 0.0025978870759750011053,
 -4.0056939974279436888E-4,
 3.9484593834564675782E-5,
 -1.8664310296132134769E-6
};
static double fd_coeffs_19_5[] = {
 1.0769258795699577563,
 -0.68560617118155806456,
 0.28680710760207700895,
 -0.088840734672113618816,
 0.024130585406417011651,
 -0.0055097917439829246775,
 9.991873369134619636E-4,
 -1.3352313324759812296E-4,
 1.1613115833695492877E-5,
 -4.9116606042452986233E-7
};
static double fd_coeffs_19_6[] = {
 -0.20930129541797138823,
 0.4481121775017160325,
 -0.38356127882344045392,
 0.20374687883167898897,
 -0.07721163638879030822,
 0.02243975722866430908,
 -0.004921453536409266554,
 7.6981451134568118596E-4,
 -7.6609465455236927526E-5,
 3.6455586616421172325E-6
};
static double fd_coeffs_19_7[] = {
 -1.4651090679257997176,
 1.0455950808373374092,
 -0.5369857903528166355,
 0.20374687883167898897,
 -0.06005349496905912861,
 0.014279845509150014869,
 -0.00265001344268191276,
 3.5924677196131788679E-4,
 -3.1545074010979911334E-5,
 1.3431005595523589804E-6
};
static double fd_coeffs_19_8[] = {
 0.20477333965790685242,
 -0.46419532829978937366,
 0.44180228631523570248,
 -0.26752317453072930025,
 0.11341136569584602918,
 -0.03510345329683293741,
 0.007991852311010408119,
 -0.0012800980461452258441,
 1.2943921267371488327E-4,
 -6.22901917586989956E-6
};
static double fd_coeffs_19_9[] = {
 1.8429600569211616718,
 -1.392585984899368121,
 0.79524411536742426447,
 -0.3439583672537948146,
 0.11341136569584602918,
 -0.028721007242863312428,
 0.005532820830699513313,
 -7.680588276871355065E-4,
 6.852664200373140879E-5,
 -2.9505880306752155812E-6
};
static double fd_coeffs_19_10[] = {
 -0.18578297413846172354,
 0.43496950155212765648,
 -0.44028088308516002836,
 0.28969594770007663304,
 -0.13434238604136875698,
 0.044895906486208476717,
 -0.010764465587479727609,
 0.0017852109102975754511,
 -1.849108114444389545E-4,
 9.053015204333754444E-6
};
static double fd_coeffs_20_1[] = {
 0.90909090909090909093,
 -0.3409090909090909091,
 0.13986013986013986014,
 -0.05244755244755244755,
 0.016783216783216783217,
 -0.0043706293706293706294,
 8.814714697067638244E-4,
 -1.2854792266556972439E-4,
 1.2027875804965588247E-5,
 -5.412544112234514711E-7
};
static double fd_coeffs_20_2[] = {
 -3.0995354623330813807,
 1.8181818181818181819,
 -0.3409090909090909091,
 0.093240093240093240094,
 -0.026223776223776223776,
 0.006713286713286713287,
 -0.0014568764568764568765,
 2.5184899134478966413E-4,
 -3.2136980666392431097E-5,
 2.672861289992352944E-6,
 -1.0825088224469029423E-7
};
static double fd_coeffs_20_3[] = {
 -2.9987330790902219475,
 2.6586158137497423212,
 -1.2072642965500108357,
 0.4680213140034568606,
 -0.15203255474684046113,
 0.03991232395250252393,
 -0.0080885209561680149916,
 0.0011832651669836543786,
 -1.10951529018755909514E-4,
 5.000436460520494134E-6
};
static double fd_coeffs_20_4[] = {
 15.836921244855967078,
 -11.99493231636088779,
 5.3172316274994846424,
 -1.609685728733347781,
 0.4680213140034568606,
 -0.121626043797472368903,
 0.026608215968335015954,
 -0.004622011974953151424,
 5.916325834918271893E-4,
 -4.9311790675002626448E-5,
 2.0001745842081976535E-6
};
static double fd_coeffs_20_5[] = {
 12.011344076631775044,
 -13.701673053164868641,
 8.391960553408966107,
 -3.5680121454823835777,
 1.2073463683582731201,
 -0.32391305235861287448,
 0.06649753410170076837,
 -0.0098092462725399233335,
 9.250271700668526065E-4,
 -4.1858930127779334128E-5
};
static double fd_coeffs_20_6[] = {
 -87.140166599304330786,
 72.06806445979065027,
 -41.105019159494605923,
 16.783921106817932214,
 -5.3520182182235753665,
 1.4488156420299277442,
 -0.32391305235861287448,
 0.056997886372886372885,
 -0.0073569347044049425004,
 6.1668478004456840436E-4,
 -2.5115358076667600477E-5
};
static double fd_coeffs_20_7[] = {
 -50.051881686129371316,
 64.08055778101785046,
 -46.149568633526966862,
 22.62598732414704637,
 -8.209104247090358202,
 2.2881030394181435849,
 -0.4806831086865809088,
 0.07197449391315132056,
 -0.0068571339925506592175,
 3.125742463126722386E-4
};
static double fd_coeffs_20_8[] = {
 464.9466992332941407,
 -400.41505348903497052,
 256.32223112407140184,
 -123.06551635607191163,
 45.25197464829409274,
 -13.134566795344573122,
 3.0508040525575247798,
 -0.54935212421323532434,
 0.07197449391315132056,
 -0.006095230215600585971,
 2.5005939705013779087E-4
};
static double fd_coeffs_20_9[] = {
 200.373875962000962,
 -273.09096895292207793,
 216.0510443722943723,
 -117.65090458152958153,
 46.58749098124098124,
 -13.7127812161796536795,
 2.982225378787878788,
 -0.45694008537758537758,
 0.04423566017316017316,
 -0.002039836610149110149
};
static double fd_coeffs_20_10[] = {
 -2276.7668113425925926,
 2003.73875962000962,
 -1365.4548447646103896,
 720.17014790764790766,
 -294.12726145382395382,
 93.17498196248196248,
 -22.8546353602994228,
 4.260321969696969697,
 -0.571175106721981722,
 0.049150733525733525733,
 -0.002039836610149110149
};
static double fd_coeffs_21_1[] = {
 0.62231917728058760986,
 -0.057622146044498852763,
 0.014361211783398175612,
 -0.0041869422109032581958,
 0.0011819927393743354413,
 -2.9671925172310280191E-4,
 6.248351802731541773E-5,
 -1.0429347700361783306E-5,
 1.2820633213884909363E-6,
 -1.0263609414993736305E-7,
 4.000823883827598322E-9
};
static double fd_coeffs_21_2[] = {
 -0.26260485842999193177,
 0.3802639062456583069,
 -0.168168193708698478,
 0.06978849749976549695,
 -0.025502176194517962235,
 0.007851172791598424411,
 -0.0019577251422724689884,
 3.7750414453768106126E-4,
 -5.2636359703359305883E-5,
 4.7122606300888759717E-6,
 -2.0310700579788607497E-7
};
static double fd_coeffs_21_3[] = {
 -0.78781457528997579534,
 0.3802639062456583069,
 -0.1009009162252190868,
 0.029909356071328070118,
 -0.008500725398172654078,
 0.0021412289431632066575,
 -4.5178272513980053578E-4,
 7.550082890753621225E-5,
 -9.288769359416348097E-6,
 7.4404115211929620605E-7,
 -2.9015286542555153567E-8
};
static double fd_coeffs_21_4[] = {
 0.22294360058181273126,
 -0.43025976437848778873,
 0.30861025568233041278,
 -0.14181954700516178941,
 0.053900564810072254814,
 -0.016918234414418183135,
 0.004265186635053202575,
 -8.280821071987434637E-4,
 1.1598686780036609275E-4,
 -1.0416685178732195373E-5,
 4.500133762694200998E-7
};
static double fd_coeffs_21_5[] = {
 1.1147180029090636563,
 -0.7170996072974796479,
 0.30861025568233041278,
 -0.10129967643225842101,
 0.02994475822781791934,
 -0.0076901065520082650613,
 0.0016404563980973856059,
 -2.7602736906624782124E-4,
 3.4113784647166497868E-5,
 -2.7412329417716303614E-6,
 1.07146041968909547575E-7
};
static double fd_coeffs_21_6[] = {
 -0.22446233308351165624,
 0.48601477166556670255,
 -0.42729504132019122706,
 0.23873388882907960746,
 -0.09820384238723067931,
 0.032061184977949479167,
 -0.008265800080278443322,
 0.0016273392661839316392,
 -2.3006126368945016653E-4,
 2.0796053758407126298E-5,
 -9.026576366718425824E-7
};
static double fd_coeffs_21_7[] = {
 -1.5712363315845815937,
 1.1340344672196556393,
 -0.5982130578482677179,
 0.23873388882907960746,
 -0.076380766301179417245,
 0.020402572258695123105,
 -0.0044508154278422387117,
 7.59424990885834765E-4,
 -9.4731108578008892104E-5,
 7.661704016255257057E-6,
 -3.0088587889061419412E-7
};
static double fd_coeffs_21_8[] = {
 0.2318770803012348174,
 -0.5319546799081092861,
 0.5199861535556048322,
 -0.33007026832302460405,
 0.15093962197122321146,
 -0.05230390408971414596,
 0.013970618629391576865,
 -0.0028131150508583460356,
 4.037685714118521807E-4,
 -3.688935927013230339E-5,
 1.6137021102243370436E-6
};
static double fd_coeffs_21_9[] = {
 2.0868937227111133566,
 -1.5958640397243278584,
 0.935975076400088698,
 -0.42437605927246020522,
 0.15093962197122321146,
 -0.042794103346129755784,
 0.00967196674342493783,
 -0.0016878690305150076214,
 2.1375983192392174271E-4,
 -1.7473907022694248974E-5,
 6.915866186675730187E-7
};
static double fd_coeffs_21_10[] = {
 -0.2280906640097119018,
 0.5407387262302531022,
 -0.5623222961753047734,
 0.38732907817219242906,
 -0.19292226432463823459,
 0.071745017366040320626,
 -0.020097044235549619876,
 0.0041781797944180606476,
 -6.1312629597126262125E-4,
 5.6912392886743458377E-5,
 -2.518914614863668628E-6
};
static double fd_coeffs_22_1[] = {
 0.9166666666666666667,
 -0.3525641025641025641,
 0.1510989010989010989,
 -0.06043956043956043956,
 0.021153846153846153846,
 -0.006221719457013574661,
 0.0014813617754794225382,
 -2.7288243232515678337E-4,
 3.6384324310020904448E-5,
 -3.1186563694303632384E-6,
 1.2887009791034558836E-7
};
static double fd_coeffs_22_2[] = {
 -3.1160643879529160915,
 1.8333333333333333334,
 -0.3525641025641025641,
 0.1007326007326007326,
 -0.03021978021978021978,
 0.008461538461538461539,
 -0.0020739064856711915535,
 4.2324622156554929663E-4,
 -6.8220608081289195844E-5,
 8.085405402226867655E-6,
 -6.2373127388607264766E-7,
 2.3430926892790106976E-8
};
static double fd_coeffs_22_3[] = {
 -3.0691770668705192515,
 2.7669911795655843276,
 -1.3117691135867156275,
 0.54233585056289137924,
 -0.1926733169277812135,
 0.05712488205266566611,
 -0.0136666647849245888466,
 0.0025253749603686947046,
 -3.3743255665248146452E-4,
 2.8966682770967642812E-5,
 -1.1983123155223574339E-6
};
static double fd_coeffs_22_4[] = {
 16.144313191533628041,
 -12.276708267482077006,
 5.533982359131168655,
 -1.7490254847822875034,
 0.54233585056289137924,
 -0.1541386535422249708,
 0.038083254701777110742,
 -0.007809522734242622198,
 0.0012626874801843473523,
 -1.4997002517888065089E-4,
 1.1586673108387057124E-5,
 -4.3574993291722088505E-7
};
static double fd_coeffs_22_5[] = {
 12.611227457118743494,
 -14.624570561606358564,
 9.2818974365489742475,
 -4.2008561512708338104,
 1.5534329340238318413,
 -0.4704908919346142152,
 0.113999611742071573226,
 -0.021238317584508838788,
 0.0028536829539616070896,
 -2.4594948927008139583E-4,
 1.0204527957115103084E-5
};
static double fd_coeffs_22_6[] = {
 -91.066675998855397,
 75.66736474271246097,
 -43.87371168481907569,
 18.563794873097948495,
 -6.3012842269062507156,
 1.8641195208285982096,
 -0.4704908919346142152,
 0.09771395292177563419,
 -0.01592873818838162909,
 0.001902455302641071393,
 -1.475696935620488375E-4,
 5.566106158426419864E-6
};
static double fd_coeffs_22_7[] = {
 -54.672951127001570674,
 71.18989538235969563,
 -53.005001320535174703,
 27.500961679352883056,
 -10.87510584759355014,
 3.4172331290430248763,
 -0.84660489699094058664,
 0.16001582643750853628,
 -0.02171410885603593937,
 0.0018847408985333368049,
 -7.8608332611033228316E-5
};
static double fd_coeffs_22_8[] = {
 505.27603253545151693,
 -437.3836090160125654,
 284.75958152943878252,
 -141.34667018809379921,
 55.001923358705766112,
 -17.400169356149680223,
 4.5563108387240331683,
 -0.967548453703932099,
 0.16001582643750853628,
 -0.019301430094254168328,
 0.001507792718826669444,
 -5.7169696444387802412E-5
};
static double fd_coeffs_22_9[] = {
 232.07478727336192614,
 -321.86160173963125353,
 263.0798688451925059,
 -151.09362420670158765,
 64.87647827625692209,
 -21.45870524700993451,
 5.4924785369273216497,
 -1.0609107700427144872,
 0.1461557132104007104,
 -0.012825027407740701392,
 5.3925953987957956213E-4
};
static double fd_coeffs_22_10[] = {
 -2622.5949347392576558,
 2320.7478727336192614,
 -1609.3080086981562676,
 876.93289615064168635,
 -377.73406051675396913,
 129.75295655251384418,
 -35.764508745016557516,
 7.846397909896173785,
 -1.326138462553393109,
 0.16239523690044523378,
 -0.012825027407740701392,
 4.902359453450723292E-4
};
static double fd_coeffs_23_1[] = {
 0.6234978120860432682,
 -0.058619452418345948292,
 0.015073573479003243847,
 -0.0046143592282662991366,
 0.0013957012480558559117,
 -3.8471687294490534856E-4,
 9.181605843458293328E-5,
 -1.8148437281221655819E-5,
 2.8258812375604654388E-6,
 -3.2318151074593372054E-7,
 2.4050407210736358095E-8,
 -8.7172101421342433797E-10
};
static double fd_coeffs_23_2[] = {
 -0.26545948572732368774,
 0.38751026784657737975,
 -0.17679481466217356472,
 0.07703485910068456979,
 -0.030160551509394509063,
 0.010195583897778124449,
 -0.0028812810325856841546,
 6.579360950376451806E-4,
 -1.162009351500178396E-4,
 1.4861226457706625052E-5,
 -1.2228595530704828726E-6,
 4.8559645108218895124E-8
};
static double fd_coeffs_23_3[] = {
 -0.7963784571819710632,
 0.38751026784657737975,
 -0.10607688879730413883,
 0.033014939614579101338,
 -0.010053517169798169687,
 0.0027806137903031248497,
 -6.6491100751977326646E-4,
 1.3158721900752903612E-4,
 -2.050604737941491287E-5,
 2.3465094406905197452E-6,
 -1.7469422186721183894E-7,
 6.3338667532459428423E-9
};
static double fd_coeffs_23_4[] = {
 0.22933413448662658715,
 -0.44648188890609219215,
 0.327922308691383274,
 -0.15804167153276619284,
 0.06432907343496079987,
 -0.022166568820407843066,
 0.006332712310140038306,
 -0.0014558733040874587666,
 2.5828620576180822806E-4,
 -3.313674754232379681E-5,
 2.732890455864748474E-6,
 -1.0870843236168230352E-7
};
static double fd_coeffs_23_5[] = {
 1.1466706724331329357,
 -0.7441364815101536536,
 0.327922308691383274,
 -0.11288690823769013774,
 0.035738374130533777708,
 -0.010075713100185383212,
 0.0024356585808230916562,
 -4.852911013624862555E-4,
 7.596653110641418473E-5,
 -8.720196721664157055E-6,
 6.506882037773210652E-7,
 -2.3632267904713544245E-8
};
static double fd_coeffs_23_6[] = {
 -0.23755470117165160623,
 0.51924924450469119096,
 -0.46685988993819657042,
 0.2719683616682040959,
 -0.119568860640953564734,
 0.04281351442590151954,
 -0.012501566226441368318,
 0.0029135030757475728325,
 -5.215917271905421703E-4,
 6.7342934485472236145E-5,
 -5.5796169441759923757E-6,
 2.227123479763880854E-7
};
static double fd_coeffs_23_7[] = {
 -1.6628829082015612436,
 1.2115815705109461123,
 -0.65360384591347519856,
 0.2719683616682040959,
 -0.092998002720741661456,
 0.027244963725573694253,
 -0.0067316125834684290943,
 0.0013596347686822006551,
 -2.1477306413728207013E-4,
 2.4810554810437139633E-5,
 -1.859872314725330792E-6,
 6.778201894933550425E-8
};
static double fd_coeffs_23_8[] = {
 0.2561228525227838469,
 -0.59350164016281066866,
 0.59325634433501124,
 -0.3916172285777259866,
 0.19050552499210267167,
 -0.07221615593682341678,
 0.021814839054010380521,
 -0.005194963357928832976,
 9.436541876811625538E-4,
 -1.2308958371649278313E-4,
 1.0274968681389744099E-5,
 -4.1244126529359081215E-7
};
static double fd_coeffs_23_9[] = {
 2.305105672705054622,
 -1.780504920488432006,
 1.067861419803020232,
 -0.50350786531421912564,
 0.19050552499210267167,
 -0.059085945766491886457,
 0.015102580883545648053,
 -0.0031169780147572997854,
 4.9958162877238017556E-4,
 -5.8305592286759739378E-5,
 4.403558006309890328E-6,
 -1.6139006033227466562E-7
};
static double fd_coeffs_23_10[] = {
 -0.2680471562277438061,
 0.64216674493756485925,
 -0.6830699374935330556,
 0.4887570968795041861,
 -0.258125990636481507,
 0.10455996459487647732,
 -0.03302414465903053009,
 0.008103412716527648769,
 -0.0015028457583161025955,
 1.9896844149642379039E-4,
 -1.6792488877080352706E-5,
 6.796940124865087656E-7
};
static double fd_coeffs_24_1[] = {
 0.92307692307692307694,
 -0.36263736263736263737,
 0.16117216117216117216,
 -0.06799450549450549451,
 0.025597931480284421461,
 -0.008295625942684766214,
 0.0022454325859898615317,
 -4.9118837818528221004E-4,
 8.3164169851476353024E-5,
 -1.02065117544993705984E-5,
 8.068388738734680315E-7,
 -3.081676254377829287E-8
};
static double fd_coeffs_24_2[] = {
 -3.1299532768418049803,
 1.8461538461538461539,
 -0.36263736263736263737,
 0.10744810744810744811,
 -0.033997252747252747254,
 0.010239172592113768585,
 -0.0027652086475615887382,
 6.4155216742567472335E-4,
 -1.2279709454632055251E-4,
 1.8480926633661411784E-5,
 -2.0413023508998741198E-6,
 1.4669797706790327845E-7,
 -5.1361270906297154785E-9
};
static double fd_coeffs_24_3[] = {
 -3.1291013820234599456,
 2.8611579605202054181,
 -1.4059358945413367182,
 0.6129609362788571972,
 -0.23421748499599640056,
 0.076512160484499420075,
 -0.020809346312442287675,
 0.004566141111088037227,
 -7.747395889494834336E-4,
 9.522532402808915328E-5,
 -7.5360953922905019134E-6,
 2.8808104894400656725E-7
};
static double fd_coeffs_24_4[] = {
 16.403985223863037715,
 -12.516405528093839782,
 5.7223159210404108362,
 -1.8745811927217822909,
 0.6129609362788571972,
 -0.18737398799679712044,
 0.05100810698966628005,
 -0.011891055035681307242,
 0.0022830705555440186135,
 -3.4432870619977041494E-4,
 3.809012961123566131E-5,
 -2.740398324469273423E-6,
 9.602701631466885575E-8
};
static double fd_coeffs_24_5[] = {
 13.128673392744821316,
 -15.43769988901876657,
 10.0950267639613822535,
 -4.810703146830139815,
 1.9121664608234236085,
 -0.63789987110775703993,
 0.1756766040690189297,
 -0.038860315392208083495,
 0.0066298253413257309555,
 -8.180922752343425876E-4,
 6.4931229223261825776E-5,
 -2.487577330279396486E-6
};
static double fd_coeffs_24_6[] = {
 -94.43007458042490285,
 78.7720403564689279,
 -46.31309966705629971,
 20.190053527922764507,
 -7.2160547202452097223,
 2.2945997529881083303,
 -0.63789987110775703993,
 0.15057994634487336832,
 -0.02914523654415606262,
 0.004419883560883820637,
 -4.9085536514060555256E-4,
 3.5417034121779177698E-5,
 -1.243788665139698243E-6
};
static double fd_coeffs_24_7[] = {
 -58.75927633207841541,
 77.61126356176616593,
 -59.426369499941645004,
 32.316987813907735783,
 -13.708062397331698803,
 4.7392795189208275857,
 -1.3336746195774994794,
 0.29917860431938250566,
 -0.051534704116437504237,
 0.0064030129076850890578,
 -5.1079087261685300903E-4,
 1.9644660909355444577E-5
};
static double fd_coeffs_24_8[] = {
 540.690850979450838,
 -470.0742106566273233,
 310.44505424706466373,
 -158.47031866651105335,
 64.633975627815471565,
 -21.932899835730718083,
 6.3190393585611034474,
 -1.5241995652314279765,
 0.29917860431938250566,
 -0.045808625881277781544,
 0.005122410326148071246,
 -3.7148427099407491565E-4,
 1.3096440606236963051E-5
};
static double fd_coeffs_24_9[] = {
 261.2253276119456675,
 -367.6695937002628471,
 308.88786080582409949,
 -185.44961817717528282,
 85.08588649418262514,
 -30.889762415375262598,
 8.967078546325074103,
 -2.0536536298706437596,
 0.35888632603067126877,
 -0.045056938441115028417,
 0.0036223118995936456255,
 -1.4013874362336663924E-4
};
static double fd_coeffs_24_10[] = {
 -2938.392455073914854,
 2612.253276119456675,
 -1838.3479685013142354,
 1029.6262026860803316,
 -463.62404544293820707,
 170.17177298836525028,
 -51.482937358958770997,
 12.810112209035820147,
 -2.5670670373383046995,
 0.39876258447852363197,
 -0.045056938441115028417,
 0.0032930108178124051139,
 -1.167822863528055327E-4
};
static double fd_coeffs_25_1[] = {
 0.6244970072977196196,
 -0.059475905456925678056,
 0.015701639040628379007,
 -0.0050069002042820086118,
 0.0016035170588877021045,
 -4.7707945553683698978E-4,
 1.2584437833687353795E-4,
 -2.8356933251908837216E-5,
 5.2564755162955086288E-6,
 -7.6510774324321430053E-7,
 8.169295927559904244E-8,
 -5.6752670196186480336E-9,
 1.9214184021620894783E-10
};
static double fd_coeffs_25_2[] = {
 -0.2678832919931881272,
 0.3937429125302287955,
 -0.18441249149774751732,
 0.083700326331811778306,
 -0.034697550212934877888,
 0.012660126403404991465,
 -0.003954359348432788932,
 0.0010293862812924122189,
 -2.1643352509178037374E-4,
 3.5229346338920402042E-5,
 -4.1592246618038191433E-6,
 3.1656122249261069763E-7,
 -1.165224249497355663E-8
};
static double fd_coeffs_25_3[] = {
 -0.8036498759795643816,
 0.3937429125302287955,
 -0.110647494898648510394,
 0.03587156842791933356,
 -0.0115658500709782926296,
 0.0034527617463831794902,
 -9.12544465022951292E-4,
 2.0587725625848244376E-4,
 -3.8194151486784771836E-5,
 5.562528369303221375E-6,
 -5.9417495168625987764E-7,
 4.1290594238166612735E-8,
 -1.3982690993968267957E-9
};
static double fd_coeffs_25_4[] = {
 0.23480664724818830324,
 -0.46055406457867946213,
 0.34512163451343438173,
 -0.17309108162706091208,
 0.07457278954956476844,
 -0.027731056586365554385,
 0.008755527557518754717,
 -0.0022945401204877836782,
 4.8459312447300701375E-4,
 -7.912424974032141101E-5,
 9.362667660610399949E-6,
 -7.138071454932298588E-7,
 2.6308639701371632839E-8
};
static double fd_coeffs_25_5[] = {
 1.1740332362409415162,
 -0.76759010763113243685,
 0.34512163451343438173,
 -0.12363648687647208006,
 0.041429327527535982465,
 -0.012605025721075251993,
 0.0033675105990456748912,
 -7.648467068292612261E-4,
 1.4252738955088441581E-4,
 -2.082217098429510816E-5,
 2.2292065858596190354E-6,
 -1.5517546641157170843E-7,
 5.2617279402743265677E-9
};
static double fd_coeffs_25_6[] = {
 -0.2489610773507709159,
 0.54857992610814084437,
 -0.50270850078685725787,
 0.30333589616078219741,
 -0.14091987151405294477,
 0.054411594406350565486,
 -0.017551447940416790238,
 0.004661539053662141958,
 -9.932839751992354264E-4,
 1.6319483515034038446E-4,
 -1.9398083172749661354E-5,
 1.4839215672509689842E-6,
 -5.4835183446720908645E-8
};
static double fd_coeffs_25_7[] = {
 -1.7427275414553964112,
 1.2800198275856619701,
 -0.70379190110160016103,
 0.30333589616078219741,
 -0.10960434451093006815,
 0.034625560076768541672,
 -0.009450779660224425512,
 0.0021753848917089995806,
 -4.0899928390556752854E-4,
 6.01244129501254048E-5,
 -6.466027724249887118E-6,
 4.5162830307638186475E-7,
 -1.535385136508185442E-8
};
static double fd_coeffs_25_8[] = {
 0.27785231745569293952,
 -0.64937740713314833543,
 0.66154894840986838825,
 -0.4513732571432259913,
 0.23117979653668670848,
 -0.094310821961041905917,
 0.031435004643502641343,
 -0.008525020677368461721,
 0.0018422410834029671359,
 -3.0569012937119104046E-4,
 3.659953247142633497E-5,
 -2.8150800239080415665E-6,
 1.044625547223674241E-7
};
static double fd_coeffs_25_9[] = {
 2.5006708571012364556,
 -1.9481322213994450062,
 1.1907881071377630989,
 -0.5803370448984334174,
 0.23117979653668670848,
 -0.07716339978630701393,
 0.021762695522424905545,
 -0.0051150124064210770325,
 9.753041029780414249E-4,
 -1.4480058759687996654E-4,
 1.568551391632557213E-5,
 -1.1015530528335814825E-6,
 3.7606519700052272676E-8
};
static double fd_coeffs_25_10[] = {
 -0.30541751501504875807,
 0.73826195324777759283,
 -0.8005196365393486189,
 0.591525583544592804,
 -0.32807764962700401162,
 0.14255839663911092427,
 -0.049568916506041700774,
 0.013830449125108438621,
 -0.0030482365352347284287,
 5.130050699611712859E-4,
 -6.2065503964675529406E-5,
 4.811754913338449496E-6,
 -1.796548217761713361E-7
};
static void apply_periodic_fd(int n,double *x,double *y,double coeff,int m,double *c) {
 int i,k,l=(m+1)/2;
 if (m%2) {
  for(i=m;i<n-m;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[i+k]-x[i-k]);
   y[i] = coeff * d;
  }
  for(i=0;i<m;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[i+k]-x[(i+n-k)%n]);
   y[i] = coeff * d;
  }
  for(i=n-m;i<n;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[(i+k)%n]-x[i-k]);
   y[i] = coeff * d;
  }
 } else {
  for(i=l;i<n-l;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[i+k]-x[i-k]);
   y[i] = coeff * d;
  }
  for(i=0;i<l;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[i+k]-x[(i+n-k)%n]);
   y[i] = coeff * d;
  }
  for(i=n-l;i<n;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[(i+k)%n]-x[i-k]);
   y[i] = coeff * d;
  }
 }
}
static void apply_periodic_fd2(int n,double *x,double *y,double coeff,int m,double *c) {
 int i,k,l=(m+1)/2;
 if (m%2) {
  for(i=m;i<n-m;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[i+k]+x[i-k]);
   y[i] = coeff * d;
  }
  for(i=0;i<m;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[i+k]+x[(i+n-k)%n]);
   y[i] = coeff * d;
  }
  for(i=n-m;i<n;++i) {
   double d = 0.0, *c_ptr = c + l;
   for(k=m;k>0;k-=2)
    d += (*(--c_ptr)) * (x[(i+k)%n]+x[i-k]);
   y[i] = coeff * d;
  }
 } else {
  for(i=l;i<n-l;++i) {
   double d = 0.0, *c_ptr = c + l + 1;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[i+k]+x[i-k]);
   y[i] = coeff * (d+(*c)*x[i]);
  }
  for(i=0;i<l;++i) {
   double d = 0.0, *c_ptr = c + l + 1;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[i+k]+x[(i+n-k)%n]);
   y[i] = coeff * (d+(*c)*x[i]);
  }
  for(i=n-l;i<n;++i) {
   double d = 0.0, *c_ptr = c + l + 1;
   for(k=l;k>0;--k)
    d += (*(--c_ptr)) * (x[(i+k)%n]+x[i-k]);
   y[i] = coeff * (d+(*c)*x[i]);
  }
 }
}
extern void periodic_finite_difference(
int n, double *x, double *y, double h, int k, int m) {
double coeff = pow(1.0/h,k), *c=NULL;
  switch (k*1000+m) {
  case 1001: c=fd_coeffs_1_1; break;
  case 1002: c=fd_coeffs_2_1; break;
  case 2002: c=fd_coeffs_2_2; break;
  case 1003: c=fd_coeffs_3_1; break;
  case 2003: c=fd_coeffs_3_2; break;
  case 3003: c=fd_coeffs_3_3; break;
  case 1004: c=fd_coeffs_4_1; break;
  case 2004: c=fd_coeffs_4_2; break;
  case 3004: c=fd_coeffs_4_3; break;
  case 4004: c=fd_coeffs_4_4; break;
  case 1005: c=fd_coeffs_5_1; break;
  case 2005: c=fd_coeffs_5_2; break;
  case 3005: c=fd_coeffs_5_3; break;
  case 4005: c=fd_coeffs_5_4; break;
  case 5005: c=fd_coeffs_5_5; break;
  case 1006: c=fd_coeffs_6_1; break;
  case 2006: c=fd_coeffs_6_2; break;
  case 3006: c=fd_coeffs_6_3; break;
  case 4006: c=fd_coeffs_6_4; break;
  case 5006: c=fd_coeffs_6_5; break;
  case 6006: c=fd_coeffs_6_6; break;
  case 1007: c=fd_coeffs_7_1; break;
  case 2007: c=fd_coeffs_7_2; break;
  case 3007: c=fd_coeffs_7_3; break;
  case 4007: c=fd_coeffs_7_4; break;
  case 5007: c=fd_coeffs_7_5; break;
  case 6007: c=fd_coeffs_7_6; break;
  case 7007: c=fd_coeffs_7_7; break;
  case 1008: c=fd_coeffs_8_1; break;
  case 2008: c=fd_coeffs_8_2; break;
  case 3008: c=fd_coeffs_8_3; break;
  case 4008: c=fd_coeffs_8_4; break;
  case 5008: c=fd_coeffs_8_5; break;
  case 6008: c=fd_coeffs_8_6; break;
  case 7008: c=fd_coeffs_8_7; break;
  case 8008: c=fd_coeffs_8_8; break;
  case 1009: c=fd_coeffs_9_1; break;
  case 2009: c=fd_coeffs_9_2; break;
  case 3009: c=fd_coeffs_9_3; break;
  case 4009: c=fd_coeffs_9_4; break;
  case 5009: c=fd_coeffs_9_5; break;
  case 6009: c=fd_coeffs_9_6; break;
  case 7009: c=fd_coeffs_9_7; break;
  case 8009: c=fd_coeffs_9_8; break;
  case 9009: c=fd_coeffs_9_9; break;
  case 1010: c=fd_coeffs_10_1; break;
  case 2010: c=fd_coeffs_10_2; break;
  case 3010: c=fd_coeffs_10_3; break;
  case 4010: c=fd_coeffs_10_4; break;
  case 5010: c=fd_coeffs_10_5; break;
  case 6010: c=fd_coeffs_10_6; break;
  case 7010: c=fd_coeffs_10_7; break;
  case 8010: c=fd_coeffs_10_8; break;
  case 9010: c=fd_coeffs_10_9; break;
  case 10010: c=fd_coeffs_10_10; break;
  case 1011: c=fd_coeffs_11_1; break;
  case 2011: c=fd_coeffs_11_2; break;
  case 3011: c=fd_coeffs_11_3; break;
  case 4011: c=fd_coeffs_11_4; break;
  case 5011: c=fd_coeffs_11_5; break;
  case 6011: c=fd_coeffs_11_6; break;
  case 7011: c=fd_coeffs_11_7; break;
  case 8011: c=fd_coeffs_11_8; break;
  case 9011: c=fd_coeffs_11_9; break;
  case 10011: c=fd_coeffs_11_10; break;
  case 1012: c=fd_coeffs_12_1; break;
  case 2012: c=fd_coeffs_12_2; break;
  case 3012: c=fd_coeffs_12_3; break;
  case 4012: c=fd_coeffs_12_4; break;
  case 5012: c=fd_coeffs_12_5; break;
  case 6012: c=fd_coeffs_12_6; break;
  case 7012: c=fd_coeffs_12_7; break;
  case 8012: c=fd_coeffs_12_8; break;
  case 9012: c=fd_coeffs_12_9; break;
  case 10012: c=fd_coeffs_12_10; break;
  case 1013: c=fd_coeffs_13_1; break;
  case 2013: c=fd_coeffs_13_2; break;
  case 3013: c=fd_coeffs_13_3; break;
  case 4013: c=fd_coeffs_13_4; break;
  case 5013: c=fd_coeffs_13_5; break;
  case 6013: c=fd_coeffs_13_6; break;
  case 7013: c=fd_coeffs_13_7; break;
  case 8013: c=fd_coeffs_13_8; break;
  case 9013: c=fd_coeffs_13_9; break;
  case 10013: c=fd_coeffs_13_10; break;
  case 1014: c=fd_coeffs_14_1; break;
  case 2014: c=fd_coeffs_14_2; break;
  case 3014: c=fd_coeffs_14_3; break;
  case 4014: c=fd_coeffs_14_4; break;
  case 5014: c=fd_coeffs_14_5; break;
  case 6014: c=fd_coeffs_14_6; break;
  case 7014: c=fd_coeffs_14_7; break;
  case 8014: c=fd_coeffs_14_8; break;
  case 9014: c=fd_coeffs_14_9; break;
  case 10014: c=fd_coeffs_14_10; break;
  case 1015: c=fd_coeffs_15_1; break;
  case 2015: c=fd_coeffs_15_2; break;
  case 3015: c=fd_coeffs_15_3; break;
  case 4015: c=fd_coeffs_15_4; break;
  case 5015: c=fd_coeffs_15_5; break;
  case 6015: c=fd_coeffs_15_6; break;
  case 7015: c=fd_coeffs_15_7; break;
  case 8015: c=fd_coeffs_15_8; break;
  case 9015: c=fd_coeffs_15_9; break;
  case 10015: c=fd_coeffs_15_10; break;
  case 1016: c=fd_coeffs_16_1; break;
  case 2016: c=fd_coeffs_16_2; break;
  case 3016: c=fd_coeffs_16_3; break;
  case 4016: c=fd_coeffs_16_4; break;
  case 5016: c=fd_coeffs_16_5; break;
  case 6016: c=fd_coeffs_16_6; break;
  case 7016: c=fd_coeffs_16_7; break;
  case 8016: c=fd_coeffs_16_8; break;
  case 9016: c=fd_coeffs_16_9; break;
  case 10016: c=fd_coeffs_16_10; break;
  case 1017: c=fd_coeffs_17_1; break;
  case 2017: c=fd_coeffs_17_2; break;
  case 3017: c=fd_coeffs_17_3; break;
  case 4017: c=fd_coeffs_17_4; break;
  case 5017: c=fd_coeffs_17_5; break;
  case 6017: c=fd_coeffs_17_6; break;
  case 7017: c=fd_coeffs_17_7; break;
  case 8017: c=fd_coeffs_17_8; break;
  case 9017: c=fd_coeffs_17_9; break;
  case 10017: c=fd_coeffs_17_10; break;
  case 1018: c=fd_coeffs_18_1; break;
  case 2018: c=fd_coeffs_18_2; break;
  case 3018: c=fd_coeffs_18_3; break;
  case 4018: c=fd_coeffs_18_4; break;
  case 5018: c=fd_coeffs_18_5; break;
  case 6018: c=fd_coeffs_18_6; break;
  case 7018: c=fd_coeffs_18_7; break;
  case 8018: c=fd_coeffs_18_8; break;
  case 9018: c=fd_coeffs_18_9; break;
  case 10018: c=fd_coeffs_18_10; break;
  case 1019: c=fd_coeffs_19_1; break;
  case 2019: c=fd_coeffs_19_2; break;
  case 3019: c=fd_coeffs_19_3; break;
  case 4019: c=fd_coeffs_19_4; break;
  case 5019: c=fd_coeffs_19_5; break;
  case 6019: c=fd_coeffs_19_6; break;
  case 7019: c=fd_coeffs_19_7; break;
  case 8019: c=fd_coeffs_19_8; break;
  case 9019: c=fd_coeffs_19_9; break;
  case 10019: c=fd_coeffs_19_10; break;
  case 1020: c=fd_coeffs_20_1; break;
  case 2020: c=fd_coeffs_20_2; break;
  case 3020: c=fd_coeffs_20_3; break;
  case 4020: c=fd_coeffs_20_4; break;
  case 5020: c=fd_coeffs_20_5; break;
  case 6020: c=fd_coeffs_20_6; break;
  case 7020: c=fd_coeffs_20_7; break;
  case 8020: c=fd_coeffs_20_8; break;
  case 9020: c=fd_coeffs_20_9; break;
  case 10020: c=fd_coeffs_20_10; break;
  case 1021: c=fd_coeffs_21_1; break;
  case 2021: c=fd_coeffs_21_2; break;
  case 3021: c=fd_coeffs_21_3; break;
  case 4021: c=fd_coeffs_21_4; break;
  case 5021: c=fd_coeffs_21_5; break;
  case 6021: c=fd_coeffs_21_6; break;
  case 7021: c=fd_coeffs_21_7; break;
  case 8021: c=fd_coeffs_21_8; break;
  case 9021: c=fd_coeffs_21_9; break;
  case 10021: c=fd_coeffs_21_10; break;
  case 1022: c=fd_coeffs_22_1; break;
  case 2022: c=fd_coeffs_22_2; break;
  case 3022: c=fd_coeffs_22_3; break;
  case 4022: c=fd_coeffs_22_4; break;
  case 5022: c=fd_coeffs_22_5; break;
  case 6022: c=fd_coeffs_22_6; break;
  case 7022: c=fd_coeffs_22_7; break;
  case 8022: c=fd_coeffs_22_8; break;
  case 9022: c=fd_coeffs_22_9; break;
  case 10022: c=fd_coeffs_22_10; break;
  case 1023: c=fd_coeffs_23_1; break;
  case 2023: c=fd_coeffs_23_2; break;
  case 3023: c=fd_coeffs_23_3; break;
  case 4023: c=fd_coeffs_23_4; break;
  case 5023: c=fd_coeffs_23_5; break;
  case 6023: c=fd_coeffs_23_6; break;
  case 7023: c=fd_coeffs_23_7; break;
  case 8023: c=fd_coeffs_23_8; break;
  case 9023: c=fd_coeffs_23_9; break;
  case 10023: c=fd_coeffs_23_10; break;
  case 1024: c=fd_coeffs_24_1; break;
  case 2024: c=fd_coeffs_24_2; break;
  case 3024: c=fd_coeffs_24_3; break;
  case 4024: c=fd_coeffs_24_4; break;
  case 5024: c=fd_coeffs_24_5; break;
  case 6024: c=fd_coeffs_24_6; break;
  case 7024: c=fd_coeffs_24_7; break;
  case 8024: c=fd_coeffs_24_8; break;
  case 9024: c=fd_coeffs_24_9; break;
  case 10024: c=fd_coeffs_24_10; break;
  case 1025: c=fd_coeffs_25_1; break;
  case 2025: c=fd_coeffs_25_2; break;
  case 3025: c=fd_coeffs_25_3; break;
  case 4025: c=fd_coeffs_25_4; break;
  case 5025: c=fd_coeffs_25_5; break;
  case 6025: c=fd_coeffs_25_6; break;
  case 7025: c=fd_coeffs_25_7; break;
  case 8025: c=fd_coeffs_25_8; break;
  case 9025: c=fd_coeffs_25_9; break;
  case 10025: c=fd_coeffs_25_10; break;
  default:
    fprintf(stderr,
     "Unsupported derivative/order combination: k,m=%d,%d\n",
      k,m);
  }
  if (c!=NULL) {
   if (k%2)
    apply_periodic_fd(n,x,y,coeff,m,c);
   else
    apply_periodic_fd2(n,x,y,coeff,m,c);
  }
}
